/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.host.views.overview;

import java.awt.Color;
import org.netbeans.lib.profiler.ui.charts.DynamicSynchronousXYChartModel;

public class BoundedDynamicXYChartModel
extends DynamicSynchronousXYChartModel {
    private int maxItemsCount;

    public BoundedDynamicXYChartModel(int maxItemsCount) {
        this.maxItemsCount = maxItemsCount;
    }

    public void setupModel(String[] seriesNames, Color[] seriesColors) {
        this.seriesNames = seriesNames;
        this.seriesColors = seriesColors;
        if (seriesNames.length != seriesColors.length) {
            this.seriesCount = 0;
            throw new RuntimeException("Counts of series names and series colors don't match.");
        }
        this.seriesCount = seriesNames.length;
        this.itemCount = 0;
        this.xValues = new long[this.maxItemsCount];
        this.yValues = new long[this.maxItemsCount][];
        this.minXValue = 0L;
        this.maxXValue = 0L;
        this.minYValues = new long[this.seriesCount];
        this.maxYValues = new long[this.seriesCount];
    }

    public void addItemValues(long xValue, long[] yValues) {
        if (this.itemCount == 0) {
            for (int i = 0; i < this.seriesCount; ++i) {
                this.minYValues[i] = yValues[i];
                this.maxYValues[i] = yValues[i];
            }
        } else {
            if (this.xValues[this.itemCount - 1] >= xValue) {
                throw new RuntimeException("New x-value not greater than previous x-value.");
            }
            for (int i = 0; i < this.seriesCount; ++i) {
                this.minYValues[i] = Math.min(this.minYValues[i], yValues[i]);
                this.maxYValues[i] = Math.max(this.maxYValues[i], yValues[i]);
            }
        }
        if (this.itemCount == this.maxItemsCount) {
            System.arraycopy(this.xValues, 1, this.xValues, 0, this.xValues.length - 1);
            System.arraycopy(this.yValues, 1, this.yValues, 0, this.yValues.length - 1);
            this.xValues[this.itemCount - 1] = xValue;
            this.yValues[this.itemCount - 1] = yValues;
        } else {
            this.xValues[this.itemCount] = xValue;
            this.yValues[this.itemCount] = yValues;
        }
        if (this.itemCount < this.maxItemsCount) {
            ++this.itemCount;
        }
        this.minXValue = this.xValues[0];
        this.maxXValue = xValue;
        this.fireChartDataChanged();
    }
}

