/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.instrumentation;

import java.util.Enumeration;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.classfile.BaseClassInfo;
import org.netbeans.lib.profiler.classfile.ClassInfo;
import org.netbeans.lib.profiler.classfile.ClassRepository;
import org.netbeans.lib.profiler.classfile.DynamicClassInfo;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.instrumentation.ClassManager;
import org.netbeans.lib.profiler.instrumentation.InstrumentationFactory;
import org.netbeans.lib.profiler.instrumentation.MemoryProfMethodInstrumentor;
import org.netbeans.lib.profiler.instrumentation.SingleMethodScaner;

public class ObjLivenessMethodInstrumentor
extends MemoryProfMethodInstrumentor {
    protected static final int STANDARD_INSTRUMENTATION = 1;
    protected static final int SELECTIVE_INSTR_REMOVAL = 2;
    protected MethodScanerForBannedInstantiations msbi;
    protected boolean[] allUnprofiledClassStatusArray;
    protected int operationCode;
    private final ProfilerEngineSettings engineSettings;

    public ObjLivenessMethodInstrumentor(ProfilingSessionStatus status, ProfilerEngineSettings engineSettings, boolean isLiveness) {
        super(status, isLiveness ? 10 : 9);
        this.engineSettings = engineSettings;
        this.msbi = new MethodScanerForBannedInstantiations();
        this.operationCode = 1;
    }

    public Object[] getMethodsToInstrumentUponClassUnprofiling(boolean[] unprofiledClassStatusArray) {
        this.operationCode = 2;
        this.initInstrumentationPackData();
        this.msbi.setUnprofiledClassStatusArray(unprofiledClassStatusArray);
        this.setAllUnprofiledClassStatusArray(unprofiledClassStatusArray);
        Enumeration e = ClassRepository.getClassEnumerationWithAllVersions();
        while (e.hasMoreElements()) {
            DynamicClassInfo clazz;
            Object ci = e.nextElement();
            if (!(ci instanceof DynamicClassInfo) || !(clazz = (DynamicClassInfo)ci).isLoaded() || !clazz.hasInstrumentedMethods()) continue;
            String[] methodNames = clazz.getMethodNames();
            boolean found = false;
            for (int i = 0; i < methodNames.length; ++i) {
                if (!clazz.isMethodInstrumented(i)) continue;
                this.msbi.setClassAndMethod(clazz, i);
                if (!this.msbi.hasNewOpcodes()) continue;
                found = true;
                clazz.setMethodSpecial(i);
                ++this.nInstrMethods;
            }
            if (!found) continue;
            ++this.nInstrClasses;
            this.instrClasses.add(clazz);
        }
        Object[] res = this.createInstrumentedMethodPack();
        this.operationCode = 1;
        return res;
    }

    protected void setAllUnprofiledClassStatusArray(boolean[] currentUnprofiledClassStatusArray) {
        int len = currentUnprofiledClassStatusArray.length;
        if (this.allUnprofiledClassStatusArray == null || this.allUnprofiledClassStatusArray.length < len) {
            boolean[] old = this.allUnprofiledClassStatusArray;
            this.allUnprofiledClassStatusArray = new boolean[len];
            if (old != null) {
                System.arraycopy(old, 0, this.allUnprofiledClassStatusArray, 0, old.length);
            }
        }
        for (int i = 0; i < len; ++i) {
            if (!currentUnprofiledClassStatusArray[i]) continue;
            this.allUnprofiledClassStatusArray[i] = true;
        }
    }

    protected byte[] instrumentMethod(DynamicClassInfo clazz, int methodIdx) {
        return InstrumentationFactory.instrumentForMemoryProfiling(clazz, methodIdx, this.allUnprofiledClassStatusArray, this.injType, ObjLivenessMethodInstrumentor.getRuntimeProfilingPoints(this.engineSettings.getRuntimeProfilingPoints(), clazz, methodIdx));
    }

    protected boolean methodNeedsInstrumentation(ClassInfo clazz, int methodIdx) {
        boolean ni = this.hasNewOpcodes(clazz, methodIdx, true);
        return ni || ObjLivenessMethodInstrumentor.getRuntimeProfilingPoints(this.engineSettings.getRuntimeProfilingPoints(), clazz, methodIdx).length > 0;
    }

    protected boolean methodNeedsRewriting(DynamicClassInfo clazz, int methodIdx) {
        if (this.operationCode == 1) {
            return clazz.isMethodInstrumented(methodIdx);
        }
        boolean res = clazz.isMethodSpecial(methodIdx);
        clazz.unsetMethodSpecial(methodIdx);
        return res;
    }

    static class MethodScanerForBannedInstantiations
    extends SingleMethodScaner {
        protected boolean[] unprofiledClassStatusArray;

        MethodScanerForBannedInstantiations() {
        }

        void setUnprofiledClassStatusArray(boolean[] v) {
            this.unprofiledClassStatusArray = v;
        }

        boolean hasNewOpcodes() {
            int loaderId = this.clazz.getLoaderId();
            for (int bci = 0; bci < this.bytecodesLength; bci += this.opcodeLength(bci)) {
                int arrayClassId;
                BaseClassInfo refClazz;
                int classId;
                int bc = this.bytecodes[bci] & 0xFF;
                if (bc == 187 || bc == 189 || bc == 197) {
                    int classCPIdx = this.getU2(bci + 1);
                    String refClassName = this.clazz.getRefClassName(classCPIdx);
                    BaseClassInfo refClazz2 = bc == 187 ? ClassManager.javaClassOrPlaceholderForName(refClassName, loaderId) : (bc == 189 ? ClassManager.javaClassForObjectArrayType(refClassName) : ClassRepository.lookupSpecialClass(refClassName));
                    int classId2 = refClazz2.getInstrClassId();
                    if (classId2 == -1 || this.unprofiledClassStatusArray.length <= classId2 || !this.unprofiledClassStatusArray[classId2]) continue;
                    return true;
                }
                if (bc != 188 || (classId = (refClazz = ClassManager.javaClassForPrimitiveArrayType(arrayClassId = this.getByte(bci + 1))).getInstrClassId()) == -1 || !this.unprofiledClassStatusArray[classId]) continue;
                return true;
            }
            return false;
        }
    }
}

