/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

class LongBuffer {
    private DataInputStream readStream;
    private DataOutputStream writeStream;
    private File backedFile;
    private long[] buffer;
    private boolean hasData;
    private boolean useBackingFile;
    private int bufferSize;
    private int readOffset;

    LongBuffer(int size) {
        this.buffer = new long[size];
    }

    void delete() {
        if (this.backedFile != null) {
            this.backedFile.delete();
        }
    }

    boolean hasData() {
        return this.hasData;
    }

    long readLong() throws IOException {
        if (!this.useBackingFile) {
            if (this.readOffset < this.bufferSize) {
                return this.buffer[this.readOffset++];
            }
            return 0L;
        }
        try {
            return this.readStream.readLong();
        }
        catch (EOFException ex) {
            return 0L;
        }
    }

    void reset() {
        this.bufferSize = 0;
        this.writeStream = null;
        this.readStream = null;
        this.hasData = false;
        this.useBackingFile = false;
        this.readOffset = 0;
    }

    void startReading() {
        if (this.useBackingFile) {
            try {
                this.writeStream.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        this.writeStream = null;
        this.readOffset = 0;
        if (this.useBackingFile) {
            try {
                this.readStream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.backedFile), this.buffer.length * 8));
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
        }
    }

    void writeLong(long data) throws IOException {
        this.hasData = true;
        if (this.bufferSize < this.buffer.length) {
            this.buffer[this.bufferSize++] = data;
            return;
        }
        if (this.backedFile == null) {
            this.backedFile = File.createTempFile("NBProfiler", ".gc");
        }
        if (this.writeStream == null) {
            this.writeStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.backedFile), this.buffer.length * 8));
            for (int i = 0; i < this.buffer.length; ++i) {
                this.writeStream.writeLong(this.buffer[i]);
            }
            this.useBackingFile = true;
        }
        this.writeStream.writeLong(data);
    }
}

