/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.classfile;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.netbeans.lib.profiler.classfile.DynamicClassInfo;
import org.netbeans.lib.profiler.utils.MiscUtils;

public class ClassPath {
    private Hashtable zipFileNameToFile;
    private PathEntry[] paths;
    private boolean isCP;

    public ClassPath(String classPath, boolean isCP) {
        this.isCP = isCP;
        ArrayList<PathEntry> vec = new ArrayList<PathEntry>();
        this.zipFileNameToFile = new Hashtable();
        StringTokenizer tok = new StringTokenizer(classPath, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            String path = tok.nextToken();
            if (path.equals("")) continue;
            File file = new File(path);
            try {
                if (!file.exists()) continue;
                if (file.isDirectory()) {
                    vec.add(new Dir(file));
                    continue;
                }
                ZipFile zipFile = new ZipFile(file);
                vec.add(new Zip(zipFile));
                this.zipFileNameToFile.put(path, zipFile);
            }
            catch (IOException e) {
                System.err.println("Warning: CLASSPATH component " + file + ": " + e);
            }
        }
        this.paths = new PathEntry[vec.size()];
        vec.toArray(this.paths);
    }

    public DynamicClassInfo getClassInfoForClass(String className, int classLoaderId) throws IOException, ClassFormatError {
        String slashedClassName = className.replace('.', '/');
        String dirOrJar = this.getLocationForClass(slashedClassName);
        if (dirOrJar == null) {
            return null;
        }
        return new DynamicClassInfo(slashedClassName, classLoaderId, dirOrJar);
    }

    public String getLocationForClass(String slashedClassName) {
        String fileName = slashedClassName + (this.isCP ? ".class" : ".java");
        for (int i = 0; i < this.paths.length; ++i) {
            String location = this.paths[i].getLocationForClassFile(fileName);
            if (location == null) continue;
            return location;
        }
        return null;
    }

    public ZipFile getZipFileForName(String zipFileName) {
        return (ZipFile)this.zipFileNameToFile.get(zipFileName);
    }

    public void close() {
        Iterator it = this.zipFileNameToFile.values().iterator();
        while (it.hasNext()) {
            try {
                ((ZipFile)it.next()).close();
            }
            catch (IOException iOException) {}
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.paths.length; ++i) {
            buf.append(this.paths[i] instanceof Dir ? ((Dir)this.paths[i]).dir.getAbsolutePath() : ((Zip)this.paths[i]).zip.getName());
            buf.append(File.pathSeparatorChar);
        }
        return buf.toString();
    }

    private static class Zip
    extends PathEntry {
        private ZipFile zip;

        Zip(ZipFile z) {
            this.zip = z;
            this.threshHits = 50 + (int)(20.0 * Math.random());
        }

        String getLocationForClassFile(String fileName) {
            if (this.entries != null) {
                if (this.entries.contains(fileName)) {
                    return this.zip.getName();
                }
                return null;
            }
            if (++this.hits >= this.threshHits) {
                this.entries = new HashSet();
                MiscUtils.getAllClassesInJar(this.zip.getName(), false, this.entries);
                Enumeration<? extends ZipEntry> e = this.zip.entries();
                return this.getLocationForClassFile(fileName);
            }
            ZipEntry entry = this.zip.getEntry(fileName);
            if (entry != null) {
                return this.zip.getName();
            }
            return null;
        }
    }

    private static class Dir
    extends PathEntry {
        private File dir;

        Dir(File dirF) {
            this.dir = dirF;
            this.threshHits = 100 + (int)(40.0 * Math.random());
        }

        String getLocationForClassFile(String fileName) {
            if (this.entries != null) {
                if (this.entries.contains(fileName)) {
                    return this.dir.getAbsolutePath();
                }
                return null;
            }
            if (++this.hits >= this.threshHits) {
                this.entries = new HashSet();
                MiscUtils.getAllClassesInDir(this.dir.getAbsolutePath(), "", false, this.entries);
                return this.getLocationForClassFile(fileName);
            }
            File file = new File(this.dir, fileName);
            if (file.exists()) {
                return this.dir.getAbsolutePath();
            }
            return null;
        }
    }

    private static abstract class PathEntry {
        protected HashSet entries;
        protected int hits;
        protected int threshHits;

        private PathEntry() {
        }

        abstract String getLocationForClassFile(String var1);
    }
}

