/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import java.util.Vector;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.server.ClassLoaderManager;
import org.netbeans.lib.profiler.server.ProfilerInterface;
import org.netbeans.lib.profiler.server.ProfilerServer;
import org.netbeans.lib.profiler.server.ThreadInfo;
import org.netbeans.lib.profiler.server.system.Classes;
import org.netbeans.lib.profiler.server.system.GC;
import org.netbeans.lib.profiler.server.system.Threads;
import org.netbeans.lib.profiler.server.system.Timers;
import org.netbeans.lib.profiler.wireprotocol.MonitoredNumbersResponse;

public class Monitors
implements CommonConstants {
    private static final boolean DEBUG = false;
    protected static Runtime runtime;
    protected static SurvGenAndThreadsMonitor stMonitor;
    protected static long[] generalMNums;
    protected static long[] gcRelTime;
    protected static long[] gcStartTimes;
    protected static long[] gcFinishTimes;
    protected static long time;

    public static MonitoredNumbersResponse getMonitoredNumbers() {
        int instrType;
        int nUserThreads;
        int nTotalThreads = Threads.getTotalNumberOfThreads();
        --nTotalThreads;
        int nSystemThreads = ProfilerInterface.getNPrerecordedSystemThreads();
        if (nSystemThreads != -1) {
            nUserThreads = nTotalThreads - nSystemThreads;
            nSystemThreads -= 2;
            if (ProfilerServer.isTargetAppMainThreadComplete()) {
                --nUserThreads;
            }
        } else {
            nUserThreads = nTotalThreads - 3;
        }
        if ((instrType = ProfilerInterface.getCurrentInstrType()) == 3 || instrType == 5) {
            --nUserThreads;
        }
        GC.getGCRelativeTimeMetrics(gcRelTime);
        Monitors.generalMNums[0] = runtime.freeMemory();
        Monitors.generalMNums[1] = runtime.totalMemory();
        Monitors.generalMNums[2] = nUserThreads;
        Monitors.generalMNums[3] = nSystemThreads;
        Monitors.generalMNums[4] = stMonitor.getNSurvGen();
        Monitors.generalMNums[5] = gcRelTime[0];
        Monitors.generalMNums[6] = gcRelTime[1];
        Monitors.generalMNums[7] = Classes.getLoadedClassCount();
        Monitors.generalMNums[8] = System.currentTimeMillis();
        MonitoredNumbersResponse resp = new MonitoredNumbersResponse(generalMNums);
        stMonitor.getThreadsData(resp);
        Monitors.stMonitor.getGCStartFinishData(resp);
        return resp;
    }

    public static void initialize() {
        runtime = Runtime.getRuntime();
        gcRelTime = new long[2];
        gcStartTimes = new long[10];
        gcFinishTimes = new long[10];
        generalMNums = new long[9];
        GC.activateGCEpochCounter(true);
        stMonitor = new SurvGenAndThreadsMonitor();
        ThreadInfo.addProfilerServerThread(stMonitor);
        stMonitor.start();
    }

    public static boolean monitorThreadsStarted() {
        return Monitors.stMonitor.started;
    }

    public static void shutdown() {
        Monitors.stMonitor.terminated = true;
    }

    private static void showTime() {
        long cnts = Timers.getNoOfCountsInSecond();
        time = (Timers.getCurrentTimeInCounts() - time) * 1000000L / cnts;
        long time1 = stMonitor.getTime() * 1000000L / cnts;
        System.out.println("!!! time = " + time + ", time1 = " + time1 + ", sum = " + (time + time1));
    }

    static class ThreadDataTable {
        private static final int INITIAL_SIZE = 23;
        private static final int INITIAL_NSTATES = 20;
        private static Object dummyObj = new Object();
        private String[] newThreadClassNames = new String[23];
        private int[] newThreadIds = new int[23];
        private String[] newThreadNames = new String[23];
        private long[] packedStateTimestamps = new long[20];
        private int[] packedThreadIds = new int[23];
        private byte[] packedThreadStates = new byte[460];
        private long[] stateSampleTimestamps;
        private int[] threadIds;
        private boolean[] threadNew;
        private byte[][] threadStates;
        private Object[] threads;
        private boolean jvmSupportsThreadSleepingState;
        private int curStateIdx = 0;
        private int curThreadId = 1;
        private int nFilledSlots = 0;
        private int nNewThreads;
        private int nStates = 20;
        private int nThreads = 0;
        private int size = 23;
        private int threshold = this.size * 3 / 4;

        ThreadDataTable() {
            this.threads = new Object[this.size];
            this.threadIds = new int[this.size];
            this.threadStates = new byte[this.size][this.nStates];
            this.stateSampleTimestamps = new long[this.nStates];
            this.threadNew = new boolean[this.size];
            this.jvmSupportsThreadSleepingState = Platform.thisVMSupportsThreadSleepingStateMonitoring();
        }

        public void getThreadsData(MonitoredNumbersResponse mresp) {
            int totalStates;
            if (this.nThreads > this.packedThreadIds.length) {
                this.packedThreadIds = new int[this.nThreads];
            }
            if (this.curStateIdx > this.packedStateTimestamps.length) {
                this.packedStateTimestamps = new long[this.curStateIdx];
            }
            if ((totalStates = this.nThreads * this.curStateIdx) > this.packedThreadStates.length) {
                this.packedThreadStates = new byte[totalStates];
            }
            int idx0 = 0;
            int idx1 = 0;
            for (int i = 0; i < this.size; ++i) {
                if (this.threads[i] == null || this.threads[i] == dummyObj) continue;
                this.packedThreadIds[idx0++] = this.threadIds[i];
                System.arraycopy(this.threadStates[i], 0, this.packedThreadStates, idx1, this.curStateIdx);
                idx1 += this.curStateIdx;
            }
            System.arraycopy(this.stateSampleTimestamps, 0, this.packedStateTimestamps, 0, this.curStateIdx);
            mresp.setDataOnThreads(this.nThreads, this.curStateIdx, this.packedThreadIds, this.packedStateTimestamps, this.packedThreadStates);
            if (this.nNewThreads > 0) {
                if (this.nNewThreads > this.newThreadIds.length) {
                    this.newThreadIds = new int[this.nNewThreads];
                    this.newThreadNames = new String[this.nNewThreads];
                    this.newThreadClassNames = new String[this.nNewThreads];
                }
                int idx = 0;
                for (int i = 0; i < this.size; ++i) {
                    if (!this.threadNew[i]) continue;
                    this.newThreadIds[idx] = this.threadIds[i];
                    this.newThreadNames[idx] = ((Thread)this.threads[i]).getName();
                    this.newThreadClassNames[idx] = ((Thread)this.threads[i]).getClass().getName();
                    ++idx;
                }
                mresp.setDataOnNewThreads(this.nNewThreads, this.newThreadIds, this.newThreadNames, this.newThreadClassNames);
            }
        }

        public void incStatusIdx() {
            ++this.curStateIdx;
            if (this.curStateIdx == this.nStates) {
                this.growStatesArrays();
            }
        }

        public void prePut() {
            for (int i = 0; i < this.size; ++i) {
                this.threadStates[i][this.curStateIdx] = 0;
            }
            this.stateSampleTimestamps[this.curStateIdx] = System.currentTimeMillis();
        }

        public void printCurrentStatus() {
            for (int i = 0; i < this.size; ++i) {
                if (this.threads[i] == null || this.threads[i] == dummyObj) continue;
                System.err.print(((Thread)this.threads[i]).getName() + "  ");
                byte[] states = this.threadStates[i];
                for (int j = 0; j < this.curStateIdx; ++j) {
                    System.err.print(states[j]);
                }
                System.err.println();
            }
            System.err.println();
        }

        public void put(Thread thread, int status) {
            int pos = (thread.hashCode() & Integer.MAX_VALUE) % this.size;
            while (this.threads[pos] != thread && this.threads[pos] != null) {
                pos = (pos + 1) % this.size;
            }
            if (this.threads[pos] == null) {
                this.threadNew[pos] = true;
                this.threads[pos] = thread;
                ++this.curThreadId;
                ++this.nThreads;
                ++this.nNewThreads;
                ++this.nFilledSlots;
            }
            this.threadStates[pos][this.curStateIdx] = (byte)status;
            if (this.nFilledSlots > this.threshold) {
                this.growTable();
            }
        }

        public void resetStates() {
            this.nNewThreads = 0;
            if (this.curStateIdx == 0) {
                return;
            }
            int idx = this.curStateIdx - 1;
            for (int i = 0; i < this.size; ++i) {
                if (this.threads[i] == null || this.threads[i] == dummyObj) continue;
                this.threadNew[i] = false;
                if (this.threadStates[i][idx] != 0) continue;
                this.threads[i] = dummyObj;
                --this.nThreads;
            }
            this.curStateIdx = 0;
        }

        private void growStatesArrays() {
            int oldNStates = this.nStates;
            this.nStates *= 2;
            for (int i = 0; i < this.size; ++i) {
                byte[] oldStates = this.threadStates[i];
                this.threadStates[i] = new byte[this.nStates];
                System.arraycopy(oldStates, 0, this.threadStates[i], 0, oldNStates);
            }
            long[] oldTimestamps = this.stateSampleTimestamps;
            this.stateSampleTimestamps = new long[this.nStates];
            System.arraycopy(oldTimestamps, 0, this.stateSampleTimestamps, 0, oldNStates);
        }

        private void growTable() {
            int i;
            int oldSize = this.size;
            this.size = this.nThreads * 4 / 3 * 2 + 1;
            if (this.size < oldSize) {
                this.size = oldSize;
            }
            this.threshold = this.size * 3 / 4;
            Object[] oldThreads = this.threads;
            int[] oldThreadIds = this.threadIds;
            byte[][] oldThreadStates = this.threadStates;
            boolean[] oldThreadNew = this.threadNew;
            this.threads = new Object[this.size];
            this.threadIds = new int[this.size];
            this.threadStates = new byte[this.size][];
            this.threadNew = new boolean[this.size];
            for (i = 0; i < oldSize; ++i) {
                if (oldThreads[i] == null || oldThreads[i] == dummyObj) continue;
                Object thread = oldThreads[i];
                int pos = (thread.hashCode() & Integer.MAX_VALUE) % this.size;
                while (this.threads[pos] != null) {
                    pos = (pos + 1) % this.size;
                }
                this.threadNew[pos] = oldThreadNew[i];
                this.threads[pos] = thread;
                this.threadIds[pos] = oldThreadIds[i];
                this.threadStates[pos] = oldThreadStates[i];
            }
            for (i = 0; i < this.size; ++i) {
                if (this.threadStates[i] != null) continue;
                this.threadStates[i] = new byte[this.nStates];
            }
            this.nFilledSlots = this.nThreads;
        }
    }

    static class SurvGenAndThreadsMonitor
    extends Thread {
        public boolean started;
        public boolean terminated;
        private LongList gcFinishs;
        private LongList gcStarts;
        private ThreadDataTable threadTable;
        private Vector markerObjects;
        private int[] allThreadStatusRough;
        private Thread[] allThreadsRough;
        private int savedGCEpoch = GC.getCurrentGCEpoch();
        private long lastGCFinish;
        private long lastGCStart;
        private long time;
        private long time0;

        SurvGenAndThreadsMonitor() {
            super("*** JFluid Monitor thread ***");
            this.markerObjects = new Vector();
            this.allThreadsRough = new Thread[20];
            this.allThreadStatusRough = new int[20];
            this.threadTable = new ThreadDataTable();
            this.gcStarts = new LongList(16);
            this.gcFinishs = new LongList(16);
            this.setPriority(10);
            this.setDaemon(true);
        }

        public int getNSurvGen() {
            return this.markerObjects.size();
        }

        public synchronized void getThreadsData(MonitoredNumbersResponse mresp) {
            this.threadTable.getThreadsData(mresp);
            this.threadTable.resetStates();
        }

        public long getTime() {
            long ret = this.time;
            this.time = 0L;
            return ret;
        }

        public void run() {
            this.started = true;
            int checkForUnloadedClassesCounter = 3;
            while (!this.terminated) {
                this.updateSurvGenData();
                this.updateThreadsData();
                this.updateGCStartFinishData();
                if (--checkForUnloadedClassesCounter == 0) {
                    ClassLoaderManager.checkForUnloadedClasses();
                    checkForUnloadedClassesCounter = 3;
                }
                ThreadInfo.releaseDeadThreads();
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
        }

        synchronized void updateGCStartFinishData() {
            long maxStart = this.lastGCStart;
            long maxFinish = this.lastGCFinish;
            GC.getGCStartFinishTimes(gcStartTimes, gcFinishTimes);
            for (int i = 0; i < 10; ++i) {
                long start = gcStartTimes[i];
                long finish = gcFinishTimes[i];
                if (start > this.lastGCStart) {
                    this.gcStarts.add(start & 0xFFFFFFFFFFFFFFL);
                    maxStart = start;
                }
                if (finish <= this.lastGCFinish) continue;
                this.gcFinishs.add(finish & 0xFFFFFFFFFFFFFFL);
                maxFinish = finish;
            }
            this.lastGCStart = maxStart;
            this.lastGCFinish = maxFinish;
        }

        private synchronized void getGCStartFinishData(MonitoredNumbersResponse resp) {
            long[] start = this.gcStarts.getArray();
            long[] finish = this.gcFinishs.getArray();
            this.gcStarts.clear();
            this.gcFinishs.clear();
            resp.setGCstartFinishData(start, finish);
        }

        private void updateSurvGenData() {
            int currentGCEpoch = GC.getCurrentGCEpoch();
            if (currentGCEpoch != this.savedGCEpoch) {
                this.markerObjects.add(new Object());
                this.savedGCEpoch = currentGCEpoch;
                int lenMinusOne = this.markerObjects.size() - 1;
                int initSize = lenMinusOne + 1;
                for (int i = 0; i < lenMinusOne; ++i) {
                    if (!GC.objectsAdjacent(this.markerObjects.get(i), this.markerObjects.get(i + 1))) continue;
                    this.markerObjects.remove(i);
                    --i;
                    --lenMinusOne;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateThreadsData() {
            Thread tMain = ProfilerServer.isTargetAppMainThreadComplete() ? ProfilerServer.getMainThread() : null;
            this.allThreadsRough = Threads.getAllThreads(this.allThreadsRough);
            if (this.allThreadStatusRough.length < this.allThreadsRough.length) {
                this.allThreadStatusRough = new int[this.allThreadsRough.length];
            }
            Threads.getThreadsStatus(this.allThreadsRough, this.allThreadStatusRough);
            SurvGenAndThreadsMonitor survGenAndThreadsMonitor = this;
            synchronized (survGenAndThreadsMonitor) {
                Thread thread;
                this.threadTable.prePut();
                for (int i = 0; i < this.allThreadsRough.length && (thread = this.allThreadsRough[i]) != null; ++i) {
                    if (thread == this || thread == tMain || ThreadInfo.isProfilerServerThread(thread)) continue;
                    this.threadTable.put(thread, this.allThreadStatusRough[i]);
                }
                this.threadTable.incStatusIdx();
            }
        }
    }

    static class LongList {
        long[] data;
        int size;

        LongList(int size) {
            this.data = new long[size];
        }

        long[] getArray() {
            long[] arr = new long[this.size];
            System.arraycopy(this.data, 0, arr, 0, this.size);
            return arr;
        }

        void add(long l) {
            this.ensureSize();
            this.data[this.size++] = l;
        }

        void clear() {
            this.size = 0;
        }

        void ensureSize() {
            if (this.size >= this.data.length) {
                int newCapacity = this.size * 3 / 2 + 1;
                long[] elementData = new long[newCapacity];
                System.arraycopy(this.data, 0, elementData, 0, this.size);
                this.data = elementData;
            }
        }
    }
}

