/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.jmx.application;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.explorer.ExplorerSupport;
import com.sun.tools.visualvm.host.Host;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.ui.stp.Utils;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import sun.net.util.IPAddressUtil;

class JmxApplicationConfigurator
extends JPanel {
    private boolean internalChange = false;
    private static JmxApplicationConfigurator defaultInstance;
    private JLabel connectionLabel;
    private JTextField connectionField;
    private JLabel usageLabel;
    private JCheckBox displaynameCheckbox;
    private JTextField displaynameField;
    private JCheckBox securityCheckbox;
    private JLabel usernameLabel;
    private JTextField usernameField;
    private JLabel passwordLabel;
    private JPasswordField passwordField;
    private JCheckBox saveCheckbox;
    private JButton okButton;

    public static JmxApplicationConfigurator addJmxConnection() {
        JmxApplicationConfigurator hc = JmxApplicationConfigurator.getDefault();
        hc.setupDefineJmxConnection();
        DialogDescriptor dd = new DialogDescriptor((Object)hc, NbBundle.getMessage(JmxApplicationConfigurator.class, (String)"Title_Add_JMX_Connection"), true, new Object[]{hc.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)hc.okButton, 0, null, null);
        Dialog d = ProfilerDialogs.createDialog((DialogDescriptor)dd);
        d.pack();
        d.setVisible(true);
        if (dd.getValue() == hc.okButton) {
            return hc;
        }
        return null;
    }

    public String getConnection() {
        return this.connectionField.getText().trim();
    }

    public String getDisplayName() {
        return this.displaynameField.getText().trim();
    }

    public String getUsername() {
        return this.usernameField.getText().trim();
    }

    public String getPassword() {
        return new String(this.passwordField.getPassword());
    }

    public boolean getSaveCredentialsFlag() {
        return this.saveCheckbox.isSelected();
    }

    private JmxApplicationConfigurator() {
        this.initComponents();
        this.update();
    }

    private static JmxApplicationConfigurator getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new JmxApplicationConfigurator();
        }
        return defaultInstance;
    }

    private void setupDefineJmxConnection() {
        this.connectionField.setEnabled(true);
        this.connectionField.setText("");
        this.displaynameCheckbox.setSelected(false);
        this.displaynameCheckbox.setEnabled(true);
        this.displaynameField.setText("");
        this.securityCheckbox.setSelected(false);
        this.securityCheckbox.setEnabled(true);
        this.usernameField.setText("");
        this.passwordField.setText("");
        this.saveCheckbox.setSelected(false);
        this.saveCheckbox.setEnabled(false);
        Set selectedDataSources = ExplorerSupport.sharedInstance().getSelectedDataSources();
        if (selectedDataSources.size() != 1) {
            return;
        }
        DataSource selectedDataSource = (DataSource)selectedDataSources.iterator().next();
        if (!(selectedDataSource instanceof Host)) {
            return;
        }
        Host host = (Host)selectedDataSource;
        this.connectionField.setText(host.getHostName() + ":");
    }

    private void update() {
        if (this.internalChange) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String username = JmxApplicationConfigurator.this.getUsername();
                String url = JmxApplicationConfigurator.this.getConnection();
                if (!JmxApplicationConfigurator.this.displaynameCheckbox.isSelected()) {
                    JmxApplicationConfigurator.this.internalChange = true;
                    JmxApplicationConfigurator.this.displaynameField.setText((username.isEmpty() ? "" : username + "@") + url);
                    JmxApplicationConfigurator.this.internalChange = false;
                }
                String displayname = JmxApplicationConfigurator.this.getDisplayName();
                JmxApplicationConfigurator.this.displaynameField.setEnabled(JmxApplicationConfigurator.this.displaynameCheckbox.isSelected());
                JmxApplicationConfigurator.this.usernameField.setEnabled(JmxApplicationConfigurator.this.securityCheckbox.isSelected());
                JmxApplicationConfigurator.this.passwordField.setEnabled(JmxApplicationConfigurator.this.securityCheckbox.isSelected());
                JmxApplicationConfigurator.this.saveCheckbox.setEnabled(JmxApplicationConfigurator.this.securityCheckbox.isSelected());
                JmxApplicationConfigurator.this.okButton.setEnabled(JmxApplicationConfigurator.this.enableOkButton(url, displayname));
            }
        });
    }

    private boolean enableOkButton(String url, String displayname) {
        return JmxApplicationConfigurator.isValidRemoteString(url) && displayname.length() > 0;
    }

    private static boolean isValidRemoteString(String txt) {
        boolean valid = false;
        if (txt != null) {
            if ((txt = txt.trim()).startsWith("service:jmx:")) {
                if (txt.length() > "service:jmx:".length()) {
                    valid = true;
                }
            } else if (txt.startsWith("[")) {
                String address;
                int index = txt.indexOf("]:");
                if (index != -1 && IPAddressUtil.isIPv6LiteralAddress(address = txt.substring(1, index))) {
                    try {
                        String portStr = txt.substring(index + 2);
                        int port = Integer.parseInt(portStr);
                        if (port >= 0 && port <= 65535) {
                            valid = true;
                        }
                    }
                    catch (NumberFormatException ex) {
                        valid = false;
                    }
                }
            } else {
                String[] s = txt.split(":");
                if (s.length == 2) {
                    try {
                        int port = Integer.parseInt(s[1]);
                        if (port >= 0 && port <= 65535) {
                            valid = true;
                        }
                    }
                    catch (NumberFormatException ex) {
                        valid = false;
                    }
                }
            }
        }
        return valid;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.connectionLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.connectionLabel, (String)NbBundle.getMessage(JmxApplicationConfigurator.class, (String)"LBL_Connection"));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 13;
        constraints.insets = new Insets(15, 10, 0, 0);
        this.add((Component)this.connectionLabel, constraints);
        this.connectionField = new JTextField();
        this.connectionLabel.setLabelFor(this.connectionField);
        this.connectionField.setPreferredSize(new Dimension(250, this.connectionField.getPreferredSize().height));
        this.connectionField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                JmxApplicationConfigurator.this.update();
            }

            public void removeUpdate(DocumentEvent e) {
                JmxApplicationConfigurator.this.update();
            }

            public void changedUpdate(DocumentEvent e) {
                JmxApplicationConfigurator.this.update();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(15, 5, 0, 10);
        this.add((Component)this.connectionField, constraints);
        Font normalLabelFont = this.connectionLabel.getFont();
        Font smallLabelFont = normalLabelFont.deriveFont(normalLabelFont.getSize2D() - 1.0f);
        this.usageLabel = new JLabel(NbBundle.getMessage(JmxApplicationConfigurator.class, (String)"LBL_Usage"));
        this.usageLabel.setFont(smallLabelFont);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 5, 0, 10);
        this.add((Component)this.usageLabel, constraints);
        this.displaynameCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.displaynameCheckbox, (String)NbBundle.getMessage(JmxApplicationConfigurator.class, (String)"LBL_Display_name"));
        this.displaynameCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JmxApplicationConfigurator.this.update();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 13;
        constraints.insets = new Insets(8, 10, 0, 0);
        this.add((Component)this.displaynameCheckbox, constraints);
        this.displaynameField = new JTextField();
        this.displaynameField.setPreferredSize(new Dimension(250, this.displaynameField.getPreferredSize().height));
        this.displaynameField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                JmxApplicationConfigurator.this.update();
            }

            public void removeUpdate(DocumentEvent e) {
                JmxApplicationConfigurator.this.update();
            }

            public void changedUpdate(DocumentEvent e) {
                JmxApplicationConfigurator.this.update();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(8, 5, 0, 10);
        this.add((Component)this.displaynameField, constraints);
        this.securityCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.securityCheckbox, (String)NbBundle.getMessage(JmxApplicationConfigurator.class, (String)"LBL_Use_security_credentials"));
        this.securityCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JmxApplicationConfigurator.this.update();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.anchor = 13;
        constraints.insets = new Insets(15, 6, 0, 0);
        this.add((Component)this.securityCheckbox, constraints);
        this.usernameLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.usernameLabel, (String)NbBundle.getMessage(JmxApplicationConfigurator.class, (String)"LBL_Username"));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 13;
        constraints.insets = new Insets(8, 10, 0, 0);
        this.add((Component)this.usernameLabel, constraints);
        this.usernameField = new JTextField();
        this.usernameLabel.setLabelFor(this.usernameField);
        this.usernameField.setPreferredSize(new Dimension(320, this.usernameField.getPreferredSize().height));
        this.usernameField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                JmxApplicationConfigurator.this.update();
            }

            public void removeUpdate(DocumentEvent e) {
                JmxApplicationConfigurator.this.update();
            }

            public void changedUpdate(DocumentEvent e) {
                JmxApplicationConfigurator.this.update();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 4;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(8, 5, 0, 10);
        this.add((Component)this.usernameField, constraints);
        this.passwordLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)NbBundle.getMessage(JmxApplicationConfigurator.class, (String)"LBL_Password"));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 13;
        constraints.insets = new Insets(8, 10, 0, 0);
        this.add((Component)this.passwordLabel, constraints);
        this.passwordField = new JPasswordField();
        this.passwordLabel.setLabelFor(this.passwordField);
        this.passwordField.setPreferredSize(new Dimension(200, this.passwordField.getPreferredSize().height));
        this.passwordField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                JmxApplicationConfigurator.this.update();
            }

            public void removeUpdate(DocumentEvent e) {
                JmxApplicationConfigurator.this.update();
            }

            public void changedUpdate(DocumentEvent e) {
                JmxApplicationConfigurator.this.update();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 5;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(8, 5, 0, 10);
        this.add((Component)this.passwordField, constraints);
        this.saveCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.saveCheckbox, (String)NbBundle.getMessage(JmxApplicationConfigurator.class, (String)"LBL_Save_security_credentials"));
        this.saveCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JmxApplicationConfigurator.this.update();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 6;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.anchor = 13;
        constraints.insets = new Insets(8, 40, 0, 0);
        this.add((Component)this.saveCheckbox, constraints);
        JPanel spacer = Utils.createFillerPanel();
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 7;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 0, 15, 0);
        this.add((Component)spacer, constraints);
        this.okButton = new JButton(NbBundle.getMessage(JmxApplicationConfigurator.class, (String)"LBL_OK"));
        this.okButton.setEnabled(false);
        this.displaynameCheckbox.setBorder(this.connectionLabel.getBorder());
    }
}

