/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.ccache;

import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.AuthorizationData;
import sun.security.krb5.internal.AuthorizationDataEntry;
import sun.security.krb5.internal.HostAddress;
import sun.security.krb5.internal.HostAddresses;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.Ticket;
import sun.security.krb5.internal.TicketFlags;
import sun.security.krb5.internal.ccache.Credentials;
import sun.security.krb5.internal.ccache.FileCCacheConstants;
import sun.security.krb5.internal.ccache.Tag;
import sun.security.krb5.internal.util.KrbDataInputStream;

public class CCacheInputStream
extends KrbDataInputStream
implements FileCCacheConstants {
    private static boolean DEBUG = Krb5.DEBUG;

    public CCacheInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public Tag readTag() throws IOException {
        char[] cArray = new char[1024];
        int n = -1;
        Integer n2 = null;
        Integer n3 = null;
        int n4 = this.read(2);
        if (n4 < 0) {
            throw new IOException("stop.");
        }
        byte[] byArray = new byte[n4 + 2];
        if (n4 > cArray.length) {
            throw new IOException("Invalid tag length.");
        }
        while (n4 > 0) {
            n = this.read(2);
            int n5 = this.read(2);
            switch (n) {
                case 1: {
                    n2 = new Integer(this.read(4));
                    n3 = new Integer(this.read(4));
                    break;
                }
            }
            n4 -= 4 + n5;
        }
        if (n == -1) {
            // empty if block
        }
        Tag tag = new Tag(n4, n, n2, n3);
        return tag;
    }

    public PrincipalName readPrincipal(int n) throws IOException, RealmException {
        PrincipalName principalName;
        String[] stringArray = null;
        int n2 = n == 1281 ? 0 : this.read(4);
        int n3 = this.read(4);
        String[] stringArray2 = new String[n3 + 1];
        if (n == 1281) {
            --n3;
        }
        for (int i = 0; i <= n3; ++i) {
            int n4 = this.read(4);
            if (n4 > 1024) {
                throw new IOException("Invalid name length in principal name.");
            }
            byte[] byArray = new byte[n4];
            this.read(byArray, 0, n4);
            stringArray2[i] = new String(byArray);
        }
        if (this.isRealm(stringArray2[0])) {
            String string = stringArray2[0];
            stringArray = new String[n3];
            System.arraycopy(stringArray2, 1, stringArray, 0, n3);
            principalName = new PrincipalName(stringArray, n2);
            principalName.setRealm(string);
        } else {
            principalName = new PrincipalName(stringArray2, n2);
        }
        return principalName;
    }

    boolean isRealm(String string) {
        Object object;
        try {
            object = new Realm(string);
        }
        catch (Exception exception) {
            return false;
        }
        object = new StringTokenizer(string, ".");
        while (((StringTokenizer)object).hasMoreTokens()) {
            String string2 = ((StringTokenizer)object).nextToken();
            for (int i = 0; i < string2.length(); ++i) {
                if (string2.charAt(i) < '\u008d') continue;
                return false;
            }
        }
        return true;
    }

    EncryptionKey readKey(int n) throws IOException {
        int n2 = this.read(2);
        if (n == 1283) {
            this.read(2);
        }
        int n3 = this.read(4);
        byte[] byArray = new byte[n3];
        for (int i = 0; i < n3; ++i) {
            byArray[i] = (byte)this.read();
        }
        return new EncryptionKey(byArray, n2, new Integer(n));
    }

    long[] readTimes() throws IOException {
        long[] lArray = new long[]{(long)this.read(4) * 1000L, (long)this.read(4) * 1000L, (long)this.read(4) * 1000L, (long)this.read(4) * 1000L};
        return lArray;
    }

    boolean readskey() throws IOException {
        return this.read() != 0;
    }

    HostAddress[] readAddr() throws IOException, KrbApErrException {
        int n = this.read(4);
        if (n > 0) {
            HostAddress[] hostAddressArray = new HostAddress[n];
            for (int i = 0; i < n; ++i) {
                int n2 = this.read(2);
                int n3 = this.read(4);
                if (n3 != 4 && n3 != 16) {
                    System.out.println("Incorrect address format.");
                    return null;
                }
                byte[] byArray = new byte[n3];
                for (int j = 0; j < n3; ++j) {
                    byArray[j] = (byte)this.read(1);
                }
                hostAddressArray[i] = new HostAddress(n2, byArray);
            }
            return hostAddressArray;
        }
        return null;
    }

    AuthorizationDataEntry[] readAuth() throws IOException {
        int n = this.read(4);
        if (n > 0) {
            AuthorizationDataEntry[] authorizationDataEntryArray = new AuthorizationDataEntry[n];
            byte[] byArray = null;
            for (int i = 0; i < n; ++i) {
                int n2 = this.read(2);
                int n3 = this.read(4);
                byArray = new byte[n3];
                for (int j = 0; j < n3; ++j) {
                    byArray[j] = (byte)this.read();
                }
                authorizationDataEntryArray[i] = new AuthorizationDataEntry(n2, byArray);
            }
            return authorizationDataEntryArray;
        }
        return null;
    }

    Ticket readData() throws IOException, RealmException, KrbApErrException, Asn1Exception {
        int n = this.read(4);
        if (n > 0) {
            byte[] byArray = new byte[n];
            this.read(byArray, 0, n);
            Ticket ticket = new Ticket(byArray);
            return ticket;
        }
        return null;
    }

    boolean[] readFlags() throws IOException {
        boolean[] blArray = new boolean[12];
        int n = this.read(4);
        if ((n & 0x40000000) == 0x40000000) {
            blArray[1] = true;
        }
        if ((n & 0x20000000) == 0x20000000) {
            blArray[2] = true;
        }
        if ((n & 0x10000000) == 0x10000000) {
            blArray[3] = true;
        }
        if ((n & 0x8000000) == 0x8000000) {
            blArray[4] = true;
        }
        if ((n & 0x4000000) == 0x4000000) {
            blArray[5] = true;
        }
        if ((n & 0x2000000) == 0x2000000) {
            blArray[6] = true;
        }
        if ((n & 0x1000000) == 0x1000000) {
            blArray[7] = true;
        }
        if ((n & 0x800000) == 0x800000) {
            blArray[8] = true;
        }
        if ((n & 0x400000) == 0x400000) {
            blArray[9] = true;
        }
        if ((n & 0x200000) == 0x200000) {
            blArray[10] = true;
        }
        if ((n & 0x100000) == 0x100000) {
            blArray[11] = true;
        }
        if (DEBUG) {
            String string = ">>> CCacheInputStream: readFlags() ";
            if (blArray[1]) {
                string = string + " FORWARDABLE;";
            }
            if (blArray[2]) {
                string = string + " FORWARDED;";
            }
            if (blArray[3]) {
                string = string + " PROXIABLE;";
            }
            if (blArray[4]) {
                string = string + " PROXY;";
            }
            if (blArray[5]) {
                string = string + " MAY_POSTDATE;";
            }
            if (blArray[6]) {
                string = string + " POSTDATED;";
            }
            if (blArray[7]) {
                string = string + " INVALID;";
            }
            if (blArray[8]) {
                string = string + " RENEWABLE;";
            }
            if (blArray[9]) {
                string = string + " INITIAL;";
            }
            if (blArray[10]) {
                string = string + " PRE_AUTH;";
            }
            if (blArray[11]) {
                string = string + " HW_AUTH;";
            }
            System.out.println(string);
        }
        return blArray;
    }

    Credentials readCred(int n) throws IOException, RealmException, KrbApErrException, Asn1Exception {
        PrincipalName principalName = this.readPrincipal(n);
        if (DEBUG) {
            System.out.println(">>>DEBUG <CCacheInputStream>  client principal is " + principalName.toString());
        }
        PrincipalName principalName2 = this.readPrincipal(n);
        if (DEBUG) {
            System.out.println(">>>DEBUG <CCacheInputStream> server principal is " + principalName2.toString());
        }
        EncryptionKey encryptionKey = this.readKey(n);
        if (DEBUG) {
            System.out.println(">>>DEBUG <CCacheInputStream> key type: " + encryptionKey.getEType());
        }
        long[] lArray = this.readTimes();
        KerberosTime kerberosTime = new KerberosTime(lArray[0]);
        KerberosTime kerberosTime2 = new KerberosTime(lArray[1]);
        KerberosTime kerberosTime3 = new KerberosTime(lArray[2]);
        KerberosTime kerberosTime4 = new KerberosTime(lArray[3]);
        if (DEBUG) {
            System.out.println(">>>DEBUG <CCacheInputStream> auth time: " + kerberosTime.toDate().toString());
            System.out.println(">>>DEBUG <CCacheInputStream> start time: " + kerberosTime2.toDate().toString());
            System.out.println(">>>DEBUG <CCacheInputStream> end time: " + kerberosTime3.toDate().toString());
            System.out.println(">>>DEBUG <CCacheInputStream> renew_till time: " + kerberosTime4.toDate().toString());
        }
        boolean bl = this.readskey();
        boolean[] blArray = this.readFlags();
        TicketFlags ticketFlags = new TicketFlags(blArray);
        HostAddress[] hostAddressArray = this.readAddr();
        HostAddresses hostAddresses = null;
        if (hostAddressArray != null) {
            hostAddresses = new HostAddresses(hostAddressArray);
        }
        AuthorizationDataEntry[] authorizationDataEntryArray = this.readAuth();
        AuthorizationData authorizationData = null;
        if (authorizationData != null) {
            authorizationData = new AuthorizationData(authorizationDataEntryArray);
        }
        Ticket ticket = this.readData();
        if (DEBUG) {
            System.out.println(">>>DEBUG <CCacheInputStream>");
            if (ticket == null) {
                System.out.println("///ticket is null");
            }
        }
        Ticket ticket2 = this.readData();
        Credentials credentials = new Credentials(principalName, principalName2, encryptionKey, kerberosTime, kerberosTime2, kerberosTime3, kerberosTime4, bl, ticketFlags, hostAddresses, authorizationData, ticket, ticket2);
        return credentials;
    }
}

