/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.List;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Area;
import java.awt.image.VolatileImage;
import java.awt.peer.ListPeer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.X11.ListHelper;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XEvent;
import sun.awt.X11.XHorizontalScrollbar;
import sun.awt.X11.XScrollbar;
import sun.awt.X11.XScrollbarClient;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XVerticalScrollbar;

class XListPeer
extends XComponentPeer
implements ListPeer,
XScrollbarClient {
    private static final Logger log = Logger.getLogger("sun.awt.X11.XListPeer");
    public static final int MARGIN = 2;
    public static final int SPACE = 1;
    public static final int SCROLLBAR_AREA = 17;
    public static final int SCROLLBAR_WIDTH = 13;
    public static final int NONE = -1;
    public static final int WINDOW = 0;
    public static final int VERSCROLLBAR = 1;
    public static final int HORSCROLLBAR = 2;
    public static final int DEFAULT_VISIBLE_ROWS = 4;
    public static final int HORIZ_SCROLL_AMT = 10;
    static final int PAINT_VSCROLL = 2;
    static final int PAINT_HSCROLL = 4;
    static final int PAINT_ITEMS = 8;
    static final int PAINT_FOCUS = 16;
    static final int PAINT_BACKGROUND = 32;
    static final int PAINT_HIDEFOCUS = 64;
    static final int PAINT_ALL = 62;
    XVerticalScrollbar vsb;
    XHorizontalScrollbar hsb;
    ListPainter painter;
    Vector items;
    boolean multipleSelections;
    int active = -1;
    int[] selected;
    int fontHeight;
    int fontAscent;
    int fontLeading;
    int currentIndex = -1;
    int eventIndex = -1;
    int eventType = -1;
    int focusIndex;
    int maxLength;
    boolean vsbVis;
    boolean hsbVis;
    int listWidth;
    int listHeight;
    private int firstTimeVisibleIndex = 0;
    boolean bgColorSet;
    boolean fgColorSet;
    boolean mouseDraggedOutHorizontally = false;
    boolean mouseDraggedOutVertically = false;
    boolean isScrollBarOriginated = false;
    boolean isMousePressed = false;

    XListPeer(List list) {
        super(list);
    }

    public void preInit(XCreateWindowParams xCreateWindowParams) {
        super.preInit(xCreateWindowParams);
        this.items = new Vector();
        this.createVerScrollbar();
        this.createHorScrollbar();
        this.painter = new ListPainter();
        this.bgColorSet = this.target.isBackgroundSet();
        this.fgColorSet = this.target.isForegroundSet();
    }

    public void postInit(XCreateWindowParams xCreateWindowParams) {
        int n;
        super.postInit(xCreateWindowParams);
        this.initFontMetrics();
        List list = (List)this.target;
        int n2 = list.getItemCount();
        for (n = 0; n < n2; ++n) {
            this.items.addElement(list.getItem(n));
        }
        n = list.getVisibleIndex();
        if (n >= 0) {
            this.vsb.setValues(n, 0, 0, this.items.size());
        }
        this.maxLength = this.maxLength();
        int[] nArray = list.getSelectedIndexes();
        this.selected = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.selected[i] = nArray[i];
        }
        if (nArray.length > 0) {
            this.setFocusIndex(nArray[nArray.length - 1]);
        } else {
            this.setFocusIndex(0);
        }
        this.multipleSelections = list.isMultipleMode();
    }

    void createVerScrollbar() {
        this.vsb = new XVerticalScrollbar(this);
        this.vsb.setValues(0, 0, 0, 0, 1, 1);
    }

    void createHorScrollbar() {
        this.hsb = new XHorizontalScrollbar(this);
        this.hsb.setValues(0, 0, 0, 0, 10, 10);
    }

    public void add(String string, int n) {
        this.addItem(string, n);
    }

    public void removeAll() {
        this.clear();
        this.maxLength = 0;
    }

    public void setMultipleMode(boolean bl) {
        this.setMultipleSelections(bl);
    }

    public Dimension getPreferredSize(int n) {
        return this.preferredSize(n);
    }

    public Dimension getMinimumSize(int n) {
        return this.minimumSize(n);
    }

    public Dimension minimumSize() {
        return this.minimumSize(4);
    }

    public Dimension preferredSize(int n) {
        return this.minimumSize(n);
    }

    public Dimension minimumSize(int n) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.initFontMetrics();
        return new Dimension(20 + fontMetrics.stringWidth("0123456789abcde"), this.getItemHeight() * n + 4);
    }

    void initFontMetrics() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.fontHeight = fontMetrics.getHeight();
        this.fontAscent = fontMetrics.getAscent();
        this.fontLeading = fontMetrics.getLeading();
    }

    int maxLength() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = 0;
        int n2 = this.items.size();
        for (int i = 0; i < n2; ++i) {
            int n3 = fontMetrics.stringWidth((String)this.items.elementAt(i));
            n = Math.max(n, n3);
        }
        return n;
    }

    int getItemWidth(int n) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        return fontMetrics.stringWidth((String)this.items.elementAt(n));
    }

    int stringLength(String string) {
        FontMetrics fontMetrics = this.getFontMetrics(this.target.getFont());
        return fontMetrics.stringWidth(string);
    }

    public void setForeground(Color color) {
        this.fgColorSet = true;
        super.setForeground(color);
    }

    public void setBackground(Color color) {
        this.bgColorSet = true;
        super.setBackground(color);
    }

    private Color getListBackground(Color[] colorArray) {
        if (this.bgColorSet) {
            return colorArray[0];
        }
        return SystemColor.text;
    }

    private Color getListForeground(Color[] colorArray) {
        if (this.fgColorSet) {
            return colorArray[3];
        }
        return SystemColor.textText;
    }

    Rectangle getVScrollBarRec() {
        return new Rectangle(this.width - 13, 0, 14, this.height);
    }

    Rectangle getHScrollBarRec() {
        return new Rectangle(0, this.height - 13, this.width, 13);
    }

    int getFirstVisibleItem() {
        if (this.vsbVis) {
            return this.vsb.getValue();
        }
        return 0;
    }

    int getLastVisibleItem() {
        if (this.vsbVis) {
            return Math.min(this.items.size() - 1, this.vsb.getValue() + this.itemsInWindow() - 1);
        }
        return Math.min(this.items.size() - 1, this.itemsInWindow() - 1);
    }

    Area getItemsArea(int n, int n2) {
        n = Math.max(this.getFirstVisibleItem(), n);
        if ((n2 = Math.min(n2, this.getLastVisibleItem())) < this.getFirstVisibleItem()) {
            return new Area();
        }
        if (n <= n2) {
            int n3 = this.getItemY(n);
            int n4 = this.getItemY(n2) + this.getItemHeight();
            return new Area(new Rectangle(0, n3 -= 2, this.getItemWidth() + 3, (n4 += 2) - n3 + 1));
        }
        return new Area();
    }

    Rectangle getItemRect(int n) {
        return new Rectangle(2, this.getItemY(n), this.getItemWidth(), this.getItemHeight());
    }

    Area getItemArea(int n) {
        return new Area(this.getItemRect(n));
    }

    public void repaintScrollbarRequest(XScrollbar xScrollbar) {
        Graphics graphics = this.getGraphics();
        if (xScrollbar == this.hsb) {
            this.repaint(4);
        } else if (xScrollbar == this.vsb) {
            this.repaint(2);
        }
    }

    public void repaint() {
        this.repaint(this.getFirstVisibleItem(), this.getLastVisibleItem(), 62);
    }

    public void repaint(int n) {
        this.repaint(this.getFirstVisibleItem(), this.getLastVisibleItem(), n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaint(int n, int n2, int n3) {
        Graphics graphics = this.getGraphics();
        try {
            this.painter.paint(graphics, n, n2, n3);
        }
        finally {
            graphics.dispose();
        }
    }

    public void paint(Graphics graphics) {
        this.painter.paint(graphics, this.getFirstVisibleItem(), this.getLastVisibleItem(), 62);
    }

    public boolean isFocusable() {
        return true;
    }

    public void focusGained(FocusEvent focusEvent) {
        super.focusGained(focusEvent);
        this.repaint(16);
    }

    public void focusLost(FocusEvent focusEvent) {
        super.focusLost(focusEvent);
        this.repaint(16);
    }

    public void layout() {
        boolean bl;
        assert (this.target != null);
        int n = this.vsb.getValue();
        int n2 = this.itemsInWindow(false);
        int n3 = this.items.size() < n2 ? n2 : this.items.size();
        this.vsb.setValues(this.vsb.getValue(), n2, this.vsb.getMinimum(), n3);
        this.vsbVis = bl = this.vsbIsVisible(false);
        this.listHeight = this.height;
        this.listWidth = this.getListWidth();
        n2 = this.listWidth - 6;
        n3 = this.maxLength < n2 ? n2 : this.maxLength;
        this.hsb.setValues(this.hsb.getValue(), n2, this.hsb.getMinimum(), n3);
        this.hsbVis = this.hsbIsVisible(this.vsbVis);
        if (this.hsbVis) {
            this.listHeight = this.height - 17;
            n2 = this.itemsInWindow(true);
            n3 = this.items.size() < n2 ? n2 : this.items.size();
            this.vsb.setValues(n, n2, this.vsb.getMinimum(), n3);
            this.vsbVis = this.vsbIsVisible(true);
        }
        if (bl != this.vsbVis) {
            this.listWidth = this.getListWidth();
            n2 = this.listWidth - 6;
            n3 = this.maxLength < n2 ? 0 : this.maxLength;
            this.hsb.setValues(this.hsb.getValue(), n2, this.hsb.getMinimum(), n3);
            this.hsbVis = this.hsbIsVisible(this.vsbVis);
        }
        this.vsb.setSize(13, this.listHeight);
        this.hsb.setSize(this.listWidth, 13);
        this.vsb.setBlockIncrement(this.itemsInWindow());
        this.hsb.setBlockIncrement(this.width - (6 + (this.vsbVis ? 17 : 0)));
    }

    int getItemWidth() {
        return this.width - (4 + (this.vsbVis ? 17 : 0));
    }

    int getItemHeight() {
        return this.fontHeight - this.fontLeading + 2;
    }

    int getItemX() {
        return 3;
    }

    int getItemY(int n) {
        return this.index2y(n);
    }

    int getFocusIndex() {
        return this.focusIndex;
    }

    void setFocusIndex(int n) {
        this.focusIndex = n;
    }

    Rectangle getFocusRect() {
        Rectangle rectangle = new Rectangle();
        rectangle.x = 1;
        rectangle.width = this.getListWidth() - 3;
        if (this.isIndexDisplayed(this.getFocusIndex())) {
            rectangle.y = this.index2y(this.getFocusIndex()) - 2;
            rectangle.height = this.getItemHeight() + 1;
        } else {
            rectangle.y = 1;
            rectangle.height = this.hsbVis ? this.height - 17 : this.height;
            rectangle.height -= 3;
        }
        return rectangle;
    }

    public void handleConfigureNotifyEvent(XEvent xEvent) {
        super.handleConfigureNotifyEvent(xEvent);
        this.painter.invalidate();
    }

    public boolean handlesWheelScrolling() {
        return true;
    }

    void handleJavaMouseEvent(MouseEvent mouseEvent) {
        super.handleJavaMouseEvent(mouseEvent);
        int n = mouseEvent.getID();
        switch (n) {
            case 501: {
                this.mousePressed(mouseEvent);
                break;
            }
            case 502: {
                this.mouseReleased(mouseEvent);
                break;
            }
            case 506: {
                this.mouseDragged(mouseEvent);
            }
        }
    }

    void handleJavaMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        if (ListHelper.doWheelScroll(this.vsbVis ? this.vsb : null, this.hsbVis ? this.hsb : null, mouseWheelEvent)) {
            this.repaint();
        }
    }

    void mousePressed(MouseEvent mouseEvent) {
        if (log.isLoggable(Level.FINER)) {
            log.finer(mouseEvent.toString() + ", hsb " + this.hsbVis + ", vsb " + this.vsbVis);
        }
        if (this.isEnabled() && mouseEvent.getButton() == 1) {
            if (this.inWindow(mouseEvent.getX(), mouseEvent.getY())) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Mouse press in items area");
                }
                this.active = 0;
                int n = this.y2index(mouseEvent.getY());
                if (n >= 0) {
                    if (this.multipleSelections) {
                        if (this.isSelected(n)) {
                            this.deselectItem(n);
                            this.eventIndex = n;
                            this.eventType = 2;
                        } else {
                            this.selectItem(n);
                            this.eventIndex = n;
                            this.eventType = 1;
                        }
                    } else {
                        this.selectItem(n);
                        this.eventIndex = n;
                        this.eventType = 1;
                    }
                    this.setFocusIndex(n);
                    this.repaint(16);
                } else {
                    this.currentIndex = -1;
                }
            } else if (this.inVerticalScrollbar(mouseEvent.getX(), mouseEvent.getY())) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Mouse press in vertical scrollbar");
                }
                this.active = 1;
                this.vsb.handleMouseEvent(mouseEvent.getID(), mouseEvent.getModifiers(), mouseEvent.getX() - (this.width - 13), mouseEvent.getY());
            } else if (this.inHorizontalScrollbar(mouseEvent.getX(), mouseEvent.getY())) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Mouse press in horizontal scrollbar");
                }
                this.active = 2;
                this.hsb.handleMouseEvent(mouseEvent.getID(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY() - (this.height - 13));
            }
            this.isMousePressed = true;
        }
    }

    void mouseReleased(MouseEvent mouseEvent) {
        if (this.isEnabled() && mouseEvent.getButton() == 1) {
            int n = mouseEvent.getClickCount();
            if (this.active == 1) {
                this.vsb.handleMouseEvent(mouseEvent.getID(), mouseEvent.getModifiers(), mouseEvent.getX() - (this.width - 13), mouseEvent.getY());
            } else if (this.active == 2) {
                this.hsb.handleMouseEvent(mouseEvent.getID(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY() - (this.height - 13));
            } else if (this.currentIndex >= 0 && n >= 2 && n % 2 == 0) {
                this.postEvent(new ActionEvent(this.target, 1001, (String)this.items.elementAt(this.currentIndex), mouseEvent.getWhen(), mouseEvent.getModifiers()));
            } else if (this.active == 0) {
                this.trackMouseReleasedScroll();
                if (this.eventType == 2) {
                    assert (this.multipleSelections) : "Shouldn't get a deselect for a single-select List";
                    this.deselectItem(this.eventIndex);
                }
                if (this.eventType != -1) {
                    this.postEvent(new ItemEvent((List)this.target, 701, this.eventIndex, this.eventType));
                }
            }
            this.active = -1;
            this.eventIndex = -1;
            this.eventType = -1;
            this.isMousePressed = false;
        }
    }

    void mouseDragged(MouseEvent mouseEvent) {
        if (this.isEnabled() && (mouseEvent.getModifiersEx() & 0x400) != 0) {
            if (this.active == 1) {
                this.vsb.handleMouseEvent(mouseEvent.getID(), mouseEvent.getModifiers(), mouseEvent.getX() - (this.width - 13), mouseEvent.getY());
            } else if (this.active == 2) {
                this.hsb.handleMouseEvent(mouseEvent.getID(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY() - (this.height - 13));
            } else if (this.active == 0) {
                int n = this.y2index(mouseEvent.getY());
                if (this.multipleSelections) {
                    if (this.eventType == 2 && n != this.eventIndex) {
                        this.eventType = -1;
                        this.eventIndex = -1;
                    }
                } else if (this.eventType == 1) {
                    this.trackMouseDraggedScroll(mouseEvent);
                    if (n >= 0 && !this.isSelected(n)) {
                        int n2 = this.eventIndex;
                        this.selectItem(n);
                        this.eventIndex = n;
                        this.repaint(n2, this.eventIndex, 8);
                    }
                }
                if (n >= 0) {
                    this.setFocusIndex(n);
                    this.repaint(16);
                }
            }
        }
    }

    void trackMouseDraggedScroll(MouseEvent mouseEvent) {
        if (this.vsb.beforeThumb(mouseEvent.getX(), mouseEvent.getY())) {
            this.vsb.setMode(2);
        } else {
            this.vsb.setMode(1);
        }
        if (mouseEvent.getY() < 0 || mouseEvent.getY() >= this.listHeight) {
            if (!this.mouseDraggedOutVertically) {
                this.mouseDraggedOutVertically = true;
                this.vsb.startScrollingInstance();
            }
        } else if (this.mouseDraggedOutVertically) {
            this.mouseDraggedOutVertically = false;
            this.vsb.stopScrollingInstance();
        }
        if (this.hsb.beforeThumb(mouseEvent.getX(), mouseEvent.getY())) {
            this.hsb.setMode(2);
        } else {
            this.hsb.setMode(1);
        }
        if (mouseEvent.getX() < 0 || mouseEvent.getX() >= this.listWidth) {
            if (!this.mouseDraggedOutHorizontally) {
                this.mouseDraggedOutHorizontally = true;
                this.hsb.startScrollingInstance();
            }
        } else if (this.mouseDraggedOutHorizontally) {
            this.mouseDraggedOutHorizontally = false;
            this.hsb.stopScrollingInstance();
        }
    }

    void trackMouseReleasedScroll() {
        if (this.mouseDraggedOutVertically) {
            this.mouseDraggedOutVertically = false;
            this.vsb.stopScrollingInstance();
        }
        if (this.mouseDraggedOutHorizontally) {
            this.mouseDraggedOutHorizontally = false;
            this.hsb.stopScrollingInstance();
        }
    }

    void handleJavaKeyEvent(KeyEvent keyEvent) {
        switch (keyEvent.getID()) {
            case 401: {
                if (this.isMousePressed) break;
                this.keyPressed(keyEvent);
            }
        }
    }

    void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (log.isLoggable(Level.FINE)) {
            log.fine(keyEvent.toString());
        }
        switch (n) {
            case 38: 
            case 224: {
                if (this.getFocusIndex() <= 0) break;
                this.setFocusIndex(this.getFocusIndex() - 1);
                this.repaint(64);
                if (!this.multipleSelections) {
                    this.selectItem(this.getFocusIndex());
                    this.postEvent(new ItemEvent((List)this.target, 701, this.getFocusIndex(), 1));
                }
                if (this.isItemHidden(this.getFocusIndex())) {
                    this.makeVisible(this.getFocusIndex());
                    break;
                }
                this.repaint(16);
                break;
            }
            case 40: 
            case 225: {
                if (this.getFocusIndex() >= this.items.size() - 1) break;
                this.setFocusIndex(this.getFocusIndex() + 1);
                this.repaint(64);
                if (!this.multipleSelections) {
                    this.selectItem(this.getFocusIndex());
                    this.postEvent(new ItemEvent((List)this.target, 701, this.getFocusIndex(), 1));
                }
                if (this.isItemHidden(this.getFocusIndex())) {
                    this.makeVisible(this.getFocusIndex());
                    break;
                }
                this.repaint(16);
                break;
            }
            case 33: {
                int n2 = this.vsb.getValue();
                this.vsb.setValue(this.vsb.getValue() - this.vsb.getBlockIncrement());
                int n3 = this.vsb.getValue();
                if (n2 != n3) {
                    this.setFocusIndex(Math.max(this.getFocusIndex() - this.itemsInWindow(), 0));
                    if (!this.multipleSelections) {
                        this.selectItem(this.getFocusIndex());
                        this.postEvent(new ItemEvent((List)this.target, 701, this.getFocusIndex(), 1));
                    }
                }
                this.repaint();
                break;
            }
            case 34: {
                int n4 = this.vsb.getValue();
                this.vsb.setValue(this.vsb.getValue() + this.vsb.getBlockIncrement());
                int n5 = this.vsb.getValue();
                if (n4 != n5) {
                    this.setFocusIndex(Math.min(this.getFocusIndex() + this.itemsInWindow(), this.items.size() - 1));
                    if (!this.multipleSelections) {
                        this.selectItem(this.getFocusIndex());
                        this.postEvent(new ItemEvent((List)this.target, 701, this.getFocusIndex(), 1));
                    }
                }
                this.repaint();
                break;
            }
            case 37: 
            case 226: {
                if (!(this.hsbVis & this.hsb.getValue() > 0)) break;
                this.hsb.setValue(this.hsb.getValue() - 10);
                this.repaint();
                break;
            }
            case 39: 
            case 227: {
                if (!this.hsbVis) break;
                this.hsb.setValue(this.hsb.getValue() + 10);
                this.repaint();
                break;
            }
            case 36: {
                if (!keyEvent.isControlDown() || ((List)this.target).getItemCount() <= 0) break;
                if (this.vsbVis) {
                    this.vsb.setValue(this.vsb.getMinimum());
                }
                this.setFocusIndex(0);
                if (!this.multipleSelections) {
                    this.selectItem(this.getFocusIndex());
                    this.postEvent(new ItemEvent((List)this.target, 701, this.getFocusIndex(), 1));
                }
                this.repaint();
                break;
            }
            case 35: {
                if (!keyEvent.isControlDown() || ((List)this.target).getItemCount() <= 0) break;
                if (this.vsbVis) {
                    this.vsb.setValue(this.vsb.getMaximum());
                }
                this.setFocusIndex(this.items.size() - 1);
                if (!this.multipleSelections) {
                    this.selectItem(this.getFocusIndex());
                    this.postEvent(new ItemEvent((List)this.target, 701, this.getFocusIndex(), 1));
                }
                this.repaint();
                break;
            }
            case 32: {
                if (this.getFocusIndex() < 0 || ((List)this.target).getItemCount() <= 0) break;
                boolean bl = this.isSelected(this.getFocusIndex());
                if (this.multipleSelections && bl) {
                    this.deselectItem(this.getFocusIndex());
                    this.postEvent(new ItemEvent((List)this.target, 701, this.getFocusIndex(), 2));
                    break;
                }
                if (bl) break;
                this.selectItem(this.getFocusIndex());
                this.postEvent(new ItemEvent((List)this.target, 701, this.getFocusIndex(), 1));
                break;
            }
            case 10: {
                if (this.selected.length <= 0) break;
                this.postEvent(new ActionEvent((List)this.target, 1001, (String)this.items.elementAt(this.getFocusIndex()), keyEvent.getWhen(), keyEvent.getModifiers()));
            }
        }
    }

    public void notifyValue(XScrollbar xScrollbar, int n, int n2, boolean bl) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Notify value changed on " + xScrollbar + " to " + n2);
        }
        int n3 = xScrollbar.getValue();
        if (xScrollbar == this.vsb) {
            this.scrollVertical(n2 - n3);
            int n4 = this.eventIndex;
            int n5 = this.eventIndex + n2 - n3;
            if (this.mouseDraggedOutVertically && !this.isSelected(n5)) {
                this.selectItem(n5);
                this.eventIndex = n5;
                this.repaint(n4, this.eventIndex, 8);
                this.setFocusIndex(n5);
                this.repaint(16);
            }
        } else if ((XHorizontalScrollbar)xScrollbar == this.hsb) {
            this.scrollHorizontal(n2 - n3);
        }
    }

    private void deselectAllItems() {
        this.selected = new int[0];
        this.repaint(8);
    }

    public void setMultipleSelections(boolean bl) {
        if (this.multipleSelections != bl) {
            if (!bl) {
                int n = this.isSelected(this.focusIndex) ? this.focusIndex : -1;
                this.deselectAllItems();
                if (n != -1) {
                    this.selectItem(n);
                }
            }
            this.multipleSelections = bl;
        }
    }

    public void addItem(String string, int n) {
        boolean bl;
        int n2 = this.maxLength;
        boolean bl2 = this.hsbVis;
        boolean bl3 = this.vsbVis;
        int n3 = 0;
        if (n < 0 || n >= this.items.size()) {
            n = -1;
        }
        this.currentIndex = -1;
        if (n == -1) {
            this.items.addElement(string);
            n = 0;
            n3 = this.items.size() - 1;
        } else {
            this.items.insertElementAt(string, n);
            n3 = n;
            for (bl = false; bl < this.selected.length; bl += 1) {
                if (this.selected[bl] < n) continue;
                boolean bl4 = bl;
                this.selected[bl4] = this.selected[bl4] + 1;
            }
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Adding item '" + string + "' to " + n3);
        }
        bl = !this.isItemHidden(n3);
        this.maxLength = Math.max(this.maxLength, this.getItemWidth(n3));
        this.layout();
        int n4 = 0;
        n4 = this.vsbVis != bl3 || this.hsbVis != bl2 ? 62 : (bl ? 8 : 0) | (this.maxLength != n2 || bl2 ^ this.hsbVis ? 4 : 0) | (this.vsb.needsRepaint() ? 2 : 0);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Last visible: " + this.getLastVisibleItem() + ", hsb changed : " + (bl2 ^ this.hsbVis) + ", items changed " + bl);
        }
        this.repaint(n3, this.getLastVisibleItem(), n4);
    }

    public void delItems(int n, int n2) {
        int n3;
        int n4;
        int n5;
        boolean bl = this.hsbVis;
        boolean bl2 = this.vsbVis;
        int n6 = this.lastItemDisplayed();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Deleting from " + n + " to " + n2);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Last displayed item: " + n6 + ", items in window " + this.itemsInWindow() + ", size " + this.items.size());
        }
        if (this.items.size() == 0) {
            return;
        }
        if (n > n2) {
            n5 = n;
            n = n2;
            n2 = n5;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 >= this.items.size()) {
            n2 = this.items.size() - 1;
        }
        n5 = n >= this.getFirstVisibleItem() && n <= this.getLastVisibleItem() ? 1 : 0;
        for (n4 = n; n4 <= n2; ++n4) {
            this.items.removeElementAt(n);
            n3 = this.posInSel(n4);
            if (n3 == -1) continue;
            int[] nArray = new int[this.selected.length - 1];
            System.arraycopy(this.selected, 0, nArray, 0, n3);
            System.arraycopy(this.selected, n3 + 1, nArray, n3, this.selected.length - (n3 + 1));
            this.selected = nArray;
        }
        n4 = n2 - n + 1;
        for (n3 = 0; n3 < this.selected.length; ++n3) {
            if (this.selected[n3] <= n2) continue;
            int n7 = n3;
            this.selected[n7] = this.selected[n7] - n4;
        }
        n3 = 2;
        if (this.getFocusIndex() > n2) {
            this.setFocusIndex(this.getFocusIndex() - (n2 - n + 1));
            n3 |= 0x10;
        } else if (this.getFocusIndex() >= n && this.getFocusIndex() <= n2) {
            int n8 = this.items.size() > 0 ? 0 : -1;
            this.setFocusIndex(Math.max(n - 1, n8));
            n3 |= 0x10;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Multiple selections: " + this.multipleSelections);
        }
        if (this.vsb.getValue() >= n) {
            if (this.vsb.getValue() <= n2) {
                this.vsb.setValue(n2 + 1 - n4);
            } else {
                this.vsb.setValue(this.vsb.getValue() - n4);
            }
        }
        int n9 = this.maxLength;
        this.maxLength = this.maxLength();
        if (this.maxLength != n9) {
            n3 |= 4;
        }
        this.layout();
        if ((n5 |= bl2 ^ this.vsbVis || bl ^ this.hsbVis ? 1 : 0) != 0) {
            n3 |= 0x3E;
        }
        this.repaint(n, n6, n3);
    }

    public void select(int n) {
        this.setFocusIndex(n);
        this.repaint(16);
        this.selectItem(n);
    }

    void selectItem(int n) {
        this.currentIndex = n;
        if (this.isSelected(n)) {
            return;
        }
        if (!this.multipleSelections) {
            if (this.selected.length == 0) {
                this.selected = new int[1];
                this.selected[0] = n;
            } else {
                int n2 = this.selected[0];
                this.selected[0] = n;
                if (!this.isItemHidden(n2)) {
                    this.repaint(n2, n2, 8);
                }
            }
        } else {
            int n3;
            int[] nArray = new int[this.selected.length + 1];
            for (n3 = 0; n3 < this.selected.length && n > this.selected[n3]; ++n3) {
                nArray[n3] = this.selected[n3];
            }
            nArray[n3] = n;
            System.arraycopy(this.selected, n3, nArray, n3 + 1, this.selected.length - n3);
            this.selected = nArray;
        }
        if (!this.isItemHidden(n)) {
            this.repaint(n, n, 8);
        }
    }

    public void deselect(int n) {
        this.deselectItem(n);
    }

    void deselectItem(int n) {
        if (!this.isSelected(n)) {
            return;
        }
        if (!this.multipleSelections) {
            this.selected = new int[0];
        } else {
            int n2 = this.posInSel(n);
            int[] nArray = new int[this.selected.length - 1];
            System.arraycopy(this.selected, 0, nArray, 0, n2);
            System.arraycopy(this.selected, n2 + 1, nArray, n2, this.selected.length - (n2 + 1));
            this.selected = nArray;
        }
        this.currentIndex = n;
        if (!this.isItemHidden(n)) {
            this.repaint(n, n, 8);
        }
    }

    public void makeVisible(int n) {
        if (n < 0 || n >= this.items.size()) {
            return;
        }
        if (this.isItemHidden(n)) {
            if (n < this.vsb.getValue()) {
                this.scrollVertical(n - this.vsb.getValue());
            } else if (n > this.lastItemDisplayed()) {
                int n2 = n - this.lastItemDisplayed();
                this.scrollVertical(n2);
            }
        }
    }

    public void clear() {
        this.selected = new int[0];
        this.items = new Vector();
        this.currentIndex = -1;
        this.setFocusIndex(-1);
        this.vsb.setValue(0);
        this.maxLength = 0;
        this.layout();
        this.repaint();
    }

    public int[] getSelectedIndexes() {
        return this.selected;
    }

    int index2y(int n) {
        int n2 = this.getItemHeight();
        return 2 + (n - this.vsb.getValue()) * n2 + 1;
    }

    boolean validY(int n) {
        int n2 = this.itemsDisplayed();
        int n3 = n2 * this.getItemHeight() + 2;
        if (n2 == this.itemsInWindow()) {
            n3 += 2;
        }
        return n >= 0 && n < n3;
    }

    int posInSel(int n) {
        for (int i = 0; i < this.selected.length; ++i) {
            if (n != this.selected[i]) continue;
            return i;
        }
        return -1;
    }

    boolean isIndexDisplayed(int n) {
        int n2 = this.lastItemDisplayed();
        return n <= n2 && n >= Math.max(0, n2 - this.itemsInWindow() + 1);
    }

    int lastItemDisplayed() {
        int n = this.itemsInWindow();
        return Math.min(this.items.size() - 1, this.vsb.getValue() + n - 1);
    }

    boolean isItemHidden(int n) {
        return n < this.vsb.getValue() || n >= this.vsb.getValue() + this.itemsInWindow();
    }

    int getListWidth() {
        return this.vsbVis ? this.width - 17 : this.width;
    }

    int itemsDisplayed() {
        return Math.min(this.items.size() - this.vsb.getValue(), this.itemsInWindow());
    }

    void scrollVertical(int n) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Scrolling vertically by " + n);
        }
        int n2 = this.itemsInWindow();
        int n3 = this.getItemHeight();
        int n4 = n * n3;
        if (this.vsb.getValue() < -n) {
            n = -this.vsb.getValue();
        }
        this.vsb.setValue(this.vsb.getValue() + n);
        if (n > 0) {
            if (n < n2 && this.painter.isBuffer()) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Copying 2," + (2 + n4) + "," + (this.width - 17) + "," + (n3 * (n2 - n) - 1) + "," + 0 + "," + -n4);
                }
                this.repaint(64);
                this.painter.copyArea(2, 2 + n4, this.width - 17, n3 * (n2 - n - 1) - 1, 0, -n4);
            }
            this.repaint(this.vsb.getValue() + (n2 - n) - 1, this.vsb.getValue() + n2 - 1, 26);
        } else if (n < 0 && this.painter.isBuffer()) {
            if (n + this.itemsInWindow() > 0) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Copying 2,2," + (this.width - 17) + "," + n3 * (n2 + n) + "," + "0" + "," + -n4);
                }
                this.repaint(64);
                this.painter.copyArea(2, 2, this.width - 17, n3 * (n2 + n), 0, -n4);
            }
            int n5 = Math.min(this.getLastVisibleItem(), this.vsb.getValue() + -n);
            this.repaint(this.vsb.getValue(), n5, 26);
        }
    }

    void scrollHorizontal(int n) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Scrolling horizontally by " + this.y);
        }
        int n2 = this.getListWidth();
        n2 -= 6;
        int n3 = this.height - 21;
        this.hsb.setValue(this.hsb.getValue() + n);
        if (n < 0 && this.painter.isBuffer()) {
            this.painter.copyArea(3, 2, n2 + n, n3, -n, 0);
        } else if (n > 0 && this.painter.isBuffer()) {
            this.painter.copyArea(3 + n, 2, n2 - n, n3, -n, 0);
        }
        this.repaint(this.vsb.getValue(), this.lastItemDisplayed(), 12);
    }

    int y2index(int n) {
        int n2;
        if (!this.validY(n)) {
            return -1;
        }
        int n3 = (n - 2) / this.getItemHeight() + this.vsb.getValue();
        if (n3 > (n2 = this.lastItemDisplayed())) {
            n3 = n2;
        }
        return n3;
    }

    boolean isSelected(int n) {
        if (this.eventType == 1 && n == this.eventIndex) {
            return true;
        }
        for (int i = 0; i < this.selected.length; ++i) {
            if (this.selected[i] != n) continue;
            return true;
        }
        return false;
    }

    int itemsInWindow(boolean bl) {
        int n = bl ? this.height - 21 : this.height - 4;
        return n / this.getItemHeight();
    }

    int itemsInWindow() {
        return this.itemsInWindow(this.hsbVis);
    }

    boolean inHorizontalScrollbar(int n, int n2) {
        int n3 = this.getListWidth();
        int n4 = this.height - 13;
        return this.hsbVis && n >= 0 && n <= n3 && n2 > n4;
    }

    boolean inVerticalScrollbar(int n, int n2) {
        int n3 = this.width - 13;
        int n4 = this.hsbVis ? this.height - 17 : this.height;
        return this.vsbVis && n > n3 && n2 >= 0 && n2 <= n4;
    }

    boolean inWindow(int n, int n2) {
        int n3 = this.getListWidth();
        int n4 = this.hsbVis ? this.height - 17 : this.height;
        return n >= 0 && n <= n3 && n2 >= 0 && n2 <= n4;
    }

    boolean vsbIsVisible(boolean bl) {
        return this.items.size() > this.itemsInWindow(bl);
    }

    boolean hsbIsVisible(boolean bl) {
        int n = this.width - (6 + (bl ? 17 : 0));
        return this.maxLength > n;
    }

    boolean prePostEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof MouseEvent) {
            return this.prePostMouseEvent((MouseEvent)aWTEvent);
        }
        return super.prePostEvent(aWTEvent);
    }

    boolean prePostMouseEvent(MouseEvent mouseEvent) {
        if (this.getToplevelXWindow().isModalBlocked()) {
            return false;
        }
        int n = mouseEvent.getID();
        if (n != 503) {
            if ((n == 506 || n == 502) && this.isScrollBarOriginated) {
                if (n == 502) {
                    this.isScrollBarOriginated = false;
                }
                this.handleJavaMouseEventOnEDT(mouseEvent);
                return true;
            }
            if ((n == 501 || n == 500) && (this.inVerticalScrollbar(mouseEvent.getX(), mouseEvent.getY()) || this.inHorizontalScrollbar(mouseEvent.getX(), mouseEvent.getY()))) {
                if (n == 501) {
                    this.isScrollBarOriginated = true;
                }
                this.handleJavaMouseEventOnEDT(mouseEvent);
                return true;
            }
        }
        return false;
    }

    void handleJavaMouseEventOnEDT(final MouseEvent mouseEvent) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                XListPeer.this.handleJavaMouseEvent(mouseEvent);
            }
        });
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.initFontMetrics();
        this.layout();
        this.repaint();
    }

    class ListPainter {
        VolatileImage buffer;
        Color[] colors;
        private Rectangle prevFocusRect;

        ListPainter() {
        }

        private Color getListForeground() {
            if (XListPeer.this.fgColorSet) {
                return this.colors[3];
            }
            return SystemColor.textText;
        }

        private Color getListBackground() {
            if (XListPeer.this.bgColorSet) {
                return this.colors[0];
            }
            return SystemColor.text;
        }

        private Color getDisabledColor() {
            Color color = this.getListBackground();
            Color color2 = this.getListForeground();
            return color.equals(Color.BLACK) ? color2.darker() : color.darker();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean createBuffer() {
            VolatileImage volatileImage = null;
            XToolkit.awtLock();
            try {
                volatileImage = this.buffer;
            }
            finally {
                XToolkit.awtUnlock();
            }
            if (volatileImage == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Creating buffer " + XListPeer.this.width + "x" + XListPeer.this.height);
                }
                volatileImage = XListPeer.this.graphicsConfig.createCompatibleVolatileImage(XListPeer.this.width + 1, XListPeer.this.height + 1);
            }
            XToolkit.awtLock();
            try {
                if (this.buffer == null) {
                    this.buffer = volatileImage;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                XToolkit.awtUnlock();
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invalidate() {
            XToolkit.awtLock();
            try {
                if (this.buffer != null) {
                    this.buffer.flush();
                }
                this.buffer = null;
            }
            finally {
                XToolkit.awtUnlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paint(Graphics graphics, int n, int n2, int n3) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Repaint from " + n + " to " + n2 + " options " + n3);
            }
            if (n > n2) {
                int n4 = n2;
                n2 = n;
                n = n4;
            }
            if (n < 0) {
                n = 0;
            }
            this.colors = XListPeer.this.getGUIcolors();
            VolatileImage volatileImage = null;
            block9: do {
                XToolkit.awtLock();
                try {
                    if (this.createBuffer()) {
                        n3 = 62;
                    }
                    volatileImage = this.buffer;
                }
                finally {
                    XToolkit.awtUnlock();
                }
                switch (volatileImage.validate(XListPeer.this.getGraphicsConfiguration())) {
                    case 2: {
                        this.invalidate();
                        n3 = 62;
                        break;
                    }
                    default: {
                        Graphics2D graphics2D = volatileImage.createGraphics();
                        try {
                            graphics2D.setFont(XListPeer.this.getFont());
                            if ((n3 & 0x20) != 0) {
                                graphics2D.setColor(SystemColor.window);
                                graphics2D.fillRect(0, 0, XListPeer.this.width, XListPeer.this.height);
                                graphics2D.setColor(this.getListBackground());
                                graphics2D.fillRect(0, 0, XListPeer.this.listWidth, XListPeer.this.listHeight);
                                XListPeer.this.draw3DRect((Graphics)graphics2D, XComponentPeer.getSystemColors(), 0, 0, XListPeer.this.listWidth - 1, XListPeer.this.listHeight - 1, false);
                                n = XListPeer.this.getFirstVisibleItem();
                                n2 = XListPeer.this.getLastVisibleItem();
                            }
                            if ((n3 & 8) != 0) {
                                this.paintItems(graphics2D, n, n2, n3);
                            }
                            if ((n3 & 2) != 0 && XListPeer.this.vsbVis) {
                                graphics2D.setClip(XListPeer.this.getVScrollBarRec());
                                this.paintVerScrollbar(graphics2D, true);
                            }
                            if ((n3 & 4) != 0 && XListPeer.this.hsbVis) {
                                graphics2D.setClip(XListPeer.this.getHScrollBarRec());
                                this.paintHorScrollbar(graphics2D, true);
                            }
                            if ((n3 & 0x50) == 0) continue block9;
                            this.paintFocus(graphics2D, n3);
                            continue block9;
                        }
                        finally {
                            graphics2D.dispose();
                        }
                    }
                }
            } while (volatileImage.contentsLost());
            graphics.drawImage(volatileImage, 0, 0, null);
        }

        private void paintItems(Graphics graphics, int n, int n2, int n3) {
            int n4;
            if (log.isLoggable(Level.FINER)) {
                log.finer("Painting items from " + n + " to " + n2 + ", focused " + XListPeer.this.focusIndex + ", first " + XListPeer.this.getFirstVisibleItem() + ", last " + XListPeer.this.getLastVisibleItem());
            }
            if ((n = Math.max(XListPeer.this.getFirstVisibleItem(), n)) > n2) {
                n4 = n2;
                n2 = n;
                n = n4;
            }
            n = Math.max(XListPeer.this.getFirstVisibleItem(), n);
            n2 = Math.min(n2, XListPeer.this.items.size() - 1);
            if (log.isLoggable(Level.FINER)) {
                log.finer("Actually painting items from " + n + " to " + n2 + ", items in window " + XListPeer.this.itemsInWindow());
            }
            for (n4 = n; n4 <= n2; ++n4) {
                this.paintItem(graphics, n4);
            }
        }

        private void paintItem(Graphics graphics, int n) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Painting item " + n);
            }
            if (!XListPeer.this.isItemHidden(n)) {
                Shape shape = graphics.getClip();
                int n2 = XListPeer.this.getItemWidth();
                int n3 = XListPeer.this.getItemHeight();
                int n4 = XListPeer.this.getItemY(n);
                int n5 = XListPeer.this.getItemX();
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Setting clip " + new Rectangle(n5, n4, n2 - 2, n3 - 2));
                }
                graphics.setClip(n5, n4, n2 - 2, n3 - 2);
                if (XListPeer.this.isSelected(n)) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Painted item is selected");
                    }
                    graphics.setColor(this.getListForeground());
                } else {
                    graphics.setColor(this.getListBackground());
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Filling " + new Rectangle(n5, n4, n2, n3));
                }
                graphics.fillRect(n5, n4, n2, n3);
                if (n <= XListPeer.this.getLastVisibleItem() && n < XListPeer.this.items.size()) {
                    if (!XListPeer.this.isEnabled()) {
                        graphics.setColor(this.getDisabledColor());
                    } else if (XListPeer.this.isSelected(n)) {
                        graphics.setColor(this.getListBackground());
                    } else {
                        graphics.setColor(this.getListForeground());
                    }
                    String string = (String)XListPeer.this.items.elementAt(n);
                    graphics.drawString(string, n5 - XListPeer.this.hsb.getValue(), n4 + XListPeer.this.fontAscent);
                } else {
                    graphics.setClip(n5, n4, XListPeer.this.listWidth, n3);
                    graphics.setColor(this.getListBackground());
                    graphics.fillRect(n5, n4, XListPeer.this.listWidth, n3);
                }
                graphics.setClip(shape);
            }
        }

        void paintScrollBar(XScrollbar xScrollbar, Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Painting scrollbar " + xScrollbar + " width " + n3 + " height " + n4 + ", paintAll " + bl);
            }
            graphics.translate(n, n2);
            xScrollbar.paint(graphics, XComponentPeer.getSystemColors(), bl);
            graphics.translate(-n, -n2);
        }

        void paintHorScrollbar(Graphics graphics, boolean bl) {
            int n = XListPeer.this.getListWidth();
            this.paintScrollBar(XListPeer.this.hsb, graphics, 0, XListPeer.this.height - 13, n, 13, bl);
        }

        void paintVerScrollbar(Graphics graphics, boolean bl) {
            int n = XListPeer.this.height - (XListPeer.this.hsbVis ? 15 : 0);
            this.paintScrollBar(XListPeer.this.vsb, graphics, XListPeer.this.width - 13, 0, 11, n, bl);
        }

        private void paintFocus(Graphics graphics, int n) {
            boolean bl;
            boolean bl2 = bl = (n & 0x10) != 0;
            if (bl && !XListPeer.this.hasFocus()) {
                bl = false;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Painting focus, focus index " + XListPeer.this.getFocusIndex() + ", focus is " + (XListPeer.this.isItemHidden(XListPeer.this.getFocusIndex()) ? "invisible" : "visible") + ", paint focus is " + bl);
            }
            Shape shape = graphics.getClip();
            graphics.setClip(0, 0, XListPeer.this.listWidth, XListPeer.this.listHeight);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Setting focus clip " + new Rectangle(0, 0, XListPeer.this.listWidth, XListPeer.this.listHeight));
            }
            Rectangle rectangle = XListPeer.this.getFocusRect();
            if (this.prevFocusRect != null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Erasing previous focus rect " + this.prevFocusRect);
                }
                graphics.setColor(this.getListBackground());
                graphics.drawRect(this.prevFocusRect.x, this.prevFocusRect.y, this.prevFocusRect.width, this.prevFocusRect.height);
                this.prevFocusRect = null;
            }
            if (bl) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Painting focus rect " + rectangle);
                }
                graphics.setColor(this.getListForeground());
                graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                this.prevFocusRect = rectangle;
            }
            graphics.setClip(shape);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
            Graphics graphics;
            if (log.isLoggable(Level.FINER)) {
                log.finer("Copying area " + n + ", " + n2 + " " + n3 + "x" + n4 + ", (" + n5 + "," + n6 + ")");
            }
            VolatileImage volatileImage = null;
            do {
                XToolkit.awtLock();
                try {
                    if (this.createBuffer()) {
                        XListPeer.this.repaint(62);
                        return;
                    }
                    volatileImage = this.buffer;
                }
                finally {
                    XToolkit.awtUnlock();
                }
                switch (volatileImage.validate(XListPeer.this.getGraphicsConfiguration())) {
                    case 2: {
                        this.invalidate();
                    }
                    case 1: {
                        XListPeer.this.repaint(62);
                        return;
                    }
                }
                graphics = volatileImage.createGraphics();
                try {
                    graphics.copyArea(n, n2, n3, n4, n5, n6);
                }
                finally {
                    graphics.dispose();
                }
            } while (volatileImage.contentsLost());
            graphics = XListPeer.this.getGraphics();
            graphics.setClip(n, n2, n3, n4);
            graphics.drawImage(volatileImage, 0, 0, null);
            graphics.dispose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isBuffer() {
            boolean bl;
            XToolkit.awtLock();
            try {
                bl = this.buffer != null;
            }
            finally {
                XToolkit.awtUnlock();
            }
            return bl;
        }
    }
}

