/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.corba;

import com.sun.corba.se.impl.corba.AnyImpl;
import com.sun.corba.se.impl.corba.TypeCodeFactory;
import com.sun.corba.se.impl.encoding.CDRInputStream;
import com.sun.corba.se.impl.encoding.CDROutputStream;
import com.sun.corba.se.impl.encoding.TypeCodeInputStream;
import com.sun.corba.se.impl.encoding.TypeCodeOutputStream;
import com.sun.corba.se.impl.encoding.TypeCodeReader;
import com.sun.corba.se.impl.encoding.WrapperInputStream;
import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.spi.orb.ORB;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigDecimal;
import org.omg.CORBA.Any;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.ValueMember;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public final class TypeCodeImpl
extends TypeCode {
    protected static final int tk_indirect = -1;
    private static final int EMPTY = 0;
    private static final int SIMPLE = 1;
    private static final int COMPLEX = 2;
    private static final int[] typeTable = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 1, 2, 2, 2, 2, 0, 0, 0, 0, 1, 1, 2, 2, 2, 2};
    static final String[] kindNames = new String[]{"null", "void", "short", "long", "ushort", "ulong", "float", "double", "boolean", "char", "octet", "any", "typecode", "principal", "objref", "struct", "union", "enum", "string", "sequence", "array", "alias", "exception", "longlong", "ulonglong", "longdouble", "wchar", "wstring", "fixed", "value", "valueBox", "native", "abstractInterface"};
    private int _kind = 0;
    private String _id = "";
    private String _name = "";
    private int _memberCount = 0;
    private String[] _memberNames = null;
    private TypeCodeImpl[] _memberTypes = null;
    private AnyImpl[] _unionLabels = null;
    private TypeCodeImpl _discriminator = null;
    private int _defaultIndex = -1;
    private int _length = 0;
    private TypeCodeImpl _contentType = null;
    private short _digits = 0;
    private short _scale = 0;
    private short _type_modifier = (short)-1;
    private TypeCodeImpl _concrete_base = null;
    private short[] _memberAccess = null;
    private TypeCodeImpl _parent = null;
    private int _parentOffset = 0;
    private TypeCodeImpl _indirectType = null;
    private byte[] outBuffer = null;
    private boolean cachingEnabled = false;
    private ORB _orb;
    private ORBUtilSystemException wrapper;

    public TypeCodeImpl(ORB oRB) {
        this._orb = oRB;
        this.wrapper = ORBUtilSystemException.get(oRB, "rpc.presentation");
    }

    public TypeCodeImpl(ORB oRB, TypeCode typeCode) {
        this(oRB);
        TypeCode typeCode2;
        if (typeCode instanceof TypeCodeImpl) {
            typeCode2 = (TypeCodeImpl)typeCode;
            if (typeCode2._kind == -1) {
                throw this.wrapper.badRemoteTypecode();
            }
            if (typeCode2._kind == 19 && typeCode2._contentType == null) {
                throw this.wrapper.badRemoteTypecode();
            }
        }
        this._kind = typeCode.kind().value();
        try {
            switch (this._kind) {
                case 29: {
                    int n;
                    this._type_modifier = typeCode.type_modifier();
                    typeCode2 = typeCode.concrete_base_type();
                    this._concrete_base = typeCode2 != null ? TypeCodeImpl.convertToNative(this._orb, typeCode2) : null;
                    this._memberAccess = new short[typeCode.member_count()];
                    for (n = 0; n < typeCode.member_count(); ++n) {
                        this._memberAccess[n] = typeCode.member_visibility(n);
                    }
                }
                case 15: 
                case 16: 
                case 22: {
                    int n;
                    this._memberTypes = new TypeCodeImpl[typeCode.member_count()];
                    for (n = 0; n < typeCode.member_count(); ++n) {
                        this._memberTypes[n] = TypeCodeImpl.convertToNative(this._orb, typeCode.member_type(n));
                        this._memberTypes[n].setParent(this);
                    }
                }
                case 17: {
                    int n;
                    this._memberNames = new String[typeCode.member_count()];
                    for (n = 0; n < typeCode.member_count(); ++n) {
                        this._memberNames[n] = typeCode.member_name(n);
                    }
                    this._memberCount = typeCode.member_count();
                }
                case 14: 
                case 21: 
                case 30: 
                case 31: 
                case 32: {
                    this.setId(typeCode.id());
                    this._name = typeCode.name();
                }
            }
            switch (this._kind) {
                case 16: {
                    this._discriminator = TypeCodeImpl.convertToNative(this._orb, typeCode.discriminator_type());
                    this._defaultIndex = typeCode.default_index();
                    this._unionLabels = new AnyImpl[this._memberCount];
                    for (int i = 0; i < this._memberCount; ++i) {
                        this._unionLabels[i] = new AnyImpl(this._orb, typeCode.member_label(i));
                    }
                    break;
                }
            }
            switch (this._kind) {
                case 18: 
                case 19: 
                case 20: 
                case 27: {
                    this._length = typeCode.length();
                }
            }
            switch (this._kind) {
                case 19: 
                case 20: 
                case 21: 
                case 30: {
                    this._contentType = TypeCodeImpl.convertToNative(this._orb, typeCode.content_type());
                }
            }
        }
        catch (Bounds bounds) {
        }
        catch (BadKind badKind) {
            // empty catch block
        }
    }

    public TypeCodeImpl(ORB oRB, int n) {
        this(oRB);
        this._kind = n;
        switch (this._kind) {
            case 14: {
                this.setId("IDL:omg.org/CORBA/Object:1.0");
                this._name = "Object";
                break;
            }
            case 18: 
            case 27: {
                this._length = 0;
                break;
            }
            case 29: {
                this._concrete_base = null;
            }
        }
    }

    public TypeCodeImpl(ORB oRB, int n, String string, String string2, StructMember[] structMemberArray) {
        this(oRB);
        if (n == 15 || n == 22) {
            this._kind = n;
            this.setId(string);
            this._name = string2;
            this._memberCount = structMemberArray.length;
            this._memberNames = new String[this._memberCount];
            this._memberTypes = new TypeCodeImpl[this._memberCount];
            for (int i = 0; i < this._memberCount; ++i) {
                this._memberNames[i] = structMemberArray[i].name;
                this._memberTypes[i] = TypeCodeImpl.convertToNative(this._orb, structMemberArray[i].type);
                this._memberTypes[i].setParent(this);
            }
        }
    }

    public TypeCodeImpl(ORB oRB, int n, String string, String string2, TypeCode typeCode, UnionMember[] unionMemberArray) {
        this(oRB);
        if (n == 16) {
            this._kind = n;
            this.setId(string);
            this._name = string2;
            this._memberCount = unionMemberArray.length;
            this._discriminator = TypeCodeImpl.convertToNative(this._orb, typeCode);
            this._memberNames = new String[this._memberCount];
            this._memberTypes = new TypeCodeImpl[this._memberCount];
            this._unionLabels = new AnyImpl[this._memberCount];
            for (int i = 0; i < this._memberCount; ++i) {
                this._memberNames[i] = unionMemberArray[i].name;
                this._memberTypes[i] = TypeCodeImpl.convertToNative(this._orb, unionMemberArray[i].type);
                this._memberTypes[i].setParent(this);
                this._unionLabels[i] = new AnyImpl(this._orb, unionMemberArray[i].label);
                if (this._unionLabels[i].type().kind() != TCKind.tk_octet || this._unionLabels[i].extract_octet() != 0) continue;
                this._defaultIndex = i;
            }
        }
    }

    public TypeCodeImpl(ORB oRB, int n, String string, String string2, short s, TypeCode typeCode, ValueMember[] valueMemberArray) {
        this(oRB);
        if (n == 29) {
            this._kind = n;
            this.setId(string);
            this._name = string2;
            this._type_modifier = s;
            if (typeCode != null) {
                this._concrete_base = TypeCodeImpl.convertToNative(this._orb, typeCode);
            }
            this._memberCount = valueMemberArray.length;
            this._memberNames = new String[this._memberCount];
            this._memberTypes = new TypeCodeImpl[this._memberCount];
            this._memberAccess = new short[this._memberCount];
            for (int i = 0; i < this._memberCount; ++i) {
                this._memberNames[i] = valueMemberArray[i].name;
                this._memberTypes[i] = TypeCodeImpl.convertToNative(this._orb, valueMemberArray[i].type);
                this._memberTypes[i].setParent(this);
                this._memberAccess[i] = valueMemberArray[i].access;
            }
        }
    }

    public TypeCodeImpl(ORB oRB, int n, String string, String string2, String[] stringArray) {
        this(oRB);
        if (n == 17) {
            this._kind = n;
            this.setId(string);
            this._name = string2;
            this._memberCount = stringArray.length;
            this._memberNames = new String[this._memberCount];
            for (int i = 0; i < this._memberCount; ++i) {
                this._memberNames[i] = stringArray[i];
            }
        }
    }

    public TypeCodeImpl(ORB oRB, int n, String string, String string2, TypeCode typeCode) {
        this(oRB);
        if (n == 21 || n == 30) {
            this._kind = n;
            this.setId(string);
            this._name = string2;
            this._contentType = TypeCodeImpl.convertToNative(this._orb, typeCode);
        }
    }

    public TypeCodeImpl(ORB oRB, int n, String string, String string2) {
        this(oRB);
        if (n == 14 || n == 31 || n == 32) {
            this._kind = n;
            this.setId(string);
            this._name = string2;
        }
    }

    public TypeCodeImpl(ORB oRB, int n, int n2) {
        this(oRB);
        if (n2 < 0) {
            throw this.wrapper.negativeBounds();
        }
        if (n == 18 || n == 27) {
            this._kind = n;
            this._length = n2;
        }
    }

    public TypeCodeImpl(ORB oRB, int n, int n2, TypeCode typeCode) {
        this(oRB);
        if (n == 19 || n == 20) {
            this._kind = n;
            this._length = n2;
            this._contentType = TypeCodeImpl.convertToNative(this._orb, typeCode);
        }
    }

    public TypeCodeImpl(ORB oRB, int n, int n2, int n3) {
        this(oRB);
        if (n == 19) {
            this._kind = n;
            this._length = n2;
            this._parentOffset = n3;
        }
    }

    public TypeCodeImpl(ORB oRB, String string) {
        this(oRB);
        this._kind = -1;
        this._id = string;
        this.tryIndirectType();
    }

    public TypeCodeImpl(ORB oRB, int n, short s, short s2) {
        this(oRB);
        if (n == 28) {
            this._kind = n;
            this._digits = s;
            this._scale = s2;
        }
    }

    protected static TypeCodeImpl convertToNative(ORB oRB, TypeCode typeCode) {
        if (typeCode instanceof TypeCodeImpl) {
            return (TypeCodeImpl)typeCode;
        }
        return new TypeCodeImpl(oRB, typeCode);
    }

    public static CDROutputStream newOutputStream(ORB oRB) {
        TypeCodeOutputStream typeCodeOutputStream = new TypeCodeOutputStream(oRB);
        return typeCodeOutputStream;
    }

    private TypeCodeImpl indirectType() {
        this._indirectType = this.tryIndirectType();
        if (this._indirectType == null) {
            throw this.wrapper.unresolvedRecursiveTypecode();
        }
        return this._indirectType;
    }

    private TypeCodeImpl tryIndirectType() {
        if (this._indirectType != null) {
            return this._indirectType;
        }
        this.setIndirectType(this._orb.getTypeCode(this._id));
        return this._indirectType;
    }

    private void setIndirectType(TypeCodeImpl typeCodeImpl) {
        this._indirectType = typeCodeImpl;
        if (this._indirectType != null) {
            try {
                this._id = this._indirectType.id();
            }
            catch (BadKind badKind) {
                throw this.wrapper.badkindCannotOccur();
            }
        }
    }

    private void setId(String string) {
        this._id = string;
        if (this._orb instanceof TypeCodeFactory) {
            this._orb.setTypeCode(this._id, this);
        }
    }

    private void setParent(TypeCodeImpl typeCodeImpl) {
        this._parent = typeCodeImpl;
    }

    private TypeCodeImpl getParentAtLevel(int n) {
        if (n == 0) {
            return this;
        }
        if (this._parent == null) {
            throw this.wrapper.unresolvedRecursiveTypecode();
        }
        return this._parent.getParentAtLevel(n - 1);
    }

    private TypeCodeImpl lazy_content_type() {
        TypeCodeImpl typeCodeImpl;
        if (this._contentType == null && this._kind == 19 && this._parentOffset > 0 && this._parent != null && (typeCodeImpl = this.getParentAtLevel(this._parentOffset)) != null && typeCodeImpl._id != null) {
            this._contentType = new TypeCodeImpl(this._orb, typeCodeImpl._id);
        }
        return this._contentType;
    }

    private TypeCode realType(TypeCode typeCode) {
        TypeCode typeCode2 = typeCode;
        try {
            while (typeCode2.kind().value() == 21) {
                typeCode2 = typeCode2.content_type();
            }
        }
        catch (BadKind badKind) {
            throw this.wrapper.badkindCannotOccur();
        }
        return typeCode2;
    }

    public final boolean equal(TypeCode typeCode) {
        if (typeCode == this) {
            return true;
        }
        try {
            if (this._kind == -1) {
                if (this._id != null && typeCode.id() != null) {
                    return this._id.equals(typeCode.id());
                }
                return this._id == null && typeCode.id() == null;
            }
            if (this._kind != typeCode.kind().value()) {
                return false;
            }
            switch (typeTable[this._kind]) {
                case 0: {
                    return true;
                }
                case 1: {
                    switch (this._kind) {
                        case 18: 
                        case 27: {
                            return this._length == typeCode.length();
                        }
                        case 28: {
                            return this._digits == typeCode.fixed_digits() && this._scale == typeCode.fixed_scale();
                        }
                    }
                    return false;
                }
                case 2: {
                    switch (this._kind) {
                        case 14: {
                            if (this._id.compareTo(typeCode.id()) == 0) {
                                return true;
                            }
                            if (this._id.compareTo(this._orb.get_primitive_tc(this._kind).id()) == 0) {
                                return true;
                            }
                            return typeCode.id().compareTo(this._orb.get_primitive_tc(this._kind).id()) == 0;
                        }
                        case 31: 
                        case 32: {
                            return this._id.compareTo(typeCode.id()) == 0;
                        }
                        case 15: 
                        case 22: {
                            if (this._memberCount != typeCode.member_count()) {
                                return false;
                            }
                            if (this._id.compareTo(typeCode.id()) != 0) {
                                return false;
                            }
                            for (int i = 0; i < this._memberCount; ++i) {
                                if (this._memberTypes[i].equal(typeCode.member_type(i))) continue;
                                return false;
                            }
                            return true;
                        }
                        case 16: {
                            int n;
                            if (this._memberCount != typeCode.member_count()) {
                                return false;
                            }
                            if (this._id.compareTo(typeCode.id()) != 0) {
                                return false;
                            }
                            if (this._defaultIndex != typeCode.default_index()) {
                                return false;
                            }
                            if (!this._discriminator.equal(typeCode.discriminator_type())) {
                                return false;
                            }
                            for (n = 0; n < this._memberCount; ++n) {
                                if (this._unionLabels[n].equal(typeCode.member_label(n))) continue;
                                return false;
                            }
                            for (n = 0; n < this._memberCount; ++n) {
                                if (this._memberTypes[n].equal(typeCode.member_type(n))) continue;
                                return false;
                            }
                            return true;
                        }
                        case 17: {
                            if (this._id.compareTo(typeCode.id()) != 0) {
                                return false;
                            }
                            return this._memberCount == typeCode.member_count();
                        }
                        case 19: 
                        case 20: {
                            if (this._length != typeCode.length()) {
                                return false;
                            }
                            return this.lazy_content_type().equal(typeCode.content_type());
                        }
                        case 29: {
                            if (this._memberCount != typeCode.member_count()) {
                                return false;
                            }
                            if (this._id.compareTo(typeCode.id()) != 0) {
                                return false;
                            }
                            for (int i = 0; i < this._memberCount; ++i) {
                                if (this._memberAccess[i] == typeCode.member_visibility(i) && this._memberTypes[i].equal(typeCode.member_type(i))) continue;
                                return false;
                            }
                            if (this._type_modifier == typeCode.type_modifier()) {
                                return false;
                            }
                            TypeCode typeCode2 = typeCode.concrete_base_type();
                            return !(this._concrete_base == null && typeCode2 != null || this._concrete_base != null && typeCode2 == null) && this._concrete_base.equal(typeCode2);
                        }
                        case 21: 
                        case 30: {
                            if (this._id.compareTo(typeCode.id()) != 0) {
                                return false;
                            }
                            return this._contentType.equal(typeCode.content_type());
                        }
                    }
                }
            }
        }
        catch (Bounds bounds) {
        }
        catch (BadKind badKind) {
            // empty catch block
        }
        return false;
    }

    public boolean equivalent(TypeCode typeCode) {
        if (typeCode == this) {
            return true;
        }
        TypeCode typeCode2 = this._kind == -1 ? this.indirectType() : this;
        typeCode2 = this.realType(typeCode2);
        TypeCode typeCode3 = this.realType(typeCode);
        if (typeCode2.kind().value() != typeCode3.kind().value()) {
            return false;
        }
        String string = null;
        String string2 = null;
        try {
            string = this.id();
            string2 = typeCode.id();
            if (string != null && string2 != null) {
                return string.equals(string2);
            }
        }
        catch (BadKind badKind) {
            // empty catch block
        }
        int n = typeCode2.kind().value();
        try {
            int n2;
            if ((n == 15 || n == 16 || n == 17 || n == 22 || n == 29) && typeCode2.member_count() != typeCode3.member_count()) {
                return false;
            }
            if (n == 16 && typeCode2.default_index() != typeCode3.default_index()) {
                return false;
            }
            if ((n == 18 || n == 27 || n == 19 || n == 20) && typeCode2.length() != typeCode3.length()) {
                return false;
            }
            if (n == 28 && (typeCode2.fixed_digits() != typeCode3.fixed_digits() || typeCode2.fixed_scale() != typeCode3.fixed_scale())) {
                return false;
            }
            if (n == 16) {
                for (n2 = 0; n2 < typeCode2.member_count(); ++n2) {
                    if (typeCode2.member_label(n2) == typeCode3.member_label(n2)) continue;
                    return false;
                }
                if (!typeCode2.discriminator_type().equivalent(typeCode3.discriminator_type())) {
                    return false;
                }
            }
            if (!(n != 21 && n != 30 && n != 19 && n != 20 || typeCode2.content_type().equivalent(typeCode3.content_type()))) {
                return false;
            }
            if (n == 15 || n == 16 || n == 22 || n == 29) {
                for (n2 = 0; n2 < typeCode2.member_count(); ++n2) {
                    if (typeCode2.member_type(n2).equivalent(typeCode3.member_type(n2))) continue;
                    return false;
                }
            }
        }
        catch (BadKind badKind) {
            throw this.wrapper.badkindCannotOccur();
        }
        catch (Bounds bounds) {
            throw this.wrapper.boundsCannotOccur();
        }
        return true;
    }

    public TypeCode get_compact_typecode() {
        return this;
    }

    public TCKind kind() {
        if (this._kind == -1) {
            return this.indirectType().kind();
        }
        return TCKind.from_int(this._kind);
    }

    public boolean is_recursive() {
        return this._kind == -1;
    }

    public String id() throws BadKind {
        switch (this._kind) {
            case -1: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                return this._id;
            }
        }
        throw new BadKind();
    }

    public String name() throws BadKind {
        switch (this._kind) {
            case -1: {
                return this.indirectType().name();
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                return this._name;
            }
        }
        throw new BadKind();
    }

    public int member_count() throws BadKind {
        switch (this._kind) {
            case -1: {
                return this.indirectType().member_count();
            }
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 29: {
                return this._memberCount;
            }
        }
        throw new BadKind();
    }

    public String member_name(int n) throws BadKind, Bounds {
        switch (this._kind) {
            case -1: {
                return this.indirectType().member_name(n);
            }
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 29: {
                try {
                    return this._memberNames[n];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new Bounds();
                }
            }
        }
        throw new BadKind();
    }

    public TypeCode member_type(int n) throws BadKind, Bounds {
        switch (this._kind) {
            case -1: {
                return this.indirectType().member_type(n);
            }
            case 15: 
            case 16: 
            case 22: 
            case 29: {
                try {
                    return this._memberTypes[n];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new Bounds();
                }
            }
        }
        throw new BadKind();
    }

    public Any member_label(int n) throws BadKind, Bounds {
        switch (this._kind) {
            case -1: {
                return this.indirectType().member_label(n);
            }
            case 16: {
                try {
                    return new AnyImpl(this._orb, this._unionLabels[n]);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new Bounds();
                }
            }
        }
        throw new BadKind();
    }

    public TypeCode discriminator_type() throws BadKind {
        switch (this._kind) {
            case -1: {
                return this.indirectType().discriminator_type();
            }
            case 16: {
                return this._discriminator;
            }
        }
        throw new BadKind();
    }

    public int default_index() throws BadKind {
        switch (this._kind) {
            case -1: {
                return this.indirectType().default_index();
            }
            case 16: {
                return this._defaultIndex;
            }
        }
        throw new BadKind();
    }

    public int length() throws BadKind {
        switch (this._kind) {
            case -1: {
                return this.indirectType().length();
            }
            case 18: 
            case 19: 
            case 20: 
            case 27: {
                return this._length;
            }
        }
        throw new BadKind();
    }

    public TypeCode content_type() throws BadKind {
        switch (this._kind) {
            case -1: {
                return this.indirectType().content_type();
            }
            case 19: {
                return this.lazy_content_type();
            }
            case 20: 
            case 21: 
            case 30: {
                return this._contentType;
            }
        }
        throw new BadKind();
    }

    public short fixed_digits() throws BadKind {
        switch (this._kind) {
            case 28: {
                return this._digits;
            }
        }
        throw new BadKind();
    }

    public short fixed_scale() throws BadKind {
        switch (this._kind) {
            case 28: {
                return this._scale;
            }
        }
        throw new BadKind();
    }

    public short member_visibility(int n) throws BadKind, Bounds {
        switch (this._kind) {
            case -1: {
                return this.indirectType().member_visibility(n);
            }
            case 29: {
                try {
                    return this._memberAccess[n];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new Bounds();
                }
            }
        }
        throw new BadKind();
    }

    public short type_modifier() throws BadKind {
        switch (this._kind) {
            case -1: {
                return this.indirectType().type_modifier();
            }
            case 29: {
                return this._type_modifier;
            }
        }
        throw new BadKind();
    }

    public TypeCode concrete_base_type() throws BadKind {
        switch (this._kind) {
            case -1: {
                return this.indirectType().concrete_base_type();
            }
            case 29: {
                return this._concrete_base;
            }
        }
        throw new BadKind();
    }

    public void read_value(InputStream inputStream) {
        if (inputStream instanceof TypeCodeReader) {
            if (this.read_value_kind((TypeCodeReader)((Object)inputStream))) {
                this.read_value_body(inputStream);
            }
        } else if (inputStream instanceof CDRInputStream) {
            WrapperInputStream wrapperInputStream = new WrapperInputStream((CDRInputStream)inputStream);
            if (this.read_value_kind(wrapperInputStream)) {
                this.read_value_body(wrapperInputStream);
            }
        } else {
            this.read_value_kind(inputStream);
            this.read_value_body(inputStream);
        }
    }

    private void read_value_recursive(TypeCodeInputStream typeCodeInputStream) {
        if (typeCodeInputStream instanceof TypeCodeReader) {
            if (this.read_value_kind(typeCodeInputStream)) {
                this.read_value_body(typeCodeInputStream);
            }
        } else {
            this.read_value_kind(typeCodeInputStream);
            this.read_value_body(typeCodeInputStream);
        }
    }

    boolean read_value_kind(TypeCodeReader typeCodeReader) {
        this._kind = typeCodeReader.read_long();
        int n = typeCodeReader.getTopLevelPosition() - 4;
        if ((this._kind < 0 || this._kind > typeTable.length) && this._kind != -1) {
            throw this.wrapper.cannotMarshalBadTckind();
        }
        if (this._kind == 31) {
            throw this.wrapper.cannotMarshalNative();
        }
        TypeCodeReader typeCodeReader2 = typeCodeReader.getTopLevelStream();
        if (this._kind == -1) {
            int n2 = typeCodeReader.read_long();
            if (n2 > -4) {
                throw this.wrapper.invalidIndirection(new Integer(n2));
            }
            int n3 = typeCodeReader.getTopLevelPosition();
            int n4 = n3 - 4 + n2;
            TypeCodeImpl typeCodeImpl = typeCodeReader2.getTypeCodeAtPosition(n4);
            if (typeCodeImpl == null) {
                throw this.wrapper.indirectionNotFound(new Integer(n4));
            }
            this.setIndirectType(typeCodeImpl);
            return false;
        }
        typeCodeReader2.addTypeCodeAtPosition(this, n);
        return true;
    }

    void read_value_kind(InputStream inputStream) {
        this._kind = inputStream.read_long();
        if ((this._kind < 0 || this._kind > typeTable.length) && this._kind != -1) {
            throw this.wrapper.cannotMarshalBadTckind();
        }
        if (this._kind == 31) {
            throw this.wrapper.cannotMarshalNative();
        }
        if (this._kind == -1) {
            throw this.wrapper.recursiveTypecodeError();
        }
    }

    void read_value_body(InputStream inputStream) {
        block0 : switch (typeTable[this._kind]) {
            case 0: {
                break;
            }
            case 1: {
                switch (this._kind) {
                    case 18: 
                    case 27: {
                        this._length = inputStream.read_long();
                        break block0;
                    }
                    case 28: {
                        this._digits = inputStream.read_ushort();
                        this._scale = inputStream.read_short();
                        break block0;
                    }
                }
                throw this.wrapper.invalidSimpleTypecode();
            }
            case 2: {
                TypeCodeInputStream typeCodeInputStream = TypeCodeInputStream.readEncapsulation(inputStream, inputStream.orb());
                switch (this._kind) {
                    case 14: 
                    case 32: {
                        this.setId(typeCodeInputStream.read_string());
                        this._name = typeCodeInputStream.read_string();
                        break block0;
                    }
                    case 16: {
                        this.setId(typeCodeInputStream.read_string());
                        this._name = typeCodeInputStream.read_string();
                        this._discriminator = new TypeCodeImpl((ORB)inputStream.orb());
                        this._discriminator.read_value_recursive(typeCodeInputStream);
                        this._defaultIndex = typeCodeInputStream.read_long();
                        this._memberCount = typeCodeInputStream.read_long();
                        this._unionLabels = new AnyImpl[this._memberCount];
                        this._memberNames = new String[this._memberCount];
                        this._memberTypes = new TypeCodeImpl[this._memberCount];
                        for (int i = 0; i < this._memberCount; ++i) {
                            this._unionLabels[i] = new AnyImpl((ORB)inputStream.orb());
                            if (i == this._defaultIndex) {
                                this._unionLabels[i].insert_octet(typeCodeInputStream.read_octet());
                            } else {
                                switch (this.realType(this._discriminator).kind().value()) {
                                    case 2: {
                                        this._unionLabels[i].insert_short(typeCodeInputStream.read_short());
                                        break;
                                    }
                                    case 3: {
                                        this._unionLabels[i].insert_long(typeCodeInputStream.read_long());
                                        break;
                                    }
                                    case 4: {
                                        this._unionLabels[i].insert_ushort(typeCodeInputStream.read_short());
                                        break;
                                    }
                                    case 5: {
                                        this._unionLabels[i].insert_ulong(typeCodeInputStream.read_long());
                                        break;
                                    }
                                    case 6: {
                                        this._unionLabels[i].insert_float(typeCodeInputStream.read_float());
                                        break;
                                    }
                                    case 7: {
                                        this._unionLabels[i].insert_double(typeCodeInputStream.read_double());
                                        break;
                                    }
                                    case 8: {
                                        this._unionLabels[i].insert_boolean(typeCodeInputStream.read_boolean());
                                        break;
                                    }
                                    case 9: {
                                        this._unionLabels[i].insert_char(typeCodeInputStream.read_char());
                                        break;
                                    }
                                    case 17: {
                                        this._unionLabels[i].type(this._discriminator);
                                        this._unionLabels[i].insert_long(typeCodeInputStream.read_long());
                                        break;
                                    }
                                    case 23: {
                                        this._unionLabels[i].insert_longlong(typeCodeInputStream.read_longlong());
                                        break;
                                    }
                                    case 24: {
                                        this._unionLabels[i].insert_ulonglong(typeCodeInputStream.read_longlong());
                                        break;
                                    }
                                    case 26: {
                                        this._unionLabels[i].insert_wchar(typeCodeInputStream.read_wchar());
                                        break;
                                    }
                                    default: {
                                        throw this.wrapper.invalidComplexTypecode();
                                    }
                                }
                            }
                            this._memberNames[i] = typeCodeInputStream.read_string();
                            this._memberTypes[i] = new TypeCodeImpl((ORB)inputStream.orb());
                            this._memberTypes[i].read_value_recursive(typeCodeInputStream);
                            this._memberTypes[i].setParent(this);
                        }
                        break block0;
                    }
                    case 17: {
                        this.setId(typeCodeInputStream.read_string());
                        this._name = typeCodeInputStream.read_string();
                        this._memberCount = typeCodeInputStream.read_long();
                        this._memberNames = new String[this._memberCount];
                        for (int i = 0; i < this._memberCount; ++i) {
                            this._memberNames[i] = typeCodeInputStream.read_string();
                        }
                        break block0;
                    }
                    case 19: {
                        this._contentType = new TypeCodeImpl((ORB)inputStream.orb());
                        this._contentType.read_value_recursive(typeCodeInputStream);
                        this._length = typeCodeInputStream.read_long();
                        break block0;
                    }
                    case 20: {
                        this._contentType = new TypeCodeImpl((ORB)inputStream.orb());
                        this._contentType.read_value_recursive(typeCodeInputStream);
                        this._length = typeCodeInputStream.read_long();
                        break block0;
                    }
                    case 21: 
                    case 30: {
                        this.setId(typeCodeInputStream.read_string());
                        this._name = typeCodeInputStream.read_string();
                        this._contentType = new TypeCodeImpl((ORB)inputStream.orb());
                        this._contentType.read_value_recursive(typeCodeInputStream);
                        break block0;
                    }
                    case 15: 
                    case 22: {
                        this.setId(typeCodeInputStream.read_string());
                        this._name = typeCodeInputStream.read_string();
                        this._memberCount = typeCodeInputStream.read_long();
                        this._memberNames = new String[this._memberCount];
                        this._memberTypes = new TypeCodeImpl[this._memberCount];
                        for (int i = 0; i < this._memberCount; ++i) {
                            this._memberNames[i] = typeCodeInputStream.read_string();
                            this._memberTypes[i] = new TypeCodeImpl((ORB)inputStream.orb());
                            this._memberTypes[i].read_value_recursive(typeCodeInputStream);
                            this._memberTypes[i].setParent(this);
                        }
                        break block0;
                    }
                    case 29: {
                        this.setId(typeCodeInputStream.read_string());
                        this._name = typeCodeInputStream.read_string();
                        this._type_modifier = typeCodeInputStream.read_short();
                        this._concrete_base = new TypeCodeImpl((ORB)inputStream.orb());
                        this._concrete_base.read_value_recursive(typeCodeInputStream);
                        if (this._concrete_base.kind().value() == 0) {
                            this._concrete_base = null;
                        }
                        this._memberCount = typeCodeInputStream.read_long();
                        this._memberNames = new String[this._memberCount];
                        this._memberTypes = new TypeCodeImpl[this._memberCount];
                        this._memberAccess = new short[this._memberCount];
                        for (int i = 0; i < this._memberCount; ++i) {
                            this._memberNames[i] = typeCodeInputStream.read_string();
                            this._memberTypes[i] = new TypeCodeImpl((ORB)inputStream.orb());
                            this._memberTypes[i].read_value_recursive(typeCodeInputStream);
                            this._memberTypes[i].setParent(this);
                            this._memberAccess[i] = typeCodeInputStream.read_short();
                        }
                        break block0;
                    }
                    default: {
                        throw this.wrapper.invalidTypecodeKindMarshal();
                    }
                }
            }
        }
    }

    public void write_value(OutputStream outputStream) {
        if (outputStream instanceof TypeCodeOutputStream) {
            this.write_value((TypeCodeOutputStream)outputStream);
        } else {
            TypeCodeOutputStream typeCodeOutputStream = null;
            if (this.outBuffer == null) {
                typeCodeOutputStream = TypeCodeOutputStream.wrapOutputStream(outputStream);
                this.write_value(typeCodeOutputStream);
                if (this.cachingEnabled) {
                    this.outBuffer = typeCodeOutputStream.getTypeCodeBuffer();
                }
            }
            if (this.cachingEnabled && this.outBuffer != null) {
                outputStream.write_long(this._kind);
                outputStream.write_octet_array(this.outBuffer, 0, this.outBuffer.length);
            } else {
                typeCodeOutputStream.writeRawBuffer(outputStream, this._kind);
            }
        }
    }

    public void write_value(TypeCodeOutputStream typeCodeOutputStream) {
        if (this._kind == 31) {
            throw this.wrapper.cannotMarshalNative();
        }
        TypeCodeOutputStream typeCodeOutputStream2 = typeCodeOutputStream.getTopLevelStream();
        if (this._kind == -1) {
            int n = typeCodeOutputStream2.getPositionForID(this._id);
            int n2 = typeCodeOutputStream.getTopLevelPosition();
            typeCodeOutputStream.writeIndirection(-1, n);
            return;
        }
        typeCodeOutputStream.write_long(this._kind);
        typeCodeOutputStream2.addIDAtPosition(this._id, typeCodeOutputStream.getTopLevelPosition() - 4);
        block0 : switch (typeTable[this._kind]) {
            case 0: {
                break;
            }
            case 1: {
                switch (this._kind) {
                    case 18: 
                    case 27: {
                        typeCodeOutputStream.write_long(this._length);
                        break block0;
                    }
                    case 28: {
                        typeCodeOutputStream.write_ushort(this._digits);
                        typeCodeOutputStream.write_short(this._scale);
                        break block0;
                    }
                }
                throw this.wrapper.invalidSimpleTypecode();
            }
            case 2: {
                TypeCodeOutputStream typeCodeOutputStream3 = typeCodeOutputStream.createEncapsulation(typeCodeOutputStream.orb());
                switch (this._kind) {
                    case 14: 
                    case 32: {
                        typeCodeOutputStream3.write_string(this._id);
                        typeCodeOutputStream3.write_string(this._name);
                        break;
                    }
                    case 16: {
                        typeCodeOutputStream3.write_string(this._id);
                        typeCodeOutputStream3.write_string(this._name);
                        this._discriminator.write_value(typeCodeOutputStream3);
                        typeCodeOutputStream3.write_long(this._defaultIndex);
                        typeCodeOutputStream3.write_long(this._memberCount);
                        for (int i = 0; i < this._memberCount; ++i) {
                            if (i == this._defaultIndex) {
                                typeCodeOutputStream3.write_octet(this._unionLabels[i].extract_octet());
                            } else {
                                switch (this.realType(this._discriminator).kind().value()) {
                                    case 2: {
                                        typeCodeOutputStream3.write_short(this._unionLabels[i].extract_short());
                                        break;
                                    }
                                    case 3: {
                                        typeCodeOutputStream3.write_long(this._unionLabels[i].extract_long());
                                        break;
                                    }
                                    case 4: {
                                        typeCodeOutputStream3.write_short(this._unionLabels[i].extract_ushort());
                                        break;
                                    }
                                    case 5: {
                                        typeCodeOutputStream3.write_long(this._unionLabels[i].extract_ulong());
                                        break;
                                    }
                                    case 6: {
                                        typeCodeOutputStream3.write_float(this._unionLabels[i].extract_float());
                                        break;
                                    }
                                    case 7: {
                                        typeCodeOutputStream3.write_double(this._unionLabels[i].extract_double());
                                        break;
                                    }
                                    case 8: {
                                        typeCodeOutputStream3.write_boolean(this._unionLabels[i].extract_boolean());
                                        break;
                                    }
                                    case 9: {
                                        typeCodeOutputStream3.write_char(this._unionLabels[i].extract_char());
                                        break;
                                    }
                                    case 17: {
                                        typeCodeOutputStream3.write_long(this._unionLabels[i].extract_long());
                                        break;
                                    }
                                    case 23: {
                                        typeCodeOutputStream3.write_longlong(this._unionLabels[i].extract_longlong());
                                        break;
                                    }
                                    case 24: {
                                        typeCodeOutputStream3.write_longlong(this._unionLabels[i].extract_ulonglong());
                                        break;
                                    }
                                    case 26: {
                                        typeCodeOutputStream3.write_wchar(this._unionLabels[i].extract_wchar());
                                        break;
                                    }
                                    default: {
                                        throw this.wrapper.invalidComplexTypecode();
                                    }
                                }
                            }
                            typeCodeOutputStream3.write_string(this._memberNames[i]);
                            this._memberTypes[i].write_value(typeCodeOutputStream3);
                        }
                        break;
                    }
                    case 17: {
                        typeCodeOutputStream3.write_string(this._id);
                        typeCodeOutputStream3.write_string(this._name);
                        typeCodeOutputStream3.write_long(this._memberCount);
                        for (int i = 0; i < this._memberCount; ++i) {
                            typeCodeOutputStream3.write_string(this._memberNames[i]);
                        }
                        break;
                    }
                    case 19: {
                        this.lazy_content_type().write_value(typeCodeOutputStream3);
                        typeCodeOutputStream3.write_long(this._length);
                        break;
                    }
                    case 20: {
                        this._contentType.write_value(typeCodeOutputStream3);
                        typeCodeOutputStream3.write_long(this._length);
                        break;
                    }
                    case 21: 
                    case 30: {
                        typeCodeOutputStream3.write_string(this._id);
                        typeCodeOutputStream3.write_string(this._name);
                        this._contentType.write_value(typeCodeOutputStream3);
                        break;
                    }
                    case 15: 
                    case 22: {
                        typeCodeOutputStream3.write_string(this._id);
                        typeCodeOutputStream3.write_string(this._name);
                        typeCodeOutputStream3.write_long(this._memberCount);
                        for (int i = 0; i < this._memberCount; ++i) {
                            typeCodeOutputStream3.write_string(this._memberNames[i]);
                            this._memberTypes[i].write_value(typeCodeOutputStream3);
                        }
                        break;
                    }
                    case 29: {
                        typeCodeOutputStream3.write_string(this._id);
                        typeCodeOutputStream3.write_string(this._name);
                        typeCodeOutputStream3.write_short(this._type_modifier);
                        if (this._concrete_base == null) {
                            this._orb.get_primitive_tc(0).write_value(typeCodeOutputStream3);
                        } else {
                            this._concrete_base.write_value(typeCodeOutputStream3);
                        }
                        typeCodeOutputStream3.write_long(this._memberCount);
                        for (int i = 0; i < this._memberCount; ++i) {
                            typeCodeOutputStream3.write_string(this._memberNames[i]);
                            this._memberTypes[i].write_value(typeCodeOutputStream3);
                            typeCodeOutputStream3.write_short(this._memberAccess[i]);
                        }
                        break;
                    }
                    default: {
                        throw this.wrapper.invalidTypecodeKindMarshal();
                    }
                }
                typeCodeOutputStream3.writeOctetSequenceTo(typeCodeOutputStream);
                break;
            }
        }
    }

    protected void copy(org.omg.CORBA.portable.InputStream inputStream, org.omg.CORBA.portable.OutputStream outputStream) {
        switch (this._kind) {
            case 0: 
            case 1: 
            case 31: 
            case 32: {
                break;
            }
            case 2: 
            case 4: {
                outputStream.write_short(inputStream.read_short());
                break;
            }
            case 3: 
            case 5: {
                outputStream.write_long(inputStream.read_long());
                break;
            }
            case 6: {
                outputStream.write_float(inputStream.read_float());
                break;
            }
            case 7: {
                outputStream.write_double(inputStream.read_double());
                break;
            }
            case 23: 
            case 24: {
                outputStream.write_longlong(inputStream.read_longlong());
                break;
            }
            case 25: {
                throw this.wrapper.tkLongDoubleNotSupported();
            }
            case 8: {
                outputStream.write_boolean(inputStream.read_boolean());
                break;
            }
            case 9: {
                outputStream.write_char(inputStream.read_char());
                break;
            }
            case 26: {
                outputStream.write_wchar(inputStream.read_wchar());
                break;
            }
            case 10: {
                outputStream.write_octet(inputStream.read_octet());
                break;
            }
            case 18: {
                String string = inputStream.read_string();
                if (this._length != 0 && string.length() > this._length) {
                    throw this.wrapper.badStringBounds(new Integer(string.length()), new Integer(this._length));
                }
                outputStream.write_string(string);
                break;
            }
            case 27: {
                String string = inputStream.read_wstring();
                if (this._length != 0 && string.length() > this._length) {
                    throw this.wrapper.badStringBounds(new Integer(string.length()), new Integer(this._length));
                }
                outputStream.write_wstring(string);
                break;
            }
            case 28: {
                outputStream.write_ushort(inputStream.read_ushort());
                outputStream.write_short(inputStream.read_short());
                break;
            }
            case 11: {
                Any any = ((CDRInputStream)inputStream).orb().create_any();
                TypeCodeImpl typeCodeImpl = new TypeCodeImpl((ORB)outputStream.orb());
                typeCodeImpl.read_value((InputStream)inputStream);
                typeCodeImpl.write_value((OutputStream)outputStream);
                any.read_value(inputStream, typeCodeImpl);
                any.write_value(outputStream);
                break;
            }
            case 12: {
                outputStream.write_TypeCode(inputStream.read_TypeCode());
                break;
            }
            case 13: {
                outputStream.write_Principal(inputStream.read_Principal());
                break;
            }
            case 14: {
                outputStream.write_Object(inputStream.read_Object());
                break;
            }
            case 22: {
                outputStream.write_string(inputStream.read_string());
            }
            case 15: 
            case 29: {
                for (int i = 0; i < this._memberTypes.length; ++i) {
                    this._memberTypes[i].copy(inputStream, outputStream);
                }
                break;
            }
            case 16: {
                int n;
                AnyImpl anyImpl = new AnyImpl((ORB)inputStream.orb());
                switch (this.realType(this._discriminator).kind().value()) {
                    case 2: {
                        short s = inputStream.read_short();
                        ((Any)anyImpl).insert_short(s);
                        outputStream.write_short(s);
                        break;
                    }
                    case 3: {
                        int n2 = inputStream.read_long();
                        ((Any)anyImpl).insert_long(n2);
                        outputStream.write_long(n2);
                        break;
                    }
                    case 4: {
                        short s = inputStream.read_short();
                        ((Any)anyImpl).insert_ushort(s);
                        outputStream.write_short(s);
                        break;
                    }
                    case 5: {
                        int n3 = inputStream.read_long();
                        ((Any)anyImpl).insert_ulong(n3);
                        outputStream.write_long(n3);
                        break;
                    }
                    case 6: {
                        float f = inputStream.read_float();
                        ((Any)anyImpl).insert_float(f);
                        outputStream.write_float(f);
                        break;
                    }
                    case 7: {
                        double d = inputStream.read_double();
                        ((Any)anyImpl).insert_double(d);
                        outputStream.write_double(d);
                        break;
                    }
                    case 8: {
                        boolean bl = inputStream.read_boolean();
                        ((Any)anyImpl).insert_boolean(bl);
                        outputStream.write_boolean(bl);
                        break;
                    }
                    case 9: {
                        char c = inputStream.read_char();
                        ((Any)anyImpl).insert_char(c);
                        outputStream.write_char(c);
                        break;
                    }
                    case 17: {
                        int n4 = inputStream.read_long();
                        ((Any)anyImpl).type(this._discriminator);
                        ((Any)anyImpl).insert_long(n4);
                        outputStream.write_long(n4);
                        break;
                    }
                    case 23: {
                        long l = inputStream.read_longlong();
                        ((Any)anyImpl).insert_longlong(l);
                        outputStream.write_longlong(l);
                        break;
                    }
                    case 24: {
                        long l = inputStream.read_longlong();
                        ((Any)anyImpl).insert_ulonglong(l);
                        outputStream.write_longlong(l);
                        break;
                    }
                    case 26: {
                        char c = inputStream.read_wchar();
                        ((Any)anyImpl).insert_wchar(c);
                        outputStream.write_wchar(c);
                        break;
                    }
                    default: {
                        throw this.wrapper.illegalUnionDiscriminatorType();
                    }
                }
                for (n = 0; n < this._unionLabels.length; ++n) {
                    if (!((Any)anyImpl).equal(this._unionLabels[n])) continue;
                    this._memberTypes[n].copy(inputStream, outputStream);
                    break;
                }
                if (n != this._unionLabels.length) break;
                if (this._defaultIndex == -1) {
                    throw this.wrapper.unexpectedUnionDefault();
                }
                this._memberTypes[this._defaultIndex].copy(inputStream, outputStream);
                break;
            }
            case 17: {
                outputStream.write_long(inputStream.read_long());
                break;
            }
            case 19: {
                int n = inputStream.read_long();
                if (this._length != 0 && n > this._length) {
                    throw this.wrapper.badSequenceBounds(new Integer(n), new Integer(this._length));
                }
                outputStream.write_long(n);
                this.lazy_content_type();
                for (int i = 0; i < n; ++i) {
                    this._contentType.copy(inputStream, outputStream);
                }
                break;
            }
            case 20: {
                for (int i = 0; i < this._length; ++i) {
                    this._contentType.copy(inputStream, outputStream);
                }
                break;
            }
            case 21: 
            case 30: {
                this._contentType.copy(inputStream, outputStream);
                break;
            }
            case -1: {
                this.indirectType().copy(inputStream, outputStream);
                break;
            }
            default: {
                throw this.wrapper.invalidTypecodeKindMarshal();
            }
        }
    }

    protected static short digits(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return 0;
        }
        short s = (short)bigDecimal.unscaledValue().toString().length();
        if (bigDecimal.signum() == -1) {
            s = (short)(s - 1);
        }
        return s;
    }

    protected static short scale(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return 0;
        }
        return (short)bigDecimal.scale();
    }

    int currentUnionMemberIndex(Any any) throws BadKind {
        if (this._kind != 16) {
            throw new BadKind();
        }
        try {
            for (int i = 0; i < this.member_count(); ++i) {
                if (!this.member_label(i).equal(any)) continue;
                return i;
            }
            if (this._defaultIndex != -1) {
                return this._defaultIndex;
            }
        }
        catch (BadKind badKind) {
        }
        catch (Bounds bounds) {
            // empty catch block
        }
        return -1;
    }

    public String description() {
        return "TypeCodeImpl with kind " + this._kind + " and id " + this._id;
    }

    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        PrintStream printStream = new PrintStream(byteArrayOutputStream, true);
        this.printStream(printStream);
        return super.toString() + " =\n" + byteArrayOutputStream.toString();
    }

    public void printStream(PrintStream printStream) {
        this.printStream(printStream, 0);
    }

    private void printStream(PrintStream printStream, int n) {
        if (this._kind == -1) {
            printStream.print("indirect " + this._id);
            return;
        }
        switch (this._kind) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 31: {
                printStream.print(kindNames[this._kind] + " " + this._name);
                break;
            }
            case 15: 
            case 22: 
            case 29: {
                printStream.println(kindNames[this._kind] + " " + this._name + " = {");
                for (int i = 0; i < this._memberCount; ++i) {
                    printStream.print(this.indent(n + 1));
                    if (this._memberTypes[i] != null) {
                        this._memberTypes[i].printStream(printStream, n + 1);
                    } else {
                        printStream.print("<unknown type>");
                    }
                    printStream.println(" " + this._memberNames[i] + ";");
                }
                printStream.print(this.indent(n) + "}");
                break;
            }
            case 16: {
                printStream.print("union " + this._name + "...");
                break;
            }
            case 17: {
                printStream.print("enum " + this._name + "...");
                break;
            }
            case 18: {
                if (this._length == 0) {
                    printStream.print("unbounded string " + this._name);
                    break;
                }
                printStream.print("bounded string(" + this._length + ") " + this._name);
                break;
            }
            case 19: 
            case 20: {
                printStream.println(kindNames[this._kind] + "[" + this._length + "] " + this._name + " = {");
                printStream.print(this.indent(n + 1));
                if (this.lazy_content_type() != null) {
                    this.lazy_content_type().printStream(printStream, n + 1);
                }
                printStream.println(this.indent(n) + "}");
                break;
            }
            case 21: {
                printStream.print("alias " + this._name + " = " + (this._contentType != null ? this._contentType._name : "<unresolved>"));
                break;
            }
            case 27: {
                printStream.print("wstring[" + this._length + "] " + this._name);
                break;
            }
            case 28: {
                printStream.print("fixed(" + this._digits + ", " + this._scale + ") " + this._name);
                break;
            }
            case 30: {
                printStream.print("valueBox " + this._name + "...");
                break;
            }
            case 32: {
                printStream.print("abstractInterface " + this._name + "...");
                break;
            }
            default: {
                printStream.print("<unknown type>");
            }
        }
    }

    private String indent(int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + "  ";
        }
        return string;
    }

    protected void setCaching(boolean bl) {
        this.cachingEnabled = bl;
        if (!bl) {
            this.outBuffer = null;
        }
    }
}

