/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.X509Extension;
import java.util.Date;

public abstract class X509CRLEntry
implements X509Extension {
    public boolean equals(Object other) {
        if (other instanceof X509CRLEntry) {
            try {
                X509CRLEntry xe = (X509CRLEntry)other;
                if (this.getEncoded().length != xe.getEncoded().length) {
                    return false;
                }
                byte[] b1 = this.getEncoded();
                byte[] b2 = xe.getEncoded();
                for (int i = 0; i < b1.length; ++i) {
                    if (b1[i] == b2[i]) continue;
                    return false;
                }
            }
            catch (CRLException crle) {
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public abstract byte[] getEncoded() throws CRLException;

    public abstract BigInteger getSerialNumber();

    public abstract Date getRevocationDate();

    public abstract boolean hasExtensions();

    public abstract String toString();
}

