/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.provider;

import gnu.java.io.ASN1ParsingException;
import gnu.java.security.der.DER;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.der.DERWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;

public class DSAParameters
extends AlgorithmParametersSpi {
    private BigInteger q;
    private BigInteger p;
    private BigInteger g;

    public void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (!(paramSpec instanceof DSAParameterSpec)) {
            throw new InvalidParameterSpecException("Only accepts DSAParameterSpec");
        }
        DSAParameterSpec dsaParamSpec = (DSAParameterSpec)paramSpec;
        this.p = dsaParamSpec.getP();
        this.q = dsaParamSpec.getQ();
        this.g = dsaParamSpec.getG();
    }

    public void engineInit(byte[] params) throws IOException {
        DERReader in = new DERReader(params);
        DERValue val = in.read();
        if (val.getValue() != DER.CONSTRUCTED_VALUE) {
            throw new ASN1ParsingException("badly formed parameters");
        }
        try {
            this.p = (BigInteger)in.read().getValue();
            this.q = (BigInteger)in.read().getValue();
            this.g = (BigInteger)in.read().getValue();
        }
        catch (Exception x) {
            throw new ASN1ParsingException("badly formed parameters");
        }
    }

    public void engineInit(byte[] params, String format) throws IOException {
        if (!format.equals("ASN.1")) {
            throw new IOException("Invalid Format: Only accepts ASN.1");
        }
        this.engineInit(params);
    }

    public AlgorithmParameterSpec engineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        if (paramSpec.isAssignableFrom(DSAParameters.class$("java.security.spec.DSAParameterSpec"))) {
            return new DSAParameterSpec(this.p, this.q, this.g);
        }
        throw new InvalidParameterSpecException("Only accepts DSAParameterSpec");
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public byte[] engineGetEncoded() throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ArrayList seq = new ArrayList(3);
        seq.add(new DERValue(2, this.p));
        seq.add(new DERValue(2, this.q));
        seq.add(new DERValue(2, this.g));
        DERWriter.write(bout, new DERValue(48, seq));
        return bout.toByteArray();
    }

    public byte[] engineGetEncoded(String format) throws IOException {
        if (!format.equals("ASN.1")) {
            throw new IOException("Invalid Format: Only accepts ASN.1");
        }
        return this.engineGetEncoded();
    }

    public String engineToString() {
        String lineSeparator = System.getProperty("line.seperator");
        return "q: " + this.q + " p: " + this.p + " g: " + this.g;
    }
}

