/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import java.util.ArrayList;
import java.util.List;
import sun.jvm.hotspot.code.ConstantDoubleValue;
import sun.jvm.hotspot.code.ConstantIntValue;
import sun.jvm.hotspot.code.ConstantLongValue;
import sun.jvm.hotspot.code.ConstantOopReadValue;
import sun.jvm.hotspot.code.Location;
import sun.jvm.hotspot.code.LocationValue;
import sun.jvm.hotspot.code.MonitorValue;
import sun.jvm.hotspot.code.NMethod;
import sun.jvm.hotspot.code.ScopeDesc;
import sun.jvm.hotspot.code.ScopeValue;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.runtime.BasicLock;
import sun.jvm.hotspot.runtime.Frame;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.JavaVFrame;
import sun.jvm.hotspot.runtime.MonitorInfo;
import sun.jvm.hotspot.runtime.RegisterMap;
import sun.jvm.hotspot.runtime.StackValue;
import sun.jvm.hotspot.runtime.StackValueCollection;
import sun.jvm.hotspot.runtime.VFrame;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMReg;
import sun.jvm.hotspot.utilities.Assert;

public class CompiledVFrame
extends JavaVFrame {
    private ScopeDesc scope;
    private boolean mayBeImprecise;

    public CompiledVFrame(Frame fr, RegisterMap regMap, JavaThread thread, ScopeDesc scope, boolean mayBeImprecise) {
        super(fr, regMap, thread);
        this.scope = scope;
        this.mayBeImprecise = mayBeImprecise;
        if (!VM.getVM().isDebugging()) {
            Assert.that(scope != null, "scope must be present");
        }
    }

    public boolean isTop() {
        if (VM.getVM().isDebugging()) {
            return this.getScope() == null || this.getScope().isTop();
        }
        return this.getScope().isTop();
    }

    public boolean isCompiledFrame() {
        return true;
    }

    public boolean mayBeImpreciseDbg() {
        return this.mayBeImprecise;
    }

    public NMethod getCode() {
        return VM.getVM().getCodeCache().findNMethod(this.fr.getPC());
    }

    public NMethod getCodeUnsafe() {
        return VM.getVM().getCodeCache().findNMethodUnsafe(this.fr.getPC());
    }

    public ScopeDesc getScope() {
        return this.scope;
    }

    public Method getMethod() {
        if (VM.getVM().isDebugging() && this.getScope() == null) {
            return this.getCodeUnsafe().getMethod();
        }
        return this.getScope().getMethod();
    }

    public StackValueCollection getLocals() {
        List scvList = this.getScope().getLocals();
        if (scvList == null) {
            return new StackValueCollection();
        }
        int length = scvList.size();
        StackValueCollection result = new StackValueCollection(length);
        for (int i = 0; i < length; ++i) {
            result.add(this.createStackValue((ScopeValue)scvList.get(i)));
        }
        return result;
    }

    public StackValueCollection getExpressions() {
        List scvList = this.getScope().getExpressions();
        if (scvList == null) {
            return new StackValueCollection();
        }
        int length = scvList.size();
        StackValueCollection result = new StackValueCollection(length);
        for (int i = 0; i < length; ++i) {
            result.add(this.createStackValue((ScopeValue)scvList.get(i)));
        }
        return result;
    }

    public List getMonitors() {
        List monitors = this.getScope().getMonitors();
        if (monitors == null) {
            return new ArrayList();
        }
        ArrayList<MonitorInfo> result = new ArrayList<MonitorInfo>(monitors.size());
        for (int i = 0; i < monitors.size(); ++i) {
            MonitorValue mv = (MonitorValue)monitors.get(i);
            StackValue ownerSV = this.createStackValue(mv.owner());
            result.add(new MonitorInfo(ownerSV.getObject(), this.resolveMonitorLock(mv.basicLock())));
        }
        return result;
    }

    public int getBCI() {
        int raw = this.getRawBCI();
        return raw == -1 ? 0 : raw;
    }

    public int getRawBCI() {
        if (VM.getVM().isDebugging() && this.getScope() == null) {
            return 0;
        }
        return this.getScope().getBCI();
    }

    public VFrame sender() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.isTop(), "just checking");
        }
        return this.sender(false);
    }

    public VFrame sender(boolean mayBeImprecise) {
        if (!VM.getVM().isDebugging() && Assert.ASSERTS_ENABLED) {
            Assert.that(this.scope != null, "When new stub generator is in place, then scope can never be NULL");
        }
        Frame f = (Frame)this.getFrame().clone();
        return this.isTop() ? super.sender(false) : new CompiledVFrame(f, this.getRegisterMap(), this.getThread(), this.getScope().sender(), mayBeImprecise);
    }

    private StackValue createStackValue(ScopeValue sv) {
        if (sv.isLocation()) {
            Address valueAddr;
            Location loc = ((LocationValue)sv).getLocation();
            if (loc.isIllegal()) {
                return new StackValue();
            }
            Address address = valueAddr = loc.isRegister() ? this.getRegisterMap().getLocation(new VMReg(loc.getRegisterNumber())) : this.fr.getUnextendedSP().addOffsetTo(loc.getStackOffset());
            if (loc.holdsFloat()) {
                if (Assert.ASSERTS_ENABLED) {
                    Assert.that(loc.isRegister(), "floats always saved to stack in 1 word");
                }
                float value = (float)valueAddr.getJDoubleAt(0L);
                return new StackValue(Float.floatToIntBits(value) & 0xFFFFFFFF);
            }
            if (loc.holdsInt()) {
                if (Assert.ASSERTS_ENABLED) {
                    Assert.that(loc.isRegister(), "ints always saved to stack in 1 word");
                }
                return new StackValue(valueAddr.getJLongAt(0L) & 0xFFFFFFFFFFFFFFFFL);
            }
            if (loc.holdsOop()) {
                return new StackValue(valueAddr.getOopHandleAt(0L));
            }
            if (loc.holdsDouble()) {
                return new StackValue(valueAddr.getJIntAt(0L) & 0xFFFFFFFF);
            }
            if (loc.holdsAddr()) {
                if (Assert.ASSERTS_ENABLED) {
                    Assert.that(!VM.getVM().isServerCompiler(), "No address type for locations with C2 (jsr-s are inlined)");
                }
                return new StackValue(0L);
            }
            if (VM.getVM().isLP64() && loc.holdsLong()) {
                if (loc.isRegister()) {
                    return new StackValue((valueAddr.getJLongAt(0L) & 0xFFFFFFFFFFFFFFFFL) << 32 | valueAddr.getJLongAt(8L) & 0xFFFFFFFFFFFFFFFFL);
                }
                return new StackValue(valueAddr.getJLongAt(0L));
            }
            if (loc.isRegister()) {
                return new StackValue(valueAddr.getJIntAt(0L) & 0xFFFFFFFF);
            }
            return new StackValue(valueAddr.getJIntAt(0L) & 0xFFFFFFFF);
        }
        if (sv.isConstantInt()) {
            return new StackValue(((ConstantIntValue)sv).getValue() & 0xFFFFFFFF);
        }
        if (sv.isConstantOop()) {
            return new StackValue(((ConstantOopReadValue)sv).getValue());
        }
        if (sv.isConstantDouble()) {
            double d = ((ConstantDoubleValue)sv).getValue();
            return new StackValue(Double.doubleToLongBits(d) & 0xFFFFFFFFFFFFFFFFL);
        }
        if (VM.getVM().isLP64() && sv.isConstantLong()) {
            return new StackValue(((ConstantLongValue)sv).getValue() & 0xFFFFFFFFFFFFFFFFL);
        }
        Assert.that(false, "Should not reach here");
        return new StackValue(0L);
    }

    private BasicLock resolveMonitorLock(Location location) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(location.isStack(), "for now we only look at the stack");
        }
        int byteOffset = location.getStackOffset();
        return new BasicLock(this.getFrame().getUnextendedSP().addOffsetTo(byteOffset));
    }
}

