/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.memory;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.JVMDebugger;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class FreeChunk
extends VMObject {
    private static AddressField nextField;
    private static AddressField prevField;
    private static CIntegerField sizeField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("FreeChunk");
        nextField = type.getAddressField("_next");
        prevField = type.getAddressField("_prev");
        sizeField = type.getCIntegerField("_size");
    }

    public FreeChunk next() {
        return (FreeChunk)VMObjectFactory.newObject(FreeChunk.class, nextField.getValue(this.addr));
    }

    public FreeChunk prev() {
        Address prev = prevField.getValue(this.addr).andWithMask(-4L);
        return (FreeChunk)VMObjectFactory.newObject(FreeChunk.class, prev);
    }

    public long size() {
        return sizeField.getValue(this.addr);
    }

    public FreeChunk(Address addr) {
        super(addr);
    }

    public static boolean secondWordIndicatesFreeChunk(long word) {
        return (word & 1L) == 1L;
    }

    public boolean isFree() {
        JVMDebugger dbg = VM.getVM().getDebugger();
        Address prev = prevField.getValue(this.addr);
        return FreeChunk.secondWordIndicatesFreeChunk(dbg.getAddressValue(prev));
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                FreeChunk.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

