/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.interpreter;

import sun.jvm.hotspot.interpreter.MaskFillerForNative;
import sun.jvm.hotspot.interpreter.OffsetClosure;
import sun.jvm.hotspot.interpreter.OopMapForCacheEntry;
import sun.jvm.hotspot.oops.CellTypeState;
import sun.jvm.hotspot.oops.CellTypeStateList;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.utilities.Assert;
import sun.jvm.hotspot.utilities.BitMap;

public class OopMapCacheEntry {
    private Method method;
    private int bci;
    private int maskSize;
    private BitMap mask;

    public boolean isValue(int offset) {
        return !this.entryAt(offset);
    }

    public boolean isOop(int offset) {
        return this.entryAt(offset);
    }

    public void iterateOop(OffsetClosure oopClosure) {
        int n = this.numberOfEntries();
        for (int i = 0; i < n; ++i) {
            if (!this.entryAt(i)) continue;
            oopClosure.offsetDo(i);
        }
    }

    public void fill(Method method, int bci) {
        this.method = method;
        this.bci = bci;
        if (method.isNative()) {
            this.fillForNative();
        } else {
            OopMapForCacheEntry gen = new OopMapForCacheEntry(method, bci, this);
            gen.computeMap();
        }
    }

    public void setMask(CellTypeStateList vars, CellTypeStateList stack, int stackTop) {
        int nEntries;
        int maxLocals = (int)this.method.getMaxLocals();
        this.maskSize = nEntries = maxLocals + stackTop;
        this.allocateBitMask();
        CellTypeStateList curList = vars;
        int listIdx = 0;
        int entryIdx = 0;
        while (entryIdx < nEntries) {
            CellTypeState cell;
            if (entryIdx == maxLocals) {
                curList = stack;
                listIdx = 0;
            }
            if ((cell = curList.get(listIdx)).isReference()) {
                this.mask.atPut(entryIdx, true);
            }
            ++entryIdx;
            ++listIdx;
        }
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.verifyMask(vars, stack, maxLocals, stackTop), "mask could not be verified");
        }
    }

    Method method() {
        return this.method;
    }

    int bci() {
        return this.bci;
    }

    int numberOfEntries() {
        return this.maskSize;
    }

    boolean entryAt(int offset) {
        return this.mask.at(offset);
    }

    void setEmptyMask() {
        this.mask = null;
    }

    void allocateBitMask() {
        if (this.maskSize > 0) {
            this.mask = new BitMap(this.maskSize);
        }
    }

    void fillForNative() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.method.isNative(), "method must be native method");
        }
        this.maskSize = (int)this.method.getSizeOfParameters();
        this.allocateBitMask();
        MaskFillerForNative mf = new MaskFillerForNative(this.method, this.mask, this.maskSize);
        mf.generate();
    }

    boolean verifyMask(CellTypeStateList vars, CellTypeStateList stack, int maxLocals, int stackTop) {
        boolean v2;
        boolean v1;
        VerifyClosure blk = new VerifyClosure(this);
        this.iterateOop(blk);
        if (blk.failed()) {
            return false;
        }
        for (int i = 0; i < maxLocals; ++i) {
            v1 = this.isOop(i);
            v2 = vars.get(i).isReference();
            if (!Assert.ASSERTS_ENABLED) continue;
            Assert.that(v1 == v2, "locals oop mask generation error");
        }
        for (int j = 0; j < stackTop; ++j) {
            v1 = this.isOop(maxLocals + j);
            v2 = stack.get(j).isReference();
            if (!Assert.ASSERTS_ENABLED) continue;
            Assert.that(v1 == v2, "stack oop mask generation error");
        }
        return true;
    }

    static class VerifyClosure
    implements OffsetClosure {
        private OopMapCacheEntry entry;
        private boolean failed;

        VerifyClosure(OopMapCacheEntry entry) {
            this.entry = entry;
        }

        public void offsetDo(int offset) {
            if (!this.entry.isOop(offset)) {
                this.failed = true;
            }
        }

        boolean failed() {
            return this.failed;
        }
    }
}

