/*      $Id: keyboard.h 12290 2005-01-16 21:21:19Z olivier $
 
        This program is free software; you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation; either version 2, or (at your option)
        any later version.
 
        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.
 
        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 
        oroborus - (c) 2001 Ken Lynch
        xfwm4    - (c) 2002-2004 Olivier Fourdan
 
 */

#ifndef INC_KEYBOARD_H
#define INC_KEYBOARD_H

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <X11/keysym.h>

typedef struct _MyKey             MyKey;
struct _MyKey
{
    KeyCode keycode;
    int modifier;
};

extern unsigned int KeyMask;
extern unsigned int ButtonMask;
extern unsigned int ButtonKeyMask;
extern unsigned int AltMask;
extern unsigned int MetaMask;
extern unsigned int NumLockMask;
extern unsigned int ScrollLockMask;
extern unsigned int SuperMask;
extern unsigned int HyperMask;

void parseKeyString (Display *, MyKey *, char *);
void grabKey (Display *, MyKey *, Window);
void ungrabKeys (Display *, Window);
void grabButton (Display *, int, int, Window);
void ungrabButton (Display *, int, int, Window);
void initModifiers (Display *);

#endif /* INC_KEYBOARD_H */
