/*
 * Copyright (C) 2002-4 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>

#include <errno.h>
#include <dirent.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "glade_support.h"

#include "constants.h"
#include "types.h"
#include "modules.h"

#include "new.h"

#include "input.h"
#include "entry.h"
#include "misc.h"
#include "remove.h"
#include "widgets.h"


G_MODULE_EXPORT
char *new_name(char *path, char *base)
{
    int max_digit = 0;
    DIR *directory;
    struct dirent *d;
    static gchar *nfile=NULL;

    /* get highest version number */

    if (nfile) {
	    g_free(nfile); 
	    nfile=NULL;
    }
    nfile = g_strdup_printf("%s-", base);
 
    directory = opendir(path);
    if (directory) while((d = readdir(directory)) != NULL){
	    if (strncmp(d->d_name,nfile,strlen(nfile))==0){
		    char *q,*p=d->d_name+strlen(nfile);
		    int digit;
		    gboolean ok=TRUE;
                    /*printf("DBG:hey--> %s\n",d->d_name); */
		    for (q=p;*q;q++) {
			    if (*q > '9' || *q < '0'){
				    ok=FALSE;
                                    /*printf("DBG:ignore--> %s\n",d->d_name); */
				    break;
			    }
		    }
		    digit=atoi(p);
		    if (digit > max_digit) max_digit=digit;
	    }
    }   
    g_free(nfile);
    nfile = g_strdup_printf("%s-%d", base, ++max_digit);
    return nfile;
}


G_MODULE_EXPORT
int new_it(GtkTreeView * treeview, const char *path, const char *in_name, gboolean directory)
{
    static gchar *fullpath=NULL;
    FILE *fp;
    struct stat st;
    in_name=utf_2_local_string(in_name);

    if(!path || !in_name)
	return FALSE;
   if(!set_load_wait())	return FALSE;
   if (fullpath) g_free(fullpath);
   fullpath = g_strdup_printf("%s%c%s", path,G_DIR_SEPARATOR, in_name);

    if (strncmp(path,"//",strlen("//"))==0){
	tree_entry_t *t_en;
	gchar *the_name=g_strdup(in_name);
	GtkTreeIter iter;
	gboolean will_expand;
	GtkTreePath *treepath;
	GtkTreeRowReference *reference;
        GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
	
	if (!get_selectpath_iter(&iter,&t_en)) return FALSE; 
	treepath=gtk_tree_model_get_path(treemodel,&iter);
	reference = gtk_tree_row_reference_new(treemodel, treepath);
    	gtk_tree_path_free(treepath);
	will_expand=IS_EXPANDED(t_en->type);
	
#ifdef USE_SMB_BRANCH
	XF_SMBmkdir (treeview,t_en,&iter,the_name);
#endif
    	unset_load_wait();
	
	if (will_expand) {
	   treepath=gtk_tree_row_reference_get_path(reference);
    	   gtk_tree_view_expand_row(treeview, treepath, FALSE);  
    	   gtk_tree_path_free(treepath);
        }
	gtk_tree_row_reference_free(reference);
	g_free(the_name);
	return FALSE;
    }	   
    else if(lstat(fullpath, &st) >= 0)
    {
	gboolean overwrite;
	 /* dir over dir, do not retry if cannot unlink... */
        if (S_ISDIR(st.st_mode) && directory) 
	    overwrite=TRUE; 
	else overwrite=FALSE;
	/* file over dir, file over file, dir over file:
	 * keep retrying if cannot unlink... */
	if (!query_rm(fullpath, fullpath,overwrite)){
    		    unset_load_wait();
		    return FALSE;
	}
    }
 
    if(directory)
    {
	if(mkdir(fullpath, 0xFFFF) < 0)
	{
	    print_diagnostics("xfce/error", strerror(errno), " : ", fullpath, "\n", NULL);
	    print_status("xfce/error", 
			    strerror(errno), NULL);
    	    unset_load_wait();
	    return FALSE;
	}
    }
    else
    {
	fp = fopen(fullpath, "w");
	if(fp)
	    fclose(fp);
	else
	{
	    print_diagnostics("xfce/error", strerror(errno), " : ", fullpath, "\n", NULL);
	    print_status("xfce/error", strerror(errno), NULL);
    	    unset_load_wait();
	    return FALSE;
	}
    }
    print_status("xfce/info",(directory)?_("Directory created"):_("File created"), NULL);
    unset_load_wait();
    return TRUE;
}


G_MODULE_EXPORT
void set_new_combo(void)
{
    GtkWidget *w = WIDGET("input_combo");
    GList *new_list = NULL;
    GtkTreeIter iter;
    tree_entry_t *en;
    char *path;


    en = get_selected_entry(&iter);
    path = g_strdup(en->path);
    if(!IS_DIR(en->type))
	*(strrchr(path, '/')) = 0;
    if (IS_NETTHING(en->subtype))
	new_list = g_list_append(new_list,  _("New"));
    else 
	new_list = g_list_append(new_list, new_name(path, _("New")));
    gtk_combo_set_popdown_strings(GTK_COMBO(w), new_list);
    g_list_free(new_list);
    g_free(path);
    path=NULL;
}


G_MODULE_EXPORT
void do_it(int which)
{
    tree_entry_t *en;
    GtkTreeIter iter;
    en = get_selected_entry(&iter);
    if(!en || 
       (!IS_PATH(en->type) &&
        !IS_NETDIR(en->subtype) &&
        !IS_NETFILE(en->subtype) && 
        !IS_XF_NETSHARE(en->subtype)
       )) return;
    switch (which) {
	default: show_input(NEW_INPUT);
		break;
	case 1: show_input(NEW_FILE_INPUT);
		break;
	case 2: show_input(NEW_DIR_INPUT);
		break;
    }
}

/**************    callbacks *******************/

G_MODULE_EXPORT
void on_new_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    do_it(0);
}


G_MODULE_EXPORT
void tb_new(GtkWidget *w)
{
    do_it(1);
}

G_MODULE_EXPORT
void tb_newd(GtkWidget *w)
{
    do_it(2);
}
