/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.IOException;
import java.io.InputStream;
import sun.net.www.MessageHeader;
import sun.net.www.http.HttpClient;
import sun.net.www.http.Hurryable;

public class ChunkedInputStream
extends InputStream
implements Hurryable {
    private InputStream in;
    private HttpClient hc;
    private MessageHeader responses;
    private int chunkSize;
    private int chunkRead;
    private byte[] chunkData = new byte[4096];
    private int chunkPos;
    private int chunkCount;
    private byte[] rawData = new byte[32];
    private int rawPos;
    private int rawCount;
    private boolean error;
    private boolean closed;
    static final int STATE_AWAITING_CHUNK_HEADER = 1;
    static final int STATE_READING_CHUNK = 2;
    static final int STATE_AWAITING_CHUNK_EOL = 3;
    static final int STATE_AWAITING_TRAILERS = 4;
    static final int STATE_DONE = 5;
    private int state;

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("stream is closed");
        }
    }

    private void ensureRawAvailable(int n) {
        if (this.rawCount + n > this.rawData.length) {
            int n2 = this.rawCount - this.rawPos;
            if (n2 + n > this.rawData.length) {
                byte[] byArray = new byte[n2 + n];
                if (n2 > 0) {
                    System.arraycopy(this.rawData, this.rawPos, byArray, 0, n2);
                }
                this.rawData = byArray;
            } else if (n2 > 0) {
                System.arraycopy(this.rawData, this.rawPos, this.rawData, 0, n2);
            }
            this.rawCount = n2;
            this.rawPos = 0;
        }
    }

    private void closeUnderlying() throws IOException {
        if (this.in == null) {
            return;
        }
        if (!this.error && this.state == 5) {
            this.hc.finished();
        } else if (!this.hurry()) {
            this.hc.closeServer();
        }
        this.in = null;
    }

    private int fastRead(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = this.chunkSize - this.chunkRead;
        int n5 = n3 = n4 < n2 ? n4 : n2;
        if (n3 > 0) {
            int n6;
            try {
                n6 = this.in.read(byArray, n, n3);
            }
            catch (IOException iOException) {
                this.error = true;
                throw iOException;
            }
            if (n6 > 0) {
                this.chunkRead += n6;
                if (this.chunkRead >= this.chunkSize) {
                    this.state = 3;
                }
                return n6;
            }
            this.error = true;
            throw new IOException("Premature EOF");
        }
        return 0;
    }

    private void processRaw() throws IOException {
        while (this.state != 5) {
            switch (this.state) {
                case 1: {
                    int n;
                    int n2;
                    for (n2 = this.rawPos; n2 < this.rawCount && this.rawData[n2] != 10; ++n2) {
                    }
                    if (n2 >= this.rawCount) {
                        return;
                    }
                    String string = new String(this.rawData, this.rawPos, n2 - this.rawPos + 1);
                    for (n = 0; n < string.length() && Character.digit(string.charAt(n), 16) != -1; ++n) {
                    }
                    try {
                        this.chunkSize = Integer.parseInt(string.substring(0, n), 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.error = true;
                        throw new IOException("Bogus chunk size");
                    }
                    this.rawPos = n2 + 1;
                    this.chunkRead = 0;
                    if (this.chunkSize > 0) {
                        this.state = 2;
                        break;
                    }
                    this.state = 4;
                    break;
                }
                case 2: {
                    Object object;
                    if (this.rawPos >= this.rawCount) {
                        return;
                    }
                    int n = Math.min(this.chunkSize - this.chunkRead, this.rawCount - this.rawPos);
                    if (this.chunkData.length < this.chunkCount + n) {
                        int n3 = this.chunkCount - this.chunkPos;
                        if (this.chunkData.length < n3 + n) {
                            object = new byte[n3 + n];
                            System.arraycopy(this.chunkData, this.chunkPos, object, 0, n3);
                            this.chunkData = object;
                        } else {
                            System.arraycopy(this.chunkData, this.chunkPos, this.chunkData, 0, n3);
                        }
                        this.chunkPos = 0;
                        this.chunkCount = n3;
                    }
                    System.arraycopy(this.rawData, this.rawPos, this.chunkData, this.chunkCount, n);
                    this.rawPos += n;
                    this.chunkCount += n;
                    this.chunkRead += n;
                    if (this.chunkSize - this.chunkRead <= 0) {
                        this.state = 3;
                        break;
                    }
                    return;
                }
                case 3: {
                    if (this.rawPos + 1 >= this.rawCount) {
                        return;
                    }
                    if (this.rawData[this.rawPos] != 13) {
                        this.error = true;
                        throw new IOException("missing CR");
                    }
                    if (this.rawData[this.rawPos + 1] != 10) {
                        this.error = true;
                        throw new IOException("missing LF");
                    }
                    this.rawPos += 2;
                    this.state = 1;
                    break;
                }
                case 4: {
                    int n2;
                    for (n2 = this.rawPos; n2 < this.rawCount && this.rawData[n2] != 10; ++n2) {
                    }
                    if (n2 >= this.rawCount) {
                        return;
                    }
                    if (n2 == this.rawPos) {
                        this.error = true;
                        throw new IOException("LF should be proceeded by CR");
                    }
                    if (this.rawData[n2 - 1] != 13) {
                        this.error = true;
                        throw new IOException("LF should be proceeded by CR");
                    }
                    if (n2 == this.rawPos + 1) {
                        this.state = 5;
                        this.closeUnderlying();
                        return;
                    }
                    String string = new String(this.rawData, this.rawPos, n2 - this.rawPos);
                    int n = string.indexOf(58);
                    if (n == -1) {
                        throw new IOException("Malformed tailer - format should be key:value");
                    }
                    Object object = string.substring(0, n).trim();
                    String string2 = string.substring(n + 1, string.length()).trim();
                    this.responses.add((String)object, string2);
                    this.rawPos = n2 + 1;
                }
            }
        }
    }

    private int readAheadNonBlocking() throws IOException {
        int n = this.in.available();
        if (n > 0) {
            int n2;
            this.ensureRawAvailable(n);
            try {
                n2 = this.in.read(this.rawData, this.rawCount, n);
            }
            catch (IOException iOException) {
                this.error = true;
                throw iOException;
            }
            if (n2 < 0) {
                this.error = true;
                return -1;
            }
            this.rawCount += n2;
            this.processRaw();
        }
        return this.chunkCount - this.chunkPos;
    }

    private int readAheadBlocking() throws IOException {
        do {
            int n;
            if (this.state == 5) {
                return -1;
            }
            this.ensureRawAvailable(32);
            try {
                n = this.in.read(this.rawData, this.rawCount, this.rawData.length - this.rawCount);
            }
            catch (IOException iOException) {
                this.error = true;
                throw iOException;
            }
            if (n < 0) {
                this.error = true;
                throw new IOException("Premature EOF");
            }
            this.rawCount += n;
            this.processRaw();
        } while (this.chunkCount <= 0);
        return this.chunkCount - this.chunkPos;
    }

    private int readAhead(boolean bl) throws IOException {
        if (this.state == 5) {
            return -1;
        }
        if (this.chunkPos >= this.chunkCount) {
            this.chunkCount = 0;
            this.chunkPos = 0;
        }
        if (bl) {
            return this.readAheadBlocking();
        }
        return this.readAheadNonBlocking();
    }

    public ChunkedInputStream(InputStream inputStream, HttpClient httpClient, MessageHeader messageHeader) throws IOException {
        this.in = inputStream;
        this.responses = messageHeader;
        this.hc = httpClient;
        this.state = 1;
    }

    public synchronized int read() throws IOException {
        this.ensureOpen();
        if (this.chunkPos >= this.chunkCount && this.readAhead(true) <= 0) {
            return -1;
        }
        return this.chunkData[this.chunkPos++] & 0xFF;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = this.chunkCount - this.chunkPos;
        if (n3 <= 0) {
            if (this.state == 2) {
                return this.fastRead(byArray, n, n2);
            }
            n3 = this.readAhead(true);
            if (n3 < 0) {
                return -1;
            }
        }
        int n4 = n3 < n2 ? n3 : n2;
        System.arraycopy(this.chunkData, this.chunkPos, byArray, n, n4);
        this.chunkPos += n4;
        return n4;
    }

    public synchronized int available() throws IOException {
        this.ensureOpen();
        int n = this.readAhead(false);
        if (n < 0) {
            return 0;
        }
        return n;
    }

    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closeUnderlying();
        this.closed = true;
    }

    public synchronized boolean hurry() {
        if (this.in == null || this.error) {
            return false;
        }
        try {
            this.readAhead(false);
        }
        catch (Exception exception) {
            return false;
        }
        if (this.error) {
            return false;
        }
        return this.state == 5;
    }
}

