/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    transient Entry[] table;
    transient int size;
    int threshold;
    final float loadFactor;
    volatile transient int modCount;
    static final Object NULL_KEY = new Object();
    private static final boolean useNewHash = false;
    private transient Set<Map.Entry<K, V>> entrySet = null;
    private static final long serialVersionUID = 362498820763181265L;

    public HashMap(int n, float f) {
        int n2;
        if (n < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + n);
        }
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("Illegal load factor: " + f);
        }
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        this.loadFactor = f;
        this.threshold = (int)((float)n2 * f);
        this.table = new Entry[n2];
        this.init();
    }

    public HashMap(int n) {
        this(n, 0.75f);
    }

    public HashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 12;
        this.table = new Entry[16];
        this.init();
    }

    public HashMap(Map<? extends K, ? extends V> map) {
        this(Math.max((int)((float)map.size() / 0.75f) + 1, 16), 0.75f);
        this.putAllForCreate(map);
    }

    void init() {
    }

    static <T> T maskNull(T t) {
        return (T)(t == null ? NULL_KEY : t);
    }

    static <T> T unmaskNull(T t) {
        return t == NULL_KEY ? null : (T)t;
    }

    private static int oldHash(int n) {
        n += ~(n << 9);
        n ^= n >>> 14;
        n += n << 4;
        n ^= n >>> 10;
        return n;
    }

    private static int newHash(int n) {
        n ^= n >>> 20 ^ n >>> 12;
        return n ^ n >>> 7 ^ n >>> 4;
    }

    static int hash(int n) {
        return useNewHash ? HashMap.newHash(n) : HashMap.oldHash(n);
    }

    static int hash(Object object) {
        return HashMap.hash(object.hashCode());
    }

    static boolean eq(Object object, Object object2) {
        return object == object2 || object.equals(object2);
    }

    static int indexFor(int n, int n2) {
        return n & n2 - 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public V get(Object object) {
        if (object == null) {
            return this.getForNullKey();
        }
        int n = HashMap.hash(object.hashCode());
        Entry entry = this.table[HashMap.indexFor(n, this.table.length)];
        while (entry != null) {
            Object k;
            if (entry.hash == n && ((k = entry.key) == object || object.equals(k))) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    private V getForNullKey() {
        int n = HashMap.hash(NULL_KEY.hashCode());
        int n2 = HashMap.indexFor(n, this.table.length);
        Entry entry = this.table[n2];
        while (entry != null) {
            if (entry.key == NULL_KEY) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object object) {
        Object object2 = HashMap.maskNull(object);
        int n = HashMap.hash(object2.hashCode());
        int n2 = HashMap.indexFor(n, this.table.length);
        Entry entry = this.table[n2];
        while (entry != null) {
            if (entry.hash == n && HashMap.eq(object2, entry.key)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    Entry<K, V> getEntry(Object object) {
        Object object2 = HashMap.maskNull(object);
        int n = HashMap.hash(object2.hashCode());
        int n2 = HashMap.indexFor(n, this.table.length);
        Entry entry = this.table[n2];
        while (!(entry == null || entry.hash == n && HashMap.eq(object2, entry.key))) {
            entry = entry.next;
        }
        return entry;
    }

    @Override
    public V put(K k, V v) {
        if (k == null) {
            return this.putForNullKey(v);
        }
        int n = HashMap.hash(k.hashCode());
        int n2 = HashMap.indexFor(n, this.table.length);
        Entry entry = this.table[n2];
        while (entry != null) {
            Object k2;
            if (entry.hash == n && ((k2 = entry.key) == k || k.equals(k2))) {
                Object v2 = entry.value;
                entry.value = v;
                entry.recordAccess(this);
                return v2;
            }
            entry = entry.next;
        }
        ++this.modCount;
        this.addEntry(n, k, v, n2);
        return null;
    }

    private V putForNullKey(V v) {
        int n = HashMap.hash(NULL_KEY.hashCode());
        int n2 = HashMap.indexFor(n, this.table.length);
        Entry entry = this.table[n2];
        while (entry != null) {
            if (entry.key == NULL_KEY) {
                Object v2 = entry.value;
                entry.value = v;
                entry.recordAccess(this);
                return v2;
            }
            entry = entry.next;
        }
        ++this.modCount;
        this.addEntry(n, NULL_KEY, v, n2);
        return null;
    }

    private void putForCreate(K k, V v) {
        K k2 = HashMap.maskNull(k);
        int n = HashMap.hash(k2.hashCode());
        int n2 = HashMap.indexFor(n, this.table.length);
        Entry entry = this.table[n2];
        while (entry != null) {
            if (entry.hash == n && HashMap.eq(k2, entry.key)) {
                entry.value = v;
                return;
            }
            entry = entry.next;
        }
        this.createEntry(n, k2, v, n2);
    }

    void putAllForCreate(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.putForCreate(entry.getKey(), entry.getValue());
        }
    }

    void resize(int n) {
        Entry[] entryArray = this.table;
        int n2 = entryArray.length;
        if (n2 == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] entryArray2 = new Entry[n];
        this.transfer(entryArray2);
        this.table = entryArray2;
        this.threshold = (int)((float)n * this.loadFactor);
    }

    void transfer(Entry[] entryArray) {
        Entry[] entryArray2 = this.table;
        int n = entryArray.length;
        for (int i = 0; i < entryArray2.length; ++i) {
            Entry entry;
            Entry entry2 = entryArray2[i];
            if (entry2 == null) continue;
            entryArray2[i] = null;
            do {
                entry = entry2.next;
                int n2 = HashMap.indexFor(entry2.hash, n);
                entry2.next = entryArray[n2];
                entryArray[n2] = entry2;
            } while ((entry2 = entry) != null);
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        int n = map.size();
        if (n == 0) {
            return;
        }
        if (n > this.threshold) {
            int n2;
            int n3 = (int)((float)n / this.loadFactor + 1.0f);
            if (n3 > 0x40000000) {
                n3 = 0x40000000;
            }
            for (n2 = this.table.length; n2 < n3; n2 <<= 1) {
            }
            if (n2 > this.table.length) {
                this.resize(n2);
            }
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        Entry<K, V> entry = this.removeEntryForKey(object);
        return entry == null ? null : (V)entry.value;
    }

    Entry<K, V> removeEntryForKey(Object object) {
        Entry entry;
        Object object2 = HashMap.maskNull(object);
        int n = HashMap.hash(object2.hashCode());
        int n2 = HashMap.indexFor(n, this.table.length);
        Entry entry2 = entry = this.table[n2];
        while (entry2 != null) {
            Entry entry3 = entry2.next;
            if (entry2.hash == n && HashMap.eq(object2, entry2.key)) {
                ++this.modCount;
                --this.size;
                if (entry == entry2) {
                    this.table[n2] = entry3;
                } else {
                    entry.next = entry3;
                }
                entry2.recordRemoval(this);
                return entry2;
            }
            entry = entry2;
            entry2 = entry3;
        }
        return entry2;
    }

    Entry<K, V> removeMapping(Object object) {
        Entry entry;
        if (!(object instanceof Map.Entry)) {
            return null;
        }
        Map.Entry entry2 = (Map.Entry)object;
        Object k = HashMap.maskNull(entry2.getKey());
        int n = HashMap.hash(k.hashCode());
        int n2 = HashMap.indexFor(n, this.table.length);
        Entry entry3 = entry = this.table[n2];
        while (entry3 != null) {
            Entry entry4 = entry3.next;
            if (entry3.hash == n && entry3.equals(entry2)) {
                ++this.modCount;
                --this.size;
                if (entry == entry3) {
                    this.table[n2] = entry4;
                } else {
                    entry.next = entry4;
                }
                entry3.recordRemoval(this);
                return entry3;
            }
            entry = entry3;
            entry3 = entry4;
        }
        return entry3;
    }

    @Override
    public void clear() {
        ++this.modCount;
        Entry[] entryArray = this.table;
        for (int i = 0; i < entryArray.length; ++i) {
            entryArray[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            return this.containsNullValue();
        }
        Entry[] entryArray = this.table;
        for (int i = 0; i < entryArray.length; ++i) {
            Entry entry = entryArray[i];
            while (entry != null) {
                if (object.equals(entry.value)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        Entry[] entryArray = this.table;
        for (int i = 0; i < entryArray.length; ++i) {
            Entry entry = entryArray[i];
            while (entry != null) {
                if (entry.value == null) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    @Override
    public Object clone() {
        HashMap hashMap = null;
        try {
            hashMap = (HashMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        hashMap.table = new Entry[this.table.length];
        hashMap.entrySet = null;
        hashMap.modCount = 0;
        hashMap.size = 0;
        hashMap.init();
        hashMap.putAllForCreate(this);
        return hashMap;
    }

    void addEntry(int n, K k, V v, int n2) {
        Entry entry = this.table[n2];
        this.table[n2] = new Entry<K, V>(n, k, v, entry);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void createEntry(int n, K k, V v, int n2) {
        Entry entry = this.table[n2];
        this.table[n2] = new Entry<K, V>(n, k, v, entry);
        ++this.size;
    }

    Iterator<K> newKeyIterator() {
        return new KeyIterator();
    }

    Iterator<V> newValueIterator() {
        return new ValueIterator();
    }

    Iterator<Map.Entry<K, V>> newEntryIterator() {
        return new EntryIterator();
    }

    @Override
    public Set<K> keySet() {
        Set set = this.keySet;
        return set != null ? set : (this.keySet = new KeySet());
    }

    @Override
    public Collection<V> values() {
        Collection collection = this.values;
        return collection != null ? collection : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        return entrySet != null ? entrySet : (this.entrySet = new EntrySet());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Iterator<Map.Entry<K, V>> iterator = this.entrySet().iterator();
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.table.length);
        objectOutputStream.writeInt(this.size);
        while (iterator.hasNext()) {
            Map.Entry<K, V> entry = iterator.next();
            objectOutputStream.writeObject(entry.getKey());
            objectOutputStream.writeObject(entry.getValue());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.table = new Entry[n];
        this.init();
        int n2 = objectInputStream.readInt();
        for (int i = 0; i < n2; ++i) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.putForCreate(object, object2);
        }
    }

    int capacity() {
        return this.table.length;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Entry<K, V>
    implements Map.Entry<K, V> {
        final K key;
        V value;
        final int hash;
        Entry<K, V> next;

        Entry(int n, K k, V v, Entry<K, V> entry) {
            this.value = v;
            this.next = entry;
            this.key = k;
            this.hash = n;
        }

        @Override
        public K getKey() {
            return HashMap.unmaskNull(this.key);
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            V v2 = this.value;
            this.value = v;
            return v2;
        }

        @Override
        public boolean equals(Object object) {
            Object v;
            V v2;
            Object k;
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            K k2 = this.getKey();
            return (k2 == (k = entry.getKey()) || k2 != null && k2.equals(k)) && ((v2 = this.getValue()) == (v = entry.getValue()) || v2 != null && v2.equals(v));
        }

        @Override
        public int hashCode() {
            return (this.key == NULL_KEY ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        void recordAccess(HashMap<K, V> hashMap) {
        }

        void recordRemoval(HashMap<K, V> hashMap) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends HashIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        public Iterator iterator() {
            return HashMap.this.newEntryIterator();
        }

        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Entry entry2 = HashMap.this.getEntry(entry.getKey());
            return entry2 != null && entry2.equals(entry);
        }

        public boolean remove(Object object) {
            return HashMap.this.removeMapping(object) != null;
        }

        public int size() {
            return HashMap.this.size;
        }

        public void clear() {
            HashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class HashIterator<E>
    implements Iterator<E> {
        Entry<K, V> next;
        int expectedModCount;
        int index;
        Entry<K, V> current;

        HashIterator() {
            this.expectedModCount = HashMap.this.modCount;
            Entry[] entryArray = HashMap.this.table;
            int n = entryArray.length;
            Entry entry = null;
            if (HashMap.this.size != 0) {
                while (n > 0 && (entry = entryArray[--n]) == null) {
                }
            }
            this.next = entry;
            this.index = n;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        Entry<K, V> nextEntry() {
            if (HashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry entry = this.next;
            if (entry == null) {
                throw new NoSuchElementException();
            }
            Entry entry2 = entry.next;
            Entry[] entryArray = HashMap.this.table;
            int n = this.index;
            while (entry2 == null && n > 0) {
                entry2 = entryArray[--n];
            }
            this.index = n;
            this.next = entry2;
            this.current = entry;
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (HashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Object k = this.current.key;
            this.current = null;
            HashMap.this.removeEntryForKey(k);
            this.expectedModCount = HashMap.this.modCount;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyIterator
    extends HashIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return HashMap.this.newKeyIterator();
        }

        @Override
        public int size() {
            return HashMap.this.size;
        }

        @Override
        public boolean contains(Object object) {
            return HashMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return HashMap.this.removeEntryForKey(object) != null;
        }

        @Override
        public void clear() {
            HashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueIterator
    extends HashIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return HashMap.this.newValueIterator();
        }

        @Override
        public int size() {
            return HashMap.this.size;
        }

        @Override
        public boolean contains(Object object) {
            return HashMap.this.containsValue(object);
        }

        @Override
        public void clear() {
            HashMap.this.clear();
        }
    }
}

