/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBuffer;
import java.nio.ByteBufferHelper;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;

class DoubleViewBufferImpl
extends DoubleBuffer {
    private int offset;
    private ByteBuffer bb;
    private boolean readOnly;
    private ByteOrder endian;

    public DoubleViewBufferImpl(ByteBuffer bb, int offset, int capacity, int limit, int position, int mark, boolean readOnly, ByteOrder endian) {
        super(limit >> 3, limit >> 3, position >> 3, mark >> 3);
        this.bb = bb;
        this.offset = offset;
        this.readOnly = readOnly;
        this.endian = endian;
    }

    public double get() {
        int p = this.position();
        double result = ByteBufferHelper.getDouble(this.bb, (p << 3) + this.offset, this.endian);
        this.position(p + 1);
        return result;
    }

    public double get(int index) {
        return ByteBufferHelper.getDouble(this.bb, (index << 3) + this.offset, this.endian);
    }

    public DoubleBuffer put(double value) {
        int p = this.position();
        ByteBufferHelper.putDouble(this.bb, (p << 3) + this.offset, value, this.endian);
        this.position(p + 1);
        return this;
    }

    public DoubleBuffer put(int index, double value) {
        ByteBufferHelper.putDouble(this.bb, (index << 3) + this.offset, value, this.endian);
        return this;
    }

    public DoubleBuffer compact() {
        if (this.position() > 0) {
            int count = this.limit() - this.position();
            this.bb.shiftDown(this.offset, this.offset + 8 * this.position(), 8 * count);
            this.position(count);
            this.limit(this.capacity());
        }
        return this;
    }

    public DoubleBuffer slice() {
        return new DoubleViewBufferImpl(this.bb, (this.position() >> 3) + this.offset, this.remaining(), this.remaining(), 0, -1, this.readOnly, this.endian);
    }

    DoubleBuffer duplicate(boolean readOnly) {
        int pos = this.position();
        this.reset();
        int mark = this.position();
        this.position(pos);
        return new DoubleViewBufferImpl(this.bb, this.offset, this.capacity(), this.limit(), pos, mark, readOnly, this.endian);
    }

    public DoubleBuffer duplicate() {
        return this.duplicate(this.readOnly);
    }

    public DoubleBuffer asReadOnlyBuffer() {
        return this.duplicate(true);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isDirect() {
        return this.bb.isDirect();
    }

    public ByteOrder order() {
        return this.endian;
    }
}

