/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat.perfdata.monitor.protocol.rmi;

import java.nio.ByteBuffer;
import java.rmi.RemoteException;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.remote.RemoteVm;
import sun.jvmstat.perfdata.monitor.AbstractPerfDataBuffer;

public class PerfDataBuffer
extends AbstractPerfDataBuffer {
    private RemoteVm rvm;

    public PerfDataBuffer(RemoteVm remoteVm, int n) throws MonitorException {
        this.rvm = remoteVm;
        try {
            ByteBuffer byteBuffer = ByteBuffer.allocate(remoteVm.getCapacity());
            this.sample(byteBuffer);
            this.createPerfDataBuffer(byteBuffer, n);
        }
        catch (RemoteException remoteException) {
            throw new MonitorException("Could not read data for remote JVM " + n, remoteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sample(ByteBuffer byteBuffer) throws RemoteException {
        assert (byteBuffer != null);
        assert (this.rvm != null);
        ByteBuffer byteBuffer2 = byteBuffer;
        synchronized (byteBuffer2) {
            byteBuffer.clear();
            byteBuffer.put(this.rvm.getBytes());
        }
    }
}

