/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.builders;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.MethodWriter;
import com.sun.tools.doclets.internal.toolkit.builders.AbstractMemberBuilder;
import com.sun.tools.doclets.internal.toolkit.util.DocFinder;
import com.sun.tools.doclets.internal.toolkit.util.VisibleMemberMap;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MethodBuilder
extends AbstractMemberBuilder {
    private int currentMethodIndex;
    private ClassDoc classDoc;
    private VisibleMemberMap visibleMemberMap;
    private MethodWriter writer;
    private List methods;

    private MethodBuilder(Configuration configuration) {
        super(configuration);
    }

    public static MethodBuilder getInstance(Configuration configuration, ClassDoc classDoc, MethodWriter methodWriter) {
        MethodBuilder methodBuilder = new MethodBuilder(configuration);
        methodBuilder.classDoc = classDoc;
        methodBuilder.writer = methodWriter;
        methodBuilder.visibleMemberMap = new VisibleMemberMap(classDoc, 4, configuration.nodeprecated);
        methodBuilder.methods = new ArrayList(methodBuilder.visibleMemberMap.getLeafClassMembers(configuration));
        if (configuration.getMemberComparator() != null) {
            Collections.sort(methodBuilder.methods, configuration.getMemberComparator());
        }
        return methodBuilder;
    }

    public String getName() {
        return "MethodDetails";
    }

    public void invokeMethod(String string, Class[] classArray, Object[] objectArray) throws Exception {
        Method method = this.getClass().getMethod(string, classArray);
        method.invoke((Object)this, objectArray);
    }

    public List members(ClassDoc classDoc) {
        return this.visibleMemberMap.getMembersFor(classDoc);
    }

    public VisibleMemberMap getVisibleMemberMap() {
        return this.visibleMemberMap;
    }

    public boolean hasMembersToDocument() {
        return this.methods.size() > 0;
    }

    public void buildMethodDoc(List list) {
        if (this.writer == null) {
            return;
        }
        this.currentMethodIndex = 0;
        while (this.currentMethodIndex < this.methods.size()) {
            this.build(list);
            ++this.currentMethodIndex;
        }
    }

    public void buildHeader() {
        this.writer.writeHeader(this.classDoc, this.configuration.getText("doclet.Method_Detail"));
    }

    public void buildMethodHeader() {
        this.writer.writeMethodHeader((MethodDoc)this.methods.get(this.currentMethodIndex), this.currentMethodIndex == 0);
    }

    public void buildSignature() {
        this.writer.writeSignature((MethodDoc)this.methods.get(this.currentMethodIndex));
    }

    public void buildDeprecationInfo() {
        this.writer.writeDeprecated((MethodDoc)this.methods.get(this.currentMethodIndex));
    }

    public void buildMethodComments() {
        if (!this.configuration.nocomment) {
            MethodDoc methodDoc = (MethodDoc)this.methods.get(this.currentMethodIndex);
            if (methodDoc.inlineTags().length == 0) {
                DocFinder.Output output = DocFinder.search(new DocFinder.Input(methodDoc));
                methodDoc = output.inlineTags != null && output.inlineTags.length > 0 ? (MethodDoc)output.holder : methodDoc;
            }
            this.writer.writeComments(methodDoc.containingClass(), methodDoc);
        }
    }

    public void buildTagInfo() {
        this.writer.writeTags((MethodDoc)this.methods.get(this.currentMethodIndex));
    }

    public void buildMethodFooter() {
        this.writer.writeMethodFooter();
    }

    public void buildFooter() {
        this.writer.writeFooter(this.classDoc);
    }

    public MethodWriter getWriter() {
        return this.writer;
    }
}

