/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.awt.print.PrinterGraphics;
import java.awt.print.PrinterJob;
import java.text.AttributedCharacterIterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyGraphics2D
extends Graphics2D
implements PrinterGraphics {
    Graphics2D mGraphics;
    PrinterJob mPrinterJob;

    public ProxyGraphics2D(Graphics2D graphics2D, PrinterJob printerJob) {
        this.mGraphics = graphics2D;
        this.mPrinterJob = printerJob;
    }

    public Graphics2D getDelegate() {
        return this.mGraphics;
    }

    public void setDelegate(Graphics2D graphics2D) {
        this.mGraphics = graphics2D;
    }

    @Override
    public PrinterJob getPrinterJob() {
        return this.mPrinterJob;
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.mGraphics.getDeviceConfiguration();
    }

    @Override
    public Graphics create() {
        return new ProxyGraphics2D((Graphics2D)this.mGraphics.create(), this.mPrinterJob);
    }

    @Override
    public void translate(int n2, int n3) {
        this.mGraphics.translate(n2, n3);
    }

    @Override
    public void translate(double d2, double d3) {
        this.mGraphics.translate(d2, d3);
    }

    @Override
    public void rotate(double d2) {
        this.mGraphics.rotate(d2);
    }

    @Override
    public void rotate(double d2, double d3, double d4) {
        this.mGraphics.rotate(d2, d3, d4);
    }

    @Override
    public void scale(double d2, double d3) {
        this.mGraphics.scale(d2, d3);
    }

    @Override
    public void shear(double d2, double d3) {
        this.mGraphics.shear(d2, d3);
    }

    @Override
    public Color getColor() {
        return this.mGraphics.getColor();
    }

    @Override
    public void setColor(Color color) {
        this.mGraphics.setColor(color);
    }

    @Override
    public void setPaintMode() {
        this.mGraphics.setPaintMode();
    }

    @Override
    public void setXORMode(Color color) {
        this.mGraphics.setXORMode(color);
    }

    @Override
    public Font getFont() {
        return this.mGraphics.getFont();
    }

    @Override
    public void setFont(Font font) {
        this.mGraphics.setFont(font);
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return this.mGraphics.getFontMetrics(font);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.mGraphics.getFontRenderContext();
    }

    @Override
    public Rectangle getClipBounds() {
        return this.mGraphics.getClipBounds();
    }

    @Override
    public void clipRect(int n2, int n3, int n4, int n5) {
        this.mGraphics.clipRect(n2, n3, n4, n5);
    }

    @Override
    public void setClip(int n2, int n3, int n4, int n5) {
        this.mGraphics.setClip(n2, n3, n4, n5);
    }

    @Override
    public Shape getClip() {
        return this.mGraphics.getClip();
    }

    @Override
    public void setClip(Shape shape) {
        this.mGraphics.setClip(shape);
    }

    @Override
    public void copyArea(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.mGraphics.copyArea(n2, n3, n4, n5, n6, n7);
    }

    @Override
    public void drawLine(int n2, int n3, int n4, int n5) {
        this.mGraphics.drawLine(n2, n3, n4, n5);
    }

    @Override
    public void fillRect(int n2, int n3, int n4, int n5) {
        this.mGraphics.fillRect(n2, n3, n4, n5);
    }

    @Override
    public void clearRect(int n2, int n3, int n4, int n5) {
        this.mGraphics.clearRect(n2, n3, n4, n5);
    }

    @Override
    public void drawRoundRect(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.mGraphics.drawRoundRect(n2, n3, n4, n5, n6, n7);
    }

    @Override
    public void fillRoundRect(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.mGraphics.fillRoundRect(n2, n3, n4, n5, n6, n7);
    }

    @Override
    public void drawOval(int n2, int n3, int n4, int n5) {
        this.mGraphics.drawOval(n2, n3, n4, n5);
    }

    @Override
    public void fillOval(int n2, int n3, int n4, int n5) {
        this.mGraphics.fillOval(n2, n3, n4, n5);
    }

    @Override
    public void drawArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.mGraphics.drawArc(n2, n3, n4, n5, n6, n7);
    }

    @Override
    public void fillArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.mGraphics.fillArc(n2, n3, n4, n5, n6, n7);
    }

    @Override
    public void drawPolyline(int[] nArray, int[] nArray2, int n2) {
        this.mGraphics.drawPolyline(nArray, nArray2, n2);
    }

    @Override
    public void drawPolygon(int[] nArray, int[] nArray2, int n2) {
        this.mGraphics.drawPolygon(nArray, nArray2, n2);
    }

    @Override
    public void fillPolygon(int[] nArray, int[] nArray2, int n2) {
        this.mGraphics.fillPolygon(nArray, nArray2, n2);
    }

    @Override
    public void drawString(String string, int n2, int n3) {
        this.mGraphics.drawString(string, n2, n3);
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n2, int n3) {
        this.mGraphics.drawString(attributedCharacterIterator, n2, n3);
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f2, float f3) {
        this.mGraphics.drawString(attributedCharacterIterator, f2, f3);
    }

    @Override
    public boolean drawImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        return this.mGraphics.drawImage(image, n2, n3, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, ImageObserver imageObserver) {
        return this.mGraphics.drawImage(image, n2, n3, n4, n5, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n2, int n3, Color color, ImageObserver imageObserver) {
        boolean bl2;
        if (image == null) {
            return true;
        }
        if (this.needToCopyBgColorImage(image)) {
            BufferedImage bufferedImage = this.getBufferedImageCopy(image, color);
            bl2 = this.mGraphics.drawImage((Image)bufferedImage, n2, n3, null);
        } else {
            bl2 = this.mGraphics.drawImage(image, n2, n3, color, imageObserver);
        }
        return bl2;
    }

    @Override
    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, Color color, ImageObserver imageObserver) {
        boolean bl2;
        if (image == null) {
            return true;
        }
        if (this.needToCopyBgColorImage(image)) {
            BufferedImage bufferedImage = this.getBufferedImageCopy(image, color);
            bl2 = this.mGraphics.drawImage(bufferedImage, n2, n3, n4, n5, null);
        } else {
            bl2 = this.mGraphics.drawImage(image, n2, n3, n4, n5, color, imageObserver);
        }
        return bl2;
    }

    @Override
    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ImageObserver imageObserver) {
        return this.mGraphics.drawImage(image, n2, n3, n4, n5, n6, n7, n8, n9, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Color color, ImageObserver imageObserver) {
        boolean bl2;
        if (image == null) {
            return true;
        }
        if (this.needToCopyBgColorImage(image)) {
            BufferedImage bufferedImage = this.getBufferedImageCopy(image, color);
            bl2 = this.mGraphics.drawImage(bufferedImage, n2, n3, n4, n5, n7, n7, n8, n9, null);
        } else {
            bl2 = this.mGraphics.drawImage(image, n2, n3, n4, n5, n7, n7, n8, n9, color, imageObserver);
        }
        return bl2;
    }

    private boolean needToCopyBgColorImage(Image image) {
        AffineTransform affineTransform = this.getTransform();
        return (affineTransform.getType() & 0x30) != 0;
    }

    private BufferedImage getBufferedImageCopy(Image image, Color color) {
        BufferedImage bufferedImage = null;
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        if (n2 > 0 && n3 > 0) {
            int n4;
            Object object;
            if (image instanceof BufferedImage) {
                object = (BufferedImage)image;
                n4 = ((BufferedImage)object).getType();
            } else {
                n4 = 2;
            }
            bufferedImage = new BufferedImage(n2, n3, n4);
            object = bufferedImage.createGraphics();
            ((Graphics)object).drawImage(image, 0, 0, color, null);
            ((Graphics)object).dispose();
        } else {
            bufferedImage = null;
        }
        return bufferedImage;
    }

    @Override
    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        this.mGraphics.drawRenderedImage(renderedImage, affineTransform);
    }

    @Override
    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        AffineTransform affineTransform2;
        if (renderableImage == null) {
            return;
        }
        AffineTransform affineTransform3 = this.getTransform();
        AffineTransform affineTransform4 = new AffineTransform(affineTransform);
        affineTransform4.concatenate(affineTransform3);
        RenderContext renderContext = new RenderContext(affineTransform4);
        try {
            affineTransform2 = affineTransform3.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            renderContext = new RenderContext(affineTransform3);
            affineTransform2 = new AffineTransform();
        }
        RenderedImage renderedImage = renderableImage.createRendering(renderContext);
        this.drawRenderedImage(renderedImage, affineTransform2);
    }

    @Override
    public void dispose() {
        this.mGraphics.dispose();
    }

    @Override
    public void draw(Shape shape) {
        this.mGraphics.draw(shape);
    }

    @Override
    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        return this.mGraphics.drawImage(image, affineTransform, imageObserver);
    }

    @Override
    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n2, int n3) {
        this.mGraphics.drawImage(bufferedImage, bufferedImageOp, n2, n3);
    }

    @Override
    public void drawString(String string, float f2, float f3) {
        this.mGraphics.drawString(string, f2, f3);
    }

    @Override
    public void drawGlyphVector(GlyphVector glyphVector, float f2, float f3) {
        this.mGraphics.drawGlyphVector(glyphVector, f2, f3);
    }

    @Override
    public void fill(Shape shape) {
        this.mGraphics.fill(shape);
    }

    @Override
    public boolean hit(Rectangle rectangle, Shape shape, boolean bl2) {
        return this.mGraphics.hit(rectangle, shape, bl2);
    }

    @Override
    public void setComposite(Composite composite) {
        this.mGraphics.setComposite(composite);
    }

    @Override
    public void setPaint(Paint paint) {
        this.mGraphics.setPaint(paint);
    }

    @Override
    public void setStroke(Stroke stroke) {
        this.mGraphics.setStroke(stroke);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key key, Object object) {
        this.mGraphics.setRenderingHint(key, object);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key key) {
        return this.mGraphics.getRenderingHint(key);
    }

    @Override
    public void setRenderingHints(Map<?, ?> map) {
        this.mGraphics.setRenderingHints(map);
    }

    @Override
    public void addRenderingHints(Map<?, ?> map) {
        this.mGraphics.addRenderingHints(map);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.mGraphics.getRenderingHints();
    }

    @Override
    public void transform(AffineTransform affineTransform) {
        this.mGraphics.transform(affineTransform);
    }

    @Override
    public void setTransform(AffineTransform affineTransform) {
        this.mGraphics.setTransform(affineTransform);
    }

    @Override
    public AffineTransform getTransform() {
        return this.mGraphics.getTransform();
    }

    @Override
    public Paint getPaint() {
        return this.mGraphics.getPaint();
    }

    @Override
    public Composite getComposite() {
        return this.mGraphics.getComposite();
    }

    @Override
    public void setBackground(Color color) {
        this.mGraphics.setBackground(color);
    }

    @Override
    public Color getBackground() {
        return this.mGraphics.getBackground();
    }

    @Override
    public Stroke getStroke() {
        return this.mGraphics.getStroke();
    }

    @Override
    public void clip(Shape shape) {
        this.mGraphics.clip(shape);
    }
}

