/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import com.sun.java.swing.SwingUtilities2;
import java.applet.Applet;
import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.VolatileImage;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleExtendedComponent;
import javax.accessibility.AccessibleKeyBinding;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.AncestorNotifier;
import javax.swing.ArrayTable;
import javax.swing.Autoscroller;
import javax.swing.CellRendererPane;
import javax.swing.ComponentInputMap;
import javax.swing.DebugGraphics;
import javax.swing.InputMap;
import javax.swing.InputVerifier;
import javax.swing.JInternalFrame;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.KeyboardManager;
import javax.swing.LegacyGlueFocusTraversalPolicy;
import javax.swing.LookAndFeel;
import javax.swing.Popup;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.AncestorListener;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.JTableHeader;
import sun.font.FontDesignMetrics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JComponent
extends Container
implements Serializable {
    private static final String uiClassID = "ComponentUI";
    private static final StringBuffer ANCESTOR_NOTIFIER_KEY = new StringBuffer("AncestorNotifier");
    private static final StringBuffer TRANSFER_HANDLER_KEY = new StringBuffer("TransferHandler");
    private static final StringBuffer INPUT_VERIFIER_KEY = new StringBuffer("InputVerifier");
    private static final Hashtable readObjectCallbacks = new Hashtable(1);
    private static Set managingFocusForwardTraversalKeys;
    private static Set managingFocusBackwardTraversalKeys;
    private static boolean suppressDropSupport;
    private static boolean checkedSuppressDropSupport;
    private static final int NOT_OBSCURED = 0;
    private static final int PARTIALLY_OBSCURED = 1;
    private static final int COMPLETELY_OBSCURED = 2;
    static boolean DEBUG_GRAPHICS_LOADED;
    private static final Map<Font, FontMetrics> aaFontMap;
    private boolean isAlignmentXSet;
    private float alignmentX;
    private boolean isAlignmentYSet;
    private float alignmentY;
    protected transient ComponentUI ui;
    protected EventListenerList listenerList = new EventListenerList();
    private transient ArrayTable clientProperties;
    private VetoableChangeSupport vetoableChangeSupport;
    private boolean autoscrolls;
    private Border border;
    private int flags;
    private InputVerifier inputVerifier = null;
    private boolean verifyInputWhenFocusTarget = true;
    transient Component paintingChild;
    public static final int WHEN_FOCUSED = 0;
    public static final int WHEN_ANCESTOR_OF_FOCUSED_COMPONENT = 1;
    public static final int WHEN_IN_FOCUSED_WINDOW = 2;
    public static final int UNDEFINED_CONDITION = -1;
    private static final String KEYBOARD_BINDINGS_KEY = "_KeyboardBindings";
    private static final String WHEN_IN_FOCUSED_WINDOW_BINDINGS = "_WhenInFocusedWindow";
    public static final String TOOL_TIP_TEXT_KEY = "ToolTipText";
    private static final String NEXT_FOCUS = "nextFocus";
    private JPopupMenu popupMenu;
    private static final int IS_DOUBLE_BUFFERED = 0;
    private static final int ANCESTOR_USING_BUFFER = 1;
    private static final int IS_PAINTING_TILE = 2;
    private static final int IS_OPAQUE = 3;
    private static final int KEY_EVENTS_ENABLED = 4;
    private static final int FOCUS_INPUTMAP_CREATED = 5;
    private static final int ANCESTOR_INPUTMAP_CREATED = 6;
    private static final int WIF_INPUTMAP_CREATED = 7;
    private static final int ACTIONMAP_CREATED = 8;
    private static final int CREATED_DOUBLE_BUFFER = 9;
    private static final int IS_PRINTING = 11;
    private static final int IS_PRINTING_ALL = 12;
    private static final int IS_REPAINTING = 13;
    private static final int WRITE_OBJ_COUNTER_FIRST = 14;
    private static final int RESERVED_1 = 15;
    private static final int RESERVED_2 = 16;
    private static final int RESERVED_3 = 17;
    private static final int RESERVED_4 = 18;
    private static final int RESERVED_5 = 19;
    private static final int RESERVED_6 = 20;
    private static final int WRITE_OBJ_COUNTER_LAST = 21;
    private static final int REQUEST_FOCUS_DISABLED = 22;
    private static final int INHERITS_POPUP_MENU = 23;
    private static final int OPAQUE_SET = 24;
    private static final int AUTOSCROLLS_SET = 25;
    private static final int FOCUS_TRAVERSAL_KEYS_FORWARD_SET = 26;
    private static final int FOCUS_TRAVERSAL_KEYS_BACKWARD_SET = 27;
    private static boolean inInputVerifier;
    private static List tempRectangles;
    private InputMap focusInputMap;
    private InputMap ancestorInputMap;
    private ComponentInputMap windowInputMap;
    private ActionMap actionMap;
    private static final String defaultLocale = "JComponent.defaultLocale";
    private boolean aaText;
    protected AccessibleContext accessibleContext = null;

    static Set<KeyStroke> getManagingFocusForwardTraversalKeys() {
        if (managingFocusForwardTraversalKeys == null) {
            managingFocusForwardTraversalKeys = new TreeSet();
            managingFocusForwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 2));
        }
        return managingFocusForwardTraversalKeys;
    }

    static Set<KeyStroke> getManagingFocusBackwardTraversalKeys() {
        if (managingFocusBackwardTraversalKeys == null) {
            managingFocusBackwardTraversalKeys = new TreeSet();
            managingFocusBackwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 3));
        }
        return managingFocusBackwardTraversalKeys;
    }

    private static boolean getSuppressDropTarget() {
        if (!checkedSuppressDropSupport) {
            Boolean bl2 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String string = System.getProperty("suppressSwingDropSupport");
                    if (string != null) {
                        return Boolean.valueOf(string);
                    }
                    return Boolean.FALSE;
                }
            });
            suppressDropSupport = bl2;
            checkedSuppressDropSupport = true;
        }
        return suppressDropSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Rectangle fetchRectangle() {
        List list = tempRectangles;
        synchronized (list) {
            int n2 = tempRectangles.size();
            Rectangle rectangle = n2 > 0 ? (Rectangle)tempRectangles.remove(n2 - 1) : new Rectangle(0, 0, 0, 0);
            return rectangle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recycleRectangle(Rectangle rectangle) {
        List list = tempRectangles;
        synchronized (list) {
            tempRectangles.add(rectangle);
        }
    }

    public void setInheritsPopupMenu(boolean bl2) {
        this.setFlag(23, bl2);
    }

    public boolean getInheritsPopupMenu() {
        return this.getFlag(23);
    }

    public void setComponentPopupMenu(JPopupMenu jPopupMenu) {
        if (jPopupMenu != null && this.isLightweight()) {
            this.enableEvents(16L);
        }
        this.popupMenu = jPopupMenu;
    }

    public JPopupMenu getComponentPopupMenu() {
        if (!this.getInheritsPopupMenu()) {
            return this.popupMenu;
        }
        if (this.popupMenu == null) {
            for (Container container = this.getParent(); container != null; container = container.getParent()) {
                if (container instanceof JComponent) {
                    return ((JComponent)container).getComponentPopupMenu();
                }
                if (container instanceof Window || container instanceof Applet) break;
            }
            return null;
        }
        return this.popupMenu;
    }

    public JComponent() {
        this.enableEvents(8L);
        if (this.isManagingFocus()) {
            LookAndFeel.installProperty(this, "focusTraversalKeysForward", JComponent.getManagingFocusForwardTraversalKeys());
            LookAndFeel.installProperty(this, "focusTraversalKeysBackward", JComponent.getManagingFocusBackwardTraversalKeys());
        }
        super.setLocale(JComponent.getDefaultLocale());
    }

    public void updateUI() {
    }

    protected void setUI(ComponentUI componentUI) {
        if (this.ui != null) {
            this.ui.uninstallUI(this);
        }
        this.aaText = false;
        ComponentUI componentUI2 = this.ui;
        this.ui = componentUI;
        if (this.ui != null) {
            this.ui.installUI(this);
        }
        this.firePropertyChange("UI", componentUI2, componentUI);
        this.revalidate();
        this.repaint();
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected Graphics getComponentGraphics(Graphics graphics) {
        Graphics graphics2 = graphics;
        if (this.ui != null && DEBUG_GRAPHICS_LOADED && DebugGraphics.debugComponentCount() != 0 && this.shouldDebugGraphics() != 0 && !(graphics instanceof DebugGraphics)) {
            graphics2 = new DebugGraphics(graphics, this);
        }
        graphics2.setColor(this.getForeground());
        graphics2.setFont(this.getFont());
        return graphics2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponent(Graphics graphics) {
        if (this.ui != null) {
            Graphics graphics2 = graphics == null ? null : graphics.create();
            try {
                this.ui.update(graphics2, this);
            }
            finally {
                graphics2.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintChildren(Graphics graphics) {
        Graphics graphics2 = null;
        try {
            Object object = this.getTreeLock();
            synchronized (object) {
                int n2;
                block32: {
                    if (n2 >= 0) break block32;
                    return;
                }
                Graphics graphics3 = graphics2 = graphics == null ? null : graphics.create();
                if (this.paintingChild != null && this.paintingChild instanceof JComponent && ((JComponent)this.paintingChild).isOpaque()) {
                    for (n2 = this.getComponentCount() - 1; n2 >= 0 && this.getComponent(n2) != this.paintingChild; --n2) {
                    }
                }
                Rectangle rectangle = JComponent.fetchRectangle();
                boolean bl2 = !this.isOptimizedDrawingEnabled() && this.checkIfChildObscuredBySibling();
                Rectangle rectangle2 = null;
                if (bl2 && (rectangle2 = graphics2.getClipBounds()) == null) {
                    rectangle2 = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                }
                boolean bl3 = this.getFlag(11);
                while (n2 >= 0) {
                    block33: {
                        int n3;
                        Rectangle rectangle3;
                        boolean bl4;
                        Component component;
                        block35: {
                            component = this.getComponent(n2);
                            if (component == null || !bl3 && !JComponent.isLightweightComponent(component) || !component.isVisible()) break block33;
                            bl4 = component instanceof JComponent;
                            rectangle3 = component.getBounds(rectangle);
                            boolean bl5 = graphics.hitClip(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                            if (!bl5) break block33;
                            if (!bl2 || n2 <= 0) break block35;
                            int n4 = rectangle3.x;
                            n3 = rectangle3.y;
                            int n5 = rectangle3.width;
                            int n6 = rectangle3.height;
                            SwingUtilities.computeIntersection(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, rectangle3);
                            if (this.getObscuredState(n2, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height) == 2) break block33;
                            rectangle3.x = n4;
                            rectangle3.y = n3;
                            rectangle3.width = n5;
                            rectangle3.height = n6;
                        }
                        Graphics graphics4 = graphics2.create(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                        graphics4.setColor(component.getForeground());
                        graphics4.setFont(component.getFont());
                        n3 = 0;
                        try {
                            if (bl4) {
                                if (this.getFlag(1)) {
                                    ((JComponent)component).setFlag(1, true);
                                    n3 = 1;
                                }
                                if (this.getFlag(2)) {
                                    ((JComponent)component).setFlag(2, true);
                                    n3 = 1;
                                }
                                if (!bl3) {
                                    ((JComponent)component).paint(graphics4);
                                } else if (!this.getFlag(12)) {
                                    component.print(graphics4);
                                } else {
                                    component.printAll(graphics4);
                                }
                            } else if (!bl3) {
                                component.paint(graphics4);
                            } else if (!this.getFlag(12)) {
                                component.print(graphics4);
                            } else {
                                component.printAll(graphics4);
                            }
                        }
                        finally {
                            graphics4.dispose();
                            if (n3 != 0) {
                                ((JComponent)component).setFlag(1, false);
                                ((JComponent)component).setFlag(2, false);
                            }
                        }
                    }
                    --n2;
                }
                JComponent.recycleRectangle(rectangle);
            }
        }
        finally {
            if (graphics2 != null) {
                graphics2.dispose();
            }
        }
    }

    protected void paintBorder(Graphics graphics) {
        Border border = this.getBorder();
        if (border != null) {
            border.paintBorder(this, graphics, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics graphics) {
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            return;
        }
        Graphics graphics2 = this.getComponentGraphics(graphics);
        Graphics graphics3 = graphics2 == null ? null : graphics2.create();
        try {
            boolean bl4;
            int n2;
            int n3;
            int n4;
            int n5;
            RepaintManager repaintManager = RepaintManager.currentManager(this);
            Rectangle rectangle = graphics3.getClipBounds();
            if (rectangle == null) {
                n5 = 0;
                n4 = 0;
                n3 = this.getWidth();
                n2 = this.getHeight();
            } else {
                n4 = rectangle.x;
                n5 = rectangle.y;
                n3 = rectangle.width;
                n2 = rectangle.height;
            }
            if (n3 > this.getWidth()) {
                n3 = this.getWidth();
            }
            if (n2 > this.getHeight()) {
                n2 = this.getHeight();
            }
            if (this.getParent() != null && !(this.getParent() instanceof JComponent)) {
                this.adjustPaintFlags();
                bl2 = true;
            }
            if (!(bl4 = this.getFlag(11)) && repaintManager.isDoubleBufferingEnabled() && !this.getFlag(1) && this.isDoubleBuffered()) {
                bl3 = this.paintDoubleBuffered(this, this, graphics3, n4, n5, n3, n2);
            }
            if (!bl3) {
                if (rectangle == null) {
                    graphics3.setClip(n4, n5, n3, n2);
                }
                if (!this.rectangleIsObscured(n4, n5, n3, n2)) {
                    if (!bl4) {
                        this.paintComponent(graphics3);
                        this.paintBorder(graphics3);
                    } else {
                        this.printComponent(graphics3);
                        this.printBorder(graphics3);
                    }
                }
                if (!bl4) {
                    this.paintChildren(graphics3);
                } else {
                    this.printChildren(graphics3);
                }
            }
        }
        finally {
            graphics3.dispose();
            if (bl2) {
                this.setFlag(1, false);
                this.setFlag(2, false);
                this.setFlag(11, false);
                this.setFlag(12, false);
            }
        }
    }

    boolean isPainting() {
        for (Container container = this; container != null; container = container.getParent()) {
            if (!(container instanceof JComponent) || !container.getFlag(1)) continue;
            return true;
        }
        return false;
    }

    private void adjustPaintFlags() {
        JComponent jComponent = null;
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof JComponent)) continue;
            jComponent = (JComponent)container;
            if (jComponent.getFlag(1)) {
                this.setFlag(1, true);
            }
            if (jComponent.getFlag(2)) {
                this.setFlag(2, true);
            }
            if (jComponent.getFlag(11)) {
                this.setFlag(11, true);
            }
            if (!jComponent.getFlag(12)) break;
            this.setFlag(12, true);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printAll(Graphics graphics) {
        this.setFlag(12, true);
        try {
            this.print(graphics);
        }
        finally {
            this.setFlag(12, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(Graphics graphics) {
        this.setFlag(11, true);
        try {
            this.paint(graphics);
        }
        finally {
            this.setFlag(11, false);
        }
    }

    protected void printComponent(Graphics graphics) {
        this.paintComponent(graphics);
    }

    protected void printChildren(Graphics graphics) {
        this.paintChildren(graphics);
    }

    protected void printBorder(Graphics graphics) {
        this.paintBorder(graphics);
    }

    public boolean isPaintingTile() {
        return this.getFlag(2);
    }

    @Deprecated
    public boolean isManagingFocus() {
        return false;
    }

    private void registerNextFocusableComponent() {
        this.registerNextFocusableComponent(this.getNextFocusableComponent());
    }

    private void registerNextFocusableComponent(Component component) {
        if (component == null) {
            return;
        }
        Container container = this.isFocusCycleRoot() ? this : this.getFocusCycleRootAncestor();
        FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
        if (!(focusTraversalPolicy instanceof LegacyGlueFocusTraversalPolicy)) {
            focusTraversalPolicy = new LegacyGlueFocusTraversalPolicy(focusTraversalPolicy);
            container.setFocusTraversalPolicy(focusTraversalPolicy);
        }
        ((LegacyGlueFocusTraversalPolicy)focusTraversalPolicy).setNextFocusableComponent(this, component);
    }

    private void deregisterNextFocusableComponent() {
        Container container;
        Component component = this.getNextFocusableComponent();
        if (component == null) {
            return;
        }
        Container container2 = container = this.isFocusCycleRoot() ? this : this.getFocusCycleRootAncestor();
        if (container == null) {
            return;
        }
        FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
        if (focusTraversalPolicy instanceof LegacyGlueFocusTraversalPolicy) {
            ((LegacyGlueFocusTraversalPolicy)focusTraversalPolicy).unsetNextFocusableComponent(this, component);
        }
    }

    @Deprecated
    public void setNextFocusableComponent(Component component) {
        boolean bl2 = this.isDisplayable();
        if (bl2) {
            this.deregisterNextFocusableComponent();
        }
        this.putClientProperty(NEXT_FOCUS, component);
        if (bl2) {
            this.registerNextFocusableComponent(component);
        }
    }

    @Deprecated
    public Component getNextFocusableComponent() {
        return (Component)this.getClientProperty(NEXT_FOCUS);
    }

    public void setRequestFocusEnabled(boolean bl2) {
        this.setFlag(22, !bl2);
    }

    public boolean isRequestFocusEnabled() {
        return !this.getFlag(22);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runInputVerifier() {
        Object object;
        Container container;
        if (inInputVerifier) {
            return true;
        }
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component == null && (container = SwingUtilities.getWindowAncestor(this)) != null) {
            try {
                object = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                    @Override
                    public Method run() throws Exception {
                        Method method = KeyboardFocusManager.class.getDeclaredMethod("getMostRecentFocusOwner", Window.class);
                        method.setAccessible(true);
                        return method;
                    }
                });
                component = (Component)((Method)object).invoke(null, container);
            }
            catch (Exception exception) {
                component = null;
            }
        }
        if (component == this) {
            return true;
        }
        if (!this.getVerifyInputWhenFocusTarget()) {
            return true;
        }
        if (component == null || !(component instanceof JComponent)) {
            return true;
        }
        container = (JComponent)component;
        object = ((JComponent)container).getInputVerifier();
        if (object == null) {
            return true;
        }
        inInputVerifier = true;
        try {
            boolean bl2 = ((InputVerifier)object).shouldYieldFocus((JComponent)container);
            return bl2;
        }
        finally {
            inInputVerifier = false;
        }
    }

    @Override
    public void requestFocus() {
        if (this.runInputVerifier()) {
            super.requestFocus();
        }
    }

    @Override
    public boolean requestFocus(boolean bl2) {
        return this.runInputVerifier() ? super.requestFocus(bl2) : false;
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.runInputVerifier() ? super.requestFocusInWindow() : false;
    }

    @Override
    protected boolean requestFocusInWindow(boolean bl2) {
        return this.runInputVerifier() ? super.requestFocusInWindow(bl2) : false;
    }

    public void grabFocus() {
        this.requestFocus();
    }

    public void setVerifyInputWhenFocusTarget(boolean bl2) {
        boolean bl3 = this.verifyInputWhenFocusTarget;
        this.verifyInputWhenFocusTarget = bl2;
        this.firePropertyChange("verifyInputWhenFocusTarget", bl3, bl2);
    }

    public boolean getVerifyInputWhenFocusTarget() {
        return this.verifyInputWhenFocusTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FontMetrics getFontMetrics(Font font) {
        if (font != null && SwingUtilities2.drawTextAntialiased(this.aaText)) {
            Map<Font, FontMetrics> map = aaFontMap;
            synchronized (map) {
                FontMetrics fontMetrics = aaFontMap.get(font);
                if (fontMetrics == null) {
                    fontMetrics = new FontDesignMetrics(font, SwingUtilities2.AA_FRC);
                    aaFontMap.put(font, fontMetrics);
                }
                return fontMetrics;
            }
        }
        return super.getFontMetrics(font);
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        super.setPreferredSize(dimension);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Dimension dimension = null;
        if (this.ui != null) {
            dimension = this.ui.getPreferredSize(this);
        }
        return dimension != null ? dimension : super.getPreferredSize();
    }

    @Override
    public void setMaximumSize(Dimension dimension) {
        super.setMaximumSize(dimension);
    }

    @Override
    public Dimension getMaximumSize() {
        if (this.isMaximumSizeSet()) {
            return super.getMaximumSize();
        }
        Dimension dimension = null;
        if (this.ui != null) {
            dimension = this.ui.getMaximumSize(this);
        }
        return dimension != null ? dimension : super.getMaximumSize();
    }

    @Override
    public void setMinimumSize(Dimension dimension) {
        super.setMinimumSize(dimension);
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        Dimension dimension = null;
        if (this.ui != null) {
            dimension = this.ui.getMinimumSize(this);
        }
        return dimension != null ? dimension : super.getMinimumSize();
    }

    @Override
    public boolean contains(int n2, int n3) {
        return this.ui != null ? this.ui.contains(this, n2, n3) : super.contains(n2, n3);
    }

    public void setBorder(Border border) {
        Border border2 = this.border;
        this.border = border;
        this.firePropertyChange("border", border2, border);
        if (border != border2) {
            if (border == null || border2 == null || !border.getBorderInsets(this).equals(border2.getBorderInsets(this))) {
                this.revalidate();
            }
            this.repaint();
        }
    }

    public Border getBorder() {
        return this.border;
    }

    @Override
    public Insets getInsets() {
        if (this.border != null) {
            return this.border.getBorderInsets(this);
        }
        return super.getInsets();
    }

    public Insets getInsets(Insets insets) {
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        if (this.border != null) {
            if (this.border instanceof AbstractBorder) {
                return ((AbstractBorder)this.border).getBorderInsets(this, insets);
            }
            return this.border.getBorderInsets(this);
        }
        insets.bottom = 0;
        insets.right = 0;
        insets.top = 0;
        insets.left = 0;
        return insets;
    }

    @Override
    public float getAlignmentY() {
        if (this.isAlignmentYSet) {
            return this.alignmentY;
        }
        return super.getAlignmentY();
    }

    public void setAlignmentY(float f2) {
        this.alignmentY = f2 > 1.0f ? 1.0f : (f2 < 0.0f ? 0.0f : f2);
        this.isAlignmentYSet = true;
    }

    @Override
    public float getAlignmentX() {
        if (this.isAlignmentXSet) {
            return this.alignmentX;
        }
        return super.getAlignmentX();
    }

    public void setAlignmentX(float f2) {
        this.alignmentX = f2 > 1.0f ? 1.0f : (f2 < 0.0f ? 0.0f : f2);
        this.isAlignmentXSet = true;
    }

    public void setInputVerifier(InputVerifier inputVerifier) {
        InputVerifier inputVerifier2 = (InputVerifier)this.getClientProperty(INPUT_VERIFIER_KEY);
        this.putClientProperty(INPUT_VERIFIER_KEY, inputVerifier);
        this.firePropertyChange("inputVerifier", inputVerifier2, inputVerifier);
    }

    public InputVerifier getInputVerifier() {
        return (InputVerifier)this.getClientProperty(INPUT_VERIFIER_KEY);
    }

    @Override
    public Graphics getGraphics() {
        if (DEBUG_GRAPHICS_LOADED && this.shouldDebugGraphics() != 0) {
            DebugGraphics debugGraphics = new DebugGraphics(super.getGraphics(), this);
            return debugGraphics;
        }
        return super.getGraphics();
    }

    public void setDebugGraphicsOptions(int n2) {
        DebugGraphics.setDebugOptions(this, n2);
    }

    public int getDebugGraphicsOptions() {
        return DebugGraphics.getDebugOptions(this);
    }

    int shouldDebugGraphics() {
        return DebugGraphics.shouldComponentDebug(this);
    }

    public void registerKeyboardAction(ActionListener actionListener, String string, KeyStroke keyStroke, int n2) {
        InputMap inputMap = this.getInputMap(n2, true);
        if (inputMap != null) {
            ActionMap actionMap = this.getActionMap(true);
            ActionStandin actionStandin = new ActionStandin(actionListener, string);
            inputMap.put(keyStroke, actionStandin);
            if (actionMap != null) {
                actionMap.put(actionStandin, actionStandin);
            }
        }
    }

    private void registerWithKeyboardManager(boolean bl2) {
        int n2;
        KeyStroke[] keyStrokeArray;
        InputMap inputMap = this.getInputMap(2, false);
        Hashtable<KeyStroke, KeyStroke> hashtable = (Hashtable<KeyStroke, KeyStroke>)this.getClientProperty(WHEN_IN_FOCUSED_WINDOW_BINDINGS);
        if (inputMap != null) {
            keyStrokeArray = inputMap.allKeys();
            if (keyStrokeArray != null) {
                for (n2 = keyStrokeArray.length - 1; n2 >= 0; --n2) {
                    if (!bl2 || hashtable == null || hashtable.get(keyStrokeArray[n2]) == null) {
                        this.registerWithKeyboardManager(keyStrokeArray[n2]);
                    }
                    if (hashtable == null) continue;
                    hashtable.remove(keyStrokeArray[n2]);
                }
            }
        } else {
            keyStrokeArray = null;
        }
        if (hashtable != null && hashtable.size() > 0) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                KeyStroke keyStroke = (KeyStroke)enumeration.nextElement();
                this.unregisterWithKeyboardManager(keyStroke);
            }
            hashtable.clear();
        }
        if (keyStrokeArray != null && keyStrokeArray.length > 0) {
            if (hashtable == null) {
                hashtable = new Hashtable<KeyStroke, KeyStroke>(keyStrokeArray.length);
                this.putClientProperty(WHEN_IN_FOCUSED_WINDOW_BINDINGS, hashtable);
            }
            for (n2 = keyStrokeArray.length - 1; n2 >= 0; --n2) {
                hashtable.put(keyStrokeArray[n2], keyStrokeArray[n2]);
            }
        } else {
            this.putClientProperty(WHEN_IN_FOCUSED_WINDOW_BINDINGS, null);
        }
    }

    private void unregisterWithKeyboardManager() {
        Hashtable hashtable = (Hashtable)this.getClientProperty(WHEN_IN_FOCUSED_WINDOW_BINDINGS);
        if (hashtable != null && hashtable.size() > 0) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                KeyStroke keyStroke = (KeyStroke)enumeration.nextElement();
                this.unregisterWithKeyboardManager(keyStroke);
            }
        }
        this.putClientProperty(WHEN_IN_FOCUSED_WINDOW_BINDINGS, null);
    }

    void componentInputMapChanged(ComponentInputMap componentInputMap) {
        InputMap inputMap;
        for (inputMap = this.getInputMap(2, false); inputMap != componentInputMap && inputMap != null; inputMap = (ComponentInputMap)inputMap.getParent()) {
        }
        if (inputMap != null) {
            this.registerWithKeyboardManager(false);
        }
    }

    private void registerWithKeyboardManager(KeyStroke keyStroke) {
        KeyboardManager.getCurrentManager().registerKeyStroke(keyStroke, this);
    }

    private void unregisterWithKeyboardManager(KeyStroke keyStroke) {
        KeyboardManager.getCurrentManager().unregisterKeyStroke(keyStroke, this);
    }

    public void registerKeyboardAction(ActionListener actionListener, KeyStroke keyStroke, int n2) {
        this.registerKeyboardAction(actionListener, null, keyStroke, n2);
    }

    public void unregisterKeyboardAction(KeyStroke keyStroke) {
        ActionMap actionMap = this.getActionMap(false);
        for (int i2 = 0; i2 < 3; ++i2) {
            InputMap inputMap = this.getInputMap(i2, false);
            if (inputMap == null) continue;
            Object object = inputMap.get(keyStroke);
            if (actionMap != null && object != null) {
                actionMap.remove(object);
            }
            inputMap.remove(keyStroke);
        }
    }

    public KeyStroke[] getRegisteredKeyStrokes() {
        int[] nArray = new int[3];
        KeyStroke[][] keyStrokeArrayArray = new KeyStroke[3][];
        for (int i2 = 0; i2 < 3; ++i2) {
            InputMap inputMap = this.getInputMap(i2, false);
            keyStrokeArrayArray[i2] = inputMap != null ? inputMap.allKeys() : null;
            nArray[i2] = keyStrokeArrayArray[i2] != null ? keyStrokeArrayArray[i2].length : 0;
        }
        KeyStroke[] keyStrokeArray = new KeyStroke[nArray[0] + nArray[1] + nArray[2]];
        int n2 = 0;
        for (int i3 = 0; i3 < 3; ++i3) {
            if (nArray[i3] <= 0) continue;
            System.arraycopy(keyStrokeArrayArray[i3], 0, keyStrokeArray, n2, nArray[i3]);
            n2 += nArray[i3];
        }
        return keyStrokeArray;
    }

    public int getConditionForKeyStroke(KeyStroke keyStroke) {
        for (int i2 = 0; i2 < 3; ++i2) {
            InputMap inputMap = this.getInputMap(i2, false);
            if (inputMap == null || inputMap.get(keyStroke) == null) continue;
            return i2;
        }
        return -1;
    }

    public ActionListener getActionForKeyStroke(KeyStroke keyStroke) {
        ActionMap actionMap = this.getActionMap(false);
        if (actionMap == null) {
            return null;
        }
        for (int i2 = 0; i2 < 3; ++i2) {
            Object object;
            InputMap inputMap = this.getInputMap(i2, false);
            if (inputMap == null || (object = inputMap.get(keyStroke)) == null) continue;
            Action action = actionMap.get(object);
            if (action instanceof ActionStandin) {
                return ((ActionStandin)action).actionListener;
            }
            return action;
        }
        return null;
    }

    public void resetKeyboardActions() {
        for (int i2 = 0; i2 < 3; ++i2) {
            InputMap inputMap = this.getInputMap(i2, false);
            if (inputMap == null) continue;
            inputMap.clear();
        }
        ActionMap actionMap = this.getActionMap(false);
        if (actionMap != null) {
            actionMap.clear();
        }
    }

    public final void setInputMap(int n2, InputMap inputMap) {
        switch (n2) {
            case 2: {
                if (inputMap != null && !(inputMap instanceof ComponentInputMap)) {
                    throw new IllegalArgumentException("WHEN_IN_FOCUSED_WINDOW InputMaps must be of type ComponentInputMap");
                }
                this.windowInputMap = (ComponentInputMap)inputMap;
                this.setFlag(7, true);
                this.registerWithKeyboardManager(false);
                break;
            }
            case 1: {
                this.ancestorInputMap = inputMap;
                this.setFlag(6, true);
                break;
            }
            case 0: {
                this.focusInputMap = inputMap;
                this.setFlag(5, true);
                break;
            }
            default: {
                throw new IllegalArgumentException("condition must be one of JComponent.WHEN_IN_FOCUSED_WINDOW, JComponent.WHEN_FOCUSED or JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT");
            }
        }
    }

    public final InputMap getInputMap(int n2) {
        return this.getInputMap(n2, true);
    }

    public final InputMap getInputMap() {
        return this.getInputMap(0, true);
    }

    public final void setActionMap(ActionMap actionMap) {
        this.actionMap = actionMap;
        this.setFlag(8, true);
    }

    public final ActionMap getActionMap() {
        return this.getActionMap(true);
    }

    final InputMap getInputMap(int n2, boolean bl2) {
        switch (n2) {
            case 0: {
                if (this.getFlag(5)) {
                    return this.focusInputMap;
                }
                if (!bl2) break;
                InputMap inputMap = new InputMap();
                this.setInputMap(n2, inputMap);
                return inputMap;
            }
            case 1: {
                if (this.getFlag(6)) {
                    return this.ancestorInputMap;
                }
                if (!bl2) break;
                InputMap inputMap = new InputMap();
                this.setInputMap(n2, inputMap);
                return inputMap;
            }
            case 2: {
                if (this.getFlag(7)) {
                    return this.windowInputMap;
                }
                if (!bl2) break;
                ComponentInputMap componentInputMap = new ComponentInputMap(this);
                this.setInputMap(n2, componentInputMap);
                return componentInputMap;
            }
            default: {
                throw new IllegalArgumentException("condition must be one of JComponent.WHEN_IN_FOCUSED_WINDOW, JComponent.WHEN_FOCUSED or JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT");
            }
        }
        return null;
    }

    final ActionMap getActionMap(boolean bl2) {
        if (this.getFlag(8)) {
            return this.actionMap;
        }
        if (bl2) {
            ActionMap actionMap = new ActionMap();
            this.setActionMap(actionMap);
            return actionMap;
        }
        return null;
    }

    @Deprecated
    public boolean requestDefaultFocus() {
        Container container;
        Container container2 = container = this.isFocusCycleRoot() ? this : this.getFocusCycleRootAncestor();
        if (container == null) {
            return false;
        }
        Component component = container.getFocusTraversalPolicy().getDefaultComponent(container);
        if (component != null) {
            component.requestFocus();
            return true;
        }
        return false;
    }

    @Override
    public void setVisible(boolean bl2) {
        if (bl2 != this.isVisible()) {
            super.setVisible(bl2);
            Container container = this.getParent();
            if (container != null) {
                Rectangle rectangle = this.getBounds();
                container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            this.revalidate();
        }
    }

    @Override
    public void setEnabled(boolean bl2) {
        boolean bl3 = this.isEnabled();
        super.setEnabled(bl2);
        this.firePropertyChange("enabled", bl3, bl2);
        if (bl2 != bl3) {
            this.repaint();
        }
    }

    @Override
    public void setForeground(Color color) {
        Color color2 = this.getForeground();
        super.setForeground(color);
        if (color2 != null ? !color2.equals(color) : color != null && !color.equals(color2)) {
            this.repaint();
        }
    }

    @Override
    public void setBackground(Color color) {
        Color color2 = this.getBackground();
        super.setBackground(color);
        if (color2 != null ? !color2.equals(color) : color != null && !color.equals(color2)) {
            this.repaint();
        }
    }

    @Override
    public void setFont(Font font) {
        Font font2 = this.getFont();
        super.setFont(font);
        if (font != font2) {
            this.revalidate();
            this.repaint();
        }
    }

    public static Locale getDefaultLocale() {
        Locale locale = (Locale)SwingUtilities.appContextGet(defaultLocale);
        if (locale == null) {
            locale = Locale.getDefault();
            JComponent.setDefaultLocale(locale);
        }
        return locale;
    }

    public static void setDefaultLocale(Locale locale) {
        SwingUtilities.appContextPut(defaultLocale, locale);
    }

    protected void processComponentKeyEvent(KeyEvent keyEvent) {
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (!keyEvent.isConsumed()) {
            this.processComponentKeyEvent(keyEvent);
        }
        boolean bl2 = KeyboardState.shouldProcess(keyEvent);
        if (keyEvent.isConsumed()) {
            return;
        }
        if (bl2 && this.processKeyBindings(keyEvent, keyEvent.getID() == 401)) {
            keyEvent.consume();
        }
    }

    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n2, boolean bl2) {
        InputMap inputMap = this.getInputMap(n2, false);
        ActionMap actionMap = this.getActionMap(false);
        if (inputMap != null && actionMap != null && this.isEnabled()) {
            Action action;
            Object object = inputMap.get(keyStroke);
            Action action2 = action = object == null ? null : actionMap.get(object);
            if (action != null) {
                return SwingUtilities.notifyAction(action, keyStroke, keyEvent, this, keyEvent.getModifiers());
            }
        }
        return false;
    }

    boolean processKeyBindings(KeyEvent keyEvent, boolean bl2) {
        Container container;
        if (!SwingUtilities.isValidKeyEventForKeyBindings(keyEvent)) {
            return false;
        }
        KeyStroke keyStroke = keyEvent.getID() == 400 ? KeyStroke.getKeyStroke(keyEvent.getKeyChar()) : KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers(), !bl2);
        if (this.processKeyBinding(keyStroke, keyEvent, 0, bl2)) {
            return true;
        }
        for (container = this; container != null && !(container instanceof Window) && !(container instanceof Applet); container = container.getParent()) {
            if (container instanceof JComponent && container.processKeyBinding(keyStroke, keyEvent, 1, bl2)) {
                return true;
            }
            if (!(container instanceof JInternalFrame) || !JComponent.processKeyBindingsForAllComponents(keyEvent, container, bl2)) continue;
            return true;
        }
        if (container != null) {
            return JComponent.processKeyBindingsForAllComponents(keyEvent, container, bl2);
        }
        return false;
    }

    static boolean processKeyBindingsForAllComponents(KeyEvent keyEvent, Container container, boolean bl2) {
        while (true) {
            if (KeyboardManager.getCurrentManager().fireKeyboardAction(keyEvent, bl2, container)) {
                return true;
            }
            if (!(container instanceof Popup.HeavyWeightWindow)) break;
            container = ((Window)container).getOwner();
        }
        return false;
    }

    public void setToolTipText(String string) {
        String string2 = this.getToolTipText();
        this.putClientProperty(TOOL_TIP_TEXT_KEY, string);
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        if (string != null) {
            if (string2 == null) {
                toolTipManager.registerComponent(this);
            }
        } else {
            toolTipManager.unregisterComponent(this);
        }
    }

    public String getToolTipText() {
        return (String)this.getClientProperty(TOOL_TIP_TEXT_KEY);
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        return this.getToolTipText();
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        return null;
    }

    public Point getPopupLocation(MouseEvent mouseEvent) {
        return null;
    }

    public JToolTip createToolTip() {
        JToolTip jToolTip = new JToolTip();
        jToolTip.setComponent(this);
        return jToolTip;
    }

    public void scrollRectToVisible(Rectangle rectangle) {
        Container container;
        int n2 = this.getX();
        int n3 = this.getY();
        for (container = this.getParent(); container != null && !(container instanceof JComponent) && !(container instanceof CellRendererPane); container = container.getParent()) {
            Rectangle rectangle2 = container.getBounds();
            n2 += rectangle2.x;
            n3 += rectangle2.y;
        }
        if (container != null && !(container instanceof CellRendererPane)) {
            rectangle.x += n2;
            rectangle.y += n3;
            ((JComponent)container).scrollRectToVisible(rectangle);
            rectangle.x -= n2;
            rectangle.y -= n3;
        }
    }

    public void setAutoscrolls(boolean bl2) {
        this.setFlag(25, true);
        if (this.autoscrolls != bl2) {
            this.autoscrolls = bl2;
            if (bl2) {
                this.enableEvents(16L);
                this.enableEvents(32L);
            } else {
                Autoscroller.stop(this);
            }
        }
    }

    public boolean getAutoscrolls() {
        return this.autoscrolls;
    }

    public void setTransferHandler(TransferHandler transferHandler) {
        DropTarget dropTarget;
        TransferHandler transferHandler2 = (TransferHandler)this.getClientProperty(TRANSFER_HANDLER_KEY);
        this.putClientProperty(TRANSFER_HANDLER_KEY, transferHandler);
        if (!JComponent.getSuppressDropTarget() && ((dropTarget = this.getDropTarget()) == null || dropTarget instanceof UIResource)) {
            if (transferHandler == null) {
                this.setDropTarget(null);
            } else if (!GraphicsEnvironment.isHeadless()) {
                this.setDropTarget(new TransferHandler.SwingDropTarget(this));
            }
        }
        this.firePropertyChange("transferHandler", transferHandler2, transferHandler);
    }

    public TransferHandler getTransferHandler() {
        return (TransferHandler)this.getClientProperty(TRANSFER_HANDLER_KEY);
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.autoscrolls && mouseEvent.getID() == 502) {
            Autoscroller.stop(this);
        }
        super.processMouseEvent(mouseEvent);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        boolean bl2 = true;
        if (this.autoscrolls && mouseEvent.getID() == 506) {
            bl2 = !Autoscroller.isRunning(this);
            Autoscroller.processMouseDragged(mouseEvent);
        }
        if (bl2) {
            super.processMouseMotionEvent(mouseEvent);
        }
    }

    void superProcessMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
    }

    void setCreatedDoubleBuffer(boolean bl2) {
        this.setFlag(9, bl2);
    }

    boolean getCreatedDoubleBuffer() {
        return this.getFlag(9);
    }

    @Override
    @Deprecated
    public void enable() {
        if (!this.isEnabled()) {
            super.enable();
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.ENABLED);
            }
        }
    }

    @Override
    @Deprecated
    public void disable() {
        if (this.isEnabled()) {
            super.disable();
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.ENABLED, null);
            }
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        return this.accessibleContext;
    }

    private ArrayTable getClientProperties() {
        if (this.clientProperties == null) {
            this.clientProperties = new ArrayTable();
        }
        return this.clientProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getClientProperty(Object object) {
        if (object == SwingUtilities2.AA_TEXT_PROPERTY_KEY) {
            return this.aaText;
        }
        if (this.clientProperties == null) {
            return null;
        }
        ArrayTable arrayTable = this.clientProperties;
        synchronized (arrayTable) {
            return this.clientProperties.get(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void putClientProperty(Object object, Object object2) {
        Object object3;
        ArrayTable arrayTable;
        if (object2 == null && this.clientProperties == null) {
            return;
        }
        if (object == SwingUtilities2.AA_TEXT_PROPERTY_KEY) {
            if (object2 instanceof Boolean) {
                this.aaText = (Boolean)object2;
            }
            return;
        }
        ArrayTable arrayTable2 = arrayTable = this.getClientProperties();
        synchronized (arrayTable2) {
            object3 = arrayTable.get(object);
            if (object2 != null) {
                arrayTable.put(object, object2);
            } else if (object3 != null) {
                arrayTable.remove(object);
            } else {
                return;
            }
        }
        this.firePropertyChange(object.toString(), object3, object2);
    }

    void setUIProperty(String string, Object object) {
        if (string == "opaque") {
            if (!this.getFlag(24)) {
                this.setOpaque((Boolean)object);
                this.setFlag(24, false);
            }
        } else if (string == "autoscrolls") {
            if (!this.getFlag(25)) {
                this.setAutoscrolls((Boolean)object);
                this.setFlag(25, false);
            }
        } else if (string == "focusTraversalKeysForward") {
            if (!this.getFlag(26)) {
                super.setFocusTraversalKeys(0, (Set)object);
            }
        } else if (string == "focusTraversalKeysBackward") {
            if (!this.getFlag(27)) {
                super.setFocusTraversalKeys(1, (Set)object);
            }
        } else {
            throw new IllegalArgumentException("property \"" + string + "\" cannot be set using this method");
        }
    }

    @Override
    public void setFocusTraversalKeys(int n2, Set<? extends AWTKeyStroke> set) {
        if (n2 == 0) {
            this.setFlag(26, true);
        } else if (n2 == 1) {
            this.setFlag(27, true);
        }
        super.setFocusTraversalKeys(n2, set);
    }

    public static boolean isLightweightComponent(Component component) {
        return component.getPeer() instanceof LightweightPeer;
    }

    @Override
    @Deprecated
    public void reshape(int n2, int n3, int n4, int n5) {
        super.reshape(n2, n3, n4, n5);
    }

    @Override
    public Rectangle getBounds(Rectangle rectangle) {
        if (rectangle == null) {
            return new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        rectangle.setBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        return rectangle;
    }

    @Override
    public Dimension getSize(Dimension dimension) {
        if (dimension == null) {
            return new Dimension(this.getWidth(), this.getHeight());
        }
        dimension.setSize(this.getWidth(), this.getHeight());
        return dimension;
    }

    @Override
    public Point getLocation(Point point) {
        if (point == null) {
            return new Point(this.getX(), this.getY());
        }
        point.setLocation(this.getX(), this.getY());
        return point;
    }

    @Override
    public int getX() {
        return super.getX();
    }

    @Override
    public int getY() {
        return super.getY();
    }

    @Override
    public int getWidth() {
        return super.getWidth();
    }

    @Override
    public int getHeight() {
        return super.getHeight();
    }

    @Override
    public boolean isOpaque() {
        return this.getFlag(3);
    }

    public void setOpaque(boolean bl2) {
        boolean bl3 = this.getFlag(3);
        this.setFlag(3, bl2);
        this.setFlag(24, true);
        this.firePropertyChange("opaque", bl3, bl2);
    }

    boolean rectangleIsObscured(int n2, int n3, int n4, int n5) {
        int n6 = this.getComponentCount();
        for (int i2 = 0; i2 < n6; ++i2) {
            Component component = this.getComponent(i2);
            int n7 = component.getX();
            int n8 = component.getY();
            int n9 = component.getWidth();
            int n10 = component.getHeight();
            if (n2 < n7 || n2 + n4 > n7 + n9 || n3 < n8 || n3 + n5 > n8 + n10 || !component.isVisible()) continue;
            if (component instanceof JComponent) {
                return ((JComponent)component).isOpaque();
            }
            return false;
        }
        return false;
    }

    static final void computeVisibleRect(Component component, Rectangle rectangle) {
        Container container = component.getParent();
        Rectangle rectangle2 = component.getBounds();
        if (container == null || container instanceof Window || container instanceof Applet) {
            rectangle.setBounds(0, 0, rectangle2.width, rectangle2.height);
        } else {
            JComponent.computeVisibleRect(container, rectangle);
            rectangle.x -= rectangle2.x;
            rectangle.y -= rectangle2.y;
            SwingUtilities.computeIntersection(0, 0, rectangle2.width, rectangle2.height, rectangle);
        }
    }

    public void computeVisibleRect(Rectangle rectangle) {
        JComponent.computeVisibleRect(this, rectangle);
    }

    public Rectangle getVisibleRect() {
        Rectangle rectangle = new Rectangle();
        this.computeVisibleRect(rectangle);
        return rectangle;
    }

    @Override
    public void firePropertyChange(String string, boolean bl2, boolean bl3) {
        super.firePropertyChange(string, bl2, bl3);
    }

    @Override
    public void firePropertyChange(String string, int n2, int n3) {
        super.firePropertyChange(string, n2, n3);
    }

    @Override
    public void firePropertyChange(String string, char c2, char c3) {
        super.firePropertyChange(string, c2, c3);
    }

    protected void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        if (this.vetoableChangeSupport == null) {
            return;
        }
        this.vetoableChangeSupport.fireVetoableChange(string, object, object2);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this.vetoableChangeSupport == null) {
            this.vetoableChangeSupport = new VetoableChangeSupport(this);
        }
        this.vetoableChangeSupport.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this.vetoableChangeSupport == null) {
            return;
        }
        this.vetoableChangeSupport.removeVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized VetoableChangeListener[] getVetoableChangeListeners() {
        if (this.vetoableChangeSupport == null) {
            return new VetoableChangeListener[0];
        }
        return this.vetoableChangeSupport.getVetoableChangeListeners();
    }

    public Container getTopLevelAncestor() {
        for (Container container = this; container != null; container = container.getParent()) {
            if (!(container instanceof Window) && !(container instanceof Applet)) continue;
            return container;
        }
        return null;
    }

    private AncestorNotifier getAncestorNotifier() {
        return (AncestorNotifier)this.getClientProperty(ANCESTOR_NOTIFIER_KEY);
    }

    public void addAncestorListener(AncestorListener ancestorListener) {
        AncestorNotifier ancestorNotifier = this.getAncestorNotifier();
        if (ancestorNotifier == null) {
            ancestorNotifier = new AncestorNotifier(this);
            this.putClientProperty(ANCESTOR_NOTIFIER_KEY, ancestorNotifier);
        }
        ancestorNotifier.addAncestorListener(ancestorListener);
    }

    public void removeAncestorListener(AncestorListener ancestorListener) {
        AncestorNotifier ancestorNotifier = this.getAncestorNotifier();
        if (ancestorNotifier == null) {
            return;
        }
        ancestorNotifier.removeAncestorListener(ancestorListener);
        if (ancestorNotifier.listenerList.getListenerList().length == 0) {
            ancestorNotifier.removeAllListeners();
            this.putClientProperty(ANCESTOR_NOTIFIER_KEY, null);
        }
    }

    public AncestorListener[] getAncestorListeners() {
        AncestorNotifier ancestorNotifier = this.getAncestorNotifier();
        if (ancestorNotifier == null) {
            return new AncestorListener[0];
        }
        return ancestorNotifier.getAncestorListeners();
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        EventListener[] eventListenerArray = clazz == AncestorListener.class ? (EventListener[])this.getAncestorListeners() : (clazz == VetoableChangeListener.class ? (EventListener[])this.getVetoableChangeListeners() : (clazz == PropertyChangeListener.class ? (EventListener[])this.getPropertyChangeListeners() : this.listenerList.getListeners(clazz)));
        if (eventListenerArray.length == 0) {
            return super.getListeners(clazz);
        }
        return eventListenerArray;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.firePropertyChange("ancestor", null, this.getParent());
        this.registerWithKeyboardManager(false);
        this.registerNextFocusableComponent();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.firePropertyChange("ancestor", this.getParent(), null);
        this.unregisterWithKeyboardManager();
        this.deregisterNextFocusableComponent();
        if (this.getCreatedDoubleBuffer()) {
            RepaintManager.currentManager(this).resetDoubleBuffer();
            this.setCreatedDoubleBuffer(false);
        }
        if (this.autoscrolls) {
            Autoscroller.stop(this);
        }
    }

    @Override
    public void repaint(long l2, int n2, int n3, int n4, int n5) {
        RepaintManager.currentManager(this).addDirtyRegion(this, n2, n3, n4, n5);
    }

    public void repaint(Rectangle rectangle) {
        this.repaint(0L, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void revalidate() {
        if (this.getParent() == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.invalidate();
            RepaintManager.currentManager(this).addInvalidComponent(this);
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    JComponent.this.revalidate();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    public boolean isValidateRoot() {
        return false;
    }

    public boolean isOptimizedDrawingEnabled() {
        return true;
    }

    boolean isPaintingOrigin() {
        return false;
    }

    public void paintImmediately(int n2, int n3, int n4, int n5) {
        Container container;
        Container container2 = this;
        if (!this.isShowing()) {
            return;
        }
        while (!container2.isOpaque() && (container = container2.getParent()) != null) {
            n2 += ((Component)container2).getX();
            n3 += ((Component)container2).getY();
            container2 = container;
            if (container2 instanceof JComponent) continue;
        }
        if (container2 instanceof JComponent) {
            container2._paintImmediately(n2, n3, n4, n5);
        } else {
            container2.repaint(n2, n3, n4, n5);
        }
    }

    public void paintImmediately(Rectangle rectangle) {
        this.paintImmediately(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    boolean alwaysOnTop() {
        return false;
    }

    void setPaintingChild(Component component) {
        this.paintingChild = component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _paintImmediately(int n2, int n3, int n4, int n5) {
        int n6;
        Object object;
        Container container;
        int n7 = 0;
        int n8 = 0;
        boolean bl2 = false;
        JComponent jComponent = null;
        JComponent jComponent2 = this;
        RepaintManager repaintManager = RepaintManager.currentManager(this);
        Vector<JComponent> vector = new Vector<JComponent>(7);
        int n9 = -1;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        Rectangle rectangle = JComponent.fetchRectangle();
        rectangle.x = n2;
        rectangle.y = n3;
        rectangle.width = n4;
        rectangle.height = n5;
        boolean bl3 = this.alwaysOnTop() && this.isOpaque();
        JComponent jComponent3 = null;
        for (container = this; container != null && !(container instanceof Window) && !(container instanceof Applet); container = container.getParent()) {
            object = container instanceof JComponent ? container : null;
            vector.addElement((JComponent)container);
            if (!bl3 && object != null && !((JComponent)object).isOptimizedDrawingEnabled()) {
                if (container != this) {
                    if (((JComponent)object).isPaintingOrigin()) {
                        n6 = 1;
                    } else {
                        int n15;
                        Component[] componentArray = container.getComponents();
                        for (n15 = 0; n15 < componentArray.length && componentArray[n15] != jComponent3; ++n15) {
                        }
                        switch (super.getObscuredState(n15, rectangle.x, rectangle.y, rectangle.width, rectangle.height)) {
                            case 0: {
                                n6 = 0;
                                break;
                            }
                            case 2: {
                                JComponent.recycleRectangle(rectangle);
                                return;
                            }
                            default: {
                                n6 = 1;
                                break;
                            }
                        }
                    }
                } else {
                    n6 = 0;
                }
                if (n6 != 0) {
                    jComponent2 = object;
                    n9 = n10;
                    n8 = 0;
                    n7 = 0;
                    bl2 = false;
                }
            }
            ++n10;
            if (repaintManager.isDoubleBufferingEnabled() && object != null && ((JComponent)object).isDoubleBuffered()) {
                bl2 = true;
                jComponent = object;
            }
            if (!bl3) {
                n6 = container.getX();
                int n16 = container.getY();
                n12 = container.getWidth();
                n11 = container.getHeight();
                SwingUtilities.computeIntersection(n14, n13, n12, n11, rectangle);
                rectangle.x += n6;
                rectangle.y += n16;
                n7 += n6;
                n8 += n16;
            }
            jComponent3 = container;
        }
        if (container == null || container.getPeer() == null || rectangle.width <= 0 || rectangle.height <= 0) {
            JComponent.recycleRectangle(rectangle);
            return;
        }
        jComponent2.setFlag(13, true);
        rectangle.x -= n7;
        rectangle.y -= n8;
        if (jComponent2 != this) {
            for (n6 = n9; n6 > 0; --n6) {
                object = (Component)vector.elementAt(n6);
                if (!(object instanceof JComponent)) continue;
                ((JComponent)object).setPaintingChild((Component)vector.elementAt(n6 - 1));
            }
        }
        try {
            Graphics graphics;
            try {
                object = jComponent2.getGraphics();
                graphics = object == null ? null : ((Graphics)object).create();
                ((Graphics)object).dispose();
            }
            catch (NullPointerException nullPointerException) {
                graphics = null;
                nullPointerException.printStackTrace();
            }
            if (graphics == null) {
                System.err.println("In paintImmediately null graphics");
                return;
            }
            try {
                boolean bl4 = false;
                if (bl2) {
                    bl4 = this.paintDoubleBuffered(jComponent2, jComponent, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                if (!bl4) {
                    graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    jComponent2.paint(graphics);
                }
            }
            finally {
                graphics.dispose();
            }
        }
        finally {
            if (jComponent2 != this) {
                for (n6 = n9; n6 > 0; --n6) {
                    object = (Component)vector.elementAt(n6);
                    if (!(object instanceof JComponent)) continue;
                    ((JComponent)object).setPaintingChild(null);
                }
            }
            vector.removeAllElements();
            jComponent2.setFlag(13, false);
        }
        JComponent.recycleRectangle(rectangle);
    }

    private boolean paintDoubleBuffered(JComponent jComponent, Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
        RepaintManager repaintManager = RepaintManager.currentManager(jComponent);
        boolean bl2 = false;
        Image image = null;
        if (repaintManager.useVolatileDoubleBuffer() && (image = repaintManager.getVolatileOffscreenBuffer(component, n4, n5)) != null && image.getWidth(null) > 0 && image.getHeight(null) > 0) {
            VolatileImage volatileImage = (VolatileImage)image;
            GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
            for (int i2 = 0; !bl2 && i2 < 2; ++i2) {
                if (volatileImage.validate(graphicsConfiguration) == 2) {
                    repaintManager.resetVolatileDoubleBuffer(graphicsConfiguration);
                    image = repaintManager.getVolatileOffscreenBuffer(component, n4, n5);
                    volatileImage = (VolatileImage)image;
                }
                this.paintWithOffscreenBuffer(jComponent, graphics, n2, n3, n4, n5, image);
                bl2 = !volatileImage.contentsLost();
            }
        }
        if (!bl2 && (image = repaintManager.getOffscreenBuffer(component, n4, n5)) != null && image.getWidth(null) > 0 && image.getHeight(null) > 0) {
            this.paintWithOffscreenBuffer(jComponent, graphics, n2, n3, n4, n5, image);
            bl2 = true;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintWithOffscreenBuffer(JComponent jComponent, Graphics graphics, int n2, int n3, int n4, int n5, Image image) {
        Graphics graphics2 = image.getGraphics();
        Graphics graphics3 = graphics2 == null ? null : graphics2.create();
        graphics2.dispose();
        int n6 = image.getWidth(null);
        int n7 = image.getHeight(null);
        if (n6 > n4) {
            n6 = n4;
        }
        if (n7 > n5) {
            n7 = n5;
        }
        try {
            jComponent.setFlag(1, true);
            jComponent.setFlag(2, true);
            int n8 = n2 + n4;
            for (int i2 = n2; i2 < n8; i2 += n6) {
                int n9 = n3 + n5;
                for (int i3 = n3; i3 < n9; i3 += n7) {
                    if (i3 + n7 >= n9 && i2 + n6 >= n8) {
                        jComponent.setFlag(2, false);
                    }
                    graphics3.translate(-i2, -i3);
                    graphics3.setClip(i2, i3, n6, n7);
                    if (jComponent.getFlag(13)) {
                        jComponent.paint(graphics3);
                    } else {
                        if (!jComponent.rectangleIsObscured(n2, n3, n6, n7)) {
                            jComponent.paintComponent(graphics3);
                            jComponent.paintBorder(graphics3);
                        }
                        jComponent.paintChildren(graphics3);
                    }
                    graphics.setClip(i2, i3, n6, n7);
                    graphics.drawImage(image, i2, i3, jComponent);
                    graphics3.translate(i2, i3);
                }
            }
        }
        finally {
            jComponent.setFlag(1, false);
            jComponent.setFlag(2, false);
            graphics3.dispose();
        }
    }

    private int getObscuredState(int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        Rectangle rectangle = JComponent.fetchRectangle();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            boolean bl2;
            Component component = this.getComponent(i2);
            if (!component.isVisible()) continue;
            if (component instanceof JComponent) {
                bl2 = ((JComponent)component).isOpaque();
                if (!bl2 && n7 == 1) {
                    continue;
                }
            } else {
                bl2 = true;
            }
            Rectangle rectangle2 = component.getBounds(rectangle);
            if (bl2 && n3 >= rectangle2.x && n3 + n5 <= rectangle2.x + rectangle2.width && n4 >= rectangle2.y && n4 + n6 <= rectangle2.y + rectangle2.height) {
                JComponent.recycleRectangle(rectangle);
                return 2;
            }
            if (n7 != 0 || n3 + n5 <= rectangle2.x || n4 + n6 <= rectangle2.y || n3 >= rectangle2.x + rectangle2.width || n4 >= rectangle2.y + rectangle2.height) continue;
            n7 = 1;
        }
        JComponent.recycleRectangle(rectangle);
        return n7;
    }

    boolean checkIfChildObscuredBySibling() {
        return true;
    }

    private void setFlag(int n2, boolean bl2) {
        this.flags = bl2 ? (this.flags |= 1 << n2) : (this.flags &= ~(1 << n2));
    }

    private boolean getFlag(int n2) {
        int n3 = 1 << n2;
        return (this.flags & n3) == n3;
    }

    static void setWriteObjCounter(JComponent jComponent, byte by) {
        jComponent.flags = jComponent.flags & 0xFFC03FFF | by << 14;
    }

    static byte getWriteObjCounter(JComponent jComponent) {
        return (byte)(jComponent.flags >> 14 & 0xFF);
    }

    public void setDoubleBuffered(boolean bl2) {
        this.setFlag(0, bl2);
    }

    @Override
    public boolean isDoubleBuffered() {
        return this.getFlag(0);
    }

    public JRootPane getRootPane() {
        return SwingUtilities.getRootPane(this);
    }

    void compWriteObjectNotify() {
        byte by = JComponent.getWriteObjCounter(this);
        JComponent.setWriteObjCounter(this, (byte)(by + 1));
        if (by != 0) {
            return;
        }
        if (this.ui != null) {
            this.ui.uninstallUI(this);
        }
        if (this.getToolTipText() != null || this instanceof JTableHeader) {
            ToolTipManager.sharedInstance().unregisterComponent(this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n2;
        objectInputStream.defaultReadObject();
        ReadObjectCallback readObjectCallback = (ReadObjectCallback)readObjectCallbacks.get(objectInputStream);
        if (readObjectCallback == null) {
            try {
                readObjectCallback = new ReadObjectCallback(objectInputStream);
                readObjectCallbacks.put(objectInputStream, readObjectCallback);
            }
            catch (Exception exception) {
                throw new IOException(exception.toString());
            }
        }
        readObjectCallback.registerComponent(this);
        if (this.getToolTipText() != null) {
            ToolTipManager.sharedInstance().registerComponent(this);
        }
        if ((n2 = objectInputStream.readInt()) > 0) {
            this.clientProperties = new ArrayTable();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.clientProperties.put(objectInputStream.readObject(), objectInputStream.readObject());
            }
        }
        JComponent.setWriteObjCounter(this, (byte)0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
        ArrayTable.writeArrayTable(objectOutputStream, this.clientProperties);
    }

    @Override
    protected String paramString() {
        String string = this.isPreferredSizeSet() ? this.getPreferredSize().toString() : "";
        String string2 = this.isMinimumSizeSet() ? this.getMinimumSize().toString() : "";
        String string3 = this.isMaximumSizeSet() ? this.getMaximumSize().toString() : "";
        String string4 = this.border != null ? this.border.toString() : "";
        return super.paramString() + ",alignmentX=" + this.alignmentX + ",alignmentY=" + this.alignmentY + ",border=" + string4 + ",flags=" + this.flags + ",maximumSize=" + string3 + ",minimumSize=" + string2 + ",preferredSize=" + string;
    }

    static {
        tempRectangles = new ArrayList(11);
        aaFontMap = new HashMap<Font, FontMetrics>();
    }

    public abstract class AccessibleJComponent
    extends Container.AccessibleAWTContainer
    implements AccessibleExtendedComponent {
        protected ContainerListener accessibleContainerHandler;
        protected FocusListener accessibleFocusHandler;

        protected AccessibleJComponent() {
            super(JComponent.this);
            this.accessibleContainerHandler = null;
            this.accessibleFocusHandler = null;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.accessibleFocusHandler == null) {
                this.accessibleFocusHandler = new AccessibleFocusHandler();
                JComponent.this.addFocusListener(this.accessibleFocusHandler);
            }
            if (this.accessibleContainerHandler == null) {
                this.accessibleContainerHandler = new AccessibleContainerHandler();
                JComponent.this.addContainerListener(this.accessibleContainerHandler);
            }
            super.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.accessibleFocusHandler != null) {
                JComponent.this.removeFocusListener(this.accessibleFocusHandler);
                this.accessibleFocusHandler = null;
            }
            super.removePropertyChangeListener(propertyChangeListener);
        }

        protected String getBorderTitle(Border border) {
            if (border instanceof TitledBorder) {
                return ((TitledBorder)border).getTitle();
            }
            if (border instanceof CompoundBorder) {
                String string = this.getBorderTitle(((CompoundBorder)border).getInsideBorder());
                if (string == null) {
                    string = this.getBorderTitle(((CompoundBorder)border).getOutsideBorder());
                }
                return string;
            }
            return null;
        }

        public String getAccessibleName() {
            AccessibleContext accessibleContext;
            Object object;
            String string = this.accessibleName;
            if (string == null) {
                string = this.getBorderTitle(JComponent.this.getBorder());
            }
            if (string == null && (object = JComponent.this.getClientProperty("labeledBy")) instanceof Accessible && (accessibleContext = ((Accessible)object).getAccessibleContext()) != null) {
                string = accessibleContext.getAccessibleName();
            }
            return string;
        }

        public String getAccessibleDescription() {
            AccessibleContext accessibleContext;
            Object object;
            String string = this.accessibleDescription;
            if (string == null) {
                try {
                    string = this.getToolTipText();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (string == null && (object = JComponent.this.getClientProperty("labeledBy")) instanceof Accessible && (accessibleContext = ((Accessible)object).getAccessibleContext()) != null) {
                string = accessibleContext.getAccessibleDescription();
            }
            return string;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SWING_COMPONENT;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (JComponent.this.isOpaque()) {
                accessibleStateSet.add(AccessibleState.OPAQUE);
            }
            return accessibleStateSet;
        }

        public int getAccessibleChildrenCount() {
            return super.getAccessibleChildrenCount();
        }

        public Accessible getAccessibleChild(int n2) {
            return super.getAccessibleChild(n2);
        }

        AccessibleExtendedComponent getAccessibleExtendedComponent() {
            return this;
        }

        public String getToolTipText() {
            return null;
        }

        public String getTitledBorderText() {
            Border border = JComponent.this.getBorder();
            if (border instanceof TitledBorder) {
                return ((TitledBorder)border).getTitle();
            }
            return null;
        }

        public AccessibleKeyBinding getAccessibleKeyBinding() {
            return null;
        }

        protected class AccessibleContainerHandler
        implements ContainerListener {
            protected AccessibleContainerHandler() {
            }

            public void componentAdded(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component != null && component instanceof Accessible) {
                    AccessibleJComponent.this.firePropertyChange("AccessibleChild", null, ((Accessible)((Object)component)).getAccessibleContext());
                }
            }

            public void componentRemoved(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component != null && component instanceof Accessible) {
                    AccessibleJComponent.this.firePropertyChange("AccessibleChild", ((Accessible)((Object)component)).getAccessibleContext(), null);
                }
            }
        }

        protected class AccessibleFocusHandler
        implements FocusListener {
            protected AccessibleFocusHandler() {
            }

            public void focusGained(FocusEvent focusEvent) {
                if (JComponent.this.accessibleContext != null) {
                    JComponent.this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
                }
            }

            public void focusLost(FocusEvent focusEvent) {
                if (JComponent.this.accessibleContext != null) {
                    JComponent.this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
                }
            }
        }
    }

    final class ActionStandin
    implements Action {
        private final ActionListener actionListener;
        private final String command;
        private final Action action;

        ActionStandin(ActionListener actionListener, String string) {
            this.actionListener = actionListener;
            this.action = actionListener instanceof Action ? (Action)actionListener : null;
            this.command = string;
        }

        public Object getValue(String string) {
            if (string != null) {
                if (string.equals("ActionCommandKey")) {
                    return this.command;
                }
                if (this.action != null) {
                    return this.action.getValue(string);
                }
                if (string.equals("Name")) {
                    return "ActionStandin";
                }
            }
            return null;
        }

        public boolean isEnabled() {
            if (this.actionListener == null) {
                return false;
            }
            if (this.action == null) {
                return true;
            }
            return this.action.isEnabled();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(actionEvent);
            }
        }

        public void putValue(String string, Object object) {
        }

        public void setEnabled(boolean bl2) {
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }
    }

    static final class IntVector {
        int[] array = null;
        int count = 0;
        int capacity = 0;

        IntVector() {
        }

        int size() {
            return this.count;
        }

        int elementAt(int n2) {
            return this.array[n2];
        }

        void addElement(int n2) {
            if (this.count == this.capacity) {
                this.capacity = (this.capacity + 2) * 2;
                int[] nArray = new int[this.capacity];
                if (this.count > 0) {
                    System.arraycopy(this.array, 0, nArray, 0, this.count);
                }
                this.array = nArray;
            }
            this.array[this.count++] = n2;
        }

        void setElementAt(int n2, int n3) {
            this.array[n3] = n2;
        }
    }

    static class KeyboardState
    implements Serializable {
        private static final Object keyCodesKey = KeyboardState.class;

        KeyboardState() {
        }

        static IntVector getKeyCodeArray() {
            IntVector intVector = (IntVector)SwingUtilities.appContextGet(keyCodesKey);
            if (intVector == null) {
                intVector = new IntVector();
                SwingUtilities.appContextPut(keyCodesKey, intVector);
            }
            return intVector;
        }

        static void registerKeyPressed(int n2) {
            IntVector intVector = KeyboardState.getKeyCodeArray();
            int n3 = intVector.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                if (intVector.elementAt(i2) != -1) continue;
                intVector.setElementAt(n2, i2);
                return;
            }
            intVector.addElement(n2);
        }

        static void registerKeyReleased(int n2) {
            IntVector intVector = KeyboardState.getKeyCodeArray();
            int n3 = intVector.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                if (intVector.elementAt(i2) != n2) continue;
                intVector.setElementAt(-1, i2);
                return;
            }
        }

        static boolean keyIsPressed(int n2) {
            IntVector intVector = KeyboardState.getKeyCodeArray();
            int n3 = intVector.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                if (intVector.elementAt(i2) != n2) continue;
                return true;
            }
            return false;
        }

        static boolean shouldProcess(KeyEvent keyEvent) {
            switch (keyEvent.getID()) {
                case 401: {
                    if (!KeyboardState.keyIsPressed(keyEvent.getKeyCode())) {
                        KeyboardState.registerKeyPressed(keyEvent.getKeyCode());
                    }
                    return true;
                }
                case 402: {
                    if (KeyboardState.keyIsPressed(keyEvent.getKeyCode()) || keyEvent.getKeyCode() == 154) {
                        KeyboardState.registerKeyReleased(keyEvent.getKeyCode());
                        return true;
                    }
                    return false;
                }
                case 400: {
                    return true;
                }
            }
            return false;
        }
    }

    private class ReadObjectCallback
    implements ObjectInputValidation {
        private final Vector roots = new Vector(1);
        private final ObjectInputStream inputStream;

        ReadObjectCallback(ObjectInputStream objectInputStream) throws Exception {
            this.inputStream = objectInputStream;
            objectInputStream.registerValidation(this, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void validateObject() throws InvalidObjectException {
            try {
                for (int i2 = 0; i2 < this.roots.size(); ++i2) {
                    JComponent jComponent = (JComponent)this.roots.elementAt(i2);
                    SwingUtilities.updateComponentTreeUI(jComponent);
                }
            }
            finally {
                readObjectCallbacks.remove(this.inputStream);
            }
        }

        private void registerComponent(JComponent jComponent) {
            Container container;
            JComponent jComponent2;
            int n2;
            for (n2 = 0; n2 < this.roots.size(); ++n2) {
                jComponent2 = (JComponent)this.roots.elementAt(n2);
                for (container = jComponent; container != null; container = container.getParent()) {
                    if (container != jComponent2) continue;
                    return;
                }
            }
            block2: for (n2 = 0; n2 < this.roots.size(); ++n2) {
                jComponent2 = (JComponent)this.roots.elementAt(n2);
                for (container = jComponent2.getParent(); container != null; container = container.getParent()) {
                    if (container != jComponent) continue;
                    this.roots.removeElementAt(n2--);
                    continue block2;
                }
            }
            this.roots.addElement(jComponent);
        }
    }
}

