/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot;

import java.util.HashMap;
import java.util.Map;
import sun.jvm.hotspot.debugger.SymbolLookup;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.basic.BasicVtblAccess;

public class HotSpotSolarisVtblAccess
extends BasicVtblAccess {
    private Map nameMap = new HashMap();

    public HotSpotSolarisVtblAccess(SymbolLookup symbolLookup, String[] jvmLibNames) {
        super(symbolLookup, jvmLibNames);
        this.initialize();
    }

    protected String vtblSymbolForType(Type type) {
        String demangledSymbol = type.getName() + "::__vtbl";
        return (String)this.nameMap.get(demangledSymbol);
    }

    private void addMapping(String symbol, String mangledName) {
        if (this.nameMap.put(symbol, mangledName) != null) {
            throw new RuntimeException("should not have duplicate symbols in the name mangling table");
        }
    }

    private void initialize() {
        this.addMapping("If::__vtbl", "__1cCIfG__vtbl_");
        this.addMapping("Jsr::__vtbl", "__1cDJsrG__vtbl_");
        this.addMapping("Op2::__vtbl", "__1cDOp2G__vtbl_");
        this.addMapping("Phi::__vtbl", "__1cDPhiG__vtbl_");
        this.addMapping("Ret::__vtbl", "__1cDRetG__vtbl_");
        this.addMapping("Set::__vtbl", "__1cDSetG__vtbl_");
        this.addMapping("std::bad_cast::__vtbl", "__1cDstdIbad_castG__vtbl_");
        this.addMapping("std::bad_alloc::__vtbl", "__1cDstdJbad_allocG__vtbl_");
        this.addMapping("std::exception::__vtbl", "__1cDstdJexceptionG__vtbl_");
        this.addMapping("std::type_info::__vtbl", "__1cDstdJtype_infoG__vtbl_");
        this.addMapping("std::bad_typeid::__vtbl", "__1cDstdKbad_typeidG__vtbl_");
        this.addMapping("std::bad_exception::__vtbl", "__1cDstdNbad_exceptionG__vtbl_");
        this.addMapping("Base::__vtbl", "__1cEBaseG__vtbl_");
        this.addMapping("Goto::__vtbl", "__1cEGotoG__vtbl_");
        this.addMapping("IfOp::__vtbl", "__1cEIfOpG__vtbl_");
        this.addMapping("Item::__vtbl", "__1cEItemG__vtbl_");
        this.addMapping("Node::__vtbl", "__1cENodeG__vtbl_");
        this.addMapping("Type::__vtbl", "__1cETypeG__vtbl_");
        this.addMapping("Klass::__vtbl", "__1cFKlassG__vtbl_");
        this.addMapping("Local::__vtbl", "__1cFLocalG__vtbl_");
        this.addMapping("Scope::__vtbl", "__1cFScopeG__vtbl_");
        this.addMapping("SetI_::__vtbl", "__1cFSetI_G__vtbl_");
        this.addMapping("Space::__vtbl", "__1cFSpaceG__vtbl_");
        this.addMapping("Throw::__vtbl", "__1cFThrowG__vtbl_");
        this.addMapping("TypeD::__vtbl", "__1cFTypeDG__vtbl_");
        this.addMapping("TypeF::__vtbl", "__1cFTypeFG__vtbl_");
        this.addMapping("IfNode::__vtbl", "__1cGIfNodeG__vtbl_");
        this.addMapping("Invoke::__vtbl", "__1cGInvokeG__vtbl_");
        this.addMapping("LIR_Op::__vtbl", "__1cGLIR_OpG__vtbl_");
        this.addMapping("RFrame::__vtbl", "__1cGRFrameG__vtbl_");
        this.addMapping("Return::__vtbl", "__1cGReturnG__vtbl_");
        this.addMapping("SetReg::__vtbl", "__1cGSetRegG__vtbl_");
        this.addMapping("Switch::__vtbl", "__1cGSwitchG__vtbl_");
        this.addMapping("Thread::__vtbl", "__1cGThreadG__vtbl_");
        this.addMapping("VSetI_::__vtbl", "__1cGVSetI_G__vtbl_");
        this.addMapping("ciType::__vtbl", "__1cGciTypeG__vtbl_");
        this.addMapping("vframe::__vtbl", "__1cGvframeG__vtbl_");
        this.addMapping("vmNode::__vtbl", "__1cGvmNodeG__vtbl_");
        this.addMapping("AddNode::__vtbl", "__1cHAddNodeG__vtbl_");
        this.addMapping("BitData::__vtbl", "__1cHBitDataG__vtbl_");
        this.addMapping("BoxNode::__vtbl", "__1cHBoxNodeG__vtbl_");
        this.addMapping("ConNode::__vtbl", "__1cHConNodeG__vtbl_");
        this.addMapping("Convert::__vtbl", "__1cHConvertG__vtbl_");
        this.addMapping("Emitter::__vtbl", "__1cHEmitterG__vtbl_");
        this.addMapping("FreeReg::__vtbl", "__1cHFreeRegG__vtbl_");
        this.addMapping("IntType::__vtbl", "__1cHIntTypeG__vtbl_");
        this.addMapping("LIR_Op0::__vtbl", "__1cHLIR_Op0G__vtbl_");
        this.addMapping("LIR_Op1::__vtbl", "__1cHLIR_Op1G__vtbl_");
        this.addMapping("LIR_Op2::__vtbl", "__1cHLIR_Op2G__vtbl_");
        this.addMapping("LIR_Op3::__vtbl", "__1cHLIR_Op3G__vtbl_");
        this.addMapping("LockReg::__vtbl", "__1cHLockRegG__vtbl_");
        this.addMapping("LogicOp::__vtbl", "__1cHLogicOpG__vtbl_");
        this.addMapping("Matcher::__vtbl", "__1cHMatcherG__vtbl_");
        this.addMapping("MemNode::__vtbl", "__1cHMemNodeG__vtbl_");
        this.addMapping("MulNode::__vtbl", "__1cHMulNodeG__vtbl_");
        this.addMapping("OrINode::__vtbl", "__1cHOrINodeG__vtbl_");
        this.addMapping("PhiNode::__vtbl", "__1cHPhiNodeG__vtbl_");
        this.addMapping("RetData::__vtbl", "__1cHRetDataG__vtbl_");
        this.addMapping("RetNode::__vtbl", "__1cHRetNodeG__vtbl_");
        this.addMapping("ShiftOp::__vtbl", "__1cHShiftOpG__vtbl_");
        this.addMapping("SubNode::__vtbl", "__1cHSubNodeG__vtbl_");
        this.addMapping("TypeAry::__vtbl", "__1cHTypeAryG__vtbl_");
        this.addMapping("TypeInt::__vtbl", "__1cHTypeIntG__vtbl_");
        this.addMapping("TypePtr::__vtbl", "__1cHTypePtrG__vtbl_");
        this.addMapping("VM_Exit::__vtbl", "__1cHVM_ExitG__vtbl_");
        this.addMapping("ciArray::__vtbl", "__1cHciArrayG__vtbl_");
        this.addMapping("ciKlass::__vtbl", "__1cHciKlassG__vtbl_");
        this.addMapping("nmethod::__vtbl", "__1cHnmethodG__vtbl_");
        this.addMapping("AbsDNode::__vtbl", "__1cIAbsDNodeG__vtbl_");
        this.addMapping("AbsFNode::__vtbl", "__1cIAbsFNodeG__vtbl_");
        this.addMapping("AbsINode::__vtbl", "__1cIAbsINodeG__vtbl_");
        this.addMapping("AddDNode::__vtbl", "__1cIAddDNodeG__vtbl_");
        this.addMapping("AddFNode::__vtbl", "__1cIAddFNodeG__vtbl_");
        this.addMapping("AddINode::__vtbl", "__1cIAddINodeG__vtbl_");
        this.addMapping("AddPNode::__vtbl", "__1cIAddPNodeG__vtbl_");
        this.addMapping("AndINode::__vtbl", "__1cIAndINodeG__vtbl_");
        this.addMapping("BlockEnd::__vtbl", "__1cIBlockEndG__vtbl_");
        this.addMapping("BoolNode::__vtbl", "__1cIBoolNodeG__vtbl_");
        this.addMapping("CallNode::__vtbl", "__1cICallNodeG__vtbl_");
        this.addMapping("CarSpace::__vtbl", "__1cICarSpaceG__vtbl_");
        this.addMapping("CmpINode::__vtbl", "__1cICmpINodeG__vtbl_");
        this.addMapping("CmpPNode::__vtbl", "__1cICmpPNodeG__vtbl_");
        this.addMapping("CmpUNode::__vtbl", "__1cICmpUNodeG__vtbl_");
        this.addMapping("CodeBlob::__vtbl", "__1cICodeBlobG__vtbl_");
        this.addMapping("CodeStub::__vtbl", "__1cICodeStubG__vtbl_");
        this.addMapping("Compiler::__vtbl", "__1cICompilerG__vtbl_");
        this.addMapping("ConDNode::__vtbl", "__1cIConDNodeG__vtbl_");
        this.addMapping("ConFNode::__vtbl", "__1cIConFNodeG__vtbl_");
        this.addMapping("ConINode::__vtbl", "__1cIConINodeG__vtbl_");
        this.addMapping("ConLNode::__vtbl", "__1cIConLNodeG__vtbl_");
        this.addMapping("ConPNode::__vtbl", "__1cIConPNodeG__vtbl_");
        this.addMapping("Constant::__vtbl", "__1cIConstantG__vtbl_");
        this.addMapping("CopyNode::__vtbl", "__1cICopyNodeG__vtbl_");
        this.addMapping("CosDNode::__vtbl", "__1cICosDNodeG__vtbl_");
        this.addMapping("DivDNode::__vtbl", "__1cIDivDNodeG__vtbl_");
        this.addMapping("DivFNode::__vtbl", "__1cIDivFNodeG__vtbl_");
        this.addMapping("DivINode::__vtbl", "__1cIDivINodeG__vtbl_");
        this.addMapping("GotoNode::__vtbl", "__1cIGotoNodeG__vtbl_");
        this.addMapping("HaltNode::__vtbl", "__1cIHaltNodeG__vtbl_");
        this.addMapping("HintItem::__vtbl", "__1cIHintItemG__vtbl_");
        this.addMapping("JumpData::__vtbl", "__1cIJumpDataG__vtbl_");
        this.addMapping("JumpNode::__vtbl", "__1cIJumpNodeG__vtbl_");
        this.addMapping("LoadNode::__vtbl", "__1cILoadNodeG__vtbl_");
        this.addMapping("LongType::__vtbl", "__1cILongTypeG__vtbl_");
        this.addMapping("LoopExit::__vtbl", "__1cILoopExitG__vtbl_");
        this.addMapping("LoopNode::__vtbl", "__1cILoopNodeG__vtbl_");
        this.addMapping("MachNode::__vtbl", "__1cIMachNodeG__vtbl_");
        this.addMapping("MachOper::__vtbl", "__1cIMachOperG__vtbl_");
        this.addMapping("MathStub::__vtbl", "__1cIMathStubG__vtbl_");
        this.addMapping("MaxDNode::__vtbl", "__1cIMaxDNodeG__vtbl_");
        this.addMapping("MaxFNode::__vtbl", "__1cIMaxFNodeG__vtbl_");
        this.addMapping("MaxINode::__vtbl", "__1cIMaxINodeG__vtbl_");
        this.addMapping("MinDNode::__vtbl", "__1cIMinDNodeG__vtbl_");
        this.addMapping("MinFNode::__vtbl", "__1cIMinFNodeG__vtbl_");
        this.addMapping("MinINode::__vtbl", "__1cIMinINodeG__vtbl_");
        this.addMapping("ModDNode::__vtbl", "__1cIModDNodeG__vtbl_");
        this.addMapping("ModFNode::__vtbl", "__1cIModFNodeG__vtbl_");
        this.addMapping("ModINode::__vtbl", "__1cIModINodeG__vtbl_");
        this.addMapping("MulDNode::__vtbl", "__1cIMulDNodeG__vtbl_");
        this.addMapping("MulFNode::__vtbl", "__1cIMulFNodeG__vtbl_");
        this.addMapping("MulINode::__vtbl", "__1cIMulINodeG__vtbl_");
        this.addMapping("NegDNode::__vtbl", "__1cINegDNodeG__vtbl_");
        this.addMapping("NegFNode::__vtbl", "__1cINegFNodeG__vtbl_");
        this.addMapping("NegateOp::__vtbl", "__1cINegateOpG__vtbl_");
        this.addMapping("NewArray::__vtbl", "__1cINewArrayG__vtbl_");
        this.addMapping("OSThread::InterruptCallback::__vtbl", "__1cIOSThreadRInterruptCallbackG__vtbl_");
        this.addMapping("ParmNode::__vtbl", "__1cIParmNodeG__vtbl_");
        this.addMapping("PhaseCCP::__vtbl", "__1cIPhaseCCPG__vtbl_");
        this.addMapping("PhaseDCE::__vtbl", "__1cIPhaseDCEG__vtbl_");
        this.addMapping("PhaseGVN::__vtbl", "__1cIPhaseGVNG__vtbl_");
        this.addMapping("ProjNode::__vtbl", "__1cIProjNodeG__vtbl_");
        this.addMapping("RootItem::__vtbl", "__1cIRootItemG__vtbl_");
        this.addMapping("RootNode::__vtbl", "__1cIRootNodeG__vtbl_");
        this.addMapping("SinDNode::__vtbl", "__1cISinDNodeG__vtbl_");
        this.addMapping("SubDNode::__vtbl", "__1cISubDNodeG__vtbl_");
        this.addMapping("SubFNode::__vtbl", "__1cISubFNodeG__vtbl_");
        this.addMapping("SubINode::__vtbl", "__1cISubINodeG__vtbl_");
        this.addMapping("TanDNode::__vtbl", "__1cITanDNodeG__vtbl_");
        this.addMapping("TypeFunc::__vtbl", "__1cITypeFuncG__vtbl_");
        this.addMapping("TypeLong::__vtbl", "__1cITypeLongG__vtbl_");
        this.addMapping("TypeNode::__vtbl", "__1cITypeNodeG__vtbl_");
        this.addMapping("VMThread::__vtbl", "__1cIVMThreadG__vtbl_");
        this.addMapping("VM_First::__vtbl", "__1cIVM_FirstG__vtbl_");
        this.addMapping("ValueGen::__vtbl", "__1cIValueGenG__vtbl_");
        this.addMapping("VoidType::__vtbl", "__1cIVoidTypeG__vtbl_");
        this.addMapping("XorINode::__vtbl", "__1cIXorINodeG__vtbl_");
        this.addMapping("ciMethod::__vtbl", "__1cIciMethodG__vtbl_");
        this.addMapping("ciObject::__vtbl", "__1cIciObjectG__vtbl_");
        this.addMapping("ciSymbol::__vtbl", "__1cIciSymbolG__vtbl_");
        this.addMapping("immDOper::__vtbl", "__1cIimmDOperG__vtbl_");
        this.addMapping("immFOper::__vtbl", "__1cIimmFOperG__vtbl_");
        this.addMapping("immIOper::__vtbl", "__1cIimmIOperG__vtbl_");
        this.addMapping("immPOper::__vtbl", "__1cIimmPOperG__vtbl_");
        this.addMapping("regDOper::__vtbl", "__1cIregDOperG__vtbl_");
        this.addMapping("regFOper::__vtbl", "__1cIregFOperG__vtbl_");
        this.addMapping("stubNode::__vtbl", "__1cIstubNodeG__vtbl_");
        this.addMapping("ArrayType::__vtbl", "__1cJArrayTypeG__vtbl_");
        this.addMapping("AtanDNode::__vtbl", "__1cJAtanDNodeG__vtbl_");
        this.addMapping("CProjNode::__vtbl", "__1cJCProjNodeG__vtbl_");
        this.addMapping("CatchNode::__vtbl", "__1cJCatchNodeG__vtbl_");
        this.addMapping("CheckCast::__vtbl", "__1cJCheckCastG__vtbl_");
        this.addMapping("ClassType::__vtbl", "__1cJClassTypeG__vtbl_");
        this.addMapping("CompareOp::__vtbl", "__1cJCompareOpG__vtbl_");
        this.addMapping("CopyDNode::__vtbl", "__1cJCopyDNodeG__vtbl_");
        this.addMapping("CopyFNode::__vtbl", "__1cJCopyFNodeG__vtbl_");
        this.addMapping("CopyINode::__vtbl", "__1cJCopyINodeG__vtbl_");
        this.addMapping("CopyLNode::__vtbl", "__1cJCopyLNodeG__vtbl_");
        this.addMapping("CopyPNode::__vtbl", "__1cJCopyPNodeG__vtbl_");
        this.addMapping("EdenSpace::__vtbl", "__1cJEdenSpaceG__vtbl_");
        this.addMapping("FloatType::__vtbl", "__1cJFloatTypeG__vtbl_");
        this.addMapping("Intrinsic::__vtbl", "__1cJIntrinsicG__vtbl_");
        this.addMapping("IsFreeReg::__vtbl", "__1cJIsFreeRegG__vtbl_");
        this.addMapping("LIR_Const::__vtbl", "__1cJLIR_ConstG__vtbl_");
        this.addMapping("LIR_OpJsr::__vtbl", "__1cJLIR_OpJsrG__vtbl_");
        this.addMapping("LoadBNode::__vtbl", "__1cJLoadBNodeG__vtbl_");
        this.addMapping("LoadCNode::__vtbl", "__1cJLoadCNodeG__vtbl_");
        this.addMapping("LoadDNode::__vtbl", "__1cJLoadDNodeG__vtbl_");
        this.addMapping("LoadFNode::__vtbl", "__1cJLoadFNodeG__vtbl_");
        this.addMapping("LoadField::__vtbl", "__1cJLoadFieldG__vtbl_");
        this.addMapping("LoadINode::__vtbl", "__1cJLoadINodeG__vtbl_");
        this.addMapping("LoadLNode::__vtbl", "__1cJLoadLNodeG__vtbl_");
        this.addMapping("LoadLocal::__vtbl", "__1cJLoadLocalG__vtbl_");
        this.addMapping("LoadPNode::__vtbl", "__1cJLoadPNodeG__vtbl_");
        this.addMapping("LoadSNode::__vtbl", "__1cJLoadSNodeG__vtbl_");
        this.addMapping("LoopEnter::__vtbl", "__1cJLoopEnterG__vtbl_");
        this.addMapping("MarkSweep::IsAliveClosure::__vtbl", "__1cJMarkSweepOIsAliveClosureG__vtbl_");
        this.addMapping("MarkSweep::KeepAliveClosure::__vtbl", "__1cJMarkSweepQKeepAliveClosureG__vtbl_");
        this.addMapping("MarkSweep::FollowRootClosure::__vtbl", "__1cJMarkSweepRFollowRootClosureG__vtbl_");
        this.addMapping("MarkSweep::FollowStackClosure::__vtbl", "__1cJMarkSweepSFollowStackClosureG__vtbl_");
        this.addMapping("MarkSweep::MarkAndPushClosure::__vtbl", "__1cJMarkSweepSMarkAndPushClosureG__vtbl_");
        this.addMapping("MarkSweep::AdjustPointerClosure::__vtbl", "__1cJMarkSweepUAdjustPointerClosureG__vtbl_");
        this.addMapping("MultiNode::__vtbl", "__1cJMultiNodeG__vtbl_");
        this.addMapping("NullCheck::__vtbl", "__1cJNullCheckG__vtbl_");
        this.addMapping("PackINode::__vtbl", "__1cJPackINodeG__vtbl_");
        this.addMapping("RInfo2Reg::__vtbl", "__1cJRInfo2RegG__vtbl_");
        this.addMapping("SqrtDNode::__vtbl", "__1cJSqrtDNodeG__vtbl_");
        this.addMapping("StartNode::__vtbl", "__1cJStartNodeG__vtbl_");
        this.addMapping("StoreNode::__vtbl", "__1cJStoreNodeG__vtbl_");
        this.addMapping("SubFPNode::__vtbl", "__1cJSubFPNodeG__vtbl_");
        this.addMapping("TypeCheck::__vtbl", "__1cJTypeCheckG__vtbl_");
        this.addMapping("TypeTuple::__vtbl", "__1cJTypeTupleG__vtbl_");
        this.addMapping("VectorSet::__vtbl", "__1cJVectorSetG__vtbl_");
        this.addMapping("cCodeOper::__vtbl", "__1cJcCodeOperG__vtbl_");
        this.addMapping("ccRegOper::__vtbl", "__1cJccRegOperG__vtbl_");
        this.addMapping("iRegIOper::__vtbl", "__1cJiRegIOperG__vtbl_");
        this.addMapping("iRegPOper::__vtbl", "__1cJiRegPOperG__vtbl_");
        this.addMapping("immD0Oper::__vtbl", "__1cJimmD0OperG__vtbl_");
        this.addMapping("immF0Oper::__vtbl", "__1cJimmF0OperG__vtbl_");
        this.addMapping("immI0Oper::__vtbl", "__1cJimmI0OperG__vtbl_");
        this.addMapping("immP0Oper::__vtbl", "__1cJimmP0OperG__vtbl_");
        this.addMapping("labelOper::__vtbl", "__1cJlabelOperG__vtbl_");
        this.addMapping("ldSSINode::__vtbl", "__1cJldSSINodeG__vtbl_");
        this.addMapping("loadBNode::__vtbl", "__1cJloadBNodeG__vtbl_");
        this.addMapping("loadCNode::__vtbl", "__1cJloadCNodeG__vtbl_");
        this.addMapping("loadDNode::__vtbl", "__1cJloadDNodeG__vtbl_");
        this.addMapping("loadFNode::__vtbl", "__1cJloadFNodeG__vtbl_");
        this.addMapping("loadINode::__vtbl", "__1cJloadINodeG__vtbl_");
        this.addMapping("loadPNode::__vtbl", "__1cJloadPNodeG__vtbl_");
        this.addMapping("loadSNode::__vtbl", "__1cJloadSNodeG__vtbl_");
        this.addMapping("moveDNode::__vtbl", "__1cJmoveDNodeG__vtbl_");
        this.addMapping("moveFNode::__vtbl", "__1cJmoveFNodeG__vtbl_");
        this.addMapping("moveINode::__vtbl", "__1cJmoveINodeG__vtbl_");
        this.addMapping("movePNode::__vtbl", "__1cJmovePNodeG__vtbl_");
        this.addMapping("sRegDOper::__vtbl", "__1cJsRegDOperG__vtbl_");
        this.addMapping("sRegFOper::__vtbl", "__1cJsRegFOperG__vtbl_");
        this.addMapping("sRegIOper::__vtbl", "__1cJsRegIOperG__vtbl_");
        this.addMapping("sRegLOper::__vtbl", "__1cJsRegLOperG__vtbl_");
        this.addMapping("sRegPOper::__vtbl", "__1cJsRegPOperG__vtbl_");
        this.addMapping("stSSINode::__vtbl", "__1cJstSSINodeG__vtbl_");
        this.addMapping("AccessLoop::__vtbl", "__1cKAccessLoopG__vtbl_");
        this.addMapping("BarrierSet::__vtbl", "__1cKBarrierSetG__vtbl_");
        this.addMapping("BlockBegin::__vtbl", "__1cKBlockBeginG__vtbl_");
        this.addMapping("BranchData::__vtbl", "__1cKBranchDataG__vtbl_");
        this.addMapping("BufferBlob::__vtbl", "__1cKBufferBlobG__vtbl_");
        this.addMapping("C2Compiler::__vtbl", "__1cKC2CompilerG__vtbl_");
        this.addMapping("C2IAdapter::__vtbl", "__1cKC2IAdapterG__vtbl_");
        this.addMapping("CastIPNode::__vtbl", "__1cKCastIPNodeG__vtbl_");
        this.addMapping("CastPINode::__vtbl", "__1cKCastPINodeG__vtbl_");
        this.addMapping("CastPPNode::__vtbl", "__1cKCastPPNodeG__vtbl_");
        this.addMapping("ChangeItem::__vtbl", "__1cKChangeItemG__vtbl_");
        this.addMapping("Conv2BNode::__vtbl", "__1cKConv2BNodeG__vtbl_");
        this.addMapping("DoubleType::__vtbl", "__1cKDoubleTypeG__vtbl_");
        this.addMapping("Generation::__vtbl", "__1cKGenerationG__vtbl_");
        this.addMapping("HeapDumper::__vtbl", "__1cKHeapDumperG__vtbl_");
        this.addMapping("I2CAdapter::__vtbl", "__1cKI2CAdapterG__vtbl_");
        this.addMapping("ICacheStub::__vtbl", "__1cKICacheStubG__vtbl_");
        this.addMapping("IfTrueNode::__vtbl", "__1cKIfTrueNodeG__vtbl_");
        this.addMapping("InstanceOf::__vtbl", "__1cKInstanceOfG__vtbl_");
        this.addMapping("JavaThread::__vtbl", "__1cKJavaThreadG__vtbl_");
        this.addMapping("JvmdiEvent::__vtbl", "__1cKJvmdiEventG__vtbl_");
        this.addMapping("LIR_Op2Tmp::__vtbl", "__1cKLIR_Op2TmpG__vtbl_");
        this.addMapping("LIR_OpLock::__vtbl", "__1cKLIR_OpLockG__vtbl_");
        this.addMapping("LoadPCNode::__vtbl", "__1cKLoadPCNodeG__vtbl_");
        this.addMapping("MemBarNode::__vtbl", "__1cKMemBarNodeG__vtbl_");
        this.addMapping("OSRAdapter::__vtbl", "__1cKOSRAdapterG__vtbl_");
        this.addMapping("ObjectType::__vtbl", "__1cKObjectTypeG__vtbl_");
        this.addMapping("OpaqueNode::__vtbl", "__1cKOpaqueNodeG__vtbl_");
        this.addMapping("Recompilee::__vtbl", "__1cKRecompileeG__vtbl_");
        this.addMapping("RegionNode::__vtbl", "__1cKRegionNodeG__vtbl_");
        this.addMapping("Relocation::__vtbl", "__1cKRelocationG__vtbl_");
        this.addMapping("ReturnNode::__vtbl", "__1cKReturnNodeG__vtbl_");
        this.addMapping("StateSplit::__vtbl", "__1cKStateSplitG__vtbl_");
        this.addMapping("StoreBNode::__vtbl", "__1cKStoreBNodeG__vtbl_");
        this.addMapping("StoreCNode::__vtbl", "__1cKStoreCNodeG__vtbl_");
        this.addMapping("StoreDNode::__vtbl", "__1cKStoreDNodeG__vtbl_");
        this.addMapping("StoreFNode::__vtbl", "__1cKStoreFNodeG__vtbl_");
        this.addMapping("StoreField::__vtbl", "__1cKStoreFieldG__vtbl_");
        this.addMapping("StoreINode::__vtbl", "__1cKStoreINodeG__vtbl_");
        this.addMapping("StoreLNode::__vtbl", "__1cKStoreLNodeG__vtbl_");
        this.addMapping("StoreLocal::__vtbl", "__1cKStoreLocalG__vtbl_");
        this.addMapping("StorePNode::__vtbl", "__1cKStorePNodeG__vtbl_");
        this.addMapping("TypeAryPtr::__vtbl", "__1cKTypeAryPtrG__vtbl_");
        this.addMapping("TypeOopPtr::__vtbl", "__1cKTypeOopPtrG__vtbl_");
        this.addMapping("TypeRawPtr::__vtbl", "__1cKTypeRawPtrG__vtbl_");
        this.addMapping("UMulHiNode::__vtbl", "__1cKUMulHiNodeG__vtbl_");
        this.addMapping("UMulLoNode::__vtbl", "__1cKUMulLoNodeG__vtbl_");
        this.addMapping("addTLSNode::__vtbl", "__1cKaddTLSNodeG__vtbl_");
        this.addMapping("arrayKlass::__vtbl", "__1cKarrayKlassG__vtbl_");
        this.addMapping("cCodeUOper::__vtbl", "__1cKcCodeUOperG__vtbl_");
        this.addMapping("castPPNode::__vtbl", "__1cKcastPPNodeG__vtbl_");
        this.addMapping("ccRegUOper::__vtbl", "__1cKccRegUOperG__vtbl_");
        this.addMapping("ciInstance::__vtbl", "__1cKciInstanceG__vtbl_");
        this.addMapping("ciObjArray::__vtbl", "__1cKciObjArrayG__vtbl_");
        this.addMapping("fileStream::__vtbl", "__1cKfileStreamG__vtbl_");
        this.addMapping("g1RegIOper::__vtbl", "__1cKg1RegIOperG__vtbl_");
        this.addMapping("g1RegPOper::__vtbl", "__1cKg1RegPOperG__vtbl_");
        this.addMapping("g2RegPOper::__vtbl", "__1cKg2RegPOperG__vtbl_");
        this.addMapping("g3RegIOper::__vtbl", "__1cKg3RegIOperG__vtbl_");
        this.addMapping("g3RegPOper::__vtbl", "__1cKg3RegPOperG__vtbl_");
        this.addMapping("g4RegPOper::__vtbl", "__1cKg4RegPOperG__vtbl_");
        this.addMapping("g5RegPOper::__vtbl", "__1cKg5RegPOperG__vtbl_");
        this.addMapping("i0RegPOper::__vtbl", "__1cKi0RegPOperG__vtbl_");
        this.addMapping("immI13Oper::__vtbl", "__1cKimmI13OperG__vtbl_");
        this.addMapping("immP13Oper::__vtbl", "__1cKimmP13OperG__vtbl_");
        this.addMapping("immU13Oper::__vtbl", "__1cKimmU13OperG__vtbl_");
        this.addMapping("klassKlass::__vtbl", "__1cKklassKlassG__vtbl_");
        this.addMapping("l7RegIOper::__vtbl", "__1cKl7RegIOperG__vtbl_");
        this.addMapping("l7RegPOper::__vtbl", "__1cKl7RegPOperG__vtbl_");
        this.addMapping("ldfSSDNode::__vtbl", "__1cKldfSSDNodeG__vtbl_");
        this.addMapping("ldfSSINode::__vtbl", "__1cKldfSSINodeG__vtbl_");
        this.addMapping("loadUBNode::__vtbl", "__1cKloadUBNodeG__vtbl_");
        this.addMapping("membarNode::__vtbl", "__1cKmembarNodeG__vtbl_");
        this.addMapping("moveIPNode::__vtbl", "__1cKmoveIPNodeG__vtbl_");
        this.addMapping("o0RegIOper::__vtbl", "__1cKo0RegIOperG__vtbl_");
        this.addMapping("o0RegPOper::__vtbl", "__1cKo0RegPOperG__vtbl_");
        this.addMapping("o1RegIOper::__vtbl", "__1cKo1RegIOperG__vtbl_");
        this.addMapping("o1RegPOper::__vtbl", "__1cKo1RegPOperG__vtbl_");
        this.addMapping("o2RegPOper::__vtbl", "__1cKo2RegPOperG__vtbl_");
        this.addMapping("o7RegIOper::__vtbl", "__1cKo7RegIOperG__vtbl_");
        this.addMapping("setHiFNode::__vtbl", "__1cKsetHiFNodeG__vtbl_");
        this.addMapping("setHiINode::__vtbl", "__1cKsetHiINodeG__vtbl_");
        this.addMapping("setLoFNode::__vtbl", "__1cKsetLoFNodeG__vtbl_");
        this.addMapping("setLoINode::__vtbl", "__1cKsetLoINodeG__vtbl_");
        this.addMapping("stfSSDNode::__vtbl", "__1cKstfSSDNodeG__vtbl_");
        this.addMapping("stfSSINode::__vtbl", "__1cKstfSSINodeG__vtbl_");
        this.addMapping("storeBNode::__vtbl", "__1cKstoreBNodeG__vtbl_");
        this.addMapping("storeCNode::__vtbl", "__1cKstoreCNodeG__vtbl_");
        this.addMapping("storeDNode::__vtbl", "__1cKstoreDNodeG__vtbl_");
        this.addMapping("storeFNode::__vtbl", "__1cKstoreFNodeG__vtbl_");
        this.addMapping("storeINode::__vtbl", "__1cKstoreINodeG__vtbl_");
        this.addMapping("storePNode::__vtbl", "__1cKstorePNodeG__vtbl_");
        this.addMapping("AccessArray::__vtbl", "__1cLAccessArrayG__vtbl_");
        this.addMapping("AccessField::__vtbl", "__1cLAccessFieldG__vtbl_");
        this.addMapping("AccessLocal::__vtbl", "__1cLAccessLocalG__vtbl_");
        this.addMapping("AddressType::__vtbl", "__1cLAddressTypeG__vtbl_");
        this.addMapping("ArrayLength::__vtbl", "__1cLArrayLengthG__vtbl_");
        this.addMapping("BlockMerger::__vtbl", "__1cLBlockMergerG__vtbl_");
        this.addMapping("BoxLockNode::__vtbl", "__1cLBoxLockNodeG__vtbl_");
        this.addMapping("ChangeWiden::__vtbl", "__1cLChangeWidenG__vtbl_");
        this.addMapping("CodeEmitter::__vtbl", "__1cLCodeEmitterG__vtbl_");
        this.addMapping("ConvD2FNode::__vtbl", "__1cLConvD2FNodeG__vtbl_");
        this.addMapping("ConvD2INode::__vtbl", "__1cLConvD2INodeG__vtbl_");
        this.addMapping("ConvF2DNode::__vtbl", "__1cLConvF2DNodeG__vtbl_");
        this.addMapping("ConvF2INode::__vtbl", "__1cLConvF2INodeG__vtbl_");
        this.addMapping("ConvF2PNode::__vtbl", "__1cLConvF2PNodeG__vtbl_");
        this.addMapping("ConvI2DNode::__vtbl", "__1cLConvI2DNodeG__vtbl_");
        this.addMapping("ConvI2FNode::__vtbl", "__1cLConvI2FNodeG__vtbl_");
        this.addMapping("ConvI2PNode::__vtbl", "__1cLConvI2PNodeG__vtbl_");
        this.addMapping("CounterData::__vtbl", "__1cLCounterDataG__vtbl_");
        this.addMapping("FieldDumper::__vtbl", "__1cLFieldDumperG__vtbl_");
        this.addMapping("FieldStream::__vtbl", "__1cLFieldStreamG__vtbl_");
        this.addMapping("GetRefCount::__vtbl", "__1cLGetRefCountG__vtbl_");
        this.addMapping("GetValueFor::__vtbl", "__1cLGetValueForG__vtbl_");
        this.addMapping("IfFalseNode::__vtbl", "__1cLIfFalseNodeG__vtbl_");
        this.addMapping("IllegalType::__vtbl", "__1cLIllegalTypeG__vtbl_");
        this.addMapping("Instruction::__vtbl", "__1cLInstructionG__vtbl_");
        this.addMapping("IntConstant::__vtbl", "__1cLIntConstantG__vtbl_");
        this.addMapping("KlassStream::__vtbl", "__1cLKlassStreamG__vtbl_");
        this.addMapping("LIR_Address::__vtbl", "__1cLLIR_AddressG__vtbl_");
        this.addMapping("LIR_CodeGen::__vtbl", "__1cLLIR_CodeGenG__vtbl_");
        this.addMapping("LIR_Emitter::__vtbl", "__1cLLIR_EmitterG__vtbl_");
        this.addMapping("LShiftINode::__vtbl", "__1cLLShiftINodeG__vtbl_");
        this.addMapping("LoadIndexed::__vtbl", "__1cLLoadIndexedG__vtbl_");
        this.addMapping("MachNopNode::__vtbl", "__1cLMachNopNodeG__vtbl_");
        this.addMapping("MachUEPNode::__vtbl", "__1cLMachUEPNodeG__vtbl_");
        this.addMapping("MemMoveNode::__vtbl", "__1cLMemMoveNodeG__vtbl_");
        this.addMapping("MonitorExit::__vtbl", "__1cLMonitorExitG__vtbl_");
        this.addMapping("NewInstance::__vtbl", "__1cLNewInstanceG__vtbl_");
        this.addMapping("PCTableNode::__vtbl", "__1cLPCTableNodeG__vtbl_");
        this.addMapping("PhaseValues::__vtbl", "__1cLPhaseValuesG__vtbl_");
        this.addMapping("ProfileData::__vtbl", "__1cLProfileDataG__vtbl_");
        this.addMapping("RShiftINode::__vtbl", "__1cLRShiftINodeG__vtbl_");
        this.addMapping("RethrowNode::__vtbl", "__1cLRethrowNodeG__vtbl_");
        this.addMapping("RuntimeStub::__vtbl", "__1cLRuntimeStubG__vtbl_");
        this.addMapping("ScanClosure::__vtbl", "__1cLScanClosureG__vtbl_");
        this.addMapping("StrCompNode::__vtbl", "__1cLStrCompNodeG__vtbl_");
        this.addMapping("TableSwitch::__vtbl", "__1cLTableSwitchG__vtbl_");
        this.addMapping("TypeInstPtr::__vtbl", "__1cLTypeInstPtrG__vtbl_");
        this.addMapping("adapterNode::__vtbl", "__1cLadapterNodeG__vtbl_");
        this.addMapping("cCodeFGOper::__vtbl", "__1cLcCodeFGOperG__vtbl_");
        this.addMapping("cCodeFLOper::__vtbl", "__1cLcCodeFLOperG__vtbl_");
        this.addMapping("ccRegFGOper::__vtbl", "__1cLccRegFGOperG__vtbl_");
        this.addMapping("ccRegFLOper::__vtbl", "__1cLccRegFLOperG__vtbl_");
        this.addMapping("ciTypeArray::__vtbl", "__1cLciTypeArrayG__vtbl_");
        this.addMapping("cmpZeroNode::__vtbl", "__1cLcmpZeroNodeG__vtbl_");
        this.addMapping("convI2BNode::__vtbl", "__1cLconvI2BNodeG__vtbl_");
        this.addMapping("convP2BNode::__vtbl", "__1cLconvP2BNodeG__vtbl_");
        this.addMapping("entryVFrame::__vtbl", "__1cLentryVFrameG__vtbl_");
        this.addMapping("f30RegFOper::__vtbl", "__1cLf30RegFOperG__vtbl_");
        this.addMapping("memmoveNode::__vtbl", "__1cLmemmoveNodeG__vtbl_");
        this.addMapping("methodKlass::__vtbl", "__1cLmethodKlassG__vtbl_");
        this.addMapping("moveD0INode::__vtbl", "__1cLmoveD0INodeG__vtbl_");
        this.addMapping("moveD1INode::__vtbl", "__1cLmoveD1INodeG__vtbl_");
        this.addMapping("storeB0Node::__vtbl", "__1cLstoreB0NodeG__vtbl_");
        this.addMapping("storeC0Node::__vtbl", "__1cLstoreC0NodeG__vtbl_");
        this.addMapping("storeD0Node::__vtbl", "__1cLstoreD0NodeG__vtbl_");
        this.addMapping("storeF0Node::__vtbl", "__1cLstoreF0NodeG__vtbl_");
        this.addMapping("storeI0Node::__vtbl", "__1cLstoreI0NodeG__vtbl_");
        this.addMapping("storeP0Node::__vtbl", "__1cLstoreP0NodeG__vtbl_");
        this.addMapping("symbolKlass::__vtbl", "__1cLsymbolKlassG__vtbl_");
        this.addMapping("AddI_cinNode::__vtbl", "__1cMAddI_cinNodeG__vtbl_");
        this.addMapping("ArithmeticOp::__vtbl", "__1cMArithmeticOpG__vtbl_");
        this.addMapping("BasicAdapter::__vtbl", "__1cMBasicAdapterG__vtbl_");
        this.addMapping("CallJavaNode::__vtbl", "__1cMCallJavaNodeG__vtbl_");
        this.addMapping("CallLeafNode::__vtbl", "__1cMCallLeafNodeG__vtbl_");
        this.addMapping("CmpDLessNode::__vtbl", "__1cMCmpDLessNodeG__vtbl_");
        this.addMapping("CmpFLessNode::__vtbl", "__1cMCmpFLessNodeG__vtbl_");
        this.addMapping("CountObjects::__vtbl", "__1cMCountObjectsG__vtbl_");
        this.addMapping("CreateExNode::__vtbl", "__1cMCreateExNodeG__vtbl_");
        this.addMapping("FastLockNode::__vtbl", "__1cMFastLockNodeG__vtbl_");
        this.addMapping("IfInstanceOf::__vtbl", "__1cMIfInstanceOfG__vtbl_");
        this.addMapping("InstanceType::__vtbl", "__1cMInstanceTypeG__vtbl_");
        this.addMapping("JvmdiEventVm::__vtbl", "__1cMJvmdiEventVmG__vtbl_");
        this.addMapping("LIR_OpBranch::__vtbl", "__1cMLIR_OpBranchG__vtbl_");
        this.addMapping("LIR_OpRTCall::__vtbl", "__1cMLIR_OpRTCallG__vtbl_");
        this.addMapping("LongConstant::__vtbl", "__1cMLongConstantG__vtbl_");
        this.addMapping("LookupSwitch::__vtbl", "__1cMLookupSwitchG__vtbl_");
        this.addMapping("MachCallNode::__vtbl", "__1cMMachCallNodeG__vtbl_");
        this.addMapping("MachHaltNode::__vtbl", "__1cMMachHaltNodeG__vtbl_");
        this.addMapping("MachProjNode::__vtbl", "__1cMMachProjNodeG__vtbl_");
        this.addMapping("MergeMemNode::__vtbl", "__1cMMergeMemNodeG__vtbl_");
        this.addMapping("MethodStream::__vtbl", "__1cMMethodStreamG__vtbl_");
        this.addMapping("MonitorEnter::__vtbl", "__1cMMonitorEnterG__vtbl_");
        this.addMapping("NewTypeArray::__vtbl", "__1cMNewTypeArrayG__vtbl_");
        this.addMapping("PatchingStub::__vtbl", "__1cMPatchingStubG__vtbl_");
        this.addMapping("PeriodicTask::__vtbl", "__1cMPeriodicTaskG__vtbl_");
        this.addMapping("PhaseCCP_DCE::__vtbl", "__1cMPhaseCCP_DCEG__vtbl_");
        this.addMapping("PhaseChaitin::__vtbl", "__1cMPhaseChaitinG__vtbl_");
        this.addMapping("PhaseIterGVN::__vtbl", "__1cMPhaseIterGVNG__vtbl_");
        this.addMapping("ProfilerNode::__vtbl", "__1cMProfilerNodeG__vtbl_");
        this.addMapping("ScopeClosure::__vtbl", "__1cMScopeClosureG__vtbl_");
        this.addMapping("StartC2INode::__vtbl", "__1cMStartC2INodeG__vtbl_");
        this.addMapping("StartI2CNode::__vtbl", "__1cMStartI2CNodeG__vtbl_");
        this.addMapping("StartOSRNode::__vtbl", "__1cMStartOSRNodeG__vtbl_");
        this.addMapping("StoreIndexed::__vtbl", "__1cMStoreIndexedG__vtbl_");
        this.addMapping("SubI_binNode::__vtbl", "__1cMSubI_binNodeG__vtbl_");
        this.addMapping("TailCallNode::__vtbl", "__1cMTailCallNodeG__vtbl_");
        this.addMapping("TailJumpNode::__vtbl", "__1cMTailJumpNodeG__vtbl_");
        this.addMapping("TenuredSpace::__vtbl", "__1cMTenuredSpaceG__vtbl_");
        this.addMapping("TypeKlassPtr::__vtbl", "__1cMTypeKlassPtrG__vtbl_");
        this.addMapping("URShiftINode::__vtbl", "__1cMURShiftINodeG__vtbl_");
        this.addMapping("URShiftLNode::__vtbl", "__1cMURShiftLNodeG__vtbl_");
        this.addMapping("UniverseOper::__vtbl", "__1cMUniverseOperG__vtbl_");
        this.addMapping("VM_Operation::__vtbl", "__1cMVM_OperationG__vtbl_");
        this.addMapping("absD_regNode::__vtbl", "__1cMabsD_regNodeG__vtbl_");
        this.addMapping("absF_regNode::__vtbl", "__1cMabsF_regNodeG__vtbl_");
        this.addMapping("branchV8Node::__vtbl", "__1cMbranchV8NodeG__vtbl_");
        this.addMapping("branchV9Node::__vtbl", "__1cMbranchV9NodeG__vtbl_");
        this.addMapping("ciArrayKlass::__vtbl", "__1cMciArrayKlassG__vtbl_");
        this.addMapping("ciKlassKlass::__vtbl", "__1cMciKlassKlassG__vtbl_");
        this.addMapping("ciNullObject::__vtbl", "__1cMciNullObjectG__vtbl_");
        this.addMapping("compiledNode::__vtbl", "__1cMcompiledNodeG__vtbl_");
        this.addMapping("immI_255Oper::__vtbl", "__1cMimmI_255OperG__vtbl_");
        this.addMapping("indIndexOper::__vtbl", "__1cMindIndexOperG__vtbl_");
        this.addMapping("indirectOper::__vtbl", "__1cMindirectOperG__vtbl_");
        this.addMapping("loadConDNode::__vtbl", "__1cMloadConDNodeG__vtbl_");
        this.addMapping("loadConINode::__vtbl", "__1cMloadConINodeG__vtbl_");
        this.addMapping("loadConPNode::__vtbl", "__1cMloadConPNodeG__vtbl_");
        this.addMapping("negD_regNode::__vtbl", "__1cMnegD_regNodeG__vtbl_");
        this.addMapping("negF_regNode::__vtbl", "__1cMnegF_regNodeG__vtbl_");
        this.addMapping("outputStream::__vtbl", "__1cMoutputStreamG__vtbl_");
        this.addMapping("salL_immNode::__vtbl", "__1cMsalL_immNodeG__vtbl_");
        this.addMapping("sarR_immNode::__vtbl", "__1cMsarR_immNodeG__vtbl_");
        this.addMapping("sarR_regNode::__vtbl", "__1cMsarR_regNodeG__vtbl_");
        this.addMapping("setCarryNode::__vtbl", "__1cMsetCarryNodeG__vtbl_");
        this.addMapping("stringStream::__vtbl", "__1cMstringStreamG__vtbl_");
        this.addMapping("tlsLoadPNode::__vtbl", "__1cMtlsLoadPNodeG__vtbl_");
        this.addMapping("AccessIndexed::__vtbl", "__1cNAccessIndexedG__vtbl_");
        this.addMapping("AccessMonitor::__vtbl", "__1cNAccessMonitorG__vtbl_");
        this.addMapping("AddI_coutNode::__vtbl", "__1cNAddI_coutNodeG__vtbl_");
        this.addMapping("ArgumentCount::__vtbl", "__1cNArgumentCountG__vtbl_");
        this.addMapping("ArrayConstant::__vtbl", "__1cNArrayConstantG__vtbl_");
        this.addMapping("ArrayCopyStub::__vtbl", "__1cNArrayCopyStubG__vtbl_");
        this.addMapping("AtomicAddNode::__vtbl", "__1cNAtomicAddNodeG__vtbl_");
        this.addMapping("CE_Eliminator::__vtbl", "__1cNCE_EliminatorG__vtbl_");
        this.addMapping("CallGenerator::__vtbl", "__1cNCallGeneratorG__vtbl_");
        this.addMapping("Canonicalizer::__vtbl", "__1cNCanonicalizerG__vtbl_");
        this.addMapping("CatchProjNode::__vtbl", "__1cNCatchProjNodeG__vtbl_");
        this.addMapping("CheckCastStub::__vtbl", "__1cNCheckCastStubG__vtbl_");
        this.addMapping("CheckTypeNode::__vtbl", "__1cNCheckTypeNodeG__vtbl_");
        this.addMapping("ClassConstant::__vtbl", "__1cNClassConstantG__vtbl_");
        this.addMapping("CmpLTMaskNode::__vtbl", "__1cNCmpLTMaskNodeG__vtbl_");
        this.addMapping("CodeGenerator::__vtbl", "__1cNCodeGeneratorG__vtbl_");
        this.addMapping("CollectedHeap::__vtbl", "__1cNCollectedHeapG__vtbl_");
        this.addMapping("DivByZeroStub::__vtbl", "__1cNDivByZeroStubG__vtbl_");
        this.addMapping("ExceptionBlob::__vtbl", "__1cNExceptionBlobG__vtbl_");
        this.addMapping("Fingerprinter::__vtbl", "__1cNFingerprinterG__vtbl_");
        this.addMapping("FloatConstant::__vtbl", "__1cNFloatConstantG__vtbl_");
        this.addMapping("IsSpillLocked::__vtbl", "__1cNIsSpillLockedG__vtbl_");
        this.addMapping("JvmdiFramePop::__vtbl", "__1cNJvmdiFramePopG__vtbl_");
        this.addMapping("LIR_ArrayCopy::__vtbl", "__1cNLIR_ArrayCopyG__vtbl_");
        this.addMapping("LIR_OpConvert::__vtbl", "__1cNLIR_OpConvertG__vtbl_");
        this.addMapping("LoadKlassNode::__vtbl", "__1cNLoadKlassNodeG__vtbl_");
        this.addMapping("LoadRangeNode::__vtbl", "__1cNLoadRangeNodeG__vtbl_");
        this.addMapping("LocationValue::__vtbl", "__1cNLocationValueG__vtbl_");
        this.addMapping("MethodClosure::__vtbl", "__1cNMethodClosureG__vtbl_");
        this.addMapping("NewMultiArray::__vtbl", "__1cNNewMultiArrayG__vtbl_");
        this.addMapping("PhaseCoalesce::__vtbl", "__1cNPhaseCoalesceG__vtbl_");
        this.addMapping("PhasePeephole::__vtbl", "__1cNPhasePeepholeG__vtbl_");
        this.addMapping("PhaseRegAlloc::__vtbl", "__1cNPhaseRegAllocG__vtbl_");
        this.addMapping("RelocCallback::__vtbl", "__1cNRelocCallbackG__vtbl_");
        this.addMapping("RootCollector::F::__vtbl", "__1cNRootCollectorBFG__vtbl_");
        this.addMapping("SafePointNode::__vtbl", "__1cNSafePointNodeG__vtbl_");
        this.addMapping("SafepointBlob::__vtbl", "__1cNSafepointBlobG__vtbl_");
        this.addMapping("ScopeIterator::__vtbl", "__1cNScopeIteratorG__vtbl_");
        this.addMapping("SignatureInfo::__vtbl", "__1cNSignatureInfoG__vtbl_");
        this.addMapping("SpillCopyNode::__vtbl", "__1cNSpillCopyNodeG__vtbl_");
        this.addMapping("StubAssembler::__vtbl", "__1cNStubAssemblerG__vtbl_");
        this.addMapping("StubGenerator::__vtbl", "__1cNStubGeneratorG__vtbl_");
        this.addMapping("StubGenerator::StubMacroAssembler::__vtbl", "__1cNStubGeneratorSStubMacroAssemblerG__vtbl_");
        this.addMapping("SubI_boutNode::__vtbl", "__1cNSubI_boutNodeG__vtbl_");
        this.addMapping("SubI_longNode::__vtbl", "__1cNSubI_longNodeG__vtbl_");
        this.addMapping("VM_Deoptimize::__vtbl", "__1cNVM_DeoptimizeG__vtbl_");
        this.addMapping("VM_GenCollect::__vtbl", "__1cNVM_GenCollectG__vtbl_");
        this.addMapping("VM_ThreadStop::__vtbl", "__1cNVM_ThreadStopG__vtbl_");
        this.addMapping("VerifyClosure::__vtbl", "__1cNVerifyClosureG__vtbl_");
        this.addMapping("WatcherThread::__vtbl", "__1cNWatcherThreadG__vtbl_");
        this.addMapping("ciMethodKlass::__vtbl", "__1cNciMethodKlassG__vtbl_");
        this.addMapping("ciSymbolKlass::__vtbl", "__1cNciSymbolKlassG__vtbl_");
        this.addMapping("cmpDg_regNode::__vtbl", "__1cNcmpDg_regNodeG__vtbl_");
        this.addMapping("cmpDl_regNode::__vtbl", "__1cNcmpDl_regNodeG__vtbl_");
        this.addMapping("cmpFg_regNode::__vtbl", "__1cNcmpFg_regNodeG__vtbl_");
        this.addMapping("cmpFl_regNode::__vtbl", "__1cNcmpFl_regNodeG__vtbl_");
        this.addMapping("defaultStream::__vtbl", "__1cNdefaultStreamG__vtbl_");
        this.addMapping("hiMul_regNode::__vtbl", "__1cNhiMul_regNodeG__vtbl_");
        this.addMapping("indOffsetOper::__vtbl", "__1cNindOffsetOperG__vtbl_");
        this.addMapping("instanceKlass::__vtbl", "__1cNinstanceKlassG__vtbl_");
        this.addMapping("loMul_regNode::__vtbl", "__1cNloMul_regNodeG__vtbl_");
        this.addMapping("loadConPCNode::__vtbl", "__1cNloadConPCNodeG__vtbl_");
        this.addMapping("loadKlassNode::__vtbl", "__1cNloadKlassNodeG__vtbl_");
        this.addMapping("loadRangeNode::__vtbl", "__1cNloadRangeNodeG__vtbl_");
        this.addMapping("objArrayKlass::__vtbl", "__1cNobjArrayKlassG__vtbl_");
        this.addMapping("safePointNode::__vtbl", "__1cNsafePointNodeG__vtbl_");
        this.addMapping("salL_regiNode::__vtbl", "__1cNsalL_regiNodeG__vtbl_");
        this.addMapping("CallNativeNode::__vtbl", "__1cOCallNativeNodeG__vtbl_");
        this.addMapping("CallRelocation::__vtbl", "__1cOCallRelocationG__vtbl_");
        this.addMapping("CardGeneration::__vtbl", "__1cOCardGenerationG__vtbl_");
        this.addMapping("ClassPathEntry::__vtbl", "__1cOClassPathEntryG__vtbl_");
        this.addMapping("ClearArrayNode::__vtbl", "__1cOClearArrayNodeG__vtbl_");
        this.addMapping("CompiledRFrame::__vtbl", "__1cOCompiledRFrameG__vtbl_");
        this.addMapping("CompilerThread::__vtbl", "__1cOCompilerThreadG__vtbl_");
        this.addMapping("DoubleConstant::__vtbl", "__1cODoubleConstantG__vtbl_");
        this.addMapping("DoubleHalfNode::__vtbl", "__1cODoubleHalfNodeG__vtbl_");
        this.addMapping("FastUnlockNode::__vtbl", "__1cOFastUnlockNodeG__vtbl_");
        this.addMapping("GenerateOopMap::__vtbl", "__1cOGenerateOopMapG__vtbl_");
        this.addMapping("InstanceOfStub::__vtbl", "__1cOInstanceOfStubG__vtbl_");
        this.addMapping("IsAliveClosure::__vtbl", "__1cOIsAliveClosureG__vtbl_");
        this.addMapping("JvmdiEventUser::__vtbl", "__1cOJvmdiEventUserG__vtbl_");
        this.addMapping("LIR_OpAllocObj::__vtbl", "__1cOLIR_OpAllocObjG__vtbl_");
        this.addMapping("LIR_OpCodeStub::__vtbl", "__1cOLIR_OpCodeStubG__vtbl_");
        this.addMapping("LIR_OpJavaCall::__vtbl", "__1cOLIR_OpJavaCallG__vtbl_");
        this.addMapping("MachEpilogNode::__vtbl", "__1cOMachEpilogNodeG__vtbl_");
        this.addMapping("MachPrologNode::__vtbl", "__1cOMachPrologNodeG__vtbl_");
        this.addMapping("MachReturnNode::__vtbl", "__1cOMachReturnNodeG__vtbl_");
        this.addMapping("MacroAssembler::__vtbl", "__1cOMacroAssemblerG__vtbl_");
        this.addMapping("MethodIterator::__vtbl", "__1cOMethodIteratorG__vtbl_");
        this.addMapping("NewObjectArray::__vtbl", "__1cONewObjectArrayG__vtbl_");
        this.addMapping("ObjectConstant::__vtbl", "__1cOObjectConstantG__vtbl_");
        this.addMapping("ParseGenerator::__vtbl", "__1cOParseGeneratorG__vtbl_");
        this.addMapping("PhaseIdealLoop::__vtbl", "__1cOPhaseIdealLoopG__vtbl_");
        this.addMapping("PhaseTransform::__vtbl", "__1cOPhaseTransformG__vtbl_");
        this.addMapping("RangeCheckStub::__vtbl", "__1cORangeCheckStubG__vtbl_");
        this.addMapping("RoundFloatNode::__vtbl", "__1cORoundFloatNodeG__vtbl_");
        this.addMapping("SignExtendNode::__vtbl", "__1cOSignExtendNodeG__vtbl_");
        this.addMapping("StaticCallStub::__vtbl", "__1cOStaticCallStubG__vtbl_");
        this.addMapping("compI_iRegNode::__vtbl", "__1cOcompI_iRegNodeG__vtbl_");
        this.addMapping("compU_iRegNode::__vtbl", "__1cOcompU_iRegNodeG__vtbl_");
        this.addMapping("compiledVFrame::__vtbl", "__1cOcompiledVFrameG__vtbl_");
        this.addMapping("externalVFrame::__vtbl", "__1cOexternalVFrameG__vtbl_");
        this.addMapping("jsr_Relocation::__vtbl", "__1cOjsr_RelocationG__vtbl_");
        this.addMapping("loadConI13Node::__vtbl", "__1cOloadConI13NodeG__vtbl_");
        this.addMapping("loadI_fregNode::__vtbl", "__1cOloadI_fregNodeG__vtbl_");
        this.addMapping("moveI_FvalNode::__vtbl", "__1cOmoveI_FvalNodeG__vtbl_");
        this.addMapping("oop_Relocation::__vtbl", "__1cOoop_RelocationG__vtbl_");
        this.addMapping("stackSlotDOper::__vtbl", "__1cOstackSlotDOperG__vtbl_");
        this.addMapping("stackSlotFOper::__vtbl", "__1cOstackSlotFOperG__vtbl_");
        this.addMapping("stackSlotIOper::__vtbl", "__1cOstackSlotIOperG__vtbl_");
        this.addMapping("stackSlotLOper::__vtbl", "__1cOstackSlotLOperG__vtbl_");
        this.addMapping("tailjmpIndNode::__vtbl", "__1cOtailjmpIndNodeG__vtbl_");
        this.addMapping("typeArrayKlass::__vtbl", "__1cOtypeArrayKlassG__vtbl_");
        this.addMapping("AddressConstant::__vtbl", "__1cPAddressConstantG__vtbl_");
        this.addMapping("BlockCollection::__vtbl", "__1cPBlockCollectionG__vtbl_");
        this.addMapping("BlockItemSetter::__vtbl", "__1cPBlockItemSetterG__vtbl_");
        this.addMapping("C1_CodePatterns::__vtbl", "__1cPC1_CodePatternsG__vtbl_");
        this.addMapping("CallRuntimeNode::__vtbl", "__1cPCallRuntimeNodeG__vtbl_");
        this.addMapping("ChangeJumpWiden::__vtbl", "__1cPChangeJumpWidenG__vtbl_");
        this.addMapping("ChangeSwitchPad::__vtbl", "__1cPChangeSwitchPadG__vtbl_");
        this.addMapping("CheckCastPPNode::__vtbl", "__1cPCheckCastPPNodeG__vtbl_");
        this.addMapping("CmpDGreaterNode::__vtbl", "__1cPCmpDGreaterNodeG__vtbl_");
        this.addMapping("CmpFGreaterNode::__vtbl", "__1cPCmpFGreaterNodeG__vtbl_");
        this.addMapping("ContigPermSpace::__vtbl", "__1cPContigPermSpaceG__vtbl_");
        this.addMapping("ContiguousSpace::__vtbl", "__1cPContiguousSpaceG__vtbl_");
        this.addMapping("CountedLoopNode::__vtbl", "__1cPCountedLoopNodeG__vtbl_");
        this.addMapping("DoubleHalf0Node::__vtbl", "__1cPDoubleHalf0NodeG__vtbl_");
        this.addMapping("DoubleHalf1Node::__vtbl", "__1cPDoubleHalf1NodeG__vtbl_");
        this.addMapping("ICStubInterface::__vtbl", "__1cPICStubInterfaceG__vtbl_");
        this.addMapping("InliningClosure::__vtbl", "__1cPInliningClosureG__vtbl_");
        this.addMapping("JsrContinuation::__vtbl", "__1cPJsrContinuationG__vtbl_");
        this.addMapping("JvmdiBreakpoint::__vtbl", "__1cPJvmdiBreakpointG__vtbl_");
        this.addMapping("JvmdiEventClass::__vtbl", "__1cPJvmdiEventClassG__vtbl_");
        this.addMapping("JvmdiEventFrame::__vtbl", "__1cPJvmdiEventFrameG__vtbl_");
        this.addMapping("LIR_FastConvert::__vtbl", "__1cPLIR_FastConvertG__vtbl_");
        this.addMapping("LocalOopClosure::__vtbl", "__1cPLocalOopClosureG__vtbl_");
        this.addMapping("MonitorExitStub::__vtbl", "__1cPMonitorExitStubG__vtbl_");
        this.addMapping("MultiBranchData::__vtbl", "__1cPMultiBranchDataG__vtbl_");
        this.addMapping("NewInstanceStub::__vtbl", "__1cPNewInstanceStubG__vtbl_");
        this.addMapping("ParameterMapper::__vtbl", "__1cPParameterMapperG__vtbl_");
        this.addMapping("PrintingClosure::__vtbl", "__1cPPrintingClosureG__vtbl_");
        this.addMapping("RoundDoubleNode::__vtbl", "__1cPRoundDoubleNodeG__vtbl_");
        this.addMapping("ScavengeClosure::__vtbl", "__1cPScavengeClosureG__vtbl_");
        this.addMapping("SetPredsClosure::__vtbl", "__1cPSetPredsClosureG__vtbl_");
        this.addMapping("ThreadLocalNode::__vtbl", "__1cPThreadLocalNodeG__vtbl_");
        this.addMapping("TrainGeneration::__vtbl", "__1cPTrainGenerationG__vtbl_");
        this.addMapping("VM_GC_Operation::__vtbl", "__1cPVM_GC_OperationG__vtbl_");
        this.addMapping("VM_PrintThreads::__vtbl", "__1cPVM_PrintThreadsG__vtbl_");
        this.addMapping("VirtualCallData::__vtbl", "__1cPVirtualCallDataG__vtbl_");
        this.addMapping("addIx_reg_0Node::__vtbl", "__1cPaddIx_reg_0NodeG__vtbl_");
        this.addMapping("arrayKlassKlass::__vtbl", "__1cParrayKlassKlassG__vtbl_");
        this.addMapping("branchConV8Node::__vtbl", "__1cPbranchConV8NodeG__vtbl_");
        this.addMapping("branchConV9Node::__vtbl", "__1cPbranchConV9NodeG__vtbl_");
        this.addMapping("checkCastPPNode::__vtbl", "__1cPcheckCastPPNodeG__vtbl_");
        this.addMapping("ciInstanceKlass::__vtbl", "__1cPciInstanceKlassG__vtbl_");
        this.addMapping("ciObjArrayKlass::__vtbl", "__1cPciObjArrayKlassG__vtbl_");
        this.addMapping("ciReturnAddress::__vtbl", "__1cPciReturnAddressG__vtbl_");
        this.addMapping("cmpDg_cc_V8Node::__vtbl", "__1cPcmpDg_cc_V8NodeG__vtbl_");
        this.addMapping("cmpDg_cc_V9Node::__vtbl", "__1cPcmpDg_cc_V9NodeG__vtbl_");
        this.addMapping("cmpDl_cc_V8Node::__vtbl", "__1cPcmpDl_cc_V8NodeG__vtbl_");
        this.addMapping("cmpDl_cc_V9Node::__vtbl", "__1cPcmpDl_cc_V9NodeG__vtbl_");
        this.addMapping("cmpFg_cc_V8Node::__vtbl", "__1cPcmpFg_cc_V8NodeG__vtbl_");
        this.addMapping("cmpFg_cc_V9Node::__vtbl", "__1cPcmpFg_cc_V9NodeG__vtbl_");
        this.addMapping("cmpFl_cc_V8Node::__vtbl", "__1cPcmpFl_cc_V8NodeG__vtbl_");
        this.addMapping("cmpFl_cc_V9Node::__vtbl", "__1cPcmpFl_cc_V9NodeG__vtbl_");
        this.addMapping("compP_iRegPNode::__vtbl", "__1cPcompP_iRegPNodeG__vtbl_");
        this.addMapping("compU_iRegPNode::__vtbl", "__1cPcompU_iRegPNodeG__vtbl_");
        this.addMapping("convD2F_regNode::__vtbl", "__1cPconvD2F_regNodeG__vtbl_");
        this.addMapping("convD2I_NanNode::__vtbl", "__1cPconvD2I_NanNodeG__vtbl_");
        this.addMapping("convD2I_regNode::__vtbl", "__1cPconvD2I_regNodeG__vtbl_");
        this.addMapping("convF2D_regNode::__vtbl", "__1cPconvF2D_regNodeG__vtbl_");
        this.addMapping("convF2I_NanNode::__vtbl", "__1cPconvF2I_NanNodeG__vtbl_");
        this.addMapping("convF2I_regNode::__vtbl", "__1cPconvF2I_regNodeG__vtbl_");
        this.addMapping("convI2D_regNode::__vtbl", "__1cPconvI2D_regNodeG__vtbl_");
        this.addMapping("convI2F_regNode::__vtbl", "__1cPconvI2F_regNodeG__vtbl_");
        this.addMapping("interpretedNode::__vtbl", "__1cPinterpretedNodeG__vtbl_");
        this.addMapping("loadConFmemNode::__vtbl", "__1cPloadConFmemNodeG__vtbl_");
        this.addMapping("methodDataKlass::__vtbl", "__1cPmethodDataKlassG__vtbl_");
        this.addMapping("orI_reg_regNode::__vtbl", "__1cPorI_reg_regNodeG__vtbl_");
        this.addMapping("runtimeStubNode::__vtbl", "__1cPruntimeStubNodeG__vtbl_");
        this.addMapping("sp_or_iRegPOper::__vtbl", "__1cPsp_or_iRegPOperG__vtbl_");
        this.addMapping("storeI_FregNode::__vtbl", "__1cPstoreI_FregNodeG__vtbl_");
        this.addMapping("AbstractCompiler::__vtbl", "__1cQAbstractCompilerG__vtbl_");
        this.addMapping("AllocProfClosure::__vtbl", "__1cQAllocProfClosureG__vtbl_");
        this.addMapping("BlockOffsetArray::__vtbl", "__1cQBlockOffsetArrayG__vtbl_");
        this.addMapping("BlockOffsetTable::__vtbl", "__1cQBlockOffsetTableG__vtbl_");
        this.addMapping("ChangeSpillCount::__vtbl", "__1cQChangeSpillCountG__vtbl_");
        this.addMapping("ChunkPoolCleaner::__vtbl", "__1cQChunkPoolCleanerG__vtbl_");
        this.addMapping("CollectConstants::__vtbl", "__1cQCollectConstantsG__vtbl_");
        this.addMapping("CompactibleSpace::__vtbl", "__1cQCompactibleSpaceG__vtbl_");
        this.addMapping("CompilationScope::__vtbl", "__1cQCompilationScopeG__vtbl_");
        this.addMapping("ComputeCallStack::__vtbl", "__1cQComputeCallStackG__vtbl_");
        this.addMapping("ConstantIntValue::__vtbl", "__1cQConstantIntValueG__vtbl_");
        this.addMapping("CMSPermGen::__vtbl", "__1cKCMSPermGenG__vtbl_");
        this.addMapping("CMSPermGenGen::__vtbl", "__1cNCMSPermGenGenG__vtbl_");
        this.addMapping("ConcurrentMarkSweepGeneration::__vtbl", "__1cbDConcurrentMarkSweepGenerationG__vtbl_");
        this.addMapping("DefNewGeneration::__vtbl", "__1cQDefNewGenerationG__vtbl_");
        this.addMapping("DoNothingClosure::__vtbl", "__1cQDoNothingClosureG__vtbl_");
        this.addMapping("FlatProfilerTask::__vtbl", "__1cQFlatProfilerTaskG__vtbl_");
        this.addMapping("GenCollectedHeap::__vtbl", "__1cQGenCollectedHeapG__vtbl_");
        this.addMapping("InstanceConstant::__vtbl", "__1cQInstanceConstantG__vtbl_");
        this.addMapping("JvmtiAgentThread::__vtbl", "__1cQJvmtiAgentThreadG__vtbl_");
        this.addMapping("KeepAliveClosure::__vtbl", "__1cQKeepAliveClosureG__vtbl_");
        this.addMapping("LIR_OpAllocArray::__vtbl", "__1cQLIR_OpAllocArrayG__vtbl_");
        this.addMapping("LIR_OpBranchDest::__vtbl", "__1cQLIR_OpBranchDestG__vtbl_");
        this.addMapping("LIR_OpMathHelper::__vtbl", "__1cQLIR_OpMathHelperG__vtbl_");
        this.addMapping("LShiftDoubleNode::__vtbl", "__1cQLShiftDoubleNodeG__vtbl_");
        this.addMapping("LoadThreadIDNode::__vtbl", "__1cQLoadThreadIDNodeG__vtbl_");
        this.addMapping("MachCallJavaNode::__vtbl", "__1cQMachCallJavaNodeG__vtbl_");
        this.addMapping("MonitorEnterStub::__vtbl", "__1cQMonitorEnterStubG__vtbl_");
        this.addMapping("NewTypeArrayStub::__vtbl", "__1cQNewTypeArrayStubG__vtbl_");
        this.addMapping("ParNewGeneration::__vtbl", "__1cQParNewGenerationG__vtbl_");
        this.addMapping("ParallelScavengeHeap::__vtbl", "__1cUParallelScavengeHeapG__vtbl_");
        this.addMapping("RShiftDoubleNode::__vtbl", "__1cQRShiftDoubleNodeG__vtbl_");
        this.addMapping("ResultTypeFinder::__vtbl", "__1cQResultTypeFinderG__vtbl_");
        this.addMapping("RethrowLocalNode::__vtbl", "__1cQRethrowLocalNodeG__vtbl_");
        this.addMapping("SafepointHandler::__vtbl", "__1cQSafepointHandlerG__vtbl_");
        this.addMapping("UncommonTrapBlob::__vtbl", "__1cQUncommonTrapBlobG__vtbl_");
        this.addMapping("VM_ThreadSuspend::__vtbl", "__1cQVM_ThreadSuspendG__vtbl_");
        this.addMapping("VerifyOopClosure::__vtbl", "__1cQVerifyOopClosureG__vtbl_");
        this.addMapping("addD_reg_regNode::__vtbl", "__1cQaddD_reg_regNodeG__vtbl_");
        this.addMapping("addF_reg_regNode::__vtbl", "__1cQaddF_reg_regNodeG__vtbl_");
        this.addMapping("addI_reg_regNode::__vtbl", "__1cQaddI_reg_regNodeG__vtbl_");
        this.addMapping("addP_reg_regNode::__vtbl", "__1cQaddP_reg_regNodeG__vtbl_");
        this.addMapping("andI_reg_regNode::__vtbl", "__1cQandI_reg_regNodeG__vtbl_");
        this.addMapping("branchConUV8Node::__vtbl", "__1cQbranchConUV8NodeG__vtbl_");
        this.addMapping("branchConUV9Node::__vtbl", "__1cQbranchConUV9NodeG__vtbl_");
        this.addMapping("ciGenerateOopMap::__vtbl", "__1cQciGenerateOopMapG__vtbl_");
        this.addMapping("ciTypeArrayKlass::__vtbl", "__1cQciTypeArrayKlassG__vtbl_");
        this.addMapping("cmpI_reg_regNode::__vtbl", "__1cQcmpI_reg_regNodeG__vtbl_");
        this.addMapping("divD_reg_regNode::__vtbl", "__1cQdivD_reg_regNodeG__vtbl_");
        this.addMapping("divF_reg_regNode::__vtbl", "__1cQdivF_reg_regNodeG__vtbl_");
        this.addMapping("divI_reg_regNode::__vtbl", "__1cQdivI_reg_regNodeG__vtbl_");
        this.addMapping("instanceRefKlass::__vtbl", "__1cQinstanceRefKlassG__vtbl_");
        this.addMapping("jmpCheckTypeNode::__vtbl", "__1cQjmpCheckTypeNodeG__vtbl_");
        this.addMapping("loadThreadIDNode::__vtbl", "__1cQloadThreadIDNodeG__vtbl_");
        this.addMapping("modI_reg_regNode::__vtbl", "__1cQmodI_reg_regNodeG__vtbl_");
        this.addMapping("mulD_reg_regNode::__vtbl", "__1cQmulD_reg_regNodeG__vtbl_");
        this.addMapping("mulF_reg_regNode::__vtbl", "__1cQmulF_reg_regNodeG__vtbl_");
        this.addMapping("mulI_reg_regNode::__vtbl", "__1cQmulI_reg_regNodeG__vtbl_");
        this.addMapping("notemp_iRegIOper::__vtbl", "__1cQnotemp_iRegIOperG__vtbl_");
        this.addMapping("notemp_iRegPOper::__vtbl", "__1cQnotemp_iRegPOperG__vtbl_");
        this.addMapping("sarI_reg_regNode::__vtbl", "__1cQsarI_reg_regNodeG__vtbl_");
        this.addMapping("setCarryMaskNode::__vtbl", "__1cQsetCarryMaskNodeG__vtbl_");
        this.addMapping("shlI_reg_regNode::__vtbl", "__1cQshlI_reg_regNodeG__vtbl_");
        this.addMapping("shrI_reg_regNode::__vtbl", "__1cQshrI_reg_regNodeG__vtbl_");
        this.addMapping("subD_reg_regNode::__vtbl", "__1cQsubD_reg_regNodeG__vtbl_");
        this.addMapping("subF_reg_regNode::__vtbl", "__1cQsubF_reg_regNodeG__vtbl_");
        this.addMapping("subI_reg_regNode::__vtbl", "__1cQsubI_reg_regNodeG__vtbl_");
        this.addMapping("tlsReferenceOper::__vtbl", "__1cQtlsReferenceOperG__vtbl_");
        this.addMapping("xorI_reg_regNode::__vtbl", "__1cQxorI_reg_regNodeG__vtbl_");
        this.addMapping("AlwaysTrueClosure::__vtbl", "__1cRAlwaysTrueClosureG__vtbl_");
        this.addMapping("ArgumentOopFinder::__vtbl", "__1cRArgumentOopFinderG__vtbl_");
        this.addMapping("CardTableModRefBS::__vtbl", "__1cRCardTableModRefBSG__vtbl_");
        this.addMapping("ClassPathDirEntry::__vtbl", "__1cRClassPathDirEntryG__vtbl_");
        this.addMapping("ClassPathZipEntry::__vtbl", "__1cRClassPathZipEntryG__vtbl_");
        this.addMapping("CompactingPermGen::__vtbl", "__1cRCompactingPermGenG__vtbl_");
        this.addMapping("ComputeEntryStack::__vtbl", "__1cRComputeEntryStackG__vtbl_");
        this.addMapping("ConstantLongValue::__vtbl", "__1cRConstantLongValueG__vtbl_");
        this.addMapping("CreateInfoClosure::__vtbl", "__1cRCreateInfoClosureG__vtbl_");
        this.addMapping("DeoptimizedRFrame::__vtbl", "__1cRDeoptimizedRFrameG__vtbl_");
        this.addMapping("GenCompactClosure::__vtbl", "__1cRGenCompactClosureG__vtbl_");
        this.addMapping("InstructionFilter::__vtbl", "__1cRInstructionFilterG__vtbl_");
        this.addMapping("InterpretedRFrame::__vtbl", "__1cRInterpretedRFrameG__vtbl_");
        this.addMapping("JVMPIDaemonThread::__vtbl", "__1cRJVMPIDaemonThreadG__vtbl_");
        this.addMapping("JVMPI_Object_Free::__vtbl", "__1cRJVMPI_Object_FreeG__vtbl_");
        this.addMapping("JavaMonitorDumper::__vtbl", "__1cRJavaMonitorDumperG__vtbl_");
        this.addMapping("MachNullCheckNode::__vtbl", "__1cRMachNullCheckNodeG__vtbl_");
        this.addMapping("MachSafePointNode::__vtbl", "__1cRMachSafePointNodeG__vtbl_");
        this.addMapping("MonitorAccessStub::__vtbl", "__1cRMonitorAccessStubG__vtbl_");
        this.addMapping("NullExceptionStub::__vtbl", "__1cRNullExceptionStubG__vtbl_");
        this.addMapping("SignatureIterator::__vtbl", "__1cRSignatureIteratorG__vtbl_");
        this.addMapping("StubCodeGenerator::__vtbl", "__1cRStubCodeGeneratorG__vtbl_");
        this.addMapping("TenuredGeneration::__vtbl", "__1cRTenuredGenerationG__vtbl_");
        this.addMapping("VM_ForceSafepoint::__vtbl", "__1cRVM_ForceSafepointG__vtbl_");
        this.addMapping("VM_GenerateOopMap::__vtbl", "__1cRVM_GenerateOopMapG__vtbl_");
        this.addMapping("VM_SuspendDaemons::__vtbl", "__1cRVM_SuspendDaemonsG__vtbl_");
        this.addMapping("addIc_reg_regNode::__vtbl", "__1cRaddIc_reg_regNodeG__vtbl_");
        this.addMapping("addIx_reg_regNode::__vtbl", "__1cRaddIx_reg_regNodeG__vtbl_");
        this.addMapping("branchConFGV8Node::__vtbl", "__1cRbranchConFGV8NodeG__vtbl_");
        this.addMapping("branchConFGV9Node::__vtbl", "__1cRbranchConFGV9NodeG__vtbl_");
        this.addMapping("branchConFLV8Node::__vtbl", "__1cRbranchConFLV8NodeG__vtbl_");
        this.addMapping("branchConFLV9Node::__vtbl", "__1cRbranchConFLV9NodeG__vtbl_");
        this.addMapping("constantPoolKlass::__vtbl", "__1cRconstantPoolKlassG__vtbl_");
        this.addMapping("deoptimizedVFrame::__vtbl", "__1cRdeoptimizedVFrameG__vtbl_");
        this.addMapping("interpretedVFrame::__vtbl", "__1cRinterpretedVFrameG__vtbl_");
        this.addMapping("orI_reg_imm13Node::__vtbl", "__1cRorI_reg_imm13NodeG__vtbl_");
        this.addMapping("return_Relocation::__vtbl", "__1cRreturn_RelocationG__vtbl_");
        this.addMapping("sarI_reg_imm5Node::__vtbl", "__1cRsarI_reg_imm5NodeG__vtbl_");
        this.addMapping("shlI_reg_imm5Node::__vtbl", "__1cRshlI_reg_imm5NodeG__vtbl_");
        this.addMapping("shrI_reg_imm5Node::__vtbl", "__1cRshrI_reg_imm5NodeG__vtbl_");
        this.addMapping("subI_zero_regNode::__vtbl", "__1cRsubI_zero_regNodeG__vtbl_");
        this.addMapping("subIc_reg_immNode::__vtbl", "__1cRsubIc_reg_immNodeG__vtbl_");
        this.addMapping("subIc_reg_regNode::__vtbl", "__1cRsubIc_reg_regNodeG__vtbl_");
        this.addMapping("subIx_reg_regNode::__vtbl", "__1cRsubIx_reg_regNodeG__vtbl_");
        this.addMapping("testI_reg_immNode::__vtbl", "__1cRtestI_reg_immNodeG__vtbl_");
        this.addMapping("testI_reg_regNode::__vtbl", "__1cRtestI_reg_regNodeG__vtbl_");
        this.addMapping("CallLeafDirectNode::__vtbl", "__1cSCallLeafDirectNodeG__vtbl_");
        this.addMapping("CallStaticJavaNode::__vtbl", "__1cSCallStaticJavaNodeG__vtbl_");
        this.addMapping("CompiledRecompilee::__vtbl", "__1cSCompiledRecompileeG__vtbl_");
        this.addMapping("ComputeAdapterInfo::__vtbl", "__1cSComputeAdapterInfoG__vtbl_");
        this.addMapping("CountedLoopEndNode::__vtbl", "__1cSCountedLoopEndNodeG__vtbl_");
        this.addMapping("DeoptimizationBlob::__vtbl", "__1cSDeoptimizationBlobG__vtbl_");
        this.addMapping("FindSignatureTypes::__vtbl", "__1cSFindSignatureTypesG__vtbl_");
        this.addMapping("FixupMirrorClosure::__vtbl", "__1cSFixupMirrorClosureG__vtbl_");
        this.addMapping("InterpreterRuntime::SignatureHandlerGenerator::__vtbl", "__1cSInterpreterRuntimeZSignatureHandlerGeneratorG__vtbl_");
        this.addMapping("Interrupt_Callback::__vtbl", "__1cSInterrupt_CallbackG__vtbl_");
        this.addMapping("JNI_ArgumentPusher::__vtbl", "__1cSJNI_ArgumentPusherG__vtbl_");
        this.addMapping("MachBreakpointNode::__vtbl", "__1cSMachBreakpointNodeG__vtbl_");
        this.addMapping("MachC2IEntriesNode::__vtbl", "__1cSMachC2IEntriesNodeG__vtbl_");
        this.addMapping("MachC2IcheckICNode::__vtbl", "__1cSMachC2IcheckICNodeG__vtbl_");
        this.addMapping("MachCallNativeNode::__vtbl", "__1cSMachCallNativeNodeG__vtbl_");
        this.addMapping("NewObjectArrayStub::__vtbl", "__1cSNewObjectArrayStubG__vtbl_");
        this.addMapping("ObjectToOopClosure::__vtbl", "__1cSObjectToOopClosureG__vtbl_");
        this.addMapping("PredecessorCounter::__vtbl", "__1cSPredecessorCounterG__vtbl_");
        this.addMapping("SetupItableClosure::__vtbl", "__1cSSetupItableClosureG__vtbl_");
        this.addMapping("TailCalljmpIndNode::__vtbl", "__1cSTailCalljmpIndNodeG__vtbl_");
        this.addMapping("VM_ChangeFramePops::__vtbl", "__1cSVM_ChangeFramePopsG__vtbl_");
        this.addMapping("VM_DeoptimizeFrame::__vtbl", "__1cSVM_DeoptimizeFrameG__vtbl_");
        this.addMapping("VM_RedefineClasses::__vtbl", "__1cSVM_RedefineClassesG__vtbl_");
        this.addMapping("addI_reg_imm13Node::__vtbl", "__1cSaddI_reg_imm13NodeG__vtbl_");
        this.addMapping("addP_reg_imm13Node::__vtbl", "__1cSaddP_reg_imm13NodeG__vtbl_");
        this.addMapping("andI_reg_imm13Node::__vtbl", "__1cSandI_reg_imm13NodeG__vtbl_");
        this.addMapping("cadd_cmpLTMaskNode::__vtbl", "__1cScadd_cmpLTMaskNodeG__vtbl_");
        this.addMapping("cmpFastLock_V8Node::__vtbl", "__1cScmpFastLock_V8NodeG__vtbl_");
        this.addMapping("cmpFastLock_V9Node::__vtbl", "__1cScmpFastLock_V9NodeG__vtbl_");
        this.addMapping("cmpI_reg_imm13Node::__vtbl", "__1cScmpI_reg_imm13NodeG__vtbl_");
        this.addMapping("convD2I_helperNode::__vtbl", "__1cSconvD2I_helperNodeG__vtbl_");
        this.addMapping("convF2I_helperNode::__vtbl", "__1cSconvF2I_helperNodeG__vtbl_");
        this.addMapping("convI2D_helperNode::__vtbl", "__1cSconvI2D_helperNodeG__vtbl_");
        this.addMapping("convI2F_helperNode::__vtbl", "__1cSconvI2F_helperNodeG__vtbl_");
        this.addMapping("divI_reg_imm13Node::__vtbl", "__1cSdivI_reg_imm13NodeG__vtbl_");
        this.addMapping("instanceKlassKlass::__vtbl", "__1cSinstanceKlassKlassG__vtbl_");
        this.addMapping("jsr_ret_Relocation::__vtbl", "__1cSjsr_ret_RelocationG__vtbl_");
        this.addMapping("modI_reg_imm13Node::__vtbl", "__1cSmodI_reg_imm13NodeG__vtbl_");
        this.addMapping("mulI_reg_imm13Node::__vtbl", "__1cSmulI_reg_imm13NodeG__vtbl_");
        this.addMapping("objArrayKlassKlass::__vtbl", "__1cSobjArrayKlassKlassG__vtbl_");
        this.addMapping("roundFloat_nopNode::__vtbl", "__1cSroundFloat_nopNodeG__vtbl_");
        this.addMapping("string_compareNode::__vtbl", "__1cSstring_compareNodeG__vtbl_");
        this.addMapping("subI_reg_imm13Node::__vtbl", "__1cSsubI_reg_imm13NodeG__vtbl_");
        this.addMapping("xorI_reg_imm13Node::__vtbl", "__1cSxorI_reg_imm13NodeG__vtbl_");
        this.addMapping("ArrayStoreCheckStub::__vtbl", "__1cTArrayStoreCheckStubG__vtbl_");
        this.addMapping("AssertIsPermClosure::__vtbl", "__1cTAssertIsPermClosureG__vtbl_");
        this.addMapping("CallDynamicJavaNode::__vtbl", "__1cTCallDynamicJavaNodeG__vtbl_");
        this.addMapping("CallInterpreterNode::__vtbl", "__1cTCallInterpreterNodeG__vtbl_");
        this.addMapping("ConstantDoubleValue::__vtbl", "__1cTConstantDoubleValueG__vtbl_");
        this.addMapping("CreateExceptionNode::__vtbl", "__1cTCreateExceptionNodeG__vtbl_");
        this.addMapping("DirectCallGenerator::__vtbl", "__1cTDirectCallGeneratorG__vtbl_");
        this.addMapping("EntryFrameOopFinder::__vtbl", "__1cTEntryFrameOopFinderG__vtbl_");
        this.addMapping("GeneratePairingInfo::__vtbl", "__1cTGeneratePairingInfoG__vtbl_");
        this.addMapping("ICacheStubGenerator::__vtbl", "__1cTICacheStubGeneratorG__vtbl_");
        this.addMapping("JvmdiEventException::__vtbl", "__1cTJvmdiEventExceptionG__vtbl_");
        this.addMapping("MachCallRuntimeNode::__vtbl", "__1cTMachCallRuntimeNodeG__vtbl_");
        this.addMapping("MaskFillerForNative::__vtbl", "__1cTMaskFillerForNativeG__vtbl_");
        this.addMapping("OopMapForCacheEntry::__vtbl", "__1cTOopMapForCacheEntryG__vtbl_");
        this.addMapping("VM_JVMPIPostVMDeath::__vtbl", "__1cTVM_JVMPIPostVMDeathG__vtbl_");
        this.addMapping("addIc_reg_imm13Node::__vtbl", "__1cTaddIc_reg_imm13NodeG__vtbl_");
        this.addMapping("addIx_reg_imm13Node::__vtbl", "__1cTaddIx_reg_imm13NodeG__vtbl_");
        this.addMapping("branchLoopEndV8Node::__vtbl", "__1cTbranchLoopEndV8NodeG__vtbl_");
        this.addMapping("branchLoopEndV9Node::__vtbl", "__1cTbranchLoopEndV9NodeG__vtbl_");
        this.addMapping("compI_subI_iRegNode::__vtbl", "__1cTcompI_subI_iRegNodeG__vtbl_");
        this.addMapping("roundDouble_nopNode::__vtbl", "__1cTroundDouble_nopNodeG__vtbl_");
        this.addMapping("subIx_reg_imm13Node::__vtbl", "__1cTsubIx_reg_imm13NodeG__vtbl_");
        this.addMapping("typeArrayKlassKlass::__vtbl", "__1cTtypeArrayKlassKlassG__vtbl_");
        this.addMapping("ArgumentSizeComputer::__vtbl", "__1cUArgumentSizeComputerG__vtbl_");
        this.addMapping("C1_ArgumentOopFinder::__vtbl", "__1cUC1_ArgumentOopFinderG__vtbl_");
        this.addMapping("CallCompiledJavaNode::__vtbl", "__1cUCallCompiledJavaNodeG__vtbl_");
        this.addMapping("CallNativeDirectNode::__vtbl", "__1cUCallNativeDirectNodeG__vtbl_");
        this.addMapping("CompactingPermGenGen::__vtbl", "__1cUCompactingPermGenGenG__vtbl_");
        this.addMapping("ConstantOopReadValue::__vtbl", "__1cUConstantOopReadValueG__vtbl_");
        this.addMapping("GenGCEpilogueClosure::__vtbl", "__1cUGenGCEpilogueClosureG__vtbl_");
        this.addMapping("GenGCPrologueClosure::__vtbl", "__1cUGenGCPrologueClosureG__vtbl_");
        this.addMapping("GenerateOopMapForBCI::__vtbl", "__1cUGenerateOopMapForBCIG__vtbl_");
        this.addMapping("GetThreadPC_Callback::__vtbl", "__1cUGetThreadPC_CallbackG__vtbl_");
        this.addMapping("JvmdiEventBreakpoint::__vtbl", "__1cUJvmdiEventBreakpointG__vtbl_");
        this.addMapping("JvmdiEventSingleStep::__vtbl", "__1cUJvmdiEventSingleStepG__vtbl_");
        this.addMapping("RecompilationMonitor::__vtbl", "__1cURecompilationMonitorG__vtbl_");
        this.addMapping("RethrowExceptionNode::__vtbl", "__1cURethrowExceptionNodeG__vtbl_");
        this.addMapping("SetThreadPC_Callback::__vtbl", "__1cUSetThreadPC_CallbackG__vtbl_");
        this.addMapping("SlowSignatureHandler::__vtbl", "__1cUSlowSignatureHandlerG__vtbl_");
        this.addMapping("SuxAndWeightAdjuster::__vtbl", "__1cUSuxAndWeightAdjusterG__vtbl_");
        this.addMapping("VM_ChangeBreakpoints::__vtbl", "__1cUVM_ChangeBreakpointsG__vtbl_");
        this.addMapping("VM_JVMPIPostHeapDump::__vtbl", "__1cUVM_JVMPIPostHeapDumpG__vtbl_");
        this.addMapping("VirtualCallGenerator::__vtbl", "__1cUVirtualCallGeneratorG__vtbl_");
        this.addMapping("branchLoopEndV8UNode::__vtbl", "__1cUbranchLoopEndV8UNodeG__vtbl_");
        this.addMapping("branchLoopEndV9UNode::__vtbl", "__1cUbranchLoopEndV9UNodeG__vtbl_");
        this.addMapping("ciInstanceKlassKlass::__vtbl", "__1cUciInstanceKlassKlassG__vtbl_");
        this.addMapping("ciObjArrayKlassKlass::__vtbl", "__1cUciObjArrayKlassKlassG__vtbl_");
        this.addMapping("cmpFastUnlock_V8Node::__vtbl", "__1cUcmpFastUnlock_V8NodeG__vtbl_");
        this.addMapping("cmpFastUnlock_V9Node::__vtbl", "__1cUcmpFastUnlock_V9NodeG__vtbl_");
        this.addMapping("compI_iReg_imm13Node::__vtbl", "__1cUcompI_iReg_imm13NodeG__vtbl_");
        this.addMapping("compI_subI_imm13Node::__vtbl", "__1cUcompI_subI_imm13NodeG__vtbl_");
        this.addMapping("compU_iReg_imm13Node::__vtbl", "__1cUcompU_iReg_imm13NodeG__vtbl_");
        this.addMapping("safepoint_Relocation::__vtbl", "__1cUsafepoint_RelocationG__vtbl_");
        this.addMapping("unknown_compiledNode::__vtbl", "__1cUunknown_compiledNodeG__vtbl_");
        this.addMapping("AdjustPointersClosure::__vtbl", "__1cVAdjustPointersClosureG__vtbl_");
        this.addMapping("CallRuntimeDirectNode::__vtbl", "__1cVCallRuntimeDirectNodeG__vtbl_");
        this.addMapping("ConstantOopWriteValue::__vtbl", "__1cVConstantOopWriteValueG__vtbl_");
        this.addMapping("DirtyCardToOopClosure::__vtbl", "__1cVDirtyCardToOopClosureG__vtbl_");
        this.addMapping("GenerationIsInClosure::__vtbl", "__1cVGenerationIsInClosureG__vtbl_");
        this.addMapping("InterpretedRecompilee::__vtbl", "__1cVInterpretedRecompileeG__vtbl_");
        this.addMapping("JvmdiEventFieldAccess::__vtbl", "__1cVJvmdiEventFieldAccessG__vtbl_");
        this.addMapping("MethodIntervalFactory::__vtbl", "__1cVMethodIntervalFactoryG__vtbl_");
        this.addMapping("ResolveStringsClosure::__vtbl", "__1cVResolveStringsClosureG__vtbl_");
        this.addMapping("SurrogateLockerThread::__vtbl", "__1cVSurrogateLockerThreadG__vtbl_");
        this.addMapping("ResumeThread_Callback::__vtbl", "__1cVResumeThread_CallbackG__vtbl_");
        this.addMapping("VM_JvmdiThreadSuspend::__vtbl", "__1cVVM_JvmdiThreadSuspendG__vtbl_");
        this.addMapping("breakpoint_Relocation::__vtbl", "__1cVbreakpoint_RelocationG__vtbl_");
        this.addMapping("ciAddressMapGenerator::__vtbl", "__1cVciAddressMapGeneratorG__vtbl_");
        this.addMapping("ciTypeArrayKlassKlass::__vtbl", "__1cVciTypeArrayKlassKlassG__vtbl_");
        this.addMapping("cmpLTMask_reg_regNode::__vtbl", "__1cVcmpLTMask_reg_regNodeG__vtbl_");
        this.addMapping("compP_iRegP_imm13Node::__vtbl", "__1cVcompP_iRegP_imm13NodeG__vtbl_");
        this.addMapping("compiledICHolderKlass::__vtbl", "__1cVcompiledICHolderKlassG__vtbl_");
        this.addMapping("inline_cache_regPOper::__vtbl", "__1cVinline_cache_regPOperG__vtbl_");
        this.addMapping("CountInterfacesClosure::__vtbl", "__1cWCountInterfacesClosureG__vtbl_");
        this.addMapping("FetchTopFrame_Callback::__vtbl", "__1cWFetchTopFrame_CallbackG__vtbl_");
        this.addMapping("JvmdiEventThreadChange::__vtbl", "__1cWJvmdiEventThreadChangeG__vtbl_");
        this.addMapping("MachCallStaticJavaNode::__vtbl", "__1cWMachCallStaticJavaNodeG__vtbl_");
        this.addMapping("OffsetTableContigSpace::__vtbl", "__1cWOffsetTableContigSpaceG__vtbl_");
        this.addMapping("ResolveOopMapConflicts::__vtbl", "__1cWResolveOopMapConflictsG__vtbl_");
        this.addMapping("ShouldNotReachHereNode::__vtbl", "__1cWShouldNotReachHereNodeG__vtbl_");
        this.addMapping("SuspendThread_Callback::__vtbl", "__1cWSuspendThread_CallbackG__vtbl_");
        this.addMapping("constantPoolCacheKlass::__vtbl", "__1cWconstantPoolCacheKlassG__vtbl_");
        this.addMapping("static_call_Relocation::__vtbl", "__1cWstatic_call_RelocationG__vtbl_");
        this.addMapping("static_stub_Relocation::__vtbl", "__1cWstatic_stub_RelocationG__vtbl_");
        this.addMapping("CompilePriorityAdjuster::__vtbl", "__1cXCompilePriorityAdjusterG__vtbl_");
        this.addMapping("InlineImageScopeClosure::__vtbl", "__1cXInlineImageScopeClosureG__vtbl_");
        this.addMapping("InterpreterFrameClosure::__vtbl", "__1cXInterpreterFrameClosureG__vtbl_");
        this.addMapping("IssueJVMPIobjAllocEvent::__vtbl", "__1cXIssueJVMPIobjAllocEventG__vtbl_");
        this.addMapping("JNI_ArgumentPusherArray::__vtbl", "__1cXJNI_ArgumentPusherArrayG__vtbl_");
        this.addMapping("JNI_ArgumentPusherVaArg::__vtbl", "__1cXJNI_ArgumentPusherVaArgG__vtbl_");
        this.addMapping("LowMemoryDetectorThread::__vtbl", "__1cXLowMemoryDetectorThreadG__vtbl_");
        this.addMapping("MachCallDynamicJavaNode::__vtbl", "__1cXMachCallDynamicJavaNodeG__vtbl_");
        this.addMapping("MachCallInterpreterNode::__vtbl", "__1cXMachCallInterpreterNodeG__vtbl_");
        this.addMapping("NativeSignatureIterator::__vtbl", "__1cXNativeSignatureIteratorG__vtbl_");
        this.addMapping("PhaseAggressiveCoalesce::__vtbl", "__1cXPhaseAggressiveCoalesceG__vtbl_");
        this.addMapping("VM_JVMPIPostMonitorDump::__vtbl", "__1cXVM_JVMPIPostMonitorDumpG__vtbl_");
        this.addMapping("cmpLTMask_reg_imm13Node::__vtbl", "__1cXcmpLTMask_reg_imm13NodeG__vtbl_");
        this.addMapping("runtime_call_Relocation::__vtbl", "__1cXruntime_call_RelocationG__vtbl_");
        this.addMapping("virtual_call_Relocation::__vtbl", "__1cXvirtual_call_RelocationG__vtbl_");
        this.addMapping("CallStaticJavaDirectNode::__vtbl", "__1cYCallStaticJavaDirectNodeG__vtbl_");
        this.addMapping("EvacuateFollowersClosure::__vtbl", "__1cYEvacuateFollowersClosureG__vtbl_");
        this.addMapping("GenAdjustPointersClosure::__vtbl", "__1cYGenAdjustPointersClosureG__vtbl_");
        this.addMapping("JvmdiEventExceptionCatch::__vtbl", "__1cYJvmdiEventExceptionCatchG__vtbl_");
        this.addMapping("MachCallCompiledJavaNode::__vtbl", "__1cYMachCallCompiledJavaNodeG__vtbl_");
        this.addMapping("VM_Version_StubGenerator::__vtbl", "__1cYVM_Version_StubGeneratorG__vtbl_");
        this.addMapping("external_word_Relocation::__vtbl", "__1cYexternal_word_RelocationG__vtbl_");
        this.addMapping("inlineCallClearArrayNode::__vtbl", "__1cYinlineCallClearArrayNodeG__vtbl_");
        this.addMapping("internal_word_Relocation::__vtbl", "__1cYinternal_word_RelocationG__vtbl_");
        this.addMapping("CallDynamicJavaDirectNode::__vtbl", "__1cZCallDynamicJavaDirectNodeG__vtbl_");
        this.addMapping("CallInterpreterDirectNode::__vtbl", "__1cZCallInterpreterDirectNodeG__vtbl_");
        this.addMapping("CompiledArgumentOopFinder::__vtbl", "__1cZCompiledArgumentOopFinderG__vtbl_");
        this.addMapping("InterpreterMacroAssembler::__vtbl", "__1cZInterpreterMacroAssemblerG__vtbl_");
        this.addMapping("PhaseConservativeCoalesce::__vtbl", "__1cZPhaseConservativeCoalesceG__vtbl_");
        this.addMapping("CallCompiledJavaDirectNode::__vtbl", "__1cbACallCompiledJavaDirectNodeG__vtbl_");
        this.addMapping("GenerationBlockSizeClosure::__vtbl", "__1cbAGenerationBlockSizeClosureG__vtbl_");
        this.addMapping("InlineImageTreeDumpClosure::__vtbl", "__1cbAInlineImageTreeDumpClosureG__vtbl_");
        this.addMapping("InlineImageTreeSortClosure::__vtbl", "__1cbAInlineImageTreeSortClosureG__vtbl_");
        this.addMapping("SuspendThreadSelf_Callback::__vtbl", "__1cbASuspendThreadSelf_CallbackG__vtbl_");
        this.addMapping("GenerationBlockIsObjClosure::__vtbl", "__1cbBGenerationBlockIsObjClosureG__vtbl_");
        this.addMapping("GenerationBlockStartClosure::__vtbl", "__1cbBGenerationBlockStartClosureG__vtbl_");
        this.addMapping("GenerationObjIterateClosure::__vtbl", "__1cbBGenerationObjIterateClosureG__vtbl_");
        this.addMapping("GenerationOopIterateClosure::__vtbl", "__1cbBGenerationOopIterateClosureG__vtbl_");
        this.addMapping("InterpreterCodeletInterface::__vtbl", "__1cbBInterpreterCodeletInterfaceG__vtbl_");
        this.addMapping("JvmdiEventFieldModification::__vtbl", "__1cbBJvmdiEventFieldModificationG__vtbl_");
        this.addMapping("atomic_increment_mem_V8Node::__vtbl", "__1cbBatomic_increment_mem_V8NodeG__vtbl_");
        this.addMapping("atomic_increment_mem_V9Node::__vtbl", "__1cbBatomic_increment_mem_V9NodeG__vtbl_");
        this.addMapping("inlineCallClearArray_v8Node::__vtbl", "__1cbBinlineCallClearArray_v8NodeG__vtbl_");
        this.addMapping("opt_virtual_call_Relocation::__vtbl", "__1cbBopt_virtual_call_RelocationG__vtbl_");
        this.addMapping("CompiledCodeSafepointHandler::__vtbl", "__1cbCCompiledCodeSafepointHandlerG__vtbl_");
        this.addMapping("OneContigSpaceCardGeneration::__vtbl", "__1cbCOneContigSpaceCardGenerationG__vtbl_");
        this.addMapping("compiler_method_oop_regPOper::__vtbl", "__1cbCcompiler_method_oop_regPOperG__vtbl_");
        this.addMapping("SpaceMemRegionOopsIterClosure::__vtbl", "__1cbDSpaceMemRegionOopsIterClosureG__vtbl_");
        this.addMapping("atomic_increment_mem_reg_V8Node::__vtbl", "__1cbFatomic_increment_mem_reg_V8NodeG__vtbl_");
        this.addMapping("atomic_increment_mem_reg_V9Node::__vtbl", "__1cbFatomic_increment_mem_reg_V9NodeG__vtbl_");
        this.addMapping("interpreter_method_oop_regPOper::__vtbl", "__1cbFinterpreter_method_oop_regPOperG__vtbl_");
        this.addMapping("FetchTopFrame_SuspendThreadSelf_Callback::__vtbl", "__1cbOFetchTopFrame_SuspendThreadSelf_CallbackG__vtbl_");
    }
}

