/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.peer.LabelPeer;
import javax.accessibility.Accessible;

public class Label
extends Component
implements Accessible {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    private static final long serialVersionUID = 3094126758329070636L;
    private int alignment;
    private String text;

    public Label() {
        this("", 0);
    }

    public Label(String text) {
        this(text, 0);
    }

    public Label(String text, int alignment) {
        this.setAlignment(alignment);
        this.setText(text);
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
    }

    public int getAlignment() {
        return this.alignment;
    }

    public synchronized void setAlignment(int alignment) {
        if (alignment != 1 && alignment != 0 && alignment != 2) {
            throw new IllegalArgumentException("invalid alignment: " + alignment);
        }
        this.alignment = alignment;
        if (this.peer != null) {
            LabelPeer lp = (LabelPeer)this.peer;
            lp.setAlignment(alignment);
        }
    }

    public String getText() {
        return this.text;
    }

    public synchronized void setText(String text) {
        this.text = text;
        if (this.peer != null) {
            LabelPeer lp = (LabelPeer)this.peer;
            lp.setText(text);
        }
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createLabel(this);
        }
        super.addNotify();
    }

    protected String paramString() {
        return "text=" + this.getText() + ",alignment=" + this.getAlignment() + "," + super.paramString();
    }
}

