/***************************************************************************
                          klatin.cpp  -  description
                             -------------------
    begin                : Thu Jul 17
    copyright            : (C) 2001-2004 by George Wright
    email                : gwright@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qradiobutton.h>

#include <kapplication.h>
#include <kconfigdialog.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kpushbutton.h>
#include <qradiobutton.h>
#include <kstandarddirs.h>

#include <pwd.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>

#include "klatin.h"
#include "settings.h"

KLatin::KLatin(QWidget* parent, const char *name)
	: KMainWindow(parent, name)
{
	m_section = 0;

	// Setup the actions for the menubar
	setupActions();

	// Used for resetting the GUI after leaving
	// a section, but used here to initialise
	// the GUI for the first time.
	resetGUI();
}

KLatin::~KLatin()
{
}

void KLatin::setupActions()
{
	// Setup various menu actions
	KStdAction::preferences(this, SLOT(loadSettings()), actionCollection());
	m_loadVocab = new KAction(i18n("Load &Vocabulary"), 0, this, SLOT(menuVocab()),  actionCollection(), "go_vocab");
	m_loadGrammar = new KAction(i18n("Load &Grammar"), 0, this, SLOT(menuGrammar()),  actionCollection(), "go_grammar");
	m_loadVerbs = new KAction(i18n("Load V&erbs"), 0, this, SLOT(menuVerbs()),  actionCollection(), "go_verbs");
	m_loadRevision = new KAction(i18n("Load &Revision"), 0, this, SLOT(menuRevision()),  actionCollection(), "go_revision");
	m_changeFile = new KAction(i18n("&Load Vocabulary File"), 0, this, SLOT(menuChangeVocab()),  actionCollection(), "load_file");
	KStdAction::quit(kapp, SLOT(quit()), actionCollection());
	m_changeFile->setEnabled(FALSE);
}

void KLatin::startClicked()
{
	if (klatinchoose->VocabOption->isOn())
		loadSection(1);
	if (klatinchoose->GrammarOption->isOn())
		loadSection(2);
	if (klatinchoose->VerbsOption->isOn())
		loadSection(3);
	if (klatinchoose->RevisionOption->isOn())
		loadSection(4);
}

void KLatin::loadSection(int option)
{
	// option is an integer passed to the function
	// stating which radio button was checked when
	// start was clicked.
	//
	// 1 = vocab, 2 = grammar, 3 = verbs and
	// 4 = revision
	switch (option) {
		case 1:
			klatinchoose->close();
			loadVocab();
			break;
		case 2:
			klatinchoose->close();
			loadGrammar();
			break;
		case 3:
			klatinchoose->close();
			loadVerbs();
			break;
		case 4:
			loadRevision();
			break;
		}
}

// Start of section loading code

void KLatin::loadVocab()
{
	klatinchoose->close();
	
	klatinvocabsection = new KLatinVocab(this);
	klatinvocabsection->show();

	// Set this widget as the central widget
	setCentralWidget(klatinvocabsection);

	updateSection(FALSE);
	
	m_changeFile->setEnabled(TRUE);
	// When the child emits the signal exitted(),
	// then reset the GUI to go back to the menu
	connect(klatinvocabsection, SIGNAL(exited()), this, SLOT(resetGUI()));

	// Set the section variable
	m_section = 1;
}

void KLatin::loadGrammar()
{
	klatinchoose->close();
	
	klatingrammarsection = new KLatinGrammar(this);
	klatingrammarsection->show();

	// Disable all the menu entries under Section/
	updateSection(FALSE);
	
	// Set this widget as the central widget
	setCentralWidget(klatingrammarsection);

	// When the child emits the signal exited(),
	// then reset the GUI to go back to the menu
	connect(klatingrammarsection, SIGNAL(exited()), this, SLOT(resetGUI()));

	// Set the section variable
	m_section = 2;
}

void KLatin::loadVerbs()
{
	klatinchoose->close();
	
	klatinverbssection = new KLatinVerbs(this);
	klatinverbssection->show();

	// Disable all the menu entries under Section/
	updateSection(FALSE);

	klatinverbssection->ChangeButton->setIconSet(KGlobal::iconLoader()->loadIconSet("apply", KIcon::Small));
	
	// Set this widget as the central widget
	setCentralWidget(klatinverbssection);

	// When the child emits the signal exited(),
	// then reset the GUI to go back to the menu
	connect(klatinverbssection, SIGNAL(exited()), this, SLOT(resetGUI()));

	// Set the section variable
	m_section = 3;
}

void KLatin::loadRevision()
{
	kapp->invokeHelp("klatin-index");
}

void KLatin::loadSettings()
{
	if (KConfigDialog::showDialog("settings")) 
		return; 

	KConfigDialog *dialog = new KConfigDialog(this, "settings", Settings::self());
	
	vocabPage = new VocabPage(0); 
	dialog->addPage(vocabPage, i18n("Vocabulary"), "kdict"); 
	connect(dialog, SIGNAL(settingsChanged()), this, SLOT(settingsChanged())); 
	dialog->show();
}

void KLatin::settingsChanged()
{
	// Only the vocab section so far needs config refreshed for it
	if (m_section == 1) {
		klatinvocabsection->changeVocab(Settings::defaultFile());
	}
}

void KLatin::resetGUI()
{
	// Load the central widget to show the user the
	// various options that are available to choose
	// and setCentralWidget it.
	klatinchoose = new KLatinChoose(this);
	klatinchoose->show();
	setCentralWidget(klatinchoose);

	// Connect the "Start" button to slot StartPressed()
	connect(klatinchoose->StartButton, SIGNAL(clicked()), this, SLOT(startClicked()));
	// Make the quit button quit the application :)
	connect(klatinchoose->QuitButton, SIGNAL(clicked()), kapp, SLOT(quit()));

	m_changeFile->setEnabled(false);
	// Enable all the menu entries under Section/
	updateSection(TRUE);

	// Use XML GUI to construct the menubar
	setupGUI();

	// Reset the section variable
	m_section = 0;
}

void KLatin::menuVocab()
{
	// Get rid of the opening widget
	klatinchoose->close();

	// Load the vocabulary stuff
	loadVocab();
}

void KLatin::menuGrammar()
{
	// Get rid of the opening widget
	klatinchoose->close();

	// Load the grammar stuff
	loadGrammar();
}

void KLatin::menuVerbs()
{
	// Get rid of the opening widget
	klatinchoose->close();

	// Load the verbs stuff
	loadVerbs();
}

void KLatin::menuRevision()
{
	// Load the revision stuff
	loadRevision();
}

void KLatin::updateSection(bool m_bool)
{
	// Disable all the menu entries under Section/
	m_loadVocab->setEnabled(m_bool);
	m_loadGrammar->setEnabled(m_bool);
	m_loadVerbs->setEnabled(m_bool);
	m_loadRevision->setEnabled(m_bool);
}

void KLatin::menuChangeVocab()
{
	QString vocabdir = "klatin/data/vocabs/";
	vocabdir += Settings::userLanguage();
	vocabdir += "/";
	
	// Load a file dialogue to choose a different vocabulary file
	loadVocabDialog = new KFileDialog(locate("data", vocabdir), "*.kvtml", 0, 0, TRUE);
	loadVocabDialog->show();
	
	connect(loadVocabDialog, SIGNAL(okClicked()), this, SLOT(menuChangeConfirm()));
}

void KLatin::menuChangeConfirm()
{
	// This slot is called when OK is pressed on the file dialogue
	klatinvocabsection->changeVocab(loadVocabDialog->selectedFile());
	Settings::setDefaultFile(loadVocabDialog->selectedFile());
	Settings::writeConfig();
}

#include "klatin.moc"
