/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __applethandle_h__
#define __applethandle_h__

#include <qwidget.h>
#include <qpushbutton.h>

#include "container_applet.h"
class QBoxLayout;
class AppletHandleDrag;
class AppletHandleButton;

class AppletHandle : public QWidget
{
 Q_OBJECT
 public:
  AppletHandle(AppletContainer* parent, const char* name = 0);

  void resetLayout();
  void setFadeOutHandle(bool);

  bool eventFilter (QObject *, QEvent *);

  int widthForHeight( int h ) const;
  int heightForWidth( int w ) const;

  Orientation orientation() const { return _parent->orientation(); }
  Direction popupDirection() const { return _parent->popupDirection(); }

  bool onMenuButton(const QPoint& point) const;

 signals:
  void moveApplet( const QPoint& moveOffset );
  void removeApplet();
  void showAppletMenu();

 public slots:
  void toggleMenuButtonOff();

 protected:
  void enterEvent(QEvent *);
  void leaveEvent(QEvent *);

 protected slots:
  void menuButtonClicked();

 private:
  QPixmap xpmPixmap( const char* const xpm[], const char* key );
  AppletContainer* _parent;
  QBoxLayout* _layout;
  AppletHandleDrag* _drag;
  AppletHandleButton* _menuButton;
  bool _fadeout_handle;
  bool _drawIt;
};

class AppletHandleDrag : public QWidget
{
 Q_OBJECT
 public:
  AppletHandleDrag( AppletHandle* parent , const char* name = 0);

  QSize minimumSizeHint() const;
  QSize minimumSize() const { return minimumSizeHint(); }
  QSize sizeHint() const { return minimumSize(); }
  QSizePolicy sizePolicy() const;

  Orientation orientation() const { return _parent->orientation(); }
  Direction popupDirection() const { return _parent->popupDirection(); }

 protected:
  void paintEvent(QPaintEvent *);

 private:
  AppletHandle* _parent;

};

class AppletHandleButton : public QPushButton
{
  Q_OBJECT
public:
  AppletHandleButton( AppletHandle *parent, const char *name=0 );
  ~AppletHandleButton();
  QSize minimumSizeHint() const;
  QSize minimumSize() const { return minimumSizeHint(); }
  QSize sizeHint() const { return minimumSize(); }
  QSizePolicy sizePolicy() const;

  Orientation orientation() const { return _parent->orientation(); }
  Direction popupDirection() const { return _parent->popupDirection(); }

protected:
  virtual void drawButton( QPainter * );
  virtual void enterEvent( QEvent * );
  virtual void leaveEvent( QEvent * );
  virtual void mousePressEvent(QMouseEvent * e);
  
private:
  AppletHandle* _parent;
  bool moveMouse;
};

#endif
