/* This file is part of the KDE libraries
   Copyright (C) 2001, 2003 Christophe Devriese <oelewapperke@kde.org>
   Copyright (C) 2001  <kurt@granroth.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/
#ifndef _KPDF_SHELL_H_
#define _KPDF_SHELL_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapplication.h>
#include <kparts/mainwindow.h>
class KPopupMenu;
class KAction;

namespace KPDF
{
    class Part;
  /**
   * This is the application "Shell".  It has a menubar, toolbar, and
   * statusbar but relies on the "Part" to do all the real work.
   *
   * @short Application Shell
   * @author Wilco Greven <greven@kde.org>
   * @version 0.1
   */
  class Shell : public KParts::MainWindow
  {
    Q_OBJECT

  public:
    /**
     * Default Constructor
     */
    Shell();

    /**
     * Default Destructor
     */
    virtual ~Shell();

  protected:
    /**
     * This method is called when it is time for the app to save its
     * properties for session management purposes.
     */
    void saveProperties(KConfig*);

    /**
     * This method is called when this app is restored.  The KConfig
     * object points to the session management config file that was saved
     * with @ref saveProperties
     */
    void readProperties(KConfig*);
    void readSettings();
    void writeSettings();
    void setFullScreen( bool );

  private slots:
    void fileOpen();
    void fileSaveAs();

    void optionsConfigureKeys();
    void optionsConfigureToolbars();
    void slotQuit();

    void applyNewToolbarConfig();
      void slotUpdateFullScreen();
      void slotRMBClick();
      void slotShowMenubar();

  public slots:
      void openURL( const KURL & url );

  private:
    void setupAccel();
    void setupActions();

  private:
      KParts::ReadOnlyPart* m_part;
      KRecentFilesAction* recent;
      KToggleAction* m_fullScreenAction;
      bool m_isFullScreen;
      KPopupMenu* m_popup;
      KToggleAction *m_showMenuBarAction;
  };

}

#endif

// vim:ts=2:sw=2:tw=78:et
