/*  
 *  xconvers - GTK+ client for amateur radio convers
 *  Copyright (C) 2000-2003 Joop Stakenborg <pa4tu@amsat.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
/*
 *  main.c - start of gtk loop.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <gtk/gtk.h>
#include "interface.h"
#include "support.h"
#include "history.h"
#include "preferences.h"
#include "types.h"
#include "utils.h"

GtkWidget *mainwindow;
extern preferencestype preferences;

/*
 * The program starts here. After gtk_main is called the behaviour of the 
 * program strictly depends user action. See callbacks.c for callbacks
 * generated by widgets (buttons, windows and menus) and all other C files
 * for private functions.
 */
 
int
main(int argc, char *argv[])
{
  GdkBitmap *mask;
  GdkPixmap *pixmap;
  GtkStyle *maintextstyle;
  GtkWidget *maintext;
  gint x, y, width, heigth;
  gchar *lang;

  /* language support */
  bindtextdomain(PACKAGE, PACKAGE_LOCALE_DIR);
  textdomain(PACKAGE);
  lang = gtk_set_locale(); /* don't free lang */

  gtk_init(&argc, &argv);
  add_pixmap_directory(PACKAGE_DATA_DIR "/pixmaps");
  add_pixmap_directory(PACKAGE_SOURCE_DIR "/pixmaps");

  dircheck();
  loadpreferences();
  loadhistory();

  mainwindow = create_mainwindow();
  gtk_widget_show(mainwindow);

  /* Set the title */
  set_title(mainwindow, "%s");
  /* Set the minimalized-window icon and title */
  set_icon(mainwindow, PACKAGE);

  /* get current window size */
  gdk_window_get_size(mainwindow->window, &width, &heigth);
  gdk_window_get_root_origin(mainwindow->window, &x, &y);

  /* position the main window */
  if (preferences.size && !preferences.origin) 
    gdk_window_move_resize(mainwindow->window, x, y, preferences.width, preferences.height);
  else if (preferences.origin && preferences.size) 
    gdk_window_move_resize(mainwindow->window, preferences.x, preferences.y, preferences.width, preferences.height);
  else if (!preferences.size && preferences.origin) 
    gdk_window_move_resize(mainwindow->window, preferences.x, preferences.y, width, heigth);

  /* Set the background depending on whether we have recalled a pixmap or not */
  maintext = lookup_widget(mainwindow, "maintext");
  if (preferences.backgroundpixmap) 
  { 
    if (preferences.backgroundpixmap->len > 0)
    {
      pixmap = gdk_pixmap_create_from_xpm(maintext->window, &mask, NULL, preferences.backgroundpixmap->str);
      maintextstyle = gtk_style_copy(maintext->style);
      gtk_style_ref(maintextstyle);
      maintextstyle->bg_pixmap[GTK_STATE_NORMAL] = pixmap;
      gtk_widget_set_style(maintext, maintextstyle);
      gtk_style_unref(maintextstyle);
    }
  }
  else
  {
    maintextstyle = gtk_style_new();
    maintextstyle->base[GTK_STATE_NORMAL] = preferences.backgroundcolor;
    maintextstyle->base[GTK_STATE_INSENSITIVE] = preferences.backgroundcolor;
    gtk_widget_set_style(maintext, maintextstyle);
  }

  gtk_main();
  return 0;
}
