/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.x500.X500Principal;
import sun.net.util.IPAddressUtil;
import sun.security.krb5.PrincipalName;
import sun.security.util.DerValue;
import sun.security.x509.X500Name;

public class HostnameChecker {
    public static final byte TYPE_TLS = 1;
    private static final HostnameChecker INSTANCE_TLS = new HostnameChecker(1);
    public static final byte TYPE_LDAP = 2;
    private static final HostnameChecker INSTANCE_LDAP = new HostnameChecker(2);
    private static final int ALTNAME_DNS = 2;
    private static final int ALTNAME_IP = 7;
    private final byte checkType;

    private HostnameChecker(byte by) {
        this.checkType = by;
    }

    public static HostnameChecker getInstance(byte by) {
        if (by == 1) {
            return INSTANCE_TLS;
        }
        if (by == 2) {
            return INSTANCE_LDAP;
        }
        throw new IllegalArgumentException("Unknown check type: " + by);
    }

    public void match(String string, X509Certificate x509Certificate) throws CertificateException {
        if (HostnameChecker.isIpAddress(string)) {
            HostnameChecker.matchIP(string, x509Certificate);
        } else {
            this.matchDNS(string, x509Certificate);
        }
    }

    public static boolean match(String string, KerberosPrincipal kerberosPrincipal) {
        String string2 = HostnameChecker.getServerName(kerberosPrincipal);
        return string.equalsIgnoreCase(string2);
    }

    public static String getServerName(KerberosPrincipal kerberosPrincipal) {
        if (kerberosPrincipal == null) {
            return null;
        }
        String string = null;
        try {
            PrincipalName principalName = new PrincipalName(kerberosPrincipal.getName(), 3);
            String[] stringArray = principalName.getNameStrings();
            if (stringArray.length >= 2) {
                string = stringArray[1];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private static boolean isIpAddress(String string) {
        return IPAddressUtil.isIPv4LiteralAddress(string) || IPAddressUtil.isIPv6LiteralAddress(string);
    }

    private static void matchIP(String string, X509Certificate x509Certificate) throws CertificateException {
        Collection<List<?>> collection = x509Certificate.getSubjectAlternativeNames();
        if (collection == null) {
            throw new CertificateException("No subject alternative names present");
        }
        for (List<?> list : collection) {
            String string2;
            if ((Integer)list.get(0) != 7 || !string.equalsIgnoreCase(string2 = (String)list.get(1))) continue;
            return;
        }
        throw new CertificateException("No subject alternative names matching IP address " + string + " found");
    }

    private void matchDNS(String string, X509Certificate x509Certificate) throws CertificateException {
        X500Name x500Name;
        Object object;
        Object object2;
        Collection<List<?>> collection = x509Certificate.getSubjectAlternativeNames();
        if (collection != null) {
            boolean bl2 = false;
            object2 = collection.iterator();
            while (object2.hasNext()) {
                object = (List)object2.next();
                if ((Integer)object.get(0) != 2) continue;
                bl2 = true;
                String string2 = (String)object.get(1);
                if (!this.isMatched(string, string2)) continue;
                return;
            }
            if (bl2) {
                throw new CertificateException("No subject alternative DNS name matching " + string + " found.");
            }
        }
        if ((object2 = (x500Name = HostnameChecker.getSubjectX500Name(x509Certificate)).findMostSpecificAttribute(X500Name.commonName_oid)) != null) {
            try {
                if (this.isMatched(string, ((DerValue)object2).getAsString())) {
                    return;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        object = "No name matching " + string + " found";
        throw new CertificateException((String)object);
    }

    public static X500Name getSubjectX500Name(X509Certificate x509Certificate) throws CertificateParsingException {
        try {
            Principal principal = x509Certificate.getSubjectDN();
            if (principal instanceof X500Name) {
                return (X500Name)principal;
            }
            X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
            return new X500Name(x500Principal.getEncoded());
        }
        catch (IOException iOException) {
            throw (CertificateParsingException)new CertificateParsingException().initCause(iOException);
        }
    }

    private boolean isMatched(String string, String string2) {
        if (this.checkType == 1) {
            return HostnameChecker.matchAllWildcards(string, string2);
        }
        if (this.checkType == 2) {
            return HostnameChecker.matchLeftmostWildcard(string, string2);
        }
        return false;
    }

    private static boolean matchAllWildcards(String string, String string2) {
        string = string.toLowerCase();
        string2 = string2.toLowerCase();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".");
        if (stringTokenizer.countTokens() != stringTokenizer2.countTokens()) {
            return false;
        }
        while (stringTokenizer.hasMoreTokens()) {
            if (HostnameChecker.matchWildCards(stringTokenizer.nextToken(), stringTokenizer2.nextToken())) continue;
            return false;
        }
        return true;
    }

    private static boolean matchLeftmostWildcard(String string, String string2) {
        string = string.toLowerCase();
        string2 = string2.toLowerCase();
        int n2 = string2.indexOf(".");
        int n3 = string.indexOf(".");
        if (n2 == -1) {
            n2 = string2.length();
        }
        if (n3 == -1) {
            n3 = string.length();
        }
        if (HostnameChecker.matchWildCards(string.substring(0, n3), string2.substring(0, n2))) {
            return string2.substring(n2).equals(string.substring(n3));
        }
        return false;
    }

    private static boolean matchWildCards(String string, String string2) {
        int n2 = string2.indexOf("*");
        if (n2 == -1) {
            return string.equals(string2);
        }
        boolean bl2 = true;
        String string3 = "";
        String string4 = string2;
        while (n2 != -1) {
            string3 = string4.substring(0, n2);
            string4 = string4.substring(n2 + 1);
            int n3 = string.indexOf(string3);
            if (n3 == -1 || bl2 && n3 != 0) {
                return false;
            }
            bl2 = false;
            string = string.substring(n3 + string3.length());
            n2 = string4.indexOf("*");
        }
        return string.endsWith(string4);
    }
}

