/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import com.sun.java.swing.SwingUtilities2;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.BreakIterator;
import javax.swing.JComponent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.CompositeView;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.GlyphView;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SegmentCache;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabExpander;
import javax.swing.text.View;

public class Utilities {
    static JComponent getJComponent(View view) {
        Container container;
        if (view != null && (container = view.getContainer()) instanceof JComponent) {
            return (JComponent)container;
        }
        return null;
    }

    public static final int drawTabbedText(Segment segment, int n2, int n3, Graphics graphics, TabExpander tabExpander, int n4) {
        return Utilities.drawTabbedText(null, segment, n2, n3, graphics, tabExpander, n4);
    }

    static final int drawTabbedText(View view, Segment segment, int n2, int n3, Graphics graphics, TabExpander tabExpander, int n4) {
        JComponent jComponent = Utilities.getJComponent(view);
        FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(jComponent, graphics);
        int n5 = n2;
        char[] cArray = segment.array;
        int n6 = segment.offset;
        int n7 = 0;
        int n8 = segment.offset;
        int n9 = segment.offset + segment.count;
        for (int i2 = n6; i2 < n9; ++i2) {
            if (cArray[i2] == '\t') {
                if (n7 > 0) {
                    n5 = SwingUtilities2.drawChars(jComponent, graphics, cArray, n8, n7, n2, n3);
                    n7 = 0;
                }
                n8 = i2 + 1;
                n5 = tabExpander != null ? (int)tabExpander.nextTabStop(n5, n4 + i2 - n6) : (n5 += fontMetrics.charWidth(' '));
                n2 = n5;
                continue;
            }
            if (cArray[i2] == '\n' || cArray[i2] == '\r') {
                if (n7 > 0) {
                    n5 = SwingUtilities2.drawChars(jComponent, graphics, cArray, n8, n7, n2, n3);
                    n7 = 0;
                }
                n8 = i2 + 1;
                n2 = n5;
                continue;
            }
            ++n7;
        }
        if (n7 > 0) {
            n5 = SwingUtilities2.drawChars(jComponent, graphics, cArray, n8, n7, n2, n3);
        }
        return n5;
    }

    public static final int getTabbedTextWidth(Segment segment, FontMetrics fontMetrics, int n2, TabExpander tabExpander, int n3) {
        int n4 = n2;
        char[] cArray = segment.array;
        int n5 = segment.offset;
        int n6 = segment.offset + segment.count;
        int n7 = 0;
        for (int i2 = n5; i2 < n6; ++i2) {
            if (cArray[i2] == '\t') {
                n4 += fontMetrics.charsWidth(cArray, i2 - n7, n7);
                n7 = 0;
                if (tabExpander != null) {
                    n4 = (int)tabExpander.nextTabStop(n4, n3 + i2 - n5);
                    continue;
                }
                n4 += fontMetrics.charWidth(' ');
                continue;
            }
            if (cArray[i2] == '\n') {
                n4 += fontMetrics.charsWidth(cArray, i2 - n7, n7);
                n7 = 0;
                continue;
            }
            ++n7;
        }
        return (n4 += fontMetrics.charsWidth(cArray, n6 - n7, n7)) - n2;
    }

    public static final int getTabbedTextOffset(Segment segment, FontMetrics fontMetrics, int n2, int n3, TabExpander tabExpander, int n4) {
        return Utilities.getTabbedTextOffset(segment, fontMetrics, n2, n3, tabExpander, n4, true);
    }

    public static final int getTabbedTextOffset(Segment segment, FontMetrics fontMetrics, int n2, int n3, TabExpander tabExpander, int n4, boolean bl2) {
        int n5;
        if (n2 >= n3) {
            return 0;
        }
        int n6 = n5 = n2;
        char[] cArray = segment.array;
        int n7 = segment.offset;
        int n8 = segment.count;
        int n9 = segment.offset + segment.count;
        for (int i2 = segment.offset; i2 < n9; ++i2) {
            n6 = cArray[i2] == '\t' ? (tabExpander != null ? (int)tabExpander.nextTabStop(n6, n4 + i2 - n7) : (n6 += fontMetrics.charWidth(' '))) : (n6 += fontMetrics.charWidth(cArray[i2]));
            if (n3 >= n5 && n3 < n6) {
                if (!bl2 || n3 - n5 < n6 - n3) {
                    return i2 - n7;
                }
                return i2 + 1 - n7;
            }
            n5 = n6;
        }
        return n8;
    }

    public static final int getBreakLocation(Segment segment, FontMetrics fontMetrics, int n2, int n3, TabExpander tabExpander, int n4) {
        char[] cArray = segment.array;
        int n5 = segment.offset;
        int n6 = segment.count;
        int n7 = Utilities.getTabbedTextOffset(segment, fontMetrics, n2, n3, tabExpander, n4, false);
        if (n7 >= n6 - 1) {
            return n6;
        }
        for (int i2 = n5 + n7; i2 >= n5; --i2) {
            char c2 = cArray[i2];
            if (c2 < '\u0100') {
                if (!Character.isWhitespace(c2)) continue;
                n7 = i2 - n5 + 1;
                break;
            }
            BreakIterator breakIterator = BreakIterator.getLineInstance();
            breakIterator.setText(segment);
            int n8 = breakIterator.preceding(i2 + 1);
            if (n8 <= n5) break;
            n7 = n8 - n5;
            break;
        }
        return n7;
    }

    public static final int getRowStart(JTextComponent jTextComponent, int n2) throws BadLocationException {
        Rectangle rectangle = jTextComponent.modelToView(n2);
        if (rectangle == null) {
            return -1;
        }
        int n3 = n2;
        int n4 = rectangle.y;
        while (rectangle != null && n4 == rectangle.y) {
            n2 = n3--;
            rectangle = n3 >= 0 ? jTextComponent.modelToView(n3) : null;
        }
        return n2;
    }

    public static final int getRowEnd(JTextComponent jTextComponent, int n2) throws BadLocationException {
        Rectangle rectangle = jTextComponent.modelToView(n2);
        if (rectangle == null) {
            return -1;
        }
        int n3 = jTextComponent.getDocument().getLength();
        int n4 = n2;
        int n5 = rectangle.y;
        while (rectangle != null && n5 == rectangle.y) {
            n2 = n4++;
            rectangle = n4 <= n3 ? jTextComponent.modelToView(n4) : null;
        }
        return n2;
    }

    public static final int getPositionAbove(JTextComponent jTextComponent, int n2, int n3) throws BadLocationException {
        int n4 = Utilities.getRowStart(jTextComponent, n2) - 1;
        if (n4 < 0) {
            return -1;
        }
        int n5 = Integer.MAX_VALUE;
        int n6 = 0;
        Rectangle rectangle = null;
        if (n4 >= 0) {
            rectangle = jTextComponent.modelToView(n4);
            n6 = rectangle.y;
        }
        while (rectangle != null && n6 == rectangle.y) {
            int n7 = Math.abs(rectangle.x - n3);
            if (n7 < n5) {
                n2 = n4;
                n5 = n7;
            }
            rectangle = --n4 >= 0 ? jTextComponent.modelToView(n4) : null;
        }
        return n2;
    }

    public static final int getPositionBelow(JTextComponent jTextComponent, int n2, int n3) throws BadLocationException {
        int n4 = Utilities.getRowEnd(jTextComponent, n2) + 1;
        if (n4 <= 0) {
            return -1;
        }
        int n5 = Integer.MAX_VALUE;
        int n6 = jTextComponent.getDocument().getLength();
        int n7 = 0;
        Rectangle rectangle = null;
        if (n4 <= n6) {
            rectangle = jTextComponent.modelToView(n4);
            n7 = rectangle.y;
        }
        while (rectangle != null && n7 == rectangle.y) {
            int n8 = Math.abs(n3 - rectangle.x);
            if (n8 < n5) {
                n2 = n4;
                n5 = n8;
            }
            rectangle = ++n4 <= n6 ? jTextComponent.modelToView(n4) : null;
        }
        return n2;
    }

    public static final int getWordStart(JTextComponent jTextComponent, int n2) throws BadLocationException {
        Document document = jTextComponent.getDocument();
        Element element = Utilities.getParagraphElement(jTextComponent, n2);
        if (element == null) {
            throw new BadLocationException("No word at " + n2, n2);
        }
        int n3 = element.getStartOffset();
        int n4 = Math.min(element.getEndOffset(), document.getLength());
        Segment segment = SegmentCache.getSharedSegment();
        document.getText(n3, n4 - n3, segment);
        if (segment.count > 0) {
            BreakIterator breakIterator = BreakIterator.getWordInstance(jTextComponent.getLocale());
            breakIterator.setText(segment);
            int n5 = segment.offset + n2 - n3;
            if (n5 >= breakIterator.last()) {
                n5 = breakIterator.last() - 1;
            }
            breakIterator.following(n5);
            n2 = n3 + breakIterator.previous() - segment.offset;
        }
        SegmentCache.releaseSharedSegment(segment);
        return n2;
    }

    public static final int getWordEnd(JTextComponent jTextComponent, int n2) throws BadLocationException {
        Document document = jTextComponent.getDocument();
        Element element = Utilities.getParagraphElement(jTextComponent, n2);
        if (element == null) {
            throw new BadLocationException("No word at " + n2, n2);
        }
        int n3 = element.getStartOffset();
        int n4 = Math.min(element.getEndOffset(), document.getLength());
        Segment segment = SegmentCache.getSharedSegment();
        document.getText(n3, n4 - n3, segment);
        if (segment.count > 0) {
            BreakIterator breakIterator = BreakIterator.getWordInstance(jTextComponent.getLocale());
            breakIterator.setText(segment);
            int n5 = n2 - n3 + segment.offset;
            if (n5 >= breakIterator.last()) {
                n5 = breakIterator.last() - 1;
            }
            n2 = n3 + breakIterator.following(n5) - segment.offset;
        }
        SegmentCache.releaseSharedSegment(segment);
        return n2;
    }

    public static final int getNextWord(JTextComponent jTextComponent, int n2) throws BadLocationException {
        Element element = Utilities.getParagraphElement(jTextComponent, n2);
        int n3 = Utilities.getNextWordInParagraph(jTextComponent, element, n2, false);
        while (n3 == -1) {
            n2 = element.getEndOffset();
            element = Utilities.getParagraphElement(jTextComponent, n2);
            n3 = Utilities.getNextWordInParagraph(jTextComponent, element, n2, true);
        }
        return n3;
    }

    static int getNextWordInParagraph(JTextComponent jTextComponent, Element element, int n2, boolean bl2) throws BadLocationException {
        if (element == null) {
            throw new BadLocationException("No more words", n2);
        }
        Document document = element.getDocument();
        int n3 = element.getStartOffset();
        int n4 = Math.min(element.getEndOffset(), document.getLength());
        if (n2 >= n4 || n2 < n3) {
            throw new BadLocationException("No more words", n2);
        }
        Segment segment = SegmentCache.getSharedSegment();
        document.getText(n3, n4 - n3, segment);
        BreakIterator breakIterator = BreakIterator.getWordInstance(jTextComponent.getLocale());
        breakIterator.setText(segment);
        if (bl2 && breakIterator.first() == segment.offset + n2 - n3 && !Character.isWhitespace(segment.array[breakIterator.first()])) {
            return n2;
        }
        int n5 = breakIterator.following(segment.offset + n2 - n3);
        if (n5 == -1 || n5 >= segment.offset + segment.count) {
            return -1;
        }
        char c2 = segment.array[n5];
        if (!Character.isWhitespace(c2)) {
            return n3 + n5 - segment.offset;
        }
        n5 = breakIterator.next();
        if (n5 != -1 && (n2 = n3 + n5 - segment.offset) != n4) {
            return n2;
        }
        SegmentCache.releaseSharedSegment(segment);
        return -1;
    }

    public static final int getPreviousWord(JTextComponent jTextComponent, int n2) throws BadLocationException {
        Element element = Utilities.getParagraphElement(jTextComponent, n2);
        int n3 = Utilities.getPrevWordInParagraph(jTextComponent, element, n2);
        while (n3 == -1) {
            n2 = element.getStartOffset() - 1;
            element = Utilities.getParagraphElement(jTextComponent, n2);
            n3 = Utilities.getPrevWordInParagraph(jTextComponent, element, n2);
        }
        return n3;
    }

    static int getPrevWordInParagraph(JTextComponent jTextComponent, Element element, int n2) throws BadLocationException {
        int n3;
        if (element == null) {
            throw new BadLocationException("No more words", n2);
        }
        Document document = element.getDocument();
        int n4 = element.getStartOffset();
        int n5 = element.getEndOffset();
        if (n2 > n5 || n2 < n4) {
            throw new BadLocationException("No more words", n2);
        }
        Segment segment = SegmentCache.getSharedSegment();
        document.getText(n4, n5 - n4, segment);
        BreakIterator breakIterator = BreakIterator.getWordInstance(jTextComponent.getLocale());
        breakIterator.setText(segment);
        if (breakIterator.following(segment.offset + n2 - n4) == -1) {
            breakIterator.last();
        }
        if ((n3 = breakIterator.previous()) == segment.offset + n2 - n4) {
            n3 = breakIterator.previous();
        }
        if (n3 == -1) {
            return -1;
        }
        char c2 = segment.array[n3];
        if (!Character.isWhitespace(c2)) {
            return n4 + n3 - segment.offset;
        }
        n3 = breakIterator.previous();
        if (n3 != -1) {
            return n4 + n3 - segment.offset;
        }
        SegmentCache.releaseSharedSegment(segment);
        return -1;
    }

    public static final Element getParagraphElement(JTextComponent jTextComponent, int n2) {
        int n3;
        Document document = jTextComponent.getDocument();
        if (document instanceof StyledDocument) {
            return ((StyledDocument)document).getParagraphElement(n2);
        }
        Element element = document.getDefaultRootElement();
        Element element2 = element.getElement(n3 = element.getElementIndex(n2));
        if (n2 >= element2.getStartOffset() && n2 < element2.getEndOffset()) {
            return element2;
        }
        return null;
    }

    static boolean isComposedTextElement(Document document, int n2) {
        Element element = document.getDefaultRootElement();
        while (!element.isLeaf()) {
            element = element.getElement(element.getElementIndex(n2));
        }
        return Utilities.isComposedTextElement(element);
    }

    static boolean isComposedTextElement(Element element) {
        AttributeSet attributeSet = element.getAttributes();
        return Utilities.isComposedTextAttributeDefined(attributeSet);
    }

    static boolean isComposedTextAttributeDefined(AttributeSet attributeSet) {
        return attributeSet != null && attributeSet.isDefined(StyleConstants.ComposedTextAttribute);
    }

    static int drawComposedText(View view, AttributeSet attributeSet, Graphics graphics, int n2, int n3, int n4, int n5) throws BadLocationException {
        Graphics2D graphics2D = (Graphics2D)graphics;
        AttributedString attributedString = (AttributedString)attributeSet.getAttribute(StyleConstants.ComposedTextAttribute);
        attributedString.addAttribute(TextAttribute.FONT, graphics.getFont());
        if (n4 >= n5) {
            return n2;
        }
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator(null, n4, n5);
        return n2 + (int)SwingUtilities2.drawString(Utilities.getJComponent(view), (Graphics)graphics2D, attributedCharacterIterator, n2, n3);
    }

    static void paintComposedText(Graphics graphics, Rectangle rectangle, GlyphView glyphView) {
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n2 = glyphView.getStartOffset();
            int n3 = glyphView.getEndOffset();
            AttributeSet attributeSet = glyphView.getElement().getAttributes();
            AttributedString attributedString = (AttributedString)attributeSet.getAttribute(StyleConstants.ComposedTextAttribute);
            int n4 = glyphView.getElement().getStartOffset();
            int n5 = rectangle.y + rectangle.height - (int)glyphView.getGlyphPainter().getDescent(glyphView);
            int n6 = rectangle.x;
            attributedString.addAttribute(TextAttribute.FONT, glyphView.getFont());
            attributedString.addAttribute(TextAttribute.FOREGROUND, glyphView.getForeground());
            if (StyleConstants.isBold(glyphView.getAttributes())) {
                attributedString.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            }
            if (StyleConstants.isItalic(glyphView.getAttributes())) {
                attributedString.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            }
            if (glyphView.isUnderline()) {
                attributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            }
            if (glyphView.isStrikeThrough()) {
                attributedString.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            }
            if (glyphView.isSuperscript()) {
                attributedString.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER);
            }
            if (glyphView.isSubscript()) {
                attributedString.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB);
            }
            AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator(null, n2 - n4, n3 - n4);
            SwingUtilities2.drawString(Utilities.getJComponent(glyphView), (Graphics)graphics2D, attributedCharacterIterator, n6, n5);
        }
    }

    static boolean isLeftToRight(Component component) {
        return component.getComponentOrientation().isLeftToRight();
    }

    static int getNextVisualPositionFrom(View view, int n2, Position.Bias bias, Shape shape, int n3, Position.Bias[] biasArray) throws BadLocationException {
        int n4;
        boolean bl2;
        if (view.getViewCount() == 0) {
            return n2;
        }
        boolean bl3 = bl2 = n3 == 1 || n3 == 7;
        if (n2 == -1) {
            Shape shape2;
            int n5 = bl2 ? view.getViewCount() - 1 : 0;
            View view2 = view.getView(n5);
            n4 = view2.getNextVisualPositionFrom(n2, bias, shape2 = view.getChildAllocation(n5, shape), n3, biasArray);
            if (n4 == -1 && !bl2 && view.getViewCount() > 1) {
                view2 = view.getView(1);
                shape2 = view.getChildAllocation(1, shape);
                n4 = view2.getNextVisualPositionFrom(-1, biasArray[0], shape2, n3, biasArray);
            }
        } else {
            int n6 = bl2 ? -1 : 1;
            int n7 = bias == Position.Bias.Backward && n2 > 0 ? view.getViewIndex(n2 - 1, Position.Bias.Forward) : view.getViewIndex(n2, Position.Bias.Forward);
            View view3 = view.getView(n7);
            Shape shape3 = view.getChildAllocation(n7, shape);
            n4 = view3.getNextVisualPositionFrom(n2, bias, shape3, n3, biasArray);
            if ((n3 == 3 || n3 == 7) && view instanceof CompositeView && ((CompositeView)view).flipEastAndWestAtEnds(n2, bias)) {
                n6 *= -1;
            }
            if (n4 == -1 && (n7 += n6) >= 0 && n7 < view.getViewCount()) {
                view3 = view.getView(n7);
                n4 = view3.getNextVisualPositionFrom(-1, bias, shape3 = view.getChildAllocation(n7, shape), n3, biasArray);
                if (n4 == n2 && biasArray[0] != bias) {
                    return Utilities.getNextVisualPositionFrom(view, n2, biasArray[0], shape, n3, biasArray);
                }
            } else if (n4 != -1 && biasArray[0] != bias && (n6 == 1 && view3.getEndOffset() == n4 || n6 == -1 && view3.getStartOffset() == n4) && n7 >= 0 && n7 < view.getViewCount()) {
                view3 = view.getView(n7);
                shape3 = view.getChildAllocation(n7, shape);
                Position.Bias bias2 = biasArray[0];
                int n8 = view3.getNextVisualPositionFrom(-1, bias, shape3, n3, biasArray);
                if (biasArray[0] == bias) {
                    n4 = n8;
                } else {
                    biasArray[0] = bias2;
                }
            }
        }
        return n4;
    }
}

