/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.auth;

import java.io.Serializable;
import java.security.Principal;
import java.text.MessageFormat;
import sun.security.util.ResourcesMgr;

public class UnixNumericGroupPrincipal
implements Principal,
Serializable {
    private static final long serialVersionUID = 3941535899328403223L;
    private String name;
    private boolean primaryGroup;

    public UnixNumericGroupPrincipal(String string, boolean bl2) {
        if (string == null) {
            MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("invalid null input: value", "sun.security.util.AuthResources"));
            Object[] objectArray = new Object[]{"name"};
            throw new NullPointerException(messageFormat.format(objectArray));
        }
        this.name = string;
        this.primaryGroup = bl2;
    }

    public UnixNumericGroupPrincipal(long l2, boolean bl2) {
        this.name = new Long(l2).toString();
        this.primaryGroup = bl2;
    }

    public String getName() {
        return this.name;
    }

    public long longValue() {
        return new Long(this.name);
    }

    public boolean isPrimaryGroup() {
        return this.primaryGroup;
    }

    public String toString() {
        if (this.primaryGroup) {
            MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("UnixNumericGroupPrincipal [Primary Group]: name", "sun.security.util.AuthResources"));
            Object[] objectArray = new Object[]{this.name};
            return messageFormat.format(objectArray);
        }
        MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("UnixNumericGroupPrincipal [Supplementary Group]: name", "sun.security.util.AuthResources"));
        Object[] objectArray = new Object[]{this.name};
        return messageFormat.format(objectArray);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof UnixNumericGroupPrincipal)) {
            return false;
        }
        UnixNumericGroupPrincipal unixNumericGroupPrincipal = (UnixNumericGroupPrincipal)object;
        return this.getName().equals(unixNumericGroupPrincipal.getName()) && this.isPrimaryGroup() == unixNumericGroupPrincipal.isPrimaryGroup();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

