/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.toolkit.url;

import java.net.MalformedURLException;

public class Uri {
    protected String uri;
    protected String scheme;
    protected String host = null;
    protected int port = -1;
    protected boolean hasAuthority;
    protected String path;
    protected String query = null;

    public Uri(String string) throws MalformedURLException {
        this.init(string);
    }

    protected Uri() {
    }

    protected void init(String string) throws MalformedURLException {
        this.uri = string;
        this.parse(string);
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.query;
    }

    public String toString() {
        return this.uri;
    }

    private void parse(String string) throws MalformedURLException {
        int n2;
        int n3 = string.indexOf(58);
        if (n3 < 0) {
            throw new MalformedURLException("Invalid URI: " + string);
        }
        this.scheme = string.substring(0, n3);
        this.hasAuthority = string.startsWith("//", ++n3);
        if (this.hasAuthority) {
            n2 = string.indexOf(47, n3 += 2);
            if (n2 < 0) {
                n2 = string.length();
            }
            if (string.startsWith("[", n3)) {
                int n4 = string.indexOf(93, n3 + 1);
                if (n4 < 0 || n4 > n2) {
                    throw new MalformedURLException("Invalid URI: " + string);
                }
                this.host = string.substring(n3, n4 + 1);
                n3 = n4 + 1;
            } else {
                int n5;
                int n6 = string.indexOf(58, n3);
                int n7 = n5 = n6 < 0 || n6 > n2 ? n2 : n6;
                if (n3 < n5) {
                    this.host = string.substring(n3, n5);
                }
                n3 = n5;
            }
            if (n3 + 1 < n2 && string.startsWith(":", n3)) {
                this.port = Integer.parseInt(string.substring(++n3, n2));
            }
            n3 = n2;
        }
        if ((n2 = string.indexOf(63, n3)) < 0) {
            this.path = string.substring(n3);
        } else {
            this.path = string.substring(n3, n2);
            this.query = string.substring(n2);
        }
    }
}

