/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayoutInfo;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Hashtable;

public class GridBagLayout
implements Serializable,
LayoutManager2 {
    private static final long serialVersionUID = 8838754796412211005L;
    protected static final int MINSIZE = 1;
    protected static final int PREFERREDSIZE = 2;
    protected static final int MAXGRIDSIZE = 512;
    protected Hashtable comptable = new Hashtable();
    protected GridBagLayoutInfo layoutInfo;
    protected GridBagConstraints defaultConstraints = new GridBagConstraints();
    public double[] columnWeights;
    public int[] columnWidths;
    public double[] rowWeights;
    public int[] rowHeights;

    private int sumIntArray(int[] array, int upto) {
        int result = 0;
        for (int i = 0; i < upto; ++i) {
            result += array[i];
        }
        return result;
    }

    private int sumIntArray(int[] array) {
        return this.sumIntArray(array, array.length);
    }

    private double sumDoubleArray(double[] array) {
        double result = 0.0;
        for (int i = 0; i < array.length; ++i) {
            result += array[i];
        }
        return result;
    }

    public void addLayoutComponent(String name, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public void addLayoutComponent(Component component, Object constraints) {
        if (constraints == null) {
            return;
        }
        if (!(constraints instanceof GridBagConstraints)) {
            throw new IllegalArgumentException();
        }
        this.setConstraints(component, (GridBagConstraints)constraints);
    }

    public Dimension preferredLayoutSize(Container parent) {
        if (parent == null) {
            return new Dimension(0, 0);
        }
        GridBagLayoutInfo li = this.getLayoutInfo(parent, 2);
        return this.getMinSize(parent, li);
    }

    public Dimension minimumLayoutSize(Container parent) {
        if (parent == null) {
            return new Dimension(0, 0);
        }
        GridBagLayoutInfo li = this.getLayoutInfo(parent, 1);
        return this.getMinSize(parent, li);
    }

    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void layoutContainer(Container parent) {
        this.arrangeGrid(parent);
    }

    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    public void invalidateLayout(Container target) {
        this.layoutInfo = null;
    }

    public void setConstraints(Component component, GridBagConstraints constraints) {
        GridBagConstraints clone = (GridBagConstraints)constraints.clone();
        if (clone.gridx < 0) {
            clone.gridx = -1;
        }
        if (clone.gridy < 0) {
            clone.gridy = -1;
        }
        if (clone.gridwidth == 0) {
            clone.gridwidth = 0;
        } else if (clone.gridwidth < 0 && clone.gridwidth != 0 && clone.gridwidth != -1) {
            clone.gridwidth = 1;
        }
        if (clone.gridheight == 0) {
            clone.gridheight = 0;
        } else if (clone.gridheight < 0 && clone.gridheight != 0 && clone.gridheight != -1) {
            clone.gridheight = 1;
        }
        this.comptable.put(component, clone);
    }

    public GridBagConstraints getConstraints(Component component) {
        return (GridBagConstraints)this.lookupConstraints(component).clone();
    }

    protected GridBagConstraints lookupConstraints(Component component) {
        GridBagConstraints result = (GridBagConstraints)this.comptable.get(component);
        if (result == null) {
            this.setConstraints(component, this.defaultConstraints);
            result = (GridBagConstraints)this.comptable.get(component);
        }
        return result;
    }

    public Point getLayoutOrigin() {
        if (this.layoutInfo == null) {
            return new Point(0, 0);
        }
        return new Point(this.layoutInfo.pos_x, this.layoutInfo.pos_y);
    }

    public int[][] getLayoutDimensions() {
        int[][] result = new int[2][];
        if (this.layoutInfo == null) {
            result[0] = new int[0];
            result[1] = new int[0];
            return result;
        }
        result[0] = new int[this.layoutInfo.cols];
        System.arraycopy(this.layoutInfo.colWidths, 0, result[0], 0, this.layoutInfo.cols);
        result[1] = new int[this.layoutInfo.rows];
        System.arraycopy(this.layoutInfo.rowHeights, 0, result[1], 0, this.layoutInfo.rows);
        return result;
    }

    public double[][] getLayoutWeights() {
        double[][] result = new double[2][];
        if (this.layoutInfo == null) {
            result[0] = new double[0];
            result[1] = new double[0];
            return result;
        }
        result[0] = new double[this.layoutInfo.cols];
        System.arraycopy(this.layoutInfo.colWeights, 0, result[0], 0, this.layoutInfo.cols);
        result[1] = new double[this.layoutInfo.rows];
        System.arraycopy(this.layoutInfo.rowWeights, 0, result[1], 0, this.layoutInfo.rows);
        return result;
    }

    public Point location(int x, int y) {
        int h;
        int row;
        int w;
        int col;
        if (this.layoutInfo == null) {
            return new Point(0, 0);
        }
        int pixel_x = this.layoutInfo.pos_x;
        int pixel_y = this.layoutInfo.pos_y;
        for (col = 0; col < this.layoutInfo.cols && x >= pixel_x + (w = this.layoutInfo.colWidths[col]); ++col) {
            pixel_x += w;
        }
        for (row = 0; row < this.layoutInfo.rows && y >= pixel_y + (h = this.layoutInfo.rowHeights[row]); ++row) {
            pixel_y += h;
        }
        return new Point(col, row);
    }

    protected void AdjustForGravity(GridBagConstraints gbc, Rectangle rect) {
        this.adjustForGravity(gbc, rect);
    }

    protected void ArrangeGrid(Container parent) {
        this.arrangeGrid(parent);
    }

    protected GridBagLayoutInfo GetLayoutInfo(Container parent, int sizeflag) {
        return this.getLayoutInfo(parent, sizeflag);
    }

    protected Dimension GetMinSize(Container parent, GridBagLayoutInfo info) {
        return this.getMinSize(parent, info);
    }

    protected Dimension getMinSize(Container parent, GridBagLayoutInfo info) {
        if (parent == null || info == null) {
            return new Dimension(0, 0);
        }
        Insets insets = parent.getInsets();
        int width = this.sumIntArray(info.colWidths) + insets.left + insets.right;
        int height = this.sumIntArray(info.rowHeights) + insets.top + insets.bottom;
        return new Dimension(width, height);
    }

    private void calcCellSizes(int[] sizes, double[] weights, int range) {
        int diff = range - this.sumIntArray(sizes);
        if (diff == 0) {
            return;
        }
        double weight = this.sumDoubleArray(weights);
        for (int i = 0; i < sizes.length; ++i) {
            int n = i;
            sizes[n] = sizes[n] + (int)((double)diff * weights[i] / weight);
            if (sizes[i] >= 0) continue;
            sizes[i] = 0;
        }
    }

    private void dumpLayoutInfo(GridBagLayoutInfo info) {
        System.out.println("GridBagLayoutInfo:");
        System.out.println("cols: " + info.cols + ", rows: " + info.rows);
        System.out.print("colWidths: ");
        this.dumpArray(info.colWidths);
        System.out.print("rowHeights: ");
        this.dumpArray(info.rowHeights);
        System.out.print("colWeights: ");
        this.dumpArray(info.colWeights);
        System.out.print("rowWeights: ");
        this.dumpArray(info.rowWeights);
    }

    private void dumpArray(int[] array) {
        String sep = "";
        for (int i = 0; i < array.length; ++i) {
            System.out.print(sep);
            System.out.print(array[i]);
            sep = ", ";
        }
        System.out.println();
    }

    private void dumpArray(double[] array) {
        String sep = "";
        for (int i = 0; i < array.length; ++i) {
            System.out.print(sep);
            System.out.print(array[i]);
            sep = ", ";
        }
        System.out.println();
    }

    protected void arrangeGrid(Container parent) {
        Component[] components = parent.getComponents();
        if (components.length == 0) {
            return;
        }
        GridBagLayoutInfo info = this.getLayoutInfo(parent, 2);
        if (info.cols == 0 && info.rows == 0) {
            return;
        }
        this.layoutInfo = info;
        for (int i = 0; i < components.length; ++i) {
            int y;
            int x;
            Component component = components[i];
            if (!component.isVisible()) continue;
            GridBagConstraints constraints = this.lookupConstraints(component);
            int cellx = this.sumIntArray(this.layoutInfo.colWidths, constraints.gridx);
            int celly = this.sumIntArray(this.layoutInfo.rowHeights, constraints.gridy);
            int cellw = this.sumIntArray(this.layoutInfo.colWidths, constraints.gridx + constraints.gridwidth) - cellx;
            int cellh = this.sumIntArray(this.layoutInfo.rowHeights, constraints.gridy + constraints.gridheight) - celly;
            Insets insets = constraints.insets;
            if (insets != null) {
                cellx += insets.left;
                celly += insets.top;
                cellw -= insets.left + insets.right;
                cellh -= insets.top + insets.bottom;
            }
            Dimension dim = component.preferredSize();
            dim.width += constraints.ipadx;
            dim.height += constraints.ipady;
            switch (constraints.fill) {
                case 2: {
                    dim.width = cellw;
                    break;
                }
                case 3: {
                    dim.height = cellh;
                    break;
                }
                case 1: {
                    dim.width = cellw;
                    dim.height = cellh;
                }
            }
            switch (constraints.anchor) {
                case 11: {
                    x = cellx + (cellw - dim.width) / 2;
                    y = celly;
                    break;
                }
                case 15: {
                    x = cellx + (cellw - dim.width) / 2;
                    y = celly + cellh - dim.height;
                    break;
                }
                case 17: {
                    x = cellx;
                    y = celly + (cellh - dim.height) / 2;
                    break;
                }
                case 13: {
                    x = cellx + cellw - dim.width;
                    y = celly + (cellh - dim.height) / 2;
                    break;
                }
                case 12: {
                    x = cellx + cellw - dim.width;
                    y = celly;
                    break;
                }
                case 18: {
                    x = cellx;
                    y = celly;
                    break;
                }
                case 14: {
                    x = cellx + cellw - dim.width;
                    y = celly + cellh - dim.height;
                    break;
                }
                case 16: {
                    x = cellx;
                    y = celly + cellh - dim.height;
                    break;
                }
                default: {
                    x = cellx + (cellw - dim.width) / 2;
                    y = celly + (cellh - dim.height) / 2;
                }
            }
            component.setBounds(this.layoutInfo.pos_x + x, this.layoutInfo.pos_y + y, dim.width, dim.height);
        }
    }

    protected GridBagLayoutInfo getLayoutInfo(Container parent, int sizeflag) {
        GridBagConstraints constraints;
        Component component;
        if (sizeflag != 1 && sizeflag != 2) {
            throw new IllegalArgumentException();
        }
        Dimension parentDim = parent.size();
        Insets parentInsets = parent.insets();
        parentDim.width -= parentInsets.left + parentInsets.right;
        parentDim.height -= parentInsets.top + parentInsets.bottom;
        int x = 0;
        int y = 0;
        int max_x = 0;
        int max_y = 0;
        Component[] components = parent.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component component2 = components[i];
            if (!component2.isVisible()) continue;
            GridBagConstraints constraints2 = this.lookupConstraints(component2);
            if (constraints2.gridx == -1) {
                constraints2.gridx = x;
            }
            if (constraints2.gridy == -1) {
                constraints2.gridy = y;
            }
            max_x = Math.max(max_x, constraints2.gridx + Math.max(1, constraints2.gridwidth));
            max_y = Math.max(max_y, constraints2.gridy + Math.max(1, constraints2.gridheight));
            if (constraints2.gridwidth == 0) {
                x = 0;
                ++y;
                continue;
            }
            x = constraints2.gridx + Math.max(1, constraints2.gridwidth);
            y = constraints2.gridy;
        }
        GridBagLayoutInfo info = new GridBagLayoutInfo(max_x, max_y);
        for (x = 0; x <= max_x; ++x) {
            if (this.columnWidths != null && this.columnWidths.length > x) {
                info.colWidths[x] = this.columnWidths[x];
            }
            if (this.columnWeights != null && this.columnWeights.length > x) {
                info.colWeights[x] = this.columnWeights[x];
            }
            for (int i = 0; i < components.length; ++i) {
                int width;
                component = components[i];
                if (!component.isVisible()) continue;
                constraints = this.lookupConstraints(component);
                if (constraints.gridwidth == 0) {
                    constraints.gridwidth = max_x - constraints.gridx;
                }
                if (constraints.gridheight == 0) {
                    constraints.gridheight = max_y - constraints.gridy;
                }
                if (constraints.gridx + constraints.gridwidth - 1 != x) continue;
                int n = width = sizeflag == 2 ? component.preferredSize().width : component.minimumSize().width;
                if (constraints.insets != null) {
                    width += constraints.insets.left + constraints.insets.right;
                }
                width += constraints.ipadx;
                for (int w = 1; w < constraints.gridwidth; ++w) {
                    width -= info.colWidths[x - w];
                }
                info.colWidths[x] = Math.max(info.colWidths[x], width);
                info.colWeights[x] = Math.max(info.colWeights[x], constraints.weightx);
            }
        }
        for (y = 0; y <= max_y; ++y) {
            if (this.rowHeights != null && this.rowHeights.length > y) {
                info.rowHeights[y] = this.rowHeights[y];
            }
            if (this.rowWeights != null && this.rowWeights.length > y) {
                info.rowWeights[y] = this.rowWeights[y];
            }
            for (int i = 0; i < components.length; ++i) {
                int height;
                component = components[i];
                if (!component.isVisible()) continue;
                constraints = this.lookupConstraints(component);
                if (constraints.gridy + constraints.gridheight - 1 != y) continue;
                int n = height = sizeflag == 2 ? component.preferredSize().height : component.minimumSize().height;
                if (constraints.insets != null) {
                    height += constraints.insets.top + constraints.insets.bottom;
                }
                height += constraints.ipady;
                for (int h = 1; h < constraints.gridheight; ++h) {
                    height -= info.rowHeights[y - h];
                }
                info.rowHeights[y] = Math.max(info.rowHeights[y], height);
                info.rowWeights[y] = Math.max(info.rowWeights[y], constraints.weighty);
            }
        }
        this.calcCellSizes(info.colWidths, info.colWeights, parentDim.width);
        this.calcCellSizes(info.rowHeights, info.rowWeights, parentDim.height);
        int totalWidth = this.sumIntArray(info.colWidths);
        int totalHeight = this.sumIntArray(info.rowHeights);
        info.pos_x = parentInsets.left + (parentDim.width - totalWidth) / 2;
        info.pos_y = parentInsets.top + (parentDim.height - totalHeight) / 2;
        return info;
    }

    protected void adjustForGravity(GridBagConstraints gbc, Rectangle rect) {
        throw new Error("Not implemented");
    }
}

