/***************************************************************************
                          picture.cpp  -  description
                             -------------------
    begin                : Mon Aug 19 2002
    copyright            : (C) 2002 by Stefan Winter
    email                : mail@stefan-winter.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qwidget.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <kstandarddirs.h>
#include "picture.h"
#include "stuff.h"
extern deviceinfo *information;

Picture::Picture (QWidget * parent):QWidget (parent, "picture")
{
  KStandardDirs finder;
  kdedir = finder.findResourceDir ("data", "kwifimanager/pics/no_card.png");
  kdedir += "kwifimanager/pics/";
  NO_CARD = new QPixmap (kdedir + "no_card.png");
  AD_HOC = new QPixmap (kdedir + "ad_hoc.png");
  ALL_ALONE = new QPixmap (kdedir + "all_alone.png");
  AP_CONNECT = new QPixmap (kdedir + "ap_connect.png");
}

Picture::~Picture()
{
    delete NO_CARD;
    delete AD_HOC;
    delete ALL_ALONE;
    delete AP_CONNECT;

}

void
Picture::paintEvent (QPaintEvent *)
{
  QPainter *picturepainter = new QPainter (this);
  if (information->has_freq != 1)
    {
      picturepainter->drawPixmap (20, 10, *NO_CARD);
    }
  else if (information->mode == 1)
    {
      picturepainter->drawPixmap (20, 10, *AD_HOC);
    }
  else if (information->qual.qual == 0)
    {
      picturepainter->drawPixmap (20, 10, *ALL_ALONE);
    }
  else if (information->qual.qual > 0)
    {
      picturepainter->drawPixmap (20, 10, *AP_CONNECT);
    }
  else
    picturepainter->drawPixmap (20, 10, *NO_CARD);
  delete picturepainter;
}
