/***************************************************************************
                           guesswidget.cpp  -  description
                             -------------------
    begin                : Sat Feb 16 2002
    copyright            : (C) 2002 by Scott Wheeler
    email                : wheeler@kde.org
***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
***************************************************************************/

#include <kpushbutton.h>
#include <klineedit.h>
#include <klocale.h>
#include <kdebug.h>

#include <qlabel.h>
#include <qlayout.h>
#include <qvbox.h>
#include <qtimer.h>
#include <qstylesheet.h>

#include "guesswidget.h"
#include "guesswidget.moc"

////////////////////////////////////////////////////////////////////////////////
// public members
////////////////////////////////////////////////////////////////////////////////

GuessWidget::GuessWidget(KStatusBar *statusBar, bool randomQuiz,
			 QWidget *parent, const char *name)
  : QuizWidget(statusBar, parent, name),
    random(randomQuiz),
    numberCorrect(0)
{
  showFeedbackLabel();
  setupLayout();
}

GuessWidget::~GuessWidget()
{

}

void GuessWidget::cut()
{
  if(guessLineEdit)
    guessLineEdit->cut();
}

void GuessWidget::copy()
{
  if(guessLineEdit)
    guessLineEdit->copy();
}

void GuessWidget::paste()
{
  if(guessLineEdit)
    guessLineEdit->paste();
}

bool GuessWidget::hasSelectedText() const
{
  return guessLineEdit && guessLineEdit->hasSelectedText();
} 

////////////////////////////////////////////////////////////////////////////////
// protected members
////////////////////////////////////////////////////////////////////////////////

QString GuessWidget::completeMessage() const
{
  int percentCorrect = int(100 * numberCorrect / numberOfCards());
  QString message = i18n("Restarting the deck.\n%1% Correct!").arg(percentCorrect);
  numberCorrect = 0;
  return message;
}

////////////////////////////////////////////////////////////////////////////////
// private members
////////////////////////////////////////////////////////////////////////////////

void GuessWidget::setupLayout()
{
  //  QVBoxLayout *layout = new QVBoxLayout(this, 0, 5, "layout");

  QVBox *card = new QVBox(this);
  layout()->addWidget(card);
  
  card->setFrameStyle(QFrame::Panel | QFrame::Raised);

  cardLabel = new QLabel(QString::null, card);
  cardLabel->setAlignment(AlignHCenter | AlignAuto | AlignVCenter | ExpandTabs);

  QHBoxLayout *guessLayout = new QHBoxLayout(layout(), 3);
  
  guessLineEdit = new KLineEdit(this);
  guessLayout->addWidget(guessLineEdit);

  connect(guessLineEdit, SIGNAL(selectionChanged()), this, SIGNAL(selectionChanged()));
  guessLineEdit->installEventFilter(this);

  checkButton = new KPushButton(i18n("Check"), this);
  guessLayout->addWidget(checkButton);

  connect(guessLineEdit, SIGNAL(returnPressed()), checkButton, SLOT(animateClick()));
  
  showAnswerButton = new KPushButton(i18n("Show Answer"), this);
  guessLayout->addWidget(showAnswerButton);

  connect(checkButton, SIGNAL(clicked()), this, SLOT(checkAnswer()));
  connect(showAnswerButton, SIGNAL(clicked()), this, SLOT(showAnswer()));
}

void GuessWidget::showCard(const Card &card)
{
  if(cardLabel) {
    QString text = QStyleSheet::escape(card.front()).replace("\n", "<br/>");
    cardLabel->setText("<h2>" +  text + "</h2>");
    guessLineEdit->clear();
    answer = card.back();
  }
}

////////////////////////////////////////////////////////////////////////////////
// private slots
////////////////////////////////////////////////////////////////////////////////

void GuessWidget::checkAnswer()
{
  if(guessLineEdit->text() == answer) {
    numberCorrect++;
    setFeedbackMessage(i18n("Correct!"));
    nextCard(random);
    guessLineEdit->setFocus();
  }
  else {
    setFeedbackMessage(i18n("Incorrect."));    
    guessLineEdit->setFocus();
    guessLineEdit->selectAll();
  }
}

void GuessWidget::showAnswer()
{
  checkButton->setEnabled(false);
  showAnswerButton->setEnabled(false);

  guessLineEdit->setText(answer);
  QTimer::singleShot(showAnswerLength()  * 1000, this, SLOT(callNextCard()));

  guessLineEdit->setFocus();
}

void GuessWidget::callNextCard()
{
  if(!checkButton->isEnabled())
    checkButton->setEnabled(true);
  if(!showAnswerButton->isEnabled())
    showAnswerButton->setEnabled(true);
  nextCard(random);
}
