/***************************************************************************
                            HTMLTableSectionElement.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef HTMLTABLESECTIONELEMENT_H
#define HTMLTABLESECTIONELEMENT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/HTMLElement.h>

/**

 The <code> THEAD </code> , <code> TFOOT </code> , and <code> TBODY
 </code> elements.

 
 @short 
 The <code> THEAD </code> , <code> TFOOT </code> , and <code> TBODY
 </code> elements.
*/

@class HTMLCollection;

@interface HTMLTableSectionElement : HTMLElement 
- init;
- copyWithZone: (NSZone *) zone;
- initWithDOMNode: (DOMNode*)other;
- (void) dealloc;

/** 
 Horizontal alignment of data in cells. See the <code> align
 </code> attribute for HTMLTheadElement for details.

     
*/
- (NSString *) align;

/** 
 see @ref align
     
*/
- setAlign: (NSString *)arg1;

/** 
 Alignment character for cells in a column. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.-[html adef]-char">
 char attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) ch;

/** 
 see @ref ch
     
*/
- setCh: (NSString *)arg1;

/** 
 Offset of alignment character. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.-[html adef]-charoff">
 charoff attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) chOff;

/** 
 see @ref chOff
     
*/
- setChOff: (NSString *)arg1;

/** 
 Vertical alignment of data in cells. See the <code> valign
 </code> attribute for HTMLTheadElement for details.

     
*/
- (NSString *) vAlign;

/** 
 see @ref vAlign
     
*/
- setVAlign: (NSString *)arg1;

/** 
 The collection of rows in this table section.

     
*/
- (HTMLCollection*) rows;

/** 
 Insert a row into this section.

     
*/
- (HTMLElement*) insertRow: (long)index;

/** 
 Delete a row from this section.

     
*/
- deleteRow: (long)index;
@end

#endif
