//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QtSupport;
import java.util.ArrayList;

/**

 Interface to the KDE Image IO plugin architecture.
 This library allows KDE applications to read and write images in a
 variety of formats, transparently via the QImage and QPixmap load
 and save methods.
 The image processing backends are written as image handlers compatible
 with the QImageIO handler format. The backends are loaded on demand
 when a particular format is requested. Each format can be identified
 by a unique type id string.
 <b></b>ormats: \n
 Currently supported formats include:

	<li>
	JPEG    \<read\>
	</li>
	
	<li>
	XV      \<read\> \<write\>
	</li>
	
	<li>
	EPS     \<read\> \<write\>
	</li>
	
	<li>
	NETPBM  \<incomplete\>
	</li>
	
	<li>
	PNG     \<read\> \<write, only with newer libraries\>
	</li>
	
	<li>
	TIFF    \<read\>
	</li>
	
	<li>
	KRL     \<read\>
	</li>
	 <b></b>sage:\n
 Simply call the KImageIO.registerFormats() static method declared
 in kimgageio.h.
 <b></b>xample:\n
 <pre>
  #include<qpixmap.h>
  #include<kimgio.h>
  int main( String[] args )
  {
    ....
    KImageIO.registerFormats();
    ...   // start main program
  }
 </pre>
		@author Sirtaj Singh Kang

		@version  kimageio.h,v 1.13 2003/08/20 08:01:43 coolo
 
		@short    Interface to the KDE Image IO plugin architecture.
		@see KImageIO
		@see org.kde.qt.QPixmap
		@see org.kde.qt.QImage
		@see org.kde.qt.QImageIO

*/
public class KImageIO implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;
	protected KImageIO(Class dummy){}

	/**	
		 Possible image file access modes.
			 Used in various KImageIO static function.
				@short    Possible image file access modes.
	*/
	public static final int Reading = 0;
	public static final int Writing = 1;

	public KImageIO() {
		newKImageIO();
	}
	private native void newKImageIO();
	public KImageIO(KImageIO arg1) {
		newKImageIO(arg1);
	}
	private native void newKImageIO(KImageIO arg1);
	/**	
		  Registers all KImageIO supported formats.
		   		@short     Registers all KImageIO supported formats.
	*/
	public static native void registerFormats();
	/**	
		 Checks if a special type is supported for writing.
			@param type the type id of the image type
				@return true if the image format can be written
   
		@short    Checks if a special type is supported for writing.
	*/
	public static native boolean canWrite(String type);
	/**	
		 Checks if a special type is supported for reading.
			@param type the type id of the image type
				@return true if the image format can be read
   
		@short    Checks if a special type is supported for reading.
	*/
	public static native boolean canRead(String type);
	/**	
		 Returns a list of all KImageIO supported formats.
			@param mode Tells whether to retrieve modes that can be read or written.
				@return a list of the type ids
   
		@short    Returns a list of all KImageIO supported formats.
	*/
	public static native ArrayList types(int mode);
	public static native ArrayList types();
	/**	
		 Returns a list of patterns of all KImageIO supported formats.
			 These patterns can be passed to KFileDialog.getOpenFileName()
		 or KFileDialog.getSaveFileName(), for example.
			@param mode Tells whether to retrieve modes that can be read or written.
				@return a space-separated list of file globs that describe the
 supported formats
   
		@short    Returns a list of patterns of all KImageIO supported formats.
	*/
	public static native String pattern(int mode);
	public static native String pattern();
	/**	
		 Returns the suffix of an image type.
			@param type the type id of the file format
				@return the suffix of the file format or null if it does not
         exist
   
		@short    Returns the suffix of an image type.
	*/
	public static native String suffix(String type);
	/**	
		 Returns the type of a MIME type.
			@param mimeType the MIME type to search
				@return type id of the MIME type or null if the MIME type
         is not supported

		@short    Returns the type of a MIME type.
	*/
	public static native String typeForMime(String mimeType);
	/**	
		 Returns the type of given filename.
			@param filename the filename to check
				@return if the file name's suffix is known the type id of the
         file type, otherwise null
   
		@short    Returns the type of given filename.
	*/
	public static native String type(String filename);
	/**	
		  Returns a list of MIME types for all KImageIO supported formats.
			@param mode Tells whether to retrieve modes that can be read or written.
				@return a list if MIME types of the supported formats
   
		@short     Returns a list of MIME types for all KImageIO supported formats.
	*/
	public static native ArrayList mimeTypes(int mode);
	public static native ArrayList mimeTypes();
	/**	
		 Test to see whether a MIME type is supported to reading/writing.
			@param _mimeType the MIME type to check
			@param _mode Tells whether to check for reading or writing capabilities
				@return true if the type is supported

		@short    Test to see whether a MIME type is supported to reading/writing.
	*/
	public static native boolean isSupported(String _mimeType, int _mode);
	public static native boolean isSupported(String _mimeType);
	/**	
		 Returns the MIME type of <code>_filename.</code>
			@param _filename the filename to check
				@return the MIME type of the file, or null

		@short    Returns the MIME type of <code>_filename.</code>
	*/
	public static native String mimeType(String _filename);
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
