/***************************************************************************
                            kde_KURLDrag.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KURLDRAG
#define KDE_KURLDRAG

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 This class is to be used instead of QUriDrag when using KURL.
 The reason is: QUriDrag (and the XDND/W3C standards) expect URLs to
 be encoded in UTF-8 (unicode), but KURL uses the current locale
 by default.
 The other reasons for using this class are:

 To create a drag object, use KURLDrag::newDrag() with a list of KURLs.
 To decode a drop, use KURLDrag::decode() or QUriDrag::decodeLocalFiles().
 
 @short *
 This class is to be used instead of QUriDrag when using KURL.
*/

/** *
 Constructs an object to drag the list of URLs in @p urls.
 The @p dragSource and @p name arguments are passed on to QUriDrag,
 and the list of urls is converted to UTF-8 before being passed
 to QUriDrag.

*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KURLDrag * kde_new_KURLDrag(kde_KURLList* urls, qt_QWidget * dragSource, char* name);
void kde_del_KURLDrag( kde_KURLDrag* p );

/** *

   
*/
kde_KURLDrag* kde_KURLDrag_newDrag( kde_KURLList* urls, qt_QWidget * dragSource, char* name);

/** *
 Convenience method that decodes the contents of @p e
 into a list of KURLs.

*/
int kde_KURLDrag_decode( qt_QMimeSource* e, kde_KURLList* urls);
char* kde_KURLDrag_format(kde_KURLDrag* instPointer,int i);
qt_QByteArray* kde_KURLDrag_encodedData(kde_KURLDrag* instPointer,char* mime);

#ifdef __cplusplus
}
#endif
#endif
