/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.BundleInstanceRequest;
import com.amazonaws.services.ec2.model.S3Storage;
import com.amazonaws.services.ec2.model.Storage;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class BundleInstanceRequestMarshaller
implements Marshaller<Request<BundleInstanceRequest>, BundleInstanceRequest> {
    public Request<BundleInstanceRequest> marshall(BundleInstanceRequest bundleInstanceRequest) {
        S3Storage s3StorageS3;
        Storage storageStorage;
        if (bundleInstanceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)bundleInstanceRequest, "AmazonEC2");
        request.addParameter("Action", "BundleInstance");
        request.addParameter("Version", "2014-05-01");
        if (bundleInstanceRequest.isDryRun() != null) {
            request.addParameter("DryRun", StringUtils.fromBoolean((Boolean)bundleInstanceRequest.isDryRun()));
        }
        if (bundleInstanceRequest.getInstanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)bundleInstanceRequest.getInstanceId()));
        }
        if ((storageStorage = bundleInstanceRequest.getStorage()) != null && (s3StorageS3 = storageStorage.getS3()) != null) {
            if (s3StorageS3.getBucket() != null) {
                request.addParameter("Storage.S3.Bucket", StringUtils.fromString((String)s3StorageS3.getBucket()));
            }
            if (s3StorageS3.getPrefix() != null) {
                request.addParameter("Storage.S3.Prefix", StringUtils.fromString((String)s3StorageS3.getPrefix()));
            }
            if (s3StorageS3.getAWSAccessKeyId() != null) {
                request.addParameter("Storage.S3.AWSAccessKeyId", StringUtils.fromString((String)s3StorageS3.getAWSAccessKeyId()));
            }
            if (s3StorageS3.getUploadPolicy() != null) {
                request.addParameter("Storage.S3.UploadPolicy", StringUtils.fromString((String)s3StorageS3.getUploadPolicy()));
            }
            if (s3StorageS3.getUploadPolicySignature() != null) {
                request.addParameter("Storage.S3.UploadPolicySignature", StringUtils.fromString((String)s3StorageS3.getUploadPolicySignature()));
            }
        }
        return request;
    }
}

