/*
 * Decompiled with CFR 0.152.
 */
package gnu.math;

import gnu.math.CQuantity;
import gnu.math.Complex;
import gnu.math.DFloNum;
import gnu.math.DQuantity;
import gnu.math.Dimensions;
import gnu.math.Numeric;
import gnu.math.RealNum;
import gnu.math.Unit;

public abstract class Quantity
extends Numeric {
    public Unit unit() {
        return Unit.Empty;
    }

    public Dimensions dimensions() {
        return this.unit().dimensions();
    }

    public abstract Complex number();

    public RealNum re() {
        return this.number().re();
    }

    public RealNum im() {
        return this.number().im();
    }

    public final double reValue() {
        return this.doubleValue();
    }

    public final double imValue() {
        return this.doubleImagValue();
    }

    public double doubleValue() {
        return this.unit().doubleValue() * this.re().doubleValue();
    }

    public double doubleImagValue() {
        return this.unit().doubleValue() * this.im().doubleValue();
    }

    public static Quantity make(Complex x, Unit u) {
        if (u == Unit.Empty) {
            return x;
        }
        if (x instanceof DFloNum) {
            return new DQuantity(x.doubleValue(), u);
        }
        return new CQuantity(x, u);
    }

    public static Quantity make(RealNum re, RealNum im, Unit unit) {
        if (unit == Unit.Empty) {
            return Complex.make(re, im);
        }
        if (!(!im.isZero() || re.isExact() && im.isExact())) {
            return new DQuantity(re.doubleValue(), unit);
        }
        return new CQuantity(re, im, unit);
    }

    public static Quantity make(double re, double im, Unit unit) {
        if (unit == Unit.Empty) {
            return Complex.make(re, im);
        }
        if (im == 0.0) {
            return new DQuantity(re, unit);
        }
        return new CQuantity(new DFloNum(re), new DFloNum(im), unit);
    }

    public Numeric neg() {
        return Quantity.make((Complex)this.number().neg(), this.unit());
    }

    public Numeric abs() {
        return Quantity.make((Complex)this.number().abs(), this.unit());
    }

    public static int compare(Quantity x, Quantity y) {
        if (x.unit() == y.unit()) {
            return Complex.compare(x.number(), y.number());
        }
        if (x.dimensions() != y.dimensions() || x.imValue() != y.imValue()) {
            return -3;
        }
        return DFloNum.compare(x.reValue(), y.reValue());
    }

    public int compare(Object obj) {
        if (!(obj instanceof Quantity)) {
            return ((Numeric)obj).compareReversed(this);
        }
        return Quantity.compare(this, (Quantity)obj);
    }

    public int compareReversed(Numeric x) {
        if (x instanceof Quantity) {
            return Quantity.compare((Quantity)x, this);
        }
        throw new IllegalArgumentException();
    }

    public static Quantity add(Quantity x, Quantity y, int k) {
        if (x.unit() == y.unit()) {
            return Quantity.make(Complex.add(x.number(), y.number(), k), x.unit());
        }
        if (x.dimensions() != y.dimensions()) {
            throw new ArithmeticException("units mis-match");
        }
        double x_factor = x.unit().doubleValue();
        double re = (x.reValue() + (double)k * y.reValue()) / x_factor;
        double im = (x.imValue() + (double)k * y.imValue()) / x_factor;
        return Quantity.make(re, im, x.unit());
    }

    public Numeric add(Object y, int k) {
        if (y instanceof Quantity) {
            return Quantity.add(this, (Quantity)y, k);
        }
        return ((Numeric)y).addReversed(this, k);
    }

    public Numeric addReversed(Numeric x, int k) {
        if (x instanceof Quantity) {
            return Quantity.add((Quantity)x, this, k);
        }
        throw new IllegalArgumentException();
    }

    public static Quantity times(Quantity x, Quantity y) {
        Unit unit = Unit.times(x.unit(), y.unit());
        Numeric num = x.number().mul(y.number());
        return Quantity.make((Complex)num, unit);
    }

    public Numeric mul(Object y) {
        if (y instanceof Quantity) {
            return Quantity.times(this, (Quantity)y);
        }
        return ((Numeric)y).mulReversed(this);
    }

    public Numeric mulReversed(Numeric x) {
        if (x instanceof Quantity) {
            return Quantity.times((Quantity)x, this);
        }
        throw new IllegalArgumentException();
    }

    public static Quantity divide(Quantity x, Quantity y) {
        Unit unit = Unit.divide(x.unit(), y.unit());
        Numeric num = x.number().div(y.number());
        return Quantity.make((Complex)num, unit);
    }

    public Numeric div(Object y) {
        if (y instanceof Quantity) {
            return Quantity.divide(this, (Quantity)y);
        }
        return ((Numeric)y).divReversed(this);
    }

    public Numeric divReversed(Numeric x) {
        if (x instanceof Quantity) {
            return Quantity.divide((Quantity)x, this);
        }
        throw new IllegalArgumentException();
    }

    public String toString(int radix) {
        String str = this.number().toString(radix);
        if (this.unit() == Unit.Empty) {
            return str;
        }
        return str + this.unit().toString();
    }
}

