/*
 * unity-webapps-action-tracker.c
 * Copyright (C) Canonical LTD 2011
 *
 * Author: Robert Carr <racarr@canonical.com>
 * 
 unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <gio/gio.h>

#include "unity-webapps-window-tracker-mock.h"

#include "../unity-webapps-debug.h"

struct _UnityWebappsWindowTrackerMockPrivate {
  guint64 active_window_id;
};

G_DEFINE_TYPE(UnityWebappsWindowTrackerMock, unity_webapps_window_tracker_mock, UNITY_WEBAPPS_TYPE_WINDOW_TRACKER)

#define UNITY_WEBAPPS_WINDOW_TRACKER_MOCK_GET_PRIVATE(object) (G_TYPE_INSTANCE_GET_PRIVATE ((object), UNITY_WEBAPPS_TYPE_WINDOW_TRACKER_MOCK, UnityWebappsWindowTrackerMockPrivate))

static void
unity_webapps_window_tracker_mock_finalize (GObject *object)
{

}

static guint64
unity_webapps_window_tracker_mock_get_active_window_id (UnityWebappsWindowTracker *tracker)
{
  UnityWebappsWindowTrackerMock *self;
  
  self = UNITY_WEBAPPS_WINDOW_TRACKER_MOCK (tracker);
  return self->priv->active_window_id;
}


static void
unity_webapps_window_tracker_mock_class_init (UnityWebappsWindowTrackerMockClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);
  UnityWebappsWindowTrackerClass *window_tracker_class = UNITY_WEBAPPS_WINDOW_TRACKER_CLASS (klass);
  
  object_class->finalize = unity_webapps_window_tracker_mock_finalize;
  
  window_tracker_class->get_active_window_id = unity_webapps_window_tracker_mock_get_active_window_id;
  
  g_type_class_add_private (object_class, sizeof(UnityWebappsWindowTrackerMockPrivate));
}

static void
unity_webapps_window_tracker_mock_init (UnityWebappsWindowTrackerMock *tracker)
{
  tracker->priv = UNITY_WEBAPPS_WINDOW_TRACKER_MOCK_GET_PRIVATE (tracker);
  
  tracker->priv->active_window_id = 0;
}

UnityWebappsWindowTrackerMock *
unity_webapps_window_tracker_mock_new ()
{
  return g_object_new (UNITY_WEBAPPS_TYPE_WINDOW_TRACKER_MOCK, NULL);
}

void
unity_webapps_window_tracker_mock_set_active_window (UnityWebappsWindowTrackerMock *tracker,
						     guint64 window_id)
{
  g_return_if_fail (UNITY_WEBAPPS_IS_WINDOW_TRACKER_MOCK (tracker));

  tracker->priv->active_window_id = window_id;
  
  g_object_notify (G_OBJECT (tracker), "active-window-id");
}
