;; list-dir takes a path and returns a list of files in that directory
(define (list-dir path)
  (letrec ((dport (%opendir path))
	   (form-dlist			; a procedure that forms the list
	    (lambda (dl)
	      (let ((fname (%readdir dport)))
		(if (eof-object? fname)
		    dl
		    (form-dlist (cons fname dl))))))
	   )
    (define output-list (form-dlist '()))
    (%closedir dport)
    output-list
    )
  )
