;; -*- scheme -*-
;; Guile SurfIt! Applet API.
;;

(require 'Gtcl)
(require 'Gtk)

(use-library tcl)
(use-interface tcl)
(use-interface tclhack)

;; Alist of termination functions.  Keys are applet names.
(define *terminate-alist* '())

;; This is called to terminate the applet.  It must be visible to Tcl.
(proc guile_terminate applet
      (let ((vcell (assoc applet *terminate-alist*)))
	(if vcell
	    (begin
	      ;; Call the function.
	      ((cdr vcell))
	      ;; Delete it.
	      (set! *terminate-alist* (delq! vcell *terminate-alist*))))))

(define (define-applet-terminate routine)
  (let ((vcell (assoc applet-slave-name *terminate-alist*)))
    (if vcell
	(setcdr! vcell routine)
	(set! *terminate-alist* (acons applet-slave-name routine
				       *terminate-alist*)))))

(define (applet . args)
  (apply Applet_command applet-slave-name applet-window args))

(define applet-embedindex
  (applet "embedindex"))

(define (applet-newpage)
   (applet "newpage"))

(define (applet-parsehtml html)
   (applet "parsehtml" html))

(define (applet-loadurl url)
   (applet "loadurl" url))

;; Here CALLBACK is a function of one argument.  The argument is the
;; contents of the URL.  This only works for text URLs.
(define (applet-loaddata url data callback)
  (applet "loaddata" url data
	  (tcl-lambda result
		      (callback result))))

;; CALLBACK must be a Tcl-visible proc.
(define (applet-postdata url datavar callback postdata)
  ;; postdata is an alist.  Convert it into a "Tcl alist".
  (let ((tpostdata (tcl-merge the-interpreter
			      (map (lambda (elt)
				     (tcl-merge the-interpreter
						(list (car elt) (cdr elt))))
				   postdata))))
    (applet "postdata" url datavar callback tpostdata)))

(proc tcl-applet-parsehtml data
      (applet-parsehtml (car data))
      "")

(define (applet-posturl url datavar postdata)
  (applet-postdata url datavar "tcl-applet-parsehtml" postdata))

(define (name->window name)
  (eval (string->symbol name)))

(define (subwindow window-name rel)
  (let ((wname
         (cond ((symbol? window-name) (symbol->string window-name))
               (#t window-name))))
    (string->symbol (string-append wname "." rel))))

;; Some definitions which are modified during applet initialization.
(define browser-window-name '#f)
(define browser-window '#f)
(define applet-window-name '#f)
(define applew-window '#f)

(define (applet-initialize)
  (set! browser-window-name
	;; Applet_command adds a "master" prefix to the start of the
	;; returned window name.  We strip it, for now.  Eventually of
	;; course we will need to handle security issues.
	(let ((w-name (applet "embedwindow")))
	  ;; 6 == (string-length "master")
	  (substring w-name 6 (string-length w-name))))

  (set! browser-window (name->window browser-window-name))

  ;; We also know there is a toplevel window named by prepending a
  ;; period to applet-slave-name.
  (wm 'withdraw (string->symbol (string-append "." applet-slave-name)))

  ;; Make a frame to hold the canvas, and put the frame into the text
  ;; widget.
  (set! applet-window-name (subwindow browser-window-name "f"))
  (set! applet-window (name->window (frame applet-window-name))))

(provide 'applet)
