#!/packages/bin/ggl
;;
;; an example of using the OpenGL and glut packages; this program
;; should be loaded into "ggl", which is the Guile image with the mesa
;; and glut libraries loaded
;;
;; This program draws a sphere in a window.  The window is managed by
;; glut, and the sphere is drawn with OpenGL calls.
;;
;; Note: this was written in scheme by Mark Galassi (1996/05/26), but
;; transliterated from Mark Kilgard's glut example written in C.
;;
(require 'logical)			; we do some bit manipulation

(define light-diffuse #s(1.0 0.0 0.0 1.0))
(define light-position #s(1.0 1.0 1.0 0.0))
(define qobj #f)

;; the actual display routine, used to refresh the window
(define (my-display)
  (begin
    (display "refreshing\n")
    (glClear (logior GL_COLOR_BUFFER_BIT GL_DEPTH_BUFFER_BIT))
    (glCallList 1)
    (glutSwapBuffers)))

;; now the workhorse which creates the sphere display list
(define (gfxinit)
  (set! qobj (gluNewQuadric))
  (display "entering gfxinit\n")
  (gluQuadricDrawStyle qobj GLU_FILL)
  (glNewList 1 GL_COMPILE)
  (gluSphere qobj 1.0 20 20)		; qobj, radius, slices, stacks
  (glEndList)
  (glLightfv GL_LIGHT0 GL_DIFFUSE light-diffuse)
  (glLightfv GL_LIGHT0 GL_POSITION light-position)
  (glEnable GL_LIGHTING)
  (glEnable GL_LIGHT0)
  (glEnable GL_DEPTH_TEST)
  (glMatrixMode GL_PROJECTION)
  ;; FIXME: gluPerspective seems to give arithmetic exceptions
  (gluPerspective 40.0 1.0		; field of view (deg), aspect ratio,
		  1.0 10.0)		; Z near, Z far
  (glMatrixMode GL_MODELVIEW)
  (gluLookAt 0.0 0.0 5.0		; eye at (0, 0, 5)
	     0.0 0.0 0.0		; center is at (0, 0, 0)
	     0.0 1.0 0.0)		; up is in +Y direction
  (glTranslatef 0.0 0.0 -1.0)
  (display "leaving gfxinit\n")
  )

;; note that glutInit is already called by ggl, so it is not part of
;; the scheme interface.
(glutInitDisplayMode (logior (logior GLUT_DOUBLE GLUT_RGB) GLUT_DEPTH))
(glutCreateWindow "sphere")		; "sphere" is just the window's name

;; still trying to figure out the DisplayFunc stuff
(define (glutDisplayFunc-callout)
  (my-display))

;; glutDisplayFunc is a special name used by glut to redraw the screen
(use-glutDisplayFunc my-display)

(gfxinit)				; workhorse: creates the sphere

;; now make a second window, just like the first but with a different name
(glutCreateWindow "a second window")
(use-glutDisplayFunc my-display)

;; now go into the glut main loop
(glutMainLoop)
