'\"
'\" Copyright (c) 1995 DSC Technologies Corporation
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" @(#) finddialog.n 1.21 94/12/17 16:04:44
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .HS name section [date [version]]
'\"	Replacement for .TH in other man pages.  See below for valid
'\"	section names.
'\"
'\" .AP type name in/out [indent]
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS [type [name]]
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .VS
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" @(#) man.macros 1.1 94/08/09 13:07:19
.\"
'\"	# Heading for Tcl/Tk man pages
.de HS
.ds ^3 \\0
.if !"\\$3"" .ds ^3 \\$3
.if '\\$2'cmds'      .TH "\\$1" 1 "\\*(^3" "\\$4" "\\$5"
.if '\\$2'lib'       .TH "\\$1" 3 "\\*(^3" "\\$4" "\\$5"
.if '\\$2'ncmds'     .TH "\\$1" n "\\*(^3" "\\$4" "\\$5"
.if '\\$2'tcl'       .TH "\\$1" n "\\*(^3"  Tcl   "Tcl Built-In Commands"
.if '\\$2'tk'        .TH "\\$1" n "\\*(^3"  Tk    "Tk Commands"
.if '\\$2'tclc'      .TH "\\$1" 3 "\\*(^3"  Tcl   "Tcl Library Procedures"
.if '\\$2'tkc'       .TH "\\$1" 3 "\\*(^3"  Tk    "Tk Library Procedures"
.if '\\$2'tclcmds'   .TH "\\$1" 1 "\\*(^3"  Tk    "Tcl Applications"
.if '\\$2'tkcmds'    .TH "\\$1" 1 "\\*(^3"  Tk    "Tk Applications"
.if '\\$2'iwid'      .TH "\\$1" 1 "\\*(^3"  Tk    "[incr Widgets]"
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.HS iwidgets::finddialog iwid
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
iwidgets::finddialog \- Create and manipulate a find dialog widget
.SH SYNOPSIS
\fBiwidgets::finddialog\fI \fIpathName \fR?\fIoptions\fR?
.SH "INHERITANCE"
itk::Toplevel <- iwidgets::Shell <- iwidgets::Dialogshell <- iwidgets::Finddialog
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fB
activeBackground   activeForeground    background        borderWidth
cursor             disabledForeground  font              foreground
highlightColor     highlightThickness  insertBackground  insertBorderWidth
insertOffTime      insertOnTime        insertWidth       selectBackground
selectBorderWidth  selectColor         selectForeground\fR
.fi
.LP
See the "options" manual entry for details on the standard options.
.SH "ASSOCIATED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBselectColor\fR
.fi
.LP
See the "checkbutton" widget manual entry for details on the above
associated options.
.LP
.nf
.ta 4c 8c 12c
\fBselectColor\fR
.fi
.LP
See the "entryfield" widget manual entry for details on the above
associated options.
.LP
.nf
.ta 4c 8c 12c
\fBlabelFont\fR	
.fi
.LP
See the "labeledwidget" widget manual entry for details on the above
associated options.
.SH "INHERITED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBbuttonBoxPadX\fR	\fBbuttonBoxPadY\fR 	\fBbuttonBoxPos\fR	\fBpadX\fR
\fBpadY\fR	\fBseparator\fR	\fBthickness\fR
.fi
.LP
See the "dialogshell" widget  manual entry for details on the above
inherited options.
.LP
.nf
.ta 4c 8c 12c
\fBheight\fR	\fBmaster\fR	\fBmodality\fR	\fBwidth\fR
.fi
.LP
See the "shell" widget  manual entry for details on the above
inherited options.
.LP
.nf
.ta 4c 8c 12c
\fBtitle\fR 
.fi
.LP
See the "Toplevel" widget  manual entry for details on the above
inherited options.
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:	\fBclearCommand\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB-clearcommand\fR
.fi
.IP
Specifies a command to be invoked following a clear operation. 
The option is meant to be used as means of notification that the
clear has taken place and allow other actions to take place such
as disabling a find again menu.
.LP
.nf
Name:	\fBmatchCommand\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB-matchcommand\fR
.fi
.IP
Specifies a command to be invoked following a find operation. 
The command is called with a match point as an argument which identifies
where exactly where in the text or scrolledtext widget that the match
is located.  Should a match not be found the match point is {}.  The
option is meant to be used as a means of notification that the
find operation has completed and allow other actions to take place
such as disabling a find again menu option if the match point was {}.
.LP
.nf
Name:	\fBpatternBackground\fR
Class:	\fBBackground\fR
Command-Line Switch:	\fB-patternbackground\fR
.fi
.IP
Specifies the background color of the text matching the search
pattern.  It may have any of the forms accepted by Tk_GetColor.
The default is gray44.
.LP
.nf
Name:	\fBpatternForeground\fR
Class:	\fBBackground\fR
Command-Line Switch:	\fB-patternforeground\fR
.fi
.IP
Specifies the foreground color of the text matching the search
pattern.  It may have any of the forms accepted by Tk_GetColor.
The default is white.
.LP
.nf
Name:	\fBsearchBackground\fR
Class:	\fBBackground\fR
Command-Line Switch:	\fB-searchbackground\fR
.fi
.IP
Specifies the background color of the line containing the matching 
the search pattern.  It may have any of the forms accepted by Tk_GetColor.
The default is gray77.
.LP
.nf
Name:	\fBsearchForeground\fR
Class:	\fBBackground\fR
Command-Line Switch:	\fB-searchforeground\fR
.fi
.IP
Specifies the foreground color of the line containing the matching 
the search pattern.  It may have any of the forms accepted by Tk_GetColor.
The default is black.
.LP
.nf
Name:	\fBtextWidget\fR
Class:	\fBTextWidget\fR
Command-Line Switch:	\fB-textwidget\fR
.fi
.IP
Specifies the text or scrolledtext widget to be searched.
.BE

.SH DESCRIPTION
.PP
The \fBiwidgets::finddialog\fR command creates a find dialog that works in
conjunction with a text or scrolledtext widget to provide a means
of performing search operations.  The user is prompted for a text 
pattern to be found in the text or scrolledtext widget.  The 
search can be for all occurances, by regular expression, considerate
of the case, or backwards.

.SH "METHODS"
.PP
The \fBiwidgets::finddialog\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for finddialog widgets:
.SH "INHERITED METHODS"
.LP
.nf
.ta 4c 8c 12c
\fBadd\fR	\fBbuttonconfigure\fR	\fBdefault\fR	\fBhide\fR
\fBinvoke\fR	\fBshow\fR	
.fi
.LP
See the "buttonbox" widget manual entry for details on the above
inherited methods.
.LP
.nf
.ta 4c 8c 12c
\fBactivate\fR	\fBcenter\fR	\fBdeactivate\fR
.fi
.LP
See the "shell" widget manual entry for details on the above
inherited methods.
.SH "WIDGET-SPECIFIC METHODS"
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBiwidgets::finddialog\fR
command.
.TP
\fIpathName \fBclear\fR
Clears the pattern in the entry field and the pattern matchin 
indicators in the text or scrolledtext widget.
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBiwidgets::finddialog\fR
command.
.TP
\fIpathName \fBfind\fR
Search for a specific text string in the text widget given by
the -textwidget option.  This method is the standard callback
for the Find button.  It is made available such that it can be 
bound to a find again action.

.SH "COMPONENTS"
.LP
.nf
Name:	\fBall\fR
Class:	\fBCheckbutton\fR
.fi
.IP
The all component specifies that all the matches of the pattern should be
found when performing the search.  See the "checkbutton" widget manual 
entry for details on the all component item.
.LP
.nf
Name:	\fBbackwards\fR
Class:	\fBCheckbutton\fR
.fi
.IP
The backwards component specifies that the search should continue in
a backwards direction towards the beginning of the text or scrolledtext
widget.  See the "checkbutton" widget manual entry for details on the 
backwards component item.
.LP
.nf
Name:	\fBcase\fR
Class:	\fBCheckbutton\fR
.fi
.IP
The case component specifies that the case of the pattern should be
taken into consideration when performing the search.  See the 
"checkbutton" widget manual entry for details on the case component item.
.LP
.nf
Name:	\fBpattern\fR
Class:	\fBEntryfield\fR
.fi
.IP
The pattern component provides the pattern entry field.  See the 
"entryfield" widget manual entry for details on the pattern component item.
.LP
.nf
Name:	\fBregexp\fR
Class:	\fBCheckbutton\fR
.fi
.IP
The regexp component specifies that the pattern is a regular expression.
See the "checkbutton" widget manual entry for details on the regexp 
component item.
.fi

.SH EXAMPLE
.DS
 package require Iwidgets 4.0
 iwidgets::scrolledtext .st
 pack .st
 .st insert end "Now is the time for all good men\\n" 
 .st insert end "to come to the aid of their country"

 iwidgets::finddialog .fd -textwidget .st
 .fd center .st
 .fd activate
.DE
.SH AUTHOR
Mark L. Ulferts
.SH KEYWORDS
finddialog, dialogshell, shell, widget

