Summary: A GNU collection of diff utilities.
Name: diffutils
Version: 2.8.1
Release: 12.gnupro.1
Group: Applications/Text
URL: http://www.gnu.org/software/diffutils/diffutils.html
Source: ftp://ftp.gnu.org/gnu/diffutils/diffutils-%{version}.tar.gz
Source1: cmp.1
Source2: diff.1
Source3: diff3.1
Source4: sdiff.1
Patch0: diffutils-2.8.4-i18n.patch
Patch1: diffutils-2.8.1-badc.patch
License: GPL
Prefix: %{_prefix}
%if "%{_arch}" == %{_build_arch}
Prereq: /sbin/install-info
%endif
Buildroot: %{_tmppath}/%{name}-%{version}-root

%description
Diffutils includes four utilities: diff, cmp, diff3 and sdiff. Diff
compares two files and shows the differences, line by line.  The cmp
command shows the offset and line numbers where two files differ, or
cmp can show the characters that differ between the two files.  The
diff3 command shows the differences between three files.  Diff3 can be
used when two people have made independent changes to a common
original; diff3 can produce a merged file that contains both sets of
changes and warnings about conflicts.  The sdiff command can be used
to merge two files interactively.

Install diffutils if you need to compare text files.

%prep
%setup -q
%patch0 -p1 -b .i18n
%patch1 -p1 -b .badc

%build
%configure
make PR_PROGRAM=%{_bindir}/pr

%install
rm -rf $RPM_BUILD_ROOT
%makeinstall

( cd $RPM_BUILD_ROOT
  gzip -9nf .%{_infodir}/diff*
  mkdir -p .%{_mandir}/man1
  for manpage in %{SOURCE1} %{SOURCE2} %{SOURCE3} %{SOURCE4}
  do
    install -m 0644 ${manpage} .%{_mandir}/man1
  done
)

rm -f $RPM_BUILD_ROOT%{_infodir}/dir
%find_lang %{name}

%if "%{_arch}" == %{_build_arch}
%post
/sbin/install-info %{_infodir}/diff.info.gz %{_infodir}/dir --entry="* diff: (diff).                 The GNU diff."
exit 0

%preun
if [ $1 = 0 ]; then
    /sbin/install-info --delete %{_infodir}/diff.info.gz %{_infodir}/dir --entry="* diff: (diff).                 The GNU diff."
fi
%endif

%clean
rm -rf $RPM_BUILD_ROOT

%files -f %{name}.lang
%defattr(-,root,root)
%doc NEWS README
%{_bindir}/*
%{_mandir}/*/*
%{_infodir}/diff.info*gz

%changelog
* Tue Jun 15 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Fri Feb 13 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Thu Jan  8 2004 Tim Waugh <twaugh@redhat.com> 2.8.1-10
- Fix mistaken use of '|' instead of '||'.

* Sat Oct 25 2003 Tim Waugh <twaugh@redhat.com> 2.8.1-9
- Rebuilt.

* Tue Jun 17 2003 Tim Waugh <twaugh@redhat.com> 2.8.1-8
- Rebuilt.

* Wed Jun 04 2003 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Wed Jan 22 2003 Tim Powers <timp@redhat.com>
- rebuilt

* Tue Nov 19 2002 Tim Waugh <twaugh@redhat.com> 2.8.1-5
- i18n patch.

* Tue Oct 22 2002 Tim Waugh <twaugh@redhat.com> 2.8.1-4
- Ship translations.

* Fri Jun 21 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Thu May 23 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Mon Apr 22 2002 Tim Waugh <twaugh@redhat.com> 2.8.1-1
- 2.8.1.
- No longer need immunix-owl-tmp patch.

* Wed Feb 27 2002 Tim Waugh <twaugh@redhat.com> 2.7.2-5
- Rebuild in new environment.

* Wed Jan 09 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Fri Nov 02 2001 Tim Waugh <twaugh@redhat.com> 2.7.2-3
- Make sure %%post scriplet doesn't fail if --excludedocs is used.

* Fri Jun 01 2001 Tim Waugh <twaugh@redhat.com> 2.7.2-2
- Install diff.1, since it's no longer in man-pages.

* Fri Mar 30 2001 Tim Waugh <twaugh@redhat.com> 2.7.2-1
- 2.7.2.

* Wed Jul 12 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild

* Thu Jul 06 2000 Trond Eivind Glomsrd <teg@redhat.com>
- fix %%changelog entries (escape them)
- update source location
- remove manual stripping
- add URL

* Tue Jun 06 2000 Than Ngo <than@redhat.de>
- add %%defattr
- use rpm macros

* Wed May 31 2000 Ngo Than <than@redhat.de>
- put man pages and info files in correct place
- cleanup specfile

* Thu Feb 03 2000 Preston Brown <pbrown@redhat.com>
- rebuild to gzip man pages.

* Mon Apr 19 1999 Jeff Johnson <jbj@redhat.com>
- man pages not in %%files.
- but avoid conflict for diff.1

* Sun Mar 21 1999 Cristian Gafton <gafton@redhat.com> 
- auto rebuild in the new build environment (release 14)

* Sun Mar 14 1999 Jeff Johnson <jbj@redhat.com>
- add man pages (#831).
- add %%configure and Prefix.

* Thu Dec 17 1998 Cristian Gafton <gafton@redhat.com>
- build for glibc 2.1

* Tue Jul 14 1998 Bill Kawakami <billk@home.com>
- included the four man pages stolen from Slackware

* Tue May 05 1998 Prospector System <bugs@redhat.com>
- translations modified for de, fr, tr

* Sun May 03 1998 Cristian Gafton <gafton@redhat.com>
- fixed spec file to reference/use the $RPM_BUILD_ROOT always
    
* Wed Dec 31 1997 Otto Hammersmith <otto@redhat.com>
- fixed where it looks for 'pr' (/usr/bin, rather than /bin)

* Fri Oct 17 1997 Donnie Barnes <djb@redhat.com>
- added BuildRoot

* Sun Sep 14 1997 Erik Troan <ewt@redhat.com>
- uses install-info

* Mon Jun 02 1997 Erik Troan <ewt@redhat.com>
- built against glibc
