#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/mman.h>
#include <netinet/in.h>

#include "/usr/src/linux/drivers/atm/midway.h"


#define MEM_DEV		"/dev/mem"
#define BASE_ADDR	0xff400000


static void usage(const char *name)
{
    fprintf(stderr,"usage: %s [ -s ] [ addr ]\n",name);
    exit(1);
}


int main(int argc,char **argv)
{
    unsigned long buffer[MAP_MAX_SIZE/4];
    unsigned char *base;
    unsigned long addr;
    char *name,*end;
    int fd,size,swap,i;

    name = argv[0];
    swap = 0;
    if (argc > 1 && *argv[1] == '-') {
	if (strcmp(argv[1],"-s")) usage(name);
	swap = 1;
	argv++;
	argc--;
    }
    addr = BASE_ADDR;
    if (argc > 1) {
	addr = strtoul(argv[1],&end,16);
	if (*end) usage(name);
    }
    if ((fd = open(MEM_DEV,O_RDWR,0)) < 0) {
	perror("open");
	return 1;
    }
    base = mmap(0L,MAP_MAX_SIZE,PROT_READ | PROT_WRITE,MAP_FILE | MAP_SHARED,
      fd,(off_t) addr);
    if (base == (unsigned char *) -1) {
	perror("mmap " MEM_DEV);
	return 1;
    }
    if (swap) {
	memcpy(buffer,base,MAP_MAX_SIZE);
	for (i = 0; i < MAP_MAX_SIZE/4; i++) buffer[i] = ntohl(buffer[i]);
	base = (char *) buffer;
    }
    size = write(1,base,MAP_MAX_SIZE);
    fprintf(stderr,"%d 0x%x\n",size,size);
    return 0;
}
