/* atmarpd.c - ATMARP demon */
 
/* Written 1995,1996 by Werner Almesberger, EPFL-LRC */
 

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <linux/atmarp.h>

#include "atm.h"
#include "atmd.h"

#include "io.h"
#include "table.h"


#ifndef NULL
#define NULL ((void *) 0)
#endif


#define COMPONENT "ARPD"


#ifdef MEM_DEBUG
extern int mpr(void);
extern int mcheck (void (*)(int));
#endif


ITF *itfs = NULL;
ENTRY *unknown_incoming = NULL;
int debug;
int pretty = A2T_PRETTY | A2T_NAME;


static void usage(const char *name)
{
    fprintf(stderr,"usage: %s [ -b ] [ -d ] [ -l logfile ] [ -n ]\n",name);
    exit(1);
}


int main(int argc,char **argv)
{
    const char *dump_dir;
    int c,background;

#ifdef MEM_DEBUG
    if (getenv("MCHECK")) mcheck(0);
    if (mpr() < 0) return 1;
#endif
    set_application("atmarpd");
    set_verbosity(NULL,DIAG_INFO);
    dump_dir = DUMP_DIR;
    background = 0;
    while ((c = getopt(argc,argv,"bdD:l:np")) != EOF)
	switch (c) {
	    case 'b':
		background = 1;
		break;
	    case 'd':
		set_verbosity(NULL,DIAG_DEBUG);
		debug = 1;
		break;
	    case 'D':
		dump_dir = optarg;
		break;
	    case 'l':
		set_logfile(optarg);
		break;
	    case 'n': /* @@@ was planned for NSAP matching */
		pretty = A2T_PRETTY;
		break;
	    case 'p':
		/* paranoid anti-firewall-tunneling mode @@@ */
	    default:
		usage(argv[0]);
	}
    diag(COMPONENT,DIAG_INFO,"Linux ATM ARP, version " VERSION);
    if (chdir(dump_dir) < 0)
	diag(COMPONENT,DIAG_ERROR,"chdir %s: %s",dump_dir,strerror(errno));
    if (debug) (void) unlink(TMP_DUMP_FILE); /* avoid confusion */
    open_all();
    if (background) {
    	pid_t pid;
 
	pid = fork();
	if (pid < 0) diag(COMPONENT,DIAG_FATAL,"fork: %s",strerror(errno));
	if (pid) {
	    diag(COMPONENT,DIAG_DEBUG,"Backgrounding (PID %d)",pid);
	    exit(0);
	}
    }
    poll_loop();
    close_all();
    return 0;
}
