#
# prepare_conf()
# Called by protopkg to move the config files specified in the rules file
# to the CONF processing directory.
#
# Parameters:     $1    The subpackage name (leave empty for main package)
#

prepare_conf() {
   # get the full path to the rules file
   if [ "$1" = "" ]
   then
      rulesFile="$CWD/rules"
      confDir="$CTL/conf"
      pkgRoot="$PKG"
   else
      rulesFile="$CWD/rules.$1"
      confDir="$SUBCTL/conf"
      pkgRoot="$SUBPKG"
   fi

   # let's do it
   if [ -f $rulesFile ]
   then
      cat $rulesFile | read_rules "conf" | (
         while read Caction Cfile
         do
            # get the file to put in the conf processing dir
            if [ "$Cfile" = "" ]
            then
               copyFile=$Caction
            else
               copyFile=$Cfile
            fi

            # move the file
            echo "   --> $copyFile"
            mkdir -p "$confDir/`dirname $copyFile`"
            mv $pkgRoot/$copyFile $confDir/$copyFile
         done )

      unset Caction Cfile pkgRoot copyFile confDir
   fi
}
